/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.jdbc.JDBCDatabase;
import com.ibm.ims.datatools.modelbase.dbdefinition.DatabaseVendorDefinition;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.sqltools.core.DatabaseVendorDefinitionId;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.osgi.util.NLS;

public class SQLEditorConnectionInfo
implements ISQLEditorConnectionInfo {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static ISQLEditorConnectionInfo DEFAULT_SQLEDITOR_CONNECTION_INFO = new SQLEditorConnectionInfo(SQLToolsFacade.getNonSpecificDatabaseVendorDefinitionId());
    protected DatabaseVendorDefinitionId _dbVendorId = null;
    protected DatabaseVendorDefinition _dbVendor = null;
    protected String _profileId = null;
    protected String _databaseName = null;
    protected Database _database = null;
    protected String _defaultSchemaName = null;
    protected int _profileStatus = 0;

    public SQLEditorConnectionInfo(DatabaseVendorDefinitionId dbVendorId) {
        this._dbVendorId = new DatabaseVendorDefinitionId("IMS", "V15");
    }

    public SQLEditorConnectionInfo(DatabaseVendorDefinitionId dbVendorId, String profileName, String dbName) {
        this(dbVendorId, profileName, dbName, null);
    }

    public SQLEditorConnectionInfo(DatabaseVendorDefinitionId dbVendorId, String profileName, String dbName, String schemaName) {
        this._profileId = profileName;
        this._dbVendorId = new DatabaseVendorDefinitionId("IMS", "V15");
        this._databaseName = dbName;
        this._defaultSchemaName = schemaName;
    }

    public DatabaseVendorDefinitionId getDatabaseVendorDefinitionId() {
        return this._dbVendorId;
    }

    public DatabaseVendorDefinition getDatabaseVendorDefinition() {
        return this._dbVendor;
    }

    public ConnectionProfile getConnectionProfile() {
        return ImsDbUtils.getConnectionProfileById((String)this._profileId);
    }

    public String getConnectionProfileId() {
        return this._profileId;
    }

    public Database getDatabase() {
        if (this._database == null && this._profileId != null) {
            this._database = new JDBCDatabase(this.getSharedConnection());
            this._database.setVendor("IMS");
            this._database.setVersion("V15");
        }
        return this._database;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public void setDatabaseName(String dbName) {
        this._databaseName = dbName;
    }

    public String getDefaultSchemaName() {
        String defaultSchemaName = null;
        if (this._defaultSchemaName != null && !this._defaultSchemaName.isBlank()) {
            defaultSchemaName = this._defaultSchemaName;
        }
        return defaultSchemaName;
    }

    public void setConnectionProfileId(String profileName) {
        this._profileId = profileName;
    }

    public void setDatabase(Database database) {
        this._database = database;
    }

    public void setDefaultSchemaName(String schemaName) {
        this._defaultSchemaName = schemaName;
    }

    public void setDatabaseVendorDefinitionId(DatabaseVendorDefinitionId dbVendorDefId) {
        this._dbVendorId = dbVendorDefId;
    }

    public String encode() {
        StringBuffer code = new StringBuffer("");
        code.append(this._dbVendorId == null ? "" : this._dbVendorId.toString()).append(";");
        code.append(this._profileId == null ? "" : this._profileId).append(";");
        code.append(this._databaseName == null ? "" : this._databaseName.toString()).append(";");
        code.append(this._defaultSchemaName == null ? "" : this._defaultSchemaName.toString());
        return code.toString();
    }

    public static ISQLEditorConnectionInfo decode(String code) {
        if (code == null || !code.matches("(?s).*;.*;.*;.*")) {
            SQLEditorPlugin.getDefault().log(NLS.bind((String)SQLEditorResources.SQLEditorConnectionInfo_decode_error, (Object[])new String[]{code}));
            return DEFAULT_SQLEDITOR_CONNECTION_INFO;
        }
        int i = 0;
        int j = code.indexOf(59);
        String dbVendorId = code.substring(i, j);
        i = j + 1;
        j = code.indexOf(59, i);
        String profileName = code.substring(i, j);
        i = j + 1;
        j = code.indexOf(59, i);
        String dbName = code.substring(i, j);
        i = j + 1;
        j = code.length();
        String schemaName = code.substring(i, j);
        if (profileName.equals("")) {
            if (dbVendorId.equals("")) {
                return DEFAULT_SQLEDITOR_CONNECTION_INFO;
            }
            return new SQLEditorConnectionInfo(new DatabaseVendorDefinitionId(dbVendorId));
        }
        return new SQLEditorConnectionInfo(null, profileName, dbName, schemaName);
    }

    public String getName() {
        StringBuffer code = new StringBuffer("");
        code.append(NLS.bind((String)SQLEditorResources.SQLEditor_status_dbType, (Object)this._dbVendorId.toString()));
        code.append(this._profileId == null ? "" : NLS.bind((String)SQLEditorResources.SQLEditor_status_profile, (Object)this.getConnectionProfileName()));
        code.append(this._profileId == null || this._databaseName == null ? "" : NLS.bind((String)SQLEditorResources.SQLEditor_status_database, (Object)this._databaseName));
        if (this.isConnected()) {
            code.append(SQLEditorResources.SQLEditor_status_profile_connected);
        } else {
            code.append(SQLEditorResources.SQLEditor_status_profile_notconnected);
        }
        return code.toString();
    }

    public IConnection getSharedConnection() {
        return ImsDbUtils.getConnectionById((String)this._profileId, (boolean)true);
    }

    public int getProfileStatus() {
        return this._profileStatus;
    }

    public void setProfileStatus(int status) {
        this._profileStatus = status;
    }

    public boolean isConnected() {
        boolean retVal = false;
        try {
            IImsDbConnection conn = ImsDbUtils.getConnectionById((String)this._profileId, (boolean)false);
            if (conn != null) {
                retVal = true;
            }
        }
        catch (Exception exception) {}
        return retVal;
    }

    public String getConnectionProfileName() {
        String retVal = null;
        ConnectionProfile profile = ImsDbUtils.getConnectionProfileById((String)this._profileId);
        if (profile != null) {
            retVal = profile.getName();
        }
        return retVal;
    }
}

