/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sql.util;

import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.ProcIdentifier;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.core.dbitem.ParameterDescriptor;
import com.ibm.ims.datatools.sqltools.sql.parser.ParserParameters;
import com.ibm.ims.datatools.sqltools.sql.parser.ParsingResult;
import com.ibm.ims.datatools.sqltools.sql.parser.SQLParser;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class ParameterUtil {
    public static Map getSPParamDefaultValues(DatabaseIdentifier databaseIdentifier, String sp) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap params = ParameterUtil.getSPParams(databaseIdentifier, sp);
        for (String name : params.keySet()) {
            String value;
            IASTSQLParam param = (IASTSQLParam)params.get(name);
            if (param.getDefaultValue() == null || (value = param.getDefaultValue()) != null && value.equalsIgnoreCase("null")) continue;
            map.put(name, value);
        }
        return map;
    }

    public static Map getSPParamTypeNameMapFromParser(DatabaseIdentifier databaseIdentifier, String sp) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap params = ParameterUtil.getSPParams(databaseIdentifier, sp);
        for (String name : params.keySet()) {
            IASTSQLParam param = (IASTSQLParam)params.get(name);
            String type = param.getType();
            map.put(name, type);
        }
        return map;
    }

    public static HashMap getSPParams(DatabaseIdentifier databaseIdentifier, String sp) {
        new HashMap();
        SQLParser parser = SQLToolsFacade.getSQLParser(databaseIdentifier.getProfileName(), "");
        Document doc = new Document(sp);
        ParsingResult result = parser.parse(sp, new ParserParameters(false));
        HashMap params = result.getParameters((IDocument)doc, doc.getLength() - 1);
        return params;
    }

    public static ParameterDescriptor[] getParameterDescriptors(DatabaseIdentifier databaseIdentifier, Connection connection, int type, ProcIdentifier proc) throws SQLException {
        ParameterDescriptor[] parameterDescriptorArray;
        block19: {
            DatabaseMetaData md = null;
            ResultSet rs = null;
            try {
                ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
                md = connection.getMetaData();
                String dbname = proc.getDatabaseIdentifier().getDBname();
                if (dbname != null && dbname.length() == 0) {
                    dbname = null;
                }
                rs = md.getProcedureColumns(dbname, proc.getOwnerName(), proc.getProcName(), "%");
                while (rs.next()) {
                    String name = rs.getString(4);
                    short parmType = rs.getShort(5);
                    int sqlDataType = rs.getShort(6);
                    Object dataTypeName = rs.getString(7);
                    if (((String)dataTypeName).equalsIgnoreCase("double") && sqlDataType == 0) {
                        sqlDataType = 8;
                    }
                    int precision = rs.getInt(8);
                    rs.getInt(9);
                    short scale = rs.getShort(10);
                    rs.getShort(11);
                    short nullable = rs.getShort(12);
                    String comment = rs.getString(13);
                    switch (sqlDataType) {
                        case 2: 
                        case 3: {
                            if ("money".equalsIgnoreCase((String)dataTypeName) || "smallmoney".equalsIgnoreCase((String)dataTypeName)) break;
                            dataTypeName = (String)dataTypeName + "(" + precision + "," + scale + ")";
                            break;
                        }
                        case -3: 
                        case -2: 
                        case 1: 
                        case 6: 
                        case 12: {
                            dataTypeName = (String)dataTypeName + "(" + precision + ")";
                        }
                    }
                    ParameterDescriptor p = new ParameterDescriptor(databaseIdentifier, name, parmType, sqlDataType, precision, scale, (String)dataTypeName, nullable, comment);
                    parameters.add(p);
                }
                parameterDescriptorArray = parameters.toArray(new ParameterDescriptor[0]);
                if (rs == null) break block19;
            }
            catch (Throwable throwable) {
                block21: {
                    if (rs != null) {
                        try {
                            try {
                                rs.close();
                            }
                            catch (SQLException sQLException) {
                                rs = null;
                                break block21;
                            }
                        }
                        catch (Throwable throwable2) {
                            rs = null;
                            throw throwable2;
                        }
                        rs = null;
                    }
                }
                throw throwable;
            }
            try {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    rs = null;
                }
            }
            finally {
                rs = null;
            }
        }
        return parameterDescriptorArray;
    }
}

