/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sql.updater;

import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import com.ibm.ims.datatools.sqltools.core.DatabaseVendorDefinitionId;
import com.ibm.ims.datatools.sqltools.core.SQLDevToolsConfiguration;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.sql.parser.ParserParameters;
import com.ibm.ims.datatools.sqltools.sql.parser.ParsingResult;
import com.ibm.ims.datatools.sqltools.sql.parser.SQLParser;
import com.ibm.ims.datatools.sqltools.sql.parser.Token;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTDeployable;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTStart;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.Node;

public abstract class ProceduralObjectSourceUpdater {
    protected DatabaseDefinition _dbDefinition;
    protected DatabaseVendorDefinitionId _dbDefinitionId;
    protected SQLParser _parser;
    protected SQLObject _routine = null;
    protected ParserParameters _parserParameters;
    protected boolean _testMode = false;

    public ProceduralObjectSourceUpdater(SQLObject _object, DatabaseDefinition dbDefinition) {
        this._routine = _object;
        this._dbDefinition = dbDefinition;
        this._dbDefinitionId = new DatabaseVendorDefinitionId(this._dbDefinition.getProduct(), this._dbDefinition.getVersion());
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByVendorIdentifier(this._dbDefinitionId);
        this._parser = f.getSQLService().getSQLParser();
        this._parserParameters = new ParserParameters(false);
        this._parserParameters.setProperty((Object)"__header_mode", (Object)Boolean.TRUE);
    }

    public boolean updateName(String newName) {
        Object body = this.getBody();
        ParsingResult result = this._parser.parse((String)body, this._parserParameters);
        IASTStart root = result.getRootNode();
        int i = 0;
        while (i < root.jjtGetNumChildren()) {
            Node node = root.jjtGetChild(i);
            if (node instanceof IASTDeployable) {
                Node nameNode = ((IASTDeployable)node).getNameNode();
                Token nameToken = nameNode.getLastToken();
                int[] range = this._parser.getRange(nameToken);
                body = ((String)body).substring(0, range[0]) + newName + ((String)body).substring(range[1]);
                this.setBody((String)body);
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract String getBody();

    public abstract void setBody(String var1);

    public void setTestMode(boolean testMode) {
        this._testMode = testMode;
    }

    public boolean getTestMode() {
        return this._testMode;
    }
}

