/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import com.ibm.ims.datatools.modelbase.sql.routines.Function;
import com.ibm.ims.datatools.modelbase.sql.routines.Procedure;
import com.ibm.ims.datatools.modelbase.sql.routines.Routine;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Event;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import com.ibm.ims.datatools.modelbase.sql.tables.Trigger;
import com.ibm.ims.datatools.sqltools.core.DBHelper;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.IDatabaseSetting;
import com.ibm.ims.datatools.sqltools.core.ProcIdentifier;
import com.ibm.ims.datatools.sqltools.core.SQLDevToolsConfiguration;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.sql.identifier.IIdentifierValidator;
import com.ibm.ims.datatools.sqltools.sql.identifier.ValidatorMessage;
import com.ibm.ims.datatools.sqltools.sql.util.ModelUtil;
import com.ibm.ims.datatools.sqltools.sql.util.SQLUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SQLDevToolsUtil {
    private static Pattern ID_PATTERN = Pattern.compile("((\\Q[\\E([^\"]|(\"\"))+\\Q]\\E|[^\\s\"\\Q.\\E]+|\"([^\"]|(\"\"))+\")\\Q.\\E?)");
    private static Pattern STRING_PATTERN = Pattern.compile("(([^\\s']+)|('([^']|(''))+'))");

    public static ProcIdentifier getProcIdentifier(SQLObject routine) {
        EObject db = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)routine);
        if (db instanceof Database) {
            String dbName = ModelUtil.getDatabaseName((EObject)routine);
            return SQLDevToolsUtil.getProcIdentifier(SQLDevToolsUtil.getDatabaseIdentifier((Database)db, dbName), routine);
        }
        return null;
    }

    public static ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, SQLObject routine) {
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        DBHelper h = null;
        h = config != null ? config.getDBHelper() : new DBHelper();
        ProcIdentifier proc = null;
        if (routine instanceof Routine) {
            Schema schema = ((Routine)routine).getSchema();
            if (routine instanceof Procedure) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), ((Procedure)routine).getSpecificName(), 0, null, schema.getName());
            } else if (routine instanceof Function) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), ((Function)routine).getSpecificName(), 1, null, schema.getName());
            }
        } else if (routine instanceof Trigger) {
            Schema schema = ((Trigger)routine).getSchema();
            Table table = ((Trigger)routine).getSubjectTable();
            proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 3, table.getName(), schema.getName(), table.getSchema().getName());
        } else if (routine instanceof Event) {
            Object obj;
            String creator = "";
            EStructuralFeature creatorFeature = routine.eClass().getEStructuralFeature("eventCreator");
            if (creatorFeature != null && (obj = routine.eGet(creatorFeature)) instanceof Schema) {
                creator = ((Schema)obj).getName();
            }
            proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 2, null, creator);
        } else {
            EStructuralFeature schemaFeature = routine.eClass().getEStructuralFeature("schema");
            EStructuralFeature eventIdFeature = routine.eClass().getEStructuralFeature("eventId");
            if (schemaFeature != null && eventIdFeature != null) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 2, null, ((Schema)routine.eGet(schemaFeature)).getName());
            }
        }
        return proc;
    }

    public static int getProcType(SQLObject routine) {
        if (routine instanceof Trigger) {
            return 3;
        }
        if (routine instanceof Procedure) {
            return 0;
        }
        if (routine instanceof Function) {
            return 1;
        }
        if (routine instanceof Event || SQLDevToolsUtil.isEventType(routine) != null) {
            return 2;
        }
        return 4;
    }

    public static EStructuralFeature isEventType(SQLObject routine) {
        return routine.eClass().getEStructuralFeature("eventId");
    }

    public static DatabaseIdentifier getDatabaseIdentifier(Database database) {
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database);
        if (connInfo instanceof ConnectionInfoImpl) {
            IConnectionProfile profile = ((ConnectionInfoImpl)connInfo).getConnectionProfile();
            return new DatabaseIdentifier(profile.getName(), database.getName());
        }
        return null;
    }

    public static DatabaseIdentifier getDatabaseIdentifier(Database database, String catalogName) {
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database);
        if (connInfo instanceof ConnectionInfoImpl) {
            String dbName = catalogName;
            if (dbName == null) {
                dbName = database.getName();
            }
            IConnectionProfile profile = ((ConnectionInfoImpl)connInfo).getConnectionProfile();
            return new DatabaseIdentifier(profile.getName(), dbName);
        }
        return null;
    }

    public static DatabaseIdentifier getDatabaseIdentifier(SQLObject obj) {
        EObject db = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)obj);
        if (db instanceof Database) {
            String dbName = ModelUtil.getDatabaseName((EObject)obj);
            return SQLDevToolsUtil.getDatabaseIdentifier((Database)db, dbName);
        }
        return null;
    }

    public static boolean getQuotedIdentifier(DatabaseIdentifier dbid) {
        return SQLDevToolsUtil.isQuotedIdentifierOn(dbid);
    }

    public static boolean isQuotedIdentifierOn(DatabaseIdentifier databaseIdentifier) {
        SQLDevToolsConfiguration conf;
        Object quotedIdentifierCfg;
        boolean quotedIdentifier;
        block5: {
            if (databaseIdentifier == null) {
                return false;
            }
            quotedIdentifier = false;
            quotedIdentifierCfg = null;
            try {
                conf = SQLToolsFacade.getConfiguration(null, databaseIdentifier);
                if (conf != null && conf.getDatabaseSetting(databaseIdentifier) != null) break block5;
                return false;
            }
            catch (IDatabaseSetting.NotSupportedSettingException notSupportedSettingException) {}
        }
        quotedIdentifierCfg = conf.getDatabaseSetting(databaseIdentifier).getConnectionConfigProperty("C_QUOTED_IDENTIFIER");
        if (quotedIdentifierCfg instanceof Boolean) {
            quotedIdentifier = (Boolean)quotedIdentifierCfg;
        }
        return quotedIdentifier;
    }

    public static String quoteStringWhenNecessary(String objstr) {
        String r = null;
        Matcher m = STRING_PATTERN.matcher(objstr);
        if (m.find()) {
            r = m.group();
        }
        if (r != null && r.equals(objstr)) {
            return r;
        }
        return SQLUtil.quote((String)objstr, (String)"'");
    }

    public static String quoteWhenNecessary(String content, DatabaseIdentifier databaseIdentifier) {
        return SQLDevToolsUtil.quoteWhenNecessary(content, databaseIdentifier, "\"");
    }

    public static String quoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier, String quote, int identiferType) {
        ValidatorMessage msg;
        if (id == null || id.equals("") || databaseIdentifier == null) {
            return id;
        }
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        IIdentifierValidator validator = conf.getSQLService().getIdentifierValidator();
        if (!(validator == null || (msg = validator.isValid(id, identiferType, databaseIdentifier)) != null && ValidatorMessage.hasError(msg, 2))) {
            return id;
        }
        boolean quoted_id = false;
        IDatabaseSetting dbSetting = conf.getDatabaseSetting(databaseIdentifier);
        if (dbSetting != null) {
            try {
                quoted_id = (Boolean)dbSetting.getConnectionConfigProperty("C_QUOTED_IDENTIFIER");
            }
            catch (Exception exception) {}
        }
        if (quoted_id) {
            return SQLUtil.quote((String)id, (String)quote);
        }
        return id;
    }

    public static String quoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier, String quote) {
        return SQLDevToolsUtil.quoteWhenNecessary(id, databaseIdentifier, quote, -1);
    }

    public static String unquoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier) {
        ValidatorMessage msg;
        if (id == null || id.equals("") || databaseIdentifier == null) {
            return id;
        }
        String newId = SQLUtil.unquote((String)id);
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        IIdentifierValidator validator = conf.getSQLService().getIdentifierValidator();
        if (!(validator == null || (msg = validator.isValid(newId, -1, databaseIdentifier)) != null && ValidatorMessage.hasError(msg, 2))) {
            return newId;
        }
        return id;
    }
}

