/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.core.profile;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.sqltools.core.profile.ConnectProfile;
import com.ibm.ims.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.core.runtime.ListenerList;

public class SQLToolsProfileListenersManager {
    private static SQLToolsProfileListenersManager _manager;
    private ListenerList _listeners = new ListenerList();

    private SQLToolsProfileListenersManager() {
    }

    public static synchronized SQLToolsProfileListenersManager getInstance() {
        if (_manager == null) {
            _manager = new SQLToolsProfileListenersManager();
        }
        return _manager;
    }

    public void addProfileListener(ISQLToolsProfileListener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add((Object)listener);
    }

    public void removeProfileListener(ISQLToolsProfileListener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove((Object)listener);
    }

    public void fireProfileAdded(IConnectionProfile profile) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((ISQLToolsProfileListener)listeners[i]).profileAdded(profile);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public void fireProfileDeleted(IConnectionProfile profile) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((ISQLToolsProfileListener)listeners[i]).profileDeleted(profile);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public void fireProfileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect, boolean onlyNameChanged, ConnectProfile oldProfile) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((ISQLToolsProfileListener)listeners[i]).profileChanged(profile, oldName, oldDesc, oldAutoConnect, onlyNameChanged, oldProfile);
            }
            catch (Exception exception) {}
            ++i;
        }
    }
}

