/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.core.modelvalidity;

import com.ibm.ims.datatools.modelbase.sql.schema.SQLSchemaPackage;
import com.ibm.ims.datatools.sqltools.core.DatabaseVendorDefinitionId;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.DefaultSQLModelValidator;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.SQLModelValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public class SQLModelValidatorRegistry {
    private Map _validatorMap;
    private SQLModelValidator _defaultValidator = new DefaultSQLModelValidator();

    public SQLModelValidatorRegistry() {
        this._validatorMap = new HashMap();
        this._defaultValidator = new DefaultSQLModelValidator();
        this.registerValidator(SQLSchemaPackage.eINSTANCE.getSQLObject(), this._defaultValidator);
    }

    public SQLModelValidator getValidator(EClass c) {
        if (c == null) {
            return this._defaultValidator;
        }
        Object obj = this._validatorMap.get(c);
        if (obj == null) {
            ArrayList list = new ArrayList();
            list.addAll(c.getESuperTypes());
            return this.getSuperValidator(list);
        }
        return (SQLModelValidator)((Object)obj);
    }

    private SQLModelValidator getSuperValidator(List list) {
        if (list.size() == 0) {
            return this._defaultValidator;
        }
        for (EClass c : list) {
            Object obj = this._validatorMap.get(c);
            if (obj == null) continue;
            return (SQLModelValidator)((Object)obj);
        }
        Iterator iter = list.iterator();
        ArrayList superList = new ArrayList();
        while (iter.hasNext()) {
            superList.addAll(((EClass)iter.next()).getESuperTypes());
        }
        return this.getSuperValidator(superList);
    }

    public SQLModelValidator getValidator(EClass c, DatabaseVendorDefinitionId vendorDefId) {
        if (c == null) {
            return this._defaultValidator;
        }
        if (vendorDefId == null) {
            return this.getValidator(c);
        }
        ValidatorKey key = new ValidatorKey(vendorDefId, c);
        Object obj = this._validatorMap.get(key);
        if (obj == null) {
            ArrayList list;
            if (obj == null) {
                list = new ArrayList();
                list.addAll(c.getESuperTypes());
                obj = this.getSuperValidator(list, vendorDefId);
            }
            if (obj == null || obj == this._defaultValidator) {
                obj = this._validatorMap.get(c);
            }
            if (obj == null || obj == this._defaultValidator) {
                list = new ArrayList();
                list.addAll(c.getESuperTypes());
                obj = this.getSuperValidator(list);
            }
        }
        return (SQLModelValidator)((Object)obj);
    }

    private SQLModelValidator getSuperValidator(List list, DatabaseVendorDefinitionId vendorDefId) {
        if (list.size() == 0) {
            return this._defaultValidator;
        }
        for (EClass c : list) {
            ValidatorKey key = new ValidatorKey(vendorDefId, c);
            Object obj = this._validatorMap.get(key);
            if (obj == null) {
                obj = this._validatorMap.get(c);
            }
            if (obj == null) continue;
            return (SQLModelValidator)((Object)obj);
        }
        Iterator iter = list.iterator();
        ArrayList superList = new ArrayList();
        while (iter.hasNext()) {
            superList.addAll(((EClass)iter.next()).getESuperTypes());
        }
        return this.getSuperValidator(superList, vendorDefId);
    }

    public void registerValidator(EClass c, DatabaseVendorDefinitionId vendorDefId, SQLModelValidator validator) {
        if (c == null || validator == null) {
            return;
        }
        if (vendorDefId == null) {
            this._validatorMap.put(c, validator);
        } else {
            this._validatorMap.put(new ValidatorKey(vendorDefId, c), validator);
        }
    }

    public void registerValidator(EClass c, SQLModelValidator validator) {
        if (c == null || validator == null) {
            return;
        }
        this._validatorMap.put(c, validator);
    }

    class ValidatorKey {
        public DatabaseVendorDefinitionId _vendorDefId;
        public EClass _class;

        public ValidatorKey(DatabaseVendorDefinitionId vendorDefId, EClass c) {
            this._vendorDefId = vendorDefId;
            this._class = c;
        }

        public boolean equals(Object arg0) {
            if (!(arg0 instanceof ValidatorKey)) {
                return false;
            }
            ValidatorKey key = (ValidatorKey)arg0;
            if (key._vendorDefId == null && this._vendorDefId != null || key._vendorDefId != null && this._vendorDefId == null) {
                return false;
            }
            return (key._vendorDefId == null && this._vendorDefId == null || key._vendorDefId.equals(this._vendorDefId)) && key._class == this._class;
        }

        public int hashCode() {
            StringBuffer sb = new StringBuffer("");
            if (this._vendorDefId != null) {
                sb.append(this._vendorDefId.toString());
            }
            sb.append(this._class.getName());
            return sb.toString().hashCode();
        }
    }
}

