/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.core.modelvalidity;

import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.DatabaseVendorDefinitionId;
import com.ibm.ims.datatools.sqltools.core.EditorCorePlugin;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.ContainmentFeatureValidationItem;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.IValidationItem;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.SQLModelValidator;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.SQLModelValidatorRegistry;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.ValidationItem;
import com.ibm.ims.datatools.sqltools.core.profile.ProfileUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class SQLModelValidationDelegate
extends EObjectValidator {
    public static final String VALIDATION_ITEMS_KEY = "vitems";
    public static final String VALIDATION_SCOPE_KEY = "vscope";
    public static final String VALIDATIOR_KEY = "validator";
    public static final String VALIDATION_DEPTH_KEY = "vdepth";
    public static final String VALIDATION_MODE_KEY = "vmode";
    public static final String VALIDATION_SCOPE_BASIC_VALUE = "vscopebasic";
    public static final String VALIDATION_SCOPE_COMPLETE_VALUE = "vscopecomplete";
    public static final String VALIDATION_MODE_ONLINE_VALUE = "vmodeonline";
    public static final String VALIDATION_MODE_OFFLINE_VALUE = "vmodeoffline";
    private static SQLModelValidationDelegate _instance;

    private SQLModelValidationDelegate() {
    }

    public static synchronized SQLModelValidationDelegate getInstance() {
        if (_instance == null) {
            _instance = new SQLModelValidationDelegate();
        }
        return _instance;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map context) {
        return this.validate(eObject, diagnostics, context, new HashMap());
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map context, Map sharedParams) {
        Object v;
        boolean isValid = true;
        boolean isBasicScope = true;
        String scope = (String)context.get(VALIDATION_SCOPE_KEY);
        if (scope != null && scope.equals(VALIDATION_SCOPE_COMPLETE_VALUE)) {
            isBasicScope = false;
        }
        if ((v = context.get(VALIDATIOR_KEY)) == null || !(v instanceof SQLModelValidator)) {
            DatabaseVendorDefinitionId dbVendorId = null;
            DatabaseIdentifier dbIdentifier = (DatabaseIdentifier)sharedParams.get("didentifier");
            if (dbIdentifier != null) {
                dbVendorId = ProfileUtil.getDatabaseVendorDefinitionId(dbIdentifier.getProfileName());
            }
            SQLModelValidatorRegistry registry = EditorCorePlugin.getDefault().getSQLModelValidatorRegistry();
            v = registry.getValidator(eObject.eClass(), dbVendorId);
        }
        if (v == null || !(v instanceof SQLModelValidator)) {
            return true;
        }
        if (!isBasicScope) {
            Map basicContext = (Map)((HashMap)context).clone();
            basicContext.put(VALIDATION_SCOPE_KEY, VALIDATION_SCOPE_BASIC_VALUE);
            basicContext.put(VALIDATIOR_KEY, context.get(VALIDATIOR_KEY));
            ArrayList<ValidationItem> itemsList = (ArrayList<ValidationItem>)basicContext.get(VALIDATION_ITEMS_KEY);
            if (itemsList == null) {
                itemsList = new ArrayList<ValidationItem>();
            }
            int depth = 1;
            Integer depthObj = (Integer)context.get(VALIDATION_DEPTH_KEY);
            try {
                depth = depthObj;
            }
            catch (Exception exception) {}
            EClass modelClass = eObject.eClass();
            EList features = modelClass.getEAllStructuralFeatures();
            for (EStructuralFeature feature : features) {
                ValidationItem item = null;
                if (feature instanceof EAttribute) {
                    EAttribute attr = (EAttribute)feature;
                    item = new ValidationItem(attr.getFeatureID());
                    if (itemsList.contains(item)) continue;
                    itemsList.add(item);
                    continue;
                }
                if (!(feature instanceof EReference)) continue;
                EReference reference = (EReference)feature;
                if (reference.isContainment() && depth > 1) {
                    item = new ContainmentFeatureValidationItem(feature.getFeatureID(), 1);
                    Map subContext = (Map)((HashMap)context).clone();
                    subContext.put(VALIDATION_SCOPE_KEY, VALIDATION_SCOPE_COMPLETE_VALUE);
                    subContext.put(VALIDATION_DEPTH_KEY, depth - 1);
                    ((ContainmentFeatureValidationItem)item).setContext(subContext);
                    if (itemsList.contains(item)) continue;
                    itemsList.add(item);
                    continue;
                }
                item = new ValidationItem(feature.getFeatureID(), 1);
                if (itemsList.contains(item)) continue;
                itemsList.add(item);
            }
            basicContext.put(VALIDATION_ITEMS_KEY, itemsList);
            return this.validate(eObject, diagnostics, basicContext, sharedParams);
        }
        List items = (List)context.get(VALIDATION_ITEMS_KEY);
        if (items == null) {
            return true;
        }
        SQLModelValidator validator = (SQLModelValidator)((Object)v);
        block7: for (Object obj : items) {
            if (obj == null || !(obj instanceof IValidationItem)) continue;
            IValidationItem item = (IValidationItem)obj;
            if (item.getContext() == null) {
                item.setContext(new HashMap());
            }
            switch (item.getType()) {
                case 0: 
                case 1: {
                    if (item.getFeature(eObject.eClass()) == null) continue block7;
                }
                case 2: {
                    isValid &= validator.validate(eObject, item, diagnostics, sharedParams);
                    break;
                }
            }
        }
        return isValid;
    }

    public static Map getCompleteValidationContext(int depth) {
        if (depth < 1) {
            depth = 1;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(VALIDATION_SCOPE_KEY, VALIDATION_SCOPE_COMPLETE_VALUE);
        context.put(VALIDATION_DEPTH_KEY, depth);
        return context;
    }

    public static Map getBasicValidationContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(VALIDATION_SCOPE_KEY, VALIDATION_SCOPE_BASIC_VALUE);
        context.put(VALIDATION_MODE_KEY, VALIDATION_MODE_ONLINE_VALUE);
        return context;
    }

    public static Map getPlainValidationContext() {
        return SQLModelValidationDelegate.getCompleteValidationContext(1);
    }
}

