/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.core;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.IProfileListener;
import com.ibm.ims.datatools.connectivity.ProfileManager;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import com.ibm.ims.datatools.connectivity.sqm.core.rte.RefreshManager;
import com.ibm.ims.datatools.sqltools.core.IControlConnectionManager;
import com.ibm.ims.datatools.sqltools.core.modelvalidity.SQLModelValidatorRegistry;
import com.ibm.ims.datatools.sqltools.core.profile.ProfileUtil;
import com.ibm.ims.datatools.sqltools.core.profile.SQLToolsProfileProxyListener;
import com.ibm.ims.datatools.sqltools.internal.core.ControlConnectionManager;
import com.ibm.ims.datatools.sqltools.internal.core.IConfigurationRegistryListener;
import com.ibm.ims.datatools.sqltools.internal.core.Messages;
import com.ibm.ims.datatools.sqltools.internal.core.SQLDevToolsConfigRegistry;
import com.ibm.ims.datatools.sqltools.internal.core.SQLDevToolsConfigRegistryImpl;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class EditorCorePlugin
extends Plugin {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final int INTERNAL_ERROR = 0;
    public static final String PLUGIN_ID = "com.ibm.ims.datatools.sqltools.editor.core";
    private static EditorCorePlugin plugin;
    private IControlConnectionManager _controlConnectionManager;
    boolean _registered = false;
    private SQLModelValidatorRegistry _registry;

    public EditorCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        EditorCorePlugin.addConfigurationRegistryListener(new IConfigurationRegistryListener(){

            @Override
            public void configurationLoaded() {
                EditorCorePlugin.this.register();
            }
        });
        this._registry = new SQLModelValidatorRegistry();
    }

    private synchronized void register() {
        if (!this._registered) {
            ProfileManager pManager = ProfileManager.getInstance();
            IConnectionProfile[] profiles = ProfileUtil.getProfiles();
            SQLToolsProfileProxyListener listener = SQLToolsProfileProxyListener.getInstance();
            listener.init(profiles);
            pManager.addProfileListener((IProfileListener)listener);
            this._registered = true;
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this._controlConnectionManager == null) {
            RefreshManager.getInstance().removeListener(null, (ICatalogObjectListener)this._controlConnectionManager);
        }
        super.stop(context);
        plugin = null;
    }

    public static EditorCorePlugin getDefault() {
        return plugin;
    }

    public static synchronized IControlConnectionManager getControlConnectionManager() {
        if (EditorCorePlugin.getDefault()._controlConnectionManager == null) {
            ControlConnectionManager controlConnectionManager = new ControlConnectionManager();
            EditorCorePlugin.getDefault()._controlConnectionManager = controlConnectionManager;
            RefreshManager.getInstance().AddListener(null, (ICatalogObjectListener)controlConnectionManager);
        }
        return EditorCorePlugin.getDefault()._controlConnectionManager;
    }

    public void log(IStatus status) {
        int severity = status.getSeverity();
        switch (severity) {
            case 0: {
                logger.fine(status.getMessage());
                break;
            }
            case 4: {
                logger.error(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            case 2: {
                logger.warn(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            default: {
                logger.info(status.getMessage(), status.getException(), new Object[0]);
            }
        }
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, Messages.plugin_internal_error, e);
    }

    public IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, e);
    }

    public void log(String message, Throwable e) {
        this.log(this.createErrorStatus(message, e));
    }

    public static SQLDevToolsConfigRegistry getDatabaseFactoryRegistry() {
        return SQLDevToolsConfigRegistryImpl.INSTANCE;
    }

    public static void addConfigurationRegistryListener(IConfigurationRegistryListener listener) {
        EditorCorePlugin.getDatabaseFactoryRegistry().addConfigurationRegistryListener(listener);
    }

    public SQLModelValidatorRegistry getSQLModelValidatorRegistry() {
        return this._registry;
    }
}

