/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.newpsb;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewPSBWizardPage
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IStructuredSelection selection;
    private boolean psbModified = false;
    private static final int margin = 5;
    private static final int rightPercentage = 65;
    private Combo projectNameCombo;
    private Text psbNameField;
    private Label psbNameStatus;
    private Combo copyFromPsbCombo;

    public NewPSBWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("newPSBWizard")));
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            Font font = parent.getFont();
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(font);
            UIHelper uih = new UIHelper();
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB103")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB104")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB499"))};
            int requiredLabelWidth = Utility.getTextWidth(parent, 0, "*");
            int labelWidth = Utility.getMaxSize(labelSizes) + requiredLabelWidth;
            FormData fd = uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(0, 0), null);
            Label projectReq = uih.genRequiredSymbol(composite, 0, fd, parent.getDisplay().getSystemColor(3));
            projectReq.setFont(font);
            fd = uih.genFormData(new FormAttachment(0, 5), null, new FormAttachment((Control)projectReq, 5), null);
            Label projectLabel = new Label(composite, 0);
            projectLabel.setText(WorkbenchPlugin.labels.getString("WB103"));
            projectLabel.setLayoutData((Object)fd);
            projectLabel.setFont(font);
            fd = uih.genFormData(new FormAttachment(0, 3), null, new FormAttachment(0, labelWidth), new FormAttachment(65, 5));
            this.projectNameCombo = new Combo(composite, 2056);
            this.projectNameCombo.setLayoutData((Object)fd);
            this.projectNameCombo.setFont(font);
            this.projectNameCombo.setFocus();
            fd = uih.genFormData(new FormAttachment((Control)this.projectNameCombo, 19), null, new FormAttachment(0, 0), null);
            Label psbReq = uih.genRequiredSymbol(composite, 0, fd, parent.getDisplay().getSystemColor(3));
            psbReq.setFont(font);
            fd = uih.genFormData(new FormAttachment((Control)this.projectNameCombo, 17), null, new FormAttachment((Control)psbReq, 5), null);
            Label psbLabel = new Label(composite, 0);
            psbLabel.setText(WorkbenchPlugin.labels.getString("WB104"));
            psbLabel.setLayoutData((Object)fd);
            psbLabel.setFont(font);
            fd = uih.genFormData(new FormAttachment((Control)this.projectNameCombo, 15), null, new FormAttachment(0, labelWidth), new FormAttachment(65, 5));
            this.psbNameField = new Text(composite, 2048);
            this.psbNameField.setLayoutData((Object)fd);
            this.psbNameField.setFont(font);
            this.psbNameField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB446"));
            fd = uih.genFormData(new FormAttachment((Control)this.projectNameCombo, 15), null, new FormAttachment((Control)this.psbNameField, 5), null);
            this.psbNameStatus = new Label(composite, 0);
            this.psbNameStatus.setImage(FigureConstants.ERROR);
            this.psbNameStatus.setVisible(false);
            this.psbNameStatus.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)psbLabel, 27), null, new FormAttachment((Control)psbReq, 5), null);
            Label copyFromPsbLbl = new Label(composite, 0);
            copyFromPsbLbl.setText(WorkbenchPlugin.labels.getString("WB499"));
            copyFromPsbLbl.setLayoutData((Object)fd);
            copyFromPsbLbl.setFont(font);
            fd = uih.genFormData(new FormAttachment((Control)this.psbNameField, 19), null, new FormAttachment(0, labelWidth), new FormAttachment(65, 5));
            this.copyFromPsbCombo = new Combo(composite, 2056);
            this.copyFromPsbCombo.setLayoutData((Object)fd);
            this.copyFromPsbCombo.setFont(font);
            this.copyFromPsbCombo.setFocus();
            this.setTitle(WorkbenchPlugin.labels.getString("WB116"));
            this.setDescription(WorkbenchPlugin.descriptions.getString("WB107"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.ies1_wb_createpsb");
            this.setControl((Control)composite);
            this.initialize();
            this.getContainer().getShell().setMinimumSize(550, 400);
        }
        catch (CoreException coreException) {
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
    }

    private void initialize() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        Vector<String> projectNames = new Vector<String>();
        String selectedName = this.getSelectedProjectName();
        int i = 0;
        while (i < projects.length) {
            String projName;
            IProjectNature nature;
            IProject project = projects[i];
            if (project.exists() && project.isOpen() && (nature = projects[i].getNature("com.ibm.im.ims.workbench.nature")) != null && !(projName = projects[i].getName()).equals("IMS_Explorer_Catalog_ReadOnly")) {
                projectNames.add(projName);
            }
            ++i;
        }
        String[] strArray = new String[projectNames.size()];
        projectNames.toArray(strArray);
        this.projectNameCombo.setItems(strArray);
        this.projectNameCombo.setText(selectedName);
        this.projectNameCombo.addListener(24, (Listener)this);
        this.psbNameField.addListener(24, (Listener)this);
        this.psbNameField.setTextLimit(8);
        this.psbNameField.setEnabled(!this.projectNameCombo.getText().isEmpty());
        this.psbNameField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB402"));
        if (selectedName != null && selectedName.length() > 0) {
            this.psbNameField.setFocus();
            this.populateCloneFromPSB();
        }
        this.psbNameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.character >= 'a' && event.character <= 'z') {
                    event.text = event.text.toUpperCase();
                }
            }
        });
    }

    private String getSelectedProjectName() {
        String selectedProject = "";
        if (this.selection == null || this.selection.isEmpty()) {
            return selectedProject;
        }
        if (this.selection.getFirstElement() instanceof IProject) {
            selectedProject = ((IProject)this.selection.getFirstElement()).getName();
        } else if (this.selection.getFirstElement() instanceof IResource) {
            selectedProject = ((IResource)this.selection.getFirstElement()).getProject().getName();
        } else if (this.selection.getFirstElement() instanceof IFile) {
            selectedProject = ((IFile)this.selection.getFirstElement()).getProject().getName();
        }
        return selectedProject;
    }

    private boolean psbExists(String name) {
        if (this.copyFromPsbCombo != null) {
            int i = 0;
            while (i < this.copyFromPsbCombo.getItemCount()) {
                if (this.copyFromPsbCombo.getItem(i).equalsIgnoreCase(name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameCombo.setFocus();
        }
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void handleEvent(Event event) {
        try {
            String psbName = this.psbNameField.getText();
            if (event.widget == this.projectNameCombo) {
                this.psbNameField.setEnabled(!this.projectNameCombo.getText().isEmpty());
                this.psbNameField.setText(psbName);
                this.psbNameField.setFocus();
                this.populateCloneFromPSB();
                if (this.psbExists(psbName)) {
                    Object[] messageArguments = new Object[]{this.psbNameField.getText(), this.projectNameCombo.getText()};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("IOCWB0404"));
                    String errorMessage = formatter.format(messageArguments);
                    this.psbNameStatus.setVisible(true);
                    this.psbNameStatus.setToolTipText(errorMessage);
                    this.setErrorMessage(errorMessage);
                }
            } else if (event.widget == this.psbNameField) {
                if (this.psbModified && this.psbNameField.getText().isEmpty()) {
                    String errorMessage = WorkbenchPlugin.errors.getString("IOCWB0401");
                    this.psbNameStatus.setVisible(true);
                    this.psbNameStatus.setToolTipText(errorMessage);
                    this.setErrorMessage(errorMessage);
                } else if (this.psbModified && (Utility.hasSpecialChar(this.psbNameField.getText()) || Utility.hasReservedName(this.psbNameField.getText()))) {
                    String errorMessage = WorkbenchPlugin.errors.getString("EISRC8");
                    this.setErrorMessage(errorMessage);
                    int lastSpace = errorMessage.substring(0, errorMessage.length() / 2).lastIndexOf(32);
                    this.psbNameStatus.setVisible(true);
                    this.psbNameStatus.setToolTipText(errorMessage.substring(0, lastSpace) + "\n" + errorMessage.substring(lastSpace + 1));
                } else if (this.psbModified && this.psbExists(this.psbNameField.getText().trim())) {
                    Object[] messageArguments = new Object[]{this.psbNameField.getText(), this.projectNameCombo.getText()};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("IOCWB0404"));
                    String errorMessage = formatter.format(messageArguments);
                    this.psbNameStatus.setVisible(true);
                    this.psbNameStatus.setToolTipText(errorMessage);
                    this.setErrorMessage(errorMessage);
                } else if (this.psbModified) {
                    char firstChar = this.psbNameField.getText().charAt(0);
                    if (firstChar >= '0' && firstChar <= '9') {
                        String errorMessage = WorkbenchPlugin.errors.getString("IOCWB0403");
                        this.psbNameStatus.setVisible(true);
                        this.psbNameStatus.setToolTipText(errorMessage);
                        this.setErrorMessage(errorMessage);
                    } else {
                        this.psbNameStatus.setVisible(false);
                        this.psbNameStatus.setToolTipText(null);
                        this.setErrorMessage(null);
                    }
                } else {
                    this.psbModified = true;
                }
            }
            this.setPageComplete(this.getErrorMessage() == null && !this.projectNameCombo.getText().isEmpty() && !this.psbNameField.getText().isEmpty());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
    }

    private void populateCloneFromPSB() throws CoreException {
        Vector psbNames = ProjectTreeFileHelper.getPSBNamesInProject((String)this.getProjectName());
        String[] psbNamesList = new String[psbNames.size()];
        int i = 0;
        while (i < psbNames.size()) {
            psbNamesList[i] = (String)psbNames.get(i);
            ++i;
        }
        this.copyFromPsbCombo.setItems(psbNamesList);
    }

    protected String getProjectName() {
        return this.projectNameCombo.getText();
    }

    protected String getPsbName() {
        return this.psbNameField.getText();
    }

    protected String getCloneFromPsbName() {
        return this.copyFromPsbCombo.getText();
    }
}

