/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.newpsb;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.wizard.newpsb.NewPSBWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewPSBWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IStructuredSelection selection;
    private NewPSBWizardPage newPSBPage;
    private IFile psbFile;

    public NewPSBWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB115"));
    }

    public boolean canFinish() {
        try {
            return this.newPSBPage.isPageComplete();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        try {
            this.newPSBPage = new NewPSBWizardPage(" ", this.selection);
            this.addPage((IWizardPage)this.newPSBPage);
            this.newPSBPage.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public boolean performFinish() {
        final String projectName = this.newPSBPage.getProjectName();
        final String psbName = this.newPSBPage.getPsbName();
        final String cloneFomPsb = this.newPSBPage.getCloneFromPsbName();
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            NewPSBWizard.this.doFinish(monitor, psbName, projectName, cloneFomPsb);
                        }
                        catch (Throwable e) {
                            logger.throwing(this.getClass().getName(), "performFinish()", e);
                            logger.error(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(true, false, op);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.psbFile != null && page != null) {
                page.setEditorAreaVisible(true);
                IDE.openEditor((IWorkbenchPage)page, (IFile)this.psbFile);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
            return false;
        }
        return true;
    }

    private void marshallGeneratedDbView(String projectName, PsbModel psbModel) throws CoreException {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("explorer_enable_ims_jdbc")) {
            ProjectTreeFileHelper.marshallGeneratedDbView((String)projectName, (PsbModel)psbModel);
        }
    }

    private void doFinish(IProgressMonitor monitor, String psbName, String projectName, String cloneFromPsb) throws CoreException, IOException, ModelException, JAXBException {
        PsbModel psbModel = null;
        IFile copyPsbFile = null;
        if (cloneFromPsb != null && cloneFromPsb != "") {
            copyPsbFile = ProjectTreeFileHelper.getPsbMetadataFile((String)projectName, (String)cloneFromPsb);
            if (copyPsbFile.exists()) {
                psbModel = new PsbModel(copyPsbFile.getContents());
            }
        } else {
            psbModel = new PsbModel();
        }
        psbModel.setPsbName(psbName);
        monitor.worked(1);
        IFile psbFile = ProjectTreeFileHelper.getPsbMetadataFile((String)projectName, (String)psbName);
        this.savePsb(psbFile, monitor, psbModel, projectName);
        if (psbModel.getDBPcbList() != null || psbModel.getGsamPcbList() != null) {
            this.marshallGeneratedDbView(projectName, psbModel);
        }
    }

    private void savePsb(IFile file, IProgressMonitor monitor, PsbModel psb, String projectName) throws ModelException, CoreException {
        ByteArrayOutputStream outputStream = null;
        outputStream = new ByteArrayOutputStream();
        psb.marshall(outputStream);
        ByteArrayInputStream input = new ByteArrayInputStream(outputStream.toByteArray());
        if (!file.exists()) {
            file.create((InputStream)input, true, monitor);
        } else {
            file.setContents((InputStream)input, true, true, monitor);
        }
        ProjectTreeFileHelper.marshallGeneratedPsbFile((String)projectName, (PsbModel)psb);
        monitor.worked(1);
        this.psbFile = file;
    }
}

