/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.migratedmu;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.DMUProjectHelp;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DLIModelMigrationWizardPage1
extends WizardPage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DialogSettings settings;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private Label workspaceLabel;
    private Label projectLabel;
    private Label migrateLabel;
    private Label optionLabel;
    private Combo wsCombo;
    private List projectList;
    private List migrateList;
    private Button browseButton;
    private Button addButton;
    private Button addAllButton;
    private Button removeButton;
    private Button removeAllButton;
    private Button overwriteButton;
    private Button appendButton;
    private Text appendText;
    private String suffix = "_ex";
    private String title = WorkbenchPlugin.labels.getString("WB514");
    private String description = WorkbenchPlugin.labels.getString("WB515");
    private String wsLabelStr = WorkbenchPlugin.labels.getString("WB516");
    private String browseStr = WorkbenchPlugin.labels.getString("WB517");
    private String optionStr = WorkbenchPlugin.labels.getString("WB518");
    private String overwriteStr = WorkbenchPlugin.labels.getString("WB519");
    private String appendStr = WorkbenchPlugin.labels.getString("WB520");
    private String appendTT = WorkbenchPlugin.labels.getString("WB521");
    private String projectLabelStr = WorkbenchPlugin.labels.getString("WB522");
    private String migrateLabelStr = WorkbenchPlugin.labels.getString("WB523");
    private String errorMsg01 = WorkbenchPlugin.errors.getString("DMUPPMW01");
    private String errorMsg02 = WorkbenchPlugin.errors.getString("DMUPPMW04");
    private String appendErrorMsg01 = WorkbenchPlugin.errors.getString("DMUPPMW02");
    private String appendErrorMsg02 = WorkbenchPlugin.errors.getString("DMUPPMW03");
    private String selectedDir;
    private ArrayList<String> migrateAL;
    private boolean overwrite;
    private ArrayList<String> knownDirs;
    private IWorkspace workspace = ResourcesPlugin.getWorkspace();

    protected DLIModelMigrationWizardPage1(String pageName) {
        super(pageName);
        this.uih = new UIHelper();
        this.setTitle(this.title);
        this.setDescription(this.description);
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("vlImportWizard")));
        this.migrateAL = new ArrayList();
        this.knownDirs = new ArrayList();
        this.settings = WorkbenchPlugin.getDefault().getGlobalDialogSettings();
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.composite = new Composite(parent, 0);
        this.display = parent.getDisplay();
        this.uih.setDisplay(this.display);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ies1_wb_dmumigration1");
        String[] prevWorkspaces = this.settings.getArray("previouslyUsed");
        String tempAppendStr = this.settings.get("appendStr");
        this.selectedDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.composite.setLayout((Layout)layout);
        FormData fd1 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.workspaceLabel = this.uih.genLabel(this.composite, 16384, this.wsLabelStr, this.uih.black, fd1);
        FormData fd3 = this.uih.genFormData(new FormAttachment(0, 0), null, null, new FormAttachment(100, -5));
        this.browseButton = new Button(this.composite, 8);
        this.computeButtonSize(this.browseButton);
        this.browseButton.setText(this.browseStr);
        this.browseButton.setLayoutData((Object)fd3);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String dir = DLIModelMigrationWizardPage1.this.performBrowseFile();
                if (dir != null && dir.length() > 0) {
                    DLIModelMigrationWizardPage1.this.selectedDir = dir;
                    if (DLIModelMigrationWizardPage1.this.wsCombo.indexOf(DLIModelMigrationWizardPage1.this.selectedDir) == -1) {
                        DLIModelMigrationWizardPage1.this.wsCombo.add(DLIModelMigrationWizardPage1.this.selectedDir, 0);
                    }
                    DLIModelMigrationWizardPage1.this.workspaceChange(DLIModelMigrationWizardPage1.this.selectedDir);
                }
            }
        });
        FormData fd2 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.workspaceLabel, 15), new FormAttachment((Control)this.browseButton, -15));
        this.wsCombo = new Combo(this.composite, 12);
        if (prevWorkspaces != null && prevWorkspaces.length > 0) {
            String[] stringArray = prevWorkspaces;
            int n = prevWorkspaces.length;
            int n2 = 0;
            while (n2 < n) {
                String ws = stringArray[n2];
                this.wsCombo.add(ws);
                this.knownDirs.add(ws);
                ++n2;
            }
        }
        this.wsCombo.setText("");
        this.wsCombo.setLayoutData((Object)fd2);
        this.wsCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.selectedDir = DLIModelMigrationWizardPage1.this.wsCombo.getText();
                DLIModelMigrationWizardPage1.this.workspaceChange(DLIModelMigrationWizardPage1.this.selectedDir);
            }
        });
        fd1 = this.uih.genFormData(new FormAttachment((Control)this.workspaceLabel, 25), null, new FormAttachment(0, 0), null);
        this.optionLabel = new Label(this.composite, 16384);
        this.optionLabel.setText(this.optionStr);
        this.optionLabel.setLayoutData((Object)fd1);
        fd1 = this.uih.genFormData(new FormAttachment((Control)this.optionLabel, 5), null, new FormAttachment(0, 10), null);
        this.overwriteButton = new Button(this.composite, 16);
        this.overwriteButton.setText(this.overwriteStr);
        this.overwriteButton.setLayoutData((Object)fd1);
        this.overwriteButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.overwrite = true;
                DLIModelMigrationWizardPage1.this.appendText.setEnabled(false);
            }
        });
        fd2 = this.uih.genFormData(new FormAttachment((Control)this.overwriteButton, 5), null, new FormAttachment(0, 10), null);
        this.appendButton = new Button(this.composite, 16);
        this.appendButton.setText(this.appendStr);
        this.appendButton.setLayoutData((Object)fd2);
        this.appendButton.setSelection(true);
        this.appendButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.overwrite = false;
                DLIModelMigrationWizardPage1.this.appendText.setEnabled(true);
            }
        });
        fd3 = this.uih.genFormData(new FormAttachment((Control)this.overwriteButton, 5), null, new FormAttachment((Control)this.appendButton, 5), null);
        this.appendText = new Text(this.composite, 18432);
        this.appendText.setToolTipText(this.appendTT);
        this.appendText.setTextLimit(4);
        this.appendText.setLayoutData((Object)fd3);
        if (tempAppendStr == null || tempAppendStr.trim().isEmpty()) {
            this.appendText.setText(this.suffix);
        } else {
            this.appendText.setText(tempAppendStr);
        }
        this.suffix = this.appendText.getText();
        this.appendText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.suffix = DLIModelMigrationWizardPage1.this.appendText.getText();
                IStatus status = DLIModelMigrationWizardPage1.this.workspace.validateName(DLIModelMigrationWizardPage1.this.suffix, 4);
                if (DLIModelMigrationWizardPage1.this.appendButton.getSelection() && DLIModelMigrationWizardPage1.this.appendText.getText().trim().isEmpty()) {
                    DLIModelMigrationWizardPage1.this.setErrorMessage(DLIModelMigrationWizardPage1.this.appendErrorMsg01);
                } else if (!status.isOK()) {
                    DLIModelMigrationWizardPage1.this.setErrorMessage(DLIModelMigrationWizardPage1.this.appendErrorMsg02);
                } else {
                    DLIModelMigrationWizardPage1.this.setErrorMessage(null);
                    DLIModelMigrationWizardPage1.this.validatePage();
                }
            }
        });
        fd1 = this.uih.genFormData(new FormAttachment((Control)this.appendButton, 15), null, new FormAttachment(0, 0), null);
        this.projectLabel = this.uih.genLabel(this.composite, 16384, this.projectLabelStr, this.uih.black, fd1);
        int bWidth = 30;
        FormData fdBC = this.uih.genFormData(new FormAttachment((Control)this.projectLabel, 30), null, new FormAttachment(50, -(bWidth / 2)), new FormAttachment(50, bWidth / 2));
        Composite bc = new Composite(this.composite, 0);
        bc.setLayoutData((Object)fdBC);
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        bc.setLayout((Layout)gl);
        this.addButton = new Button(bc, 8);
        this.addButton.setText(">");
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.addSelectedToMigrate();
            }
        });
        this.removeButton = new Button(bc, 8);
        this.removeButton.setText("<");
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.removeSelectedFromMigrate();
            }
        });
        this.addAllButton = new Button(bc, 8);
        this.addAllButton.setText(">>");
        this.addAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.addAllToMigrate();
            }
        });
        this.removeAllButton = new Button(bc, 8);
        this.removeAllButton.setText("<<");
        this.removeAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DLIModelMigrationWizardPage1.this.removeAllFromMigrate();
            }
        });
        GridData gd1 = new GridData(bWidth, -1);
        this.addButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(bWidth, -1);
        this.removeButton.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(bWidth, -1);
        gd3.verticalIndent = 20;
        this.addAllButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(bWidth, -1);
        this.removeAllButton.setLayoutData((Object)gd4);
        this.projectList = new List(this.composite, 2562);
        fd2 = this.uih.genFormData(new FormAttachment((Control)this.projectLabel, 5), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment((Control)bc, -10));
        this.projectList.setLayoutData((Object)fd2);
        this.migrateList = new List(this.composite, 2562);
        fd2 = this.uih.genFormData(new FormAttachment((Control)this.projectLabel, 5), new FormAttachment(100, 0), new FormAttachment((Control)bc, 10), new FormAttachment(100, 0));
        this.migrateList.setLayoutData((Object)fd2);
        FormData fd4 = this.uih.genFormData(((FormData)this.projectLabel.getLayoutData()).top, null, new FormAttachment((Control)bc, 10), new FormAttachment(100, 0));
        this.migrateLabel = this.uih.genLabel(this.composite, 16384, this.migrateLabelStr, this.uih.black, fd4);
        this.setControl((Control)this.composite);
    }

    private void computeButtonSize(Button button) {
        Point buttonSize = button.computeSize(-1, -1);
        button.setSize(buttonSize);
    }

    private boolean validatePage() {
        if (this.migrateAL.isEmpty()) {
            return false;
        }
        this.settings.put("appendStr", this.appendText.getText().trim());
        return true;
    }

    private void workspaceChange(String newDir) {
        this.wsCombo.setText(newDir);
        this.projectList.removeAll();
        this.migrateList.removeAll();
        this.checkForDLIProjects();
        if (this.projectList.getItemCount() > 0) {
            if (!this.knownDirs.contains(newDir)) {
                this.knownDirs.add(newDir);
            }
            String[] temp = new String[this.knownDirs.size()];
            temp = this.knownDirs.toArray(temp);
            this.settings.put("previouslyUsed", temp);
        }
    }

    private String performBrowseFile() {
        Shell shell = new Shell();
        DirectoryDialog fDialog = new DirectoryDialog(shell, -1);
        fDialog.setText(WorkbenchPlugin.labels.getString("WB496L"));
        String curDir = this.getCurrentDir();
        if (curDir != null && curDir.length() > 0) {
            fDialog.setFilterPath(curDir);
        }
        String browseDir = fDialog.open();
        return browseDir;
    }

    private void addSelectedToMigrate() {
        String[] projects = this.projectList.getSelection();
        if (projects != null) {
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                this.migrateList.add(p);
                this.projectList.remove(p);
                ++n2;
            }
        }
        this.updateMigrateAL();
        this.setPageComplete(this.validatePage());
    }

    private void addAllToMigrate() {
        String[] projects = this.projectList.getItems();
        if (projects != null) {
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                this.migrateList.add(p);
                ++n2;
            }
        }
        this.projectList.removeAll();
        this.updateMigrateAL();
        this.setPageComplete(this.validatePage());
    }

    private void removeSelectedFromMigrate() {
        String[] projects;
        String[] stringArray = projects = this.migrateList.getSelection();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.migrateList.remove(p);
            this.projectList.add(p);
            ++n2;
        }
        this.updateMigrateAL();
        this.setPageComplete(this.validatePage());
    }

    private void removeAllFromMigrate() {
        String[] projects = this.migrateList.getItems();
        if (projects != null) {
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                this.projectList.add(p);
                ++n2;
            }
        }
        this.migrateList.removeAll();
        this.migrateAL = new ArrayList();
        this.setPageComplete(this.validatePage());
    }

    private void updateMigrateAL() {
        String[] projects;
        this.migrateAL = new ArrayList();
        String[] stringArray = projects = this.migrateList.getItems();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.migrateAL.add(p);
            ++n2;
        }
    }

    private void checkForDLIProjects() {
        File root = new File(this.selectedDir);
        if (root != null && root.isDirectory()) {
            this.addDLIMUProjects(root, 0);
        } else {
            this.setErrorMessage(String.valueOf(root) + " " + this.errorMsg02);
        }
    }

    private void addDLIMUProjects(File dir, int depth) {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                DMUProjectHelp dmuHelp;
                File f = fileArray[n2];
                if (f.isDirectory() && (dmuHelp = new DMUProjectHelp(f)).isDMUProject()) {
                    this.projectList.add(f.getName());
                }
                ++n2;
            }
            this.setErrorMessage(null);
        }
        if (this.projectList.getItemCount() <= 0) {
            this.setErrorMessage(this.errorMsg01);
        }
    }

    public ArrayList<String> getMigrateAL() {
        return this.migrateAL;
    }

    public boolean doOverwrite() {
        return this.overwrite;
    }

    public String getCurrentDir() {
        return this.selectedDir;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

