/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.migratedmu;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.template.ManageTemplateController;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.IImsResourceModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.IMSSourceImporter;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.utilities.DmuToWbMigration;
import com.ibm.im.ims.workbench.utilities.MessageDialogRunner;
import com.ibm.im.ims.workbench.utilities.Warnings;
import com.ibm.im.ims.workbench.utilities.WizardDialogRunner;
import com.ibm.im.ims.workbench.wizard.managetemplate.ManageTemplateWizard;
import com.ibm.im.ims.workbench.wizard.migratedmu.DLIModelMigrationWizardPage1;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DLIModelMigrationWizard
extends Wizard
implements IImportWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private DLIModelMigrationWizardPage1 migrationWizardPage1;
    private String selectedWorkspaceDir;
    private ArrayList<String> migrateAL;
    private static final String xmlSchema = "XMLSchema";
    private static final String imsSource = "IMSSource";
    private String suffix = "_ex";
    int counter = 0;
    private String title = WorkbenchPlugin.labels.getString("WB513");
    StringBuffer buf = new StringBuffer();

    public DLIModelMigrationWizard() {
        this.setWindowTitle(this.title);
    }

    public void addPages() {
        this.migrationWizardPage1 = new DLIModelMigrationWizardPage1(" ");
        this.addPage((IWizardPage)this.migrationWizardPage1);
    }

    public boolean canFinish() {
        boolean retVal = false;
        if (this.migrationWizardPage1.isPageComplete()) {
            retVal = true;
        }
        return retVal;
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        DLIModelMigrationWizard.this.doFinish(monitor);
                    }
                    catch (Throwable e) {
                        logger.throwing(this.getClass().getName(), "performFinish()", e);
                        logger.error(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            pmd.run(true, true, op);
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            logger.error((Throwable)e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return true;
    }

    public boolean performCancel() {
        this.dispose();
        return true;
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
    }

    private void doFinish(IProgressMonitor monitor) throws IOException, ModelException, ParserConfigurationException, SAXException, CoreException, InvocationTargetException {
        ArrayList<String> projNames = new ArrayList<String>();
        this.selectedWorkspaceDir = this.migrationWizardPage1.getCurrentDir();
        this.migrateAL = this.migrationWizardPage1.getMigrateAL();
        if (this.selectedWorkspaceDir == null || this.selectedWorkspaceDir.isEmpty()) {
            return;
        }
        if (this.migrateAL == null || this.migrateAL.isEmpty()) {
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Iterator<String> iterator = this.migrateAL.iterator();
        while (iterator.hasNext()) {
            String projectName;
            String newProjectName = projectName = iterator.next();
            if (!this.migrationWizardPage1.doOverwrite()) {
                String append = this.migrationWizardPage1.getSuffix();
                if (append != null && !append.trim().isEmpty()) {
                    this.suffix = append;
                }
                newProjectName = this.renameProject(newProjectName + this.suffix, root);
                if (this.projectHasXML(this.selectedWorkspaceDir, projectName)) {
                    projNames.add(projectName);
                }
            }
            ProjectTreeFileHelper.createNewProject((String)newProjectName);
            monitor.worked(1);
            this.importIMSSource(this.selectedWorkspaceDir, projectName, newProjectName, monitor);
        }
        if (!projNames.isEmpty()) {
            this.buf.append(WorkbenchPlugin.errors.getString("DMUPPMW06")).append("\n");
            for (String prjName : projNames) {
                this.buf.append(prjName).append("\n");
            }
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Warnings warnings = new Warnings(DLIModelMigrationWizard.this.getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("DMUPPMW05"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        warnings.setWarnings(DLIModelMigrationWizard.this.buf.toString());
                        warnings.open();
                    }
                    catch (Throwable e) {
                        logger.throwing(this.getClass().getName(), "run()", e);
                        logger.error(e);
                    }
                }
            });
        }
    }

    private String renameProject(String name, IWorkspaceRoot root) {
        String newName = name;
        IProject project = root.getProject(newName);
        if (project.exists()) {
            int pos = newName.lastIndexOf("_");
            if (pos == -1) {
                ++this.counter;
                newName = this.renameProject(newName + "_" + this.counter, root);
                return newName;
            }
            String leftOver = newName.substring(pos + 1);
            try {
                int count = Integer.valueOf(leftOver);
                String temp = newName.substring(0, pos);
                newName = this.renameProject(temp + "_" + ++count, root);
                return newName;
            }
            catch (NumberFormatException numberFormatException) {
                ++this.counter;
                newName = this.renameProject(newName + "_" + this.counter, root);
                return newName;
            }
        }
        return newName;
    }

    private boolean projectHasXML(String sourceWorkspace, String sourceProject) {
        File imssource = null;
        File[] xmlSource = null;
        imssource = new File(sourceWorkspace + File.separator + sourceProject + File.separator + xmlSchema);
        xmlSource = imssource.listFiles(new XmlFileFilter());
        return xmlSource != null && xmlSource.length > 0;
    }

    private void importIMSSource(String sourceWorkspace, String sourceProject, String targetProject, IProgressMonitor monitor) throws CoreException, IOException, ModelException, ParserConfigurationException, SAXException, InvocationTargetException {
        File imssource = null;
        imssource = new File(sourceWorkspace + File.separator + sourceProject + File.separator + imsSource);
        if (imssource == null || !imssource.exists() || !imssource.isDirectory()) {
            return;
        }
        IMSSourceImporter importer = new IMSSourceImporter();
        Document mdlDoc = DmuToWbMigration.parseMDLFile(sourceWorkspace, sourceProject);
        File[] psbSources = imssource.listFiles(new PSBFileFilter());
        this.marshallPSB(targetProject, psbSources, importer, sourceWorkspace, sourceProject, mdlDoc, monitor);
        File[] dbdSources = imssource.listFiles(new DBDFileFilter());
        Vector<DbdModel> dbds = this.marshallDBD(targetProject, dbdSources, importer, sourceWorkspace, sourceProject, mdlDoc, monitor);
        ArrayList<String> dbdNames = new ArrayList<String>();
        for (DbdModel oneDbd : dbds) {
            dbdNames.add(oneDbd.getDBDName());
        }
        List listPsb = null;
        if (dbds.size() > 0) {
            listPsb = ProjectTreeFileHelper.findRelatedPSBs((String)targetProject, dbdNames);
        }
        if (listPsb != null) {
            this.marshallGeneratedDbViews(targetProject, listPsb, monitor);
        }
    }

    private void marshallGeneratedDbViews(String projectName, List<PsbModel> listPsb, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("explorer_enable_ims_jdbc")) {
            boolean createReplacement = false;
            int i = 0;
            while (i < listPsb.size()) {
                Runnable runner;
                PsbModel currPsb = listPsb.get(i);
                String psbName = currPsb.getPsbName();
                if (!createReplacement) {
                    String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                    String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
                    if (!JavaConventions.validateIdentifier((String)psbName, (String)sourceLevel, (String)complianceLevel).isOK()) {
                        MessageDialog messageDialog = new MessageDialog(this.getShell(), WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_7"), null, WorkbenchPlugin.errors.getString("IMPORT_WIZ_011"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                        runner = new MessageDialogRunner(messageDialog);
                        this.getShell().getDisplay().syncExec(runner);
                        boolean bl = createReplacement = messageDialog.getReturnCode() == 0;
                    }
                }
                if (createReplacement) {
                    try {
                        ManageTemplateController controller = new ManageTemplateController(projectName);
                        ManageTemplateWizard wizard = new ManageTemplateWizard(controller);
                        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                        runner = new WizardDialogRunner(dialog);
                        this.getShell().getDisplay().syncExec(runner);
                        if (dialog.getReturnCode() == 1) {
                            createReplacement = false;
                        }
                    }
                    catch (ModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD003") + WorkbenchPlugin.colon.getString("COLON") + psbName);
                ProjectTreeFileHelper.marshallGeneratedDbView((String)projectName, (PsbModel)currPsb);
                monitor.worked(1);
                ++i;
            }
        }
    }

    private void marshallPSB(String targetProject, File[] psbSources, IMSSourceImporter importer, String sourceWorkspace, String sourceProject, Document mdlDoc, IProgressMonitor monitor) throws IOException, ModelException, CoreException {
        if (psbSources != null && psbSources.length > 0) {
            File[] fileArray = psbSources;
            int n = psbSources.length;
            int n2 = 0;
            while (n2 < n) {
                File psbFile = fileArray[n2];
                try {
                    IImsResourceModel res;
                    Vector imsResources = importer.importImsResource(psbFile.getAbsolutePath());
                    if (imsResources.size() > 0 && (res = (IImsResourceModel)imsResources.get(0)).isPSB()) {
                        PsbModel psb = (PsbModel)res;
                        String psbName = psb.getPsbName();
                        this.savePSBSourceToProject(targetProject, psbName, psbFile, monitor);
                        DmuToWbMigration.augmentPsbWithMDLAttrs(psb, mdlDoc);
                        ByteArrayOutputStream psbOutputStream = new ByteArrayOutputStream();
                        psb.marshall(psbOutputStream);
                        ByteArrayInputStream psbInputStream = new ByteArrayInputStream(psbOutputStream.toByteArray());
                        IFile psbMetaFile = ProjectTreeFileHelper.getPsbMetadataFile((String)targetProject, (String)psb.getPsbName());
                        if (!psbMetaFile.exists()) {
                            psbMetaFile.create((InputStream)psbInputStream, true, monitor);
                        } else {
                            psbMetaFile.setContents((InputStream)psbInputStream, true, true, monitor);
                        }
                        this.generateImportedPSB(psb, targetProject, monitor);
                        psbInputStream.close();
                    }
                }
                catch (ImporterException e) {
                    logger.error((Throwable)e);
                }
                ++n2;
            }
        }
    }

    private void savePSBSourceToProject(String targetProject, String psbName, File psbFile, IProgressMonitor monitor) throws CoreException, IOException {
        FileInputStream is = new FileInputStream(psbFile);
        ProjectTreeFileHelper.marshallImportedPsbFile((String)targetProject, (String)ProjectTreeFileHelper.getUnqualFileName((String)psbFile.getPath()), (InputStream)is);
        ((InputStream)is).close();
    }

    private void generateImportedPSB(PsbModel psbModel, String targetProject, IProgressMonitor monitor) throws CoreException, ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "generateImportedPSB(PsbModel psbModel, String projectName, IProgressMonitor monitor) ", new Object[0]);
        IFile generatedSrcPsbFile = ProjectTreeFileHelper.getGenedSrcPsbFile((String)targetProject, (String)psbModel.getPsbName());
        String genedSrcFilePath = generatedSrcPsbFile.getName();
        monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD005") + WorkbenchPlugin.colon.getString("COLON") + genedSrcFilePath);
        ProjectTreeFileHelper.marshallGeneratedPsbFile((String)targetProject, (PsbModel)psbModel);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "generateImportedPSB(PsbModel psbModel, String projectName, IProgressMonitor monitor)  ", new Object[0]);
    }

    private void saveDBDSourceToProject(String targetProject, String dbdName, File dbdFile, IProgressMonitor monitor) throws CoreException, IOException {
        FileInputStream is = new FileInputStream(dbdFile);
        ProjectTreeFileHelper.marshallImportedDbdFile((String)targetProject, (String)ProjectTreeFileHelper.getUnqualFileName((String)dbdFile.getPath()), (InputStream)is);
        ((InputStream)is).close();
    }

    private void generateImportedDbd(DbdModel dbdModel, String projectName, IProgressMonitor monitor) throws CoreException, IOException, ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "generateImportedDbd(DbdModel dbdModel, String projectName, IProgressMonitor monitor)", new Object[0]);
        IFile generatedSrcDbdFile = ProjectTreeFileHelper.getGenedSrcDbdFile((String)projectName, (String)dbdModel.getDbd().getDbdName());
        monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD006") + WorkbenchPlugin.colon.getString("COLON") + generatedSrcDbdFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallGeneratedDbdFile((String)projectName, (DbdModel)dbdModel);
        ProjectTreeFileHelper.marshallGeneratedDdlFile((String)projectName, (DbdModel)dbdModel);
        IFile generatedCatSrcDbdFile = ProjectTreeFileHelper.getGenedCatalogSrcDbdFile((String)projectName, (String)dbdModel.getDbd().getDbdName());
        monitor.subTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD006") + WorkbenchPlugin.colon.getString("COLON") + generatedCatSrcDbdFile.getFullPath().toString());
        ProjectTreeFileHelper.marshallCatalogEnabledGeneratedDbdFile((String)projectName, (DbdModel)dbdModel);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "generateImportedDbd(DbdModel dbdModel, String projectName, IProgressMonitor monitor)", new Object[0]);
    }

    private Vector<DbdModel> marshallDBD(String targetProject, File[] dbdSources, IMSSourceImporter importer, String sourceWorkspace, String sourceProject, Document mdlDoc, IProgressMonitor monitor) throws IOException, ModelException, CoreException, ParserConfigurationException, SAXException {
        Vector<DbdModel> retVal = new Vector<DbdModel>();
        if (dbdSources != null && dbdSources.length > 0) {
            File[] fileArray = dbdSources;
            int n = dbdSources.length;
            int n2 = 0;
            while (n2 < n) {
                File dbdFile = fileArray[n2];
                try {
                    IImsResourceModel res;
                    Vector imsResources = importer.importImsResource(dbdFile.getAbsolutePath());
                    if (imsResources.size() > 0 && (res = (IImsResourceModel)imsResources.get(0)).isDBD()) {
                        DbdModel dbd = (DbdModel)res;
                        String defaultEncoding = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
                        dbd.setEncoding(defaultEncoding);
                        retVal.add(dbd);
                        String dbdName = dbd.getDBDName();
                        this.saveDBDSourceToProject(targetProject, dbdName, dbdFile, monitor);
                        DmuToWbMigration.augmentDbdWithMDLAttrs(dbd, mdlDoc);
                        ByteArrayOutputStream dbdOutputStream = new ByteArrayOutputStream();
                        dbd.marshall(dbdOutputStream);
                        ByteArrayInputStream dbdInputStream = new ByteArrayInputStream(dbdOutputStream.toByteArray());
                        IFile dbdMetaFile = ProjectTreeFileHelper.getDbdMetadataFile((String)targetProject, (String)dbd.getDBDName());
                        if (!dbdMetaFile.exists()) {
                            dbdMetaFile.create((InputStream)dbdInputStream, true, monitor);
                        } else {
                            dbdMetaFile.setContents((InputStream)dbdInputStream, true, true, monitor);
                        }
                        this.generateImportedDbd(dbd, targetProject, monitor);
                        dbdInputStream.close();
                    }
                }
                catch (ImporterException e) {
                    logger.error((Throwable)e);
                }
                ++n2;
            }
        }
        return retVal;
    }

    class DBDFileFilter
    implements FileFilter {
        DBDFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".dbd");
        }
    }

    class PSBFileFilter
    implements FileFilter {
        PSBFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".psb");
        }
    }

    class XmiFileFilter
    implements FileFilter {
        XmiFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".xmi");
        }
    }

    class XmlFileFilter
    implements FileFilter {
        XmlFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".xsd");
        }
    }
}

