/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managetemplate;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.template.EditTemplateController;
import com.ibm.im.ims.workbench.controller.template.ManageTemplateController;
import com.ibm.im.ims.workbench.model.TemplateModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managetemplate.EditTemplateWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ManageTemplateWizardPage1
extends WizardPage
implements SelectionListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String PAGE_NAME = "TEMPLATE";
    public static final int BUTTON_WIDTH = 100;
    private ManageTemplateController mtController;
    private Button addTemplateButton;
    private Button editTemplateButton;
    private Button removeTemplateButton;
    private Link templateHelpLink;
    private Table templateTable;
    private String templateName;
    private int margin = 5;

    public ManageTemplateWizardPage1(ManageTemplateController mtController) {
        super(PAGE_NAME);
        this.setTitle(WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_2"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("manage_template_wizard")));
        this.setDescription(WorkbenchPlugin.descriptions.getString("MANAGE_TEMPLATE_3"));
        this.mtController = mtController;
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            UIHelper uih = new UIHelper();
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB008A")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB042A")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB009A"))};
            int buttonWidth = Utility.getMaxSize(labelSizes) + this.margin;
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            FormLayout templateFL = new FormLayout();
            templateFL.marginHeight = 5;
            templateFL.marginWidth = 5;
            FormData formData = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            final Group templateGrp = new Group(composite, 0);
            templateGrp.setText(WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_4"));
            templateGrp.setLayout((Layout)templateFL);
            templateGrp.setLayoutData((Object)formData);
            formData = uih.genFormData(new FormAttachment((Control)templateGrp, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            formData.width = templateGrp.getClientArea().width;
            this.templateHelpLink = new Link((Composite)templateGrp, 16384);
            this.templateHelpLink.setText("");
            this.templateHelpLink.setLayoutData((Object)formData);
            formData = uih.genFormData(new FormAttachment((Control)this.templateHelpLink, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.addTemplateButton = new Button((Composite)templateGrp, 0x1000000);
            this.addTemplateButton.setText(WorkbenchPlugin.labels.getString("WB008A"));
            this.addTemplateButton.setLayoutData((Object)formData);
            this.addTemplateButton.setEnabled(true);
            formData = uih.genFormData(new FormAttachment((Control)this.addTemplateButton, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.editTemplateButton = new Button((Composite)templateGrp, 0x1000000);
            this.editTemplateButton.setText(WorkbenchPlugin.labels.getString("WB042A"));
            this.editTemplateButton.setLayoutData((Object)formData);
            this.editTemplateButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.editTemplateButton, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.removeTemplateButton = new Button((Composite)templateGrp, 0x1000000);
            this.removeTemplateButton.setText(WorkbenchPlugin.labels.getString("WB009A"));
            this.removeTemplateButton.setLayoutData((Object)formData);
            this.removeTemplateButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.templateHelpLink, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment((Control)this.addTemplateButton, -10));
            formData.height = 100;
            this.templateTable = new Table((Composite)templateGrp, 268503042);
            String[] columnLabels = new String[]{WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_5"), WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_6")};
            this.templateTable.setLinesVisible(true);
            this.templateTable.setHeaderVisible(true);
            this.templateTable.setLayoutData((Object)formData);
            this.setColumns(this.templateTable, columnLabels);
            this.setControl((Control)composite);
            this.setPageComplete(false);
            this.setErrorMessage(null);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.wb_template_over");
            this.initWidgetValues();
            this.addListeners();
            templateGrp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = templateGrp.getClientArea();
                    int width = area.width - 2 * ManageTemplateWizardPage1.this.templateTable.getBorderWidth();
                    TableColumn[] tableColumns = ManageTemplateWizardPage1.this.templateTable.getColumns();
                    ManageTemplateWizardPage1.this.templateTable.setSize(area.width, area.height);
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            this.getContainer().getShell().setMinimumSize(550, 550);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    private void setColumns(Table table, String[] columnsLabels) {
        int i = 0;
        while (i < columnsLabels.length) {
            this.setColumn(table, columnsLabels[i]);
            ++i;
        }
    }

    private void addListeners() {
        this.templateHelpLink.addSelectionListener((SelectionListener)this);
        this.addTemplateButton.addSelectionListener((SelectionListener)this);
        this.editTemplateButton.addSelectionListener((SelectionListener)this);
        this.removeTemplateButton.addSelectionListener((SelectionListener)this);
        this.templateTable.addSelectionListener((SelectionListener)this);
    }

    private void initWidgetValues() {
        this.populateTableFromTemplates(this.mtController.getTemplates());
        if (this.templateTable.getItemCount() > 0) {
            this.templateTable.setSelection(0);
        }
    }

    private void populateTableFromTemplates(List<TemplateModel> tm) {
        int i = 0;
        while (i < tm.size()) {
            TemplateModel currTemplate = tm.get(i);
            TableItem newTableItem = new TableItem(this.templateTable, 0);
            this.populateTableItemFromTemplate(newTableItem, currTemplate);
            ++i;
        }
    }

    private void populateTableItemFromTemplate(TableItem currentTableItem, TemplateModel templateModel) {
        String templateName = templateModel.getTemplateName();
        String varString = templateModel.getVarString();
        currentTableItem.setText(0, templateName);
        currentTableItem.setText(1, varString);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.templateHelpLink) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.wb_template_over");
        } else if (event.getSource() == this.templateTable) {
            this.enableTemplateButtons();
        } else if (event.getSource() == this.addTemplateButton) {
            try {
                this.handleTemplateAdd();
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl handle for add)", e);
                logger.error(e);
            }
        } else if (event.getSource() == this.editTemplateButton) {
            try {
                this.handleTemplateEdit();
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl handle for edit", e);
                logger.error(e);
            }
        } else if (event.getSource() == this.removeTemplateButton) {
            this.handleRemoveTemplate();
        }
        this.setPageComplete(this.mtController.hasBeenEdited());
    }

    private void handleRemoveTemplate() {
        TableItem[] templateItems = this.templateTable.getSelection();
        String[] templateNames = new String[templateItems.length];
        int i = 0;
        while (i < templateItems.length) {
            templateNames[i] = templateItems[i].getText(0);
            ++i;
        }
        this.mtController.removeTemplate(templateNames);
        this.refreshTemplateTable();
        if (this.templateTable.getItemCount() > 0) {
            this.templateTable.setSelection(0);
        }
        this.enableTemplateButtons();
    }

    private void refreshTemplateTable() {
        if (this.templateTable.getItemCount() > 0) {
            this.templateTable.removeAll();
        }
        this.populateTableFromTemplates(this.mtController.getTemplates());
    }

    private void handleTemplateEdit() throws InvalidInputException {
        if (this.templateTable.getSelection() == null || this.templateTable.getSelection().length == 0) {
            return;
        }
        TableItem selectedItem = this.templateTable.getSelection()[0];
        String templatename = selectedItem.getText(0);
        EditTemplateController etController = new EditTemplateController(this.mtController, templatename, "EDIT");
        EditTemplateWizard editTemplateWizard = new EditTemplateWizard(etController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editTemplateWizard);
        dialog.create();
        dialog.getShell().setSize(editTemplateWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshTemplateTable();
        }
    }

    private void handleTemplateAdd() throws InvalidInputException {
        EditTemplateWizard editTemplateWizard = null;
        EditTemplateController etController = null;
        etController = new EditTemplateController(this.mtController, this.templateName, "ADD");
        editTemplateWizard = new EditTemplateWizard(etController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editTemplateWizard);
        dialog.create();
        dialog.getShell().setSize(editTemplateWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshTemplateTable();
            String addedTemplateName = etController.getTemplateName();
            TableItem tabItem = this.getTableItemForTemplate(addedTemplateName);
            int tiIndex = this.templateTable.indexOf(tabItem);
            this.templateTable.select(tiIndex);
        }
    }

    private void enableTemplateButtons() {
        int numSelected = this.templateTable.getSelectionCount();
        if (numSelected == 0) {
            this.editTemplateButton.setEnabled(false);
            this.removeTemplateButton.setEnabled(false);
        } else if (numSelected == 1) {
            this.editTemplateButton.setEnabled(true);
            this.removeTemplateButton.setEnabled(true);
        } else if (numSelected > 1) {
            this.editTemplateButton.setEnabled(false);
            this.removeTemplateButton.setEnabled(true);
        }
    }

    private TableItem getTableItemForTemplate(String templateName) {
        TableItem[] tableItemArray = this.templateTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getText(0).equals(templateName)) {
                return ti;
            }
            ++n2;
        }
        return null;
    }

    public void modifyText(ModifyEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.templateTable) {
                if (this.templateTable.getItemCount() > 0) {
                    this.setPageComplete(true);
                } else {
                    this.setPageComplete(false);
                }
            }
        }
        catch (Exception err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", (Throwable)err);
            logger.error((Throwable)err);
        }
    }
}

