/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managetemplate;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.template.EditTemplateController;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.EAMessageControl;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managetemplate.EditTemplateWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditTemplateWizardPage1
extends WizardPage
implements SelectionListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAGE_NAME = "EditTemplateWizardPage1";
    private EditTemplateController editTemplateController;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EAMessageControl msgControl = null;
    public static final String TEMPLATE_NAME = "TEMPLATE_NAME";
    public static final String ALL = "ALL";
    public static final String VARIABLE_STRING = "VARIABLE_STRING";
    public static final String REPLACEMENT_STRING = "REPLACEMENT_STRING";
    private static final String REPLACEMENT_LABEL = WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_4") + WorkbenchPlugin.colon.getString("COLON");
    private static final String TEMPLATE_NAME_LABEL = WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_1") + WorkbenchPlugin.colon.getString("COLON");
    private static final String VARIABLE_STRING_LABEL = WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_2") + WorkbenchPlugin.colon.getString("COLON");
    private static final String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
    private static final String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
    private int verticalOffset = 10;
    private int horizontalOffset = 10;
    private int margin = 2;
    private int reqFieldSize = 5;
    private Label labelReqTemplateName;
    private Label labelTemplateName;
    private Label labelVariableString;
    private Label labelReplacementStr;
    private Label labelReqVariableStr;
    private Text textTemplateName;
    private Text textVariableString;
    private Text textReplacement;
    private Link templateHelpLink;
    private Button addButton;
    private Button removeButton;
    private Table replacementStringTable;

    protected EditTemplateWizardPage1(EditTemplateController editTemplateController) {
        super(PAGE_NAME);
        this.setTitle(WorkbenchPlugin.descriptions.getString("EDIT_TEMPLATE_SUBTITLE"));
        if (editTemplateController.getActionType().equals("ADD")) {
            this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("add_template_wizard")));
            this.setDescription(WorkbenchPlugin.descriptions.getString("ADD_TEMPLATE_DESCRIPTION"));
        } else {
            this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("edit_template_wizard")));
            this.setDescription(WorkbenchPlugin.descriptions.getString("EDIT_TEMPLATE_DESCRIPTION"));
        }
        this.editTemplateController = editTemplateController;
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            UIHelper uih = new UIHelper();
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            composite.setLayoutData((Object)fd);
            int[] buttonSizes = new int[]{Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB008A")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB042A")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB009A"))};
            int buttonWidth = Utility.getMaxSize(buttonSizes) + this.margin;
            int[] labelSizes = new int[]{Utility.getTextWidth(composite, 0, TEMPLATE_NAME_LABEL), Utility.getTextWidth(composite, 0, VARIABLE_STRING_LABEL), Utility.getTextWidth(composite, 0, REPLACEMENT_LABEL)};
            int labelWidth = Utility.getMaxSize(labelSizes) + Utility.getTextWidth(parent, 0, "*");
            fd = uih.genFormData(new FormAttachment(0, this.verticalOffset), null, new FormAttachment(0, this.margin), null);
            this.labelReqTemplateName = uih.genRequiredSymbol(composite, 0, fd, composite.getDisplay().getSystemColor(3));
            this.labelReqTemplateName.setFont(this.getFont());
            fd = uih.genFormData(new FormAttachment(0, this.verticalOffset), null, new FormAttachment((Control)this.labelReqTemplateName, this.margin), null);
            this.labelTemplateName = new Label(composite, 0);
            this.labelTemplateName.setText(TEMPLATE_NAME_LABEL);
            this.labelTemplateName.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment(0, this.verticalOffset), null, new FormAttachment(0, labelWidth), new FormAttachment(70, -this.horizontalOffset));
            this.textTemplateName = new Text(composite, 2052);
            this.textTemplateName.setTextLimit(8);
            this.textTemplateName.setToolTipText(WorkbenchPlugin.descriptions.getString("WB079"));
            this.textTemplateName.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.labelTemplateName, this.verticalOffset + 5), null, new FormAttachment(0, this.margin), null);
            this.labelReqVariableStr = uih.genRequiredSymbol(composite, 0, fd, display.getSystemColor(3));
            this.labelReqVariableStr.setFont(this.getFont());
            fd = uih.genFormData(new FormAttachment((Control)this.labelTemplateName, this.verticalOffset + 5), null, new FormAttachment((Control)this.labelReqVariableStr, this.margin), null);
            this.labelVariableString = new Label(composite, 0);
            this.labelVariableString.setText(VARIABLE_STRING_LABEL);
            this.labelVariableString.setToolTipText(WorkbenchPlugin.descriptions.getString("TEMPLATENAME_HOVERTXT01"));
            this.labelVariableString.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.labelTemplateName, this.verticalOffset + 5), null, new FormAttachment(0, labelWidth), new FormAttachment(70, -this.horizontalOffset));
            this.textVariableString = new Text(composite, 2052);
            this.textVariableString.setTextLimit(8);
            this.textVariableString.setToolTipText(WorkbenchPlugin.descriptions.getString("VARIABLESTRING_HOVERTXT02"));
            this.textVariableString.setLayoutData((Object)fd);
            FormLayout templateFL = new FormLayout();
            templateFL.marginHeight = 5;
            templateFL.marginWidth = 5;
            FormData formData = uih.genFormData(new FormAttachment((Control)this.labelVariableString, this.verticalOffset + 5), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            Group replacementGrp = new Group(composite, 0);
            replacementGrp.setText(WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_7"));
            replacementGrp.setLayout((Layout)templateFL);
            replacementGrp.setLayoutData((Object)formData);
            formData = uih.genFormData(new FormAttachment((Control)replacementGrp, this.verticalOffset), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            formData.width = replacementGrp.getClientArea().width;
            this.templateHelpLink = new Link((Composite)replacementGrp, 16384);
            String textLink = WorkbenchPlugin.descriptions.getString("MANAGE_TEMPLATE_1");
            this.templateHelpLink.setText(textLink);
            this.templateHelpLink.setLayoutData((Object)formData);
            fd = uih.genFormData(new FormAttachment((Control)this.templateHelpLink, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
            fd = uih.genFormData(new FormAttachment((Control)this.templateHelpLink, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
            this.labelReplacementStr = new Label((Composite)replacementGrp, 0);
            this.labelReplacementStr.setText(REPLACEMENT_LABEL);
            this.labelReplacementStr.setLayoutData((Object)fd);
            formData = uih.genFormData(new FormAttachment((Control)this.templateHelpLink, this.verticalOffset + this.margin), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.addButton = new Button((Composite)replacementGrp, 0x1000000);
            this.addButton.setText(WorkbenchPlugin.labels.getString("WB008A"));
            this.addButton.setLayoutData((Object)formData);
            this.addButton.setEnabled(false);
            fd = uih.genFormData(new FormAttachment((Control)this.templateHelpLink, this.verticalOffset + this.margin), null, new FormAttachment(0, labelWidth - this.margin * 2), new FormAttachment((Control)this.addButton, -20));
            this.textReplacement = new Text((Composite)replacementGrp, 2052);
            this.textReplacement.setToolTipText(WorkbenchPlugin.descriptions.getString("REPLACEMENT_HOVERTXT03"));
            this.textReplacement.setTextLimit(8);
            this.textReplacement.setLayoutData((Object)fd);
            formData = uih.genFormData(new FormAttachment((Control)this.addButton, this.verticalOffset + this.margin), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.removeButton = new Button((Composite)replacementGrp, 0x1000000);
            this.removeButton.setText(WorkbenchPlugin.labels.getString("WB009A"));
            this.removeButton.setLayoutData((Object)formData);
            this.removeButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.labelReplacementStr, this.verticalOffset + 5), null, new FormAttachment(0, 0), new FormAttachment((Control)this.removeButton, -20));
            formData.height = 120;
            Composite tableWrap = new Composite((Composite)replacementGrp, 0);
            tableWrap.setLayoutData((Object)formData);
            this.replacementStringTable = new Table(tableWrap, 268503554);
            this.replacementStringTable.addSelectionListener((SelectionListener)this);
            String columTable = WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_5");
            this.replacementStringTable.setLinesVisible(true);
            this.replacementStringTable.setHeaderVisible(true);
            this.setColumn(this.replacementStringTable, columTable);
            Control[] replacementList = new Control[]{this.textReplacement, this.addButton, tableWrap, this.removeButton};
            replacementGrp.setTabList(replacementList);
            this.msgControl = new EAMessageControl(composite);
            this.addMessageControls();
            this.initWidgetValues();
            TableColumnLayout tableLayout = new TableColumnLayout();
            tableWrap.setLayout((Layout)tableLayout);
            tableLayout.setColumnData((Widget)this.replacementStringTable.getColumn(0), (ColumnLayoutData)new ColumnWeightData(100));
            if (this.getWiz().isEditAction()) {
                this.validatePage();
            }
            int minimumSize = this.reqFieldSize + labelWidth + Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_5"));
            this.getContainer().getShell().setMinimumSize(minimumSize, 640);
            this.setControl((Control)composite);
            this.addListeners();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.ies1_wb_managetemplate1");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    private void initWidgetValues() {
        if (this.editTemplateController.getActionType().equals("EDIT")) {
            this.textTemplateName.setText(this.editTemplateController.getTemplateName().toUpperCase());
            this.textVariableString.setText(this.editTemplateController.getVarString());
            ArrayList replacementStrings = this.editTemplateController.getReplacementStrings();
            this.populateTableItemFromReplacementString(replacementStrings);
        }
    }

    private void populateTableItemFromReplacementString(List<String> replacementStrings) {
        if (replacementStrings != null) {
            int i = 0;
            while (i < replacementStrings.size()) {
                TableItem item = new TableItem(this.replacementStringTable, 0);
                item.setText(0, replacementStrings.get(i));
                ++i;
            }
        }
        this.replacementStringTable.getColumn(0).pack();
    }

    private void addListeners() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.textTemplateName.addModifyListener((ModifyListener)this);
        this.textVariableString.addModifyListener((ModifyListener)this);
        this.textReplacement.addModifyListener((ModifyListener)this);
    }

    public void removeListeners() {
        this.addButton.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.textTemplateName.removeModifyListener((ModifyListener)this);
        this.textVariableString.removeModifyListener((ModifyListener)this);
        this.textReplacement.removeModifyListener((ModifyListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.addButton) {
                this.handleAddReplacementString();
            }
            if (source == this.removeButton) {
                this.handleRemoveReplacementString();
            }
            if (source == this.replacementStringTable) {
                this.handleTableSelection();
            }
            this.validatePage();
        }
        catch (Throwable err) {
            this.setPageComplete(false);
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            return;
        }
    }

    private void handleAddReplacementString() throws InvalidInputException {
        String newReplStr = this.textReplacement.getText();
        if (!this.validateReplacementString(newReplStr)) {
            return;
        }
        TableItem ti = new TableItem(this.replacementStringTable, 0);
        ti.setText(0, newReplStr);
        this.replacementStringTable.getColumn(0).pack();
        this.editTemplateController.addReplacementString(newReplStr);
        this.textReplacement.setText("");
        this.textReplacement.setFocus();
        this.msgControl.clearValidationMessage((Control)this.textReplacement);
        this.setErrorMessage(null);
    }

    private void handleTableSelection() {
        TableItem[] selecteds = this.replacementStringTable.getSelection();
        if (selecteds != null && selecteds.length > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private void handleRemoveReplacementString() throws ModelException, InvalidInputException {
        TableItem[] selecteds = this.replacementStringTable.getSelection();
        int[] selInds = new int[selecteds.length];
        int i = 0;
        while (i < selecteds.length) {
            selInds[i] = this.replacementStringTable.indexOf(selecteds[i]);
            ++i;
        }
        TableItem[] tableItemArray = selecteds;
        int n = selecteds.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            this.editTemplateController.removeReplacementString(ti.getText());
            ++n2;
        }
        this.replacementStringTable.remove(selInds);
        this.validatePage();
    }

    public void validatePage() throws ModelException, InvalidInputException {
        try {
            boolean replStringOK = this.validateReplacementString(this.textReplacement.getText());
            boolean tempateNameOK = this.valdidateInputTemplateName();
            boolean variableStringOK = this.valdidateInputVariableString();
            if (tempateNameOK && variableStringOK && replStringOK) {
                this.setErrorMessage(null);
            }
            this.editTemplateController.validateAllRequiredFields();
            this.editTemplateController.semanticCheck();
            this.setPageComplete(true);
        }
        catch (InvalidInputException ex) {
            this.setPageComplete(false);
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", (Throwable)ex);
            throw ex;
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.textReplacement) {
                this.addButton.setEnabled(false);
                String s = this.textReplacement.getText();
                if (s != null && !s.isEmpty() && this.validateReplacementString(s)) {
                    this.addButton.setEnabled(true);
                }
            } else if (source == this.textTemplateName) {
                this.editTemplateController.setTemplateName(this.textTemplateName.getText());
                this.valdidateInputTemplateName();
            } else if (source == this.textVariableString) {
                this.editTemplateController.setVarString(this.textVariableString.getText());
                this.valdidateInputVariableString();
            }
            this.validatePage();
        }
        catch (Exception err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", (Throwable)err);
        }
    }

    private boolean validateReplacementString(String s) {
        if (s != null && !s.isEmpty() && !this.validateInputReplacementString(s)) {
            Object[] inserts = new Object[]{WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_3"), s};
            this.msgControl.setValidationMessage((Control)this.textReplacement, WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_5", inserts), 3);
            this.setErrorMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_5", inserts));
            return false;
        }
        if (this.editTemplateController.containsReplacementString(s)) {
            String templateName = this.editTemplateController.getTemplateName();
            Object[] inserts = new Object[]{templateName, s};
            String errorMsg = WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_1", inserts);
            this.msgControl.setValidationMessage((Control)this.textReplacement, errorMsg, 3);
            this.setErrorMessage(errorMsg);
            return false;
        }
        this.msgControl.clearValidationMessage((Control)this.textReplacement);
        this.setErrorMessage(null);
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public String getTemplateName() {
        return this.editTemplateController.getTemplateName();
    }

    private void addMessageControls() {
        this.msgControl.addControl((Control)this.textTemplateName);
        this.msgControl.addControl((Control)this.textVariableString);
        this.msgControl.addControl((Control)this.textReplacement);
    }

    public String getVariableString() {
        return this.editTemplateController.getVarString();
    }

    public boolean valdidateInputTemplateName() {
        Object[] inserts;
        String templateNameStr = this.textTemplateName.getText();
        boolean isValid = true;
        if (templateNameStr.isEmpty()) {
            inserts = new Object[]{WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_1")};
            this.msgControl.setValidationMessage((Control)this.textTemplateName, WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_4", inserts), 3);
            this.setErrorMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_4", inserts));
            isValid = false;
        } else if (templateNameStr.contains(" ")) {
            inserts = new Object[]{WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_1")};
            this.msgControl.setValidationMessage((Control)this.textTemplateName, WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_10", inserts), 3);
            this.setErrorMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_10", inserts));
            isValid = false;
        }
        if (isValid) {
            if (this.editTemplateController.templateNameHasChanged(templateNameStr) && this.editTemplateController.isNewTemplateNameTaken(templateNameStr)) {
                inserts = new Object[]{this.editTemplateController.getTemplateName()};
                this.msgControl.setValidationMessage((Control)this.textTemplateName, WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_3", inserts), 3);
                this.setErrorMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_3", inserts));
                isValid = false;
            } else if (!this.editTemplateController.isTemplateNameValid(templateNameStr)) {
                inserts = new Object[]{templateNameStr, WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_1")};
                String msg = WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_5", inserts);
                this.msgControl.setValidationMessage((Control)this.textTemplateName, msg, 3);
                this.setErrorMessage(msg);
                isValid = false;
            }
        }
        if (isValid) {
            this.msgControl.clearValidationMessage((Control)this.textTemplateName);
        } else {
            this.setPageComplete(false);
        }
        return isValid;
    }

    public boolean valdidateInputVariableString() throws ModelException {
        Object[] inserts;
        String variableStr = this.textVariableString.getText();
        boolean isValid = true;
        if (variableStr.isEmpty()) {
            inserts = new Object[]{WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_2")};
            this.msgControl.setValidationMessage((Control)this.textVariableString, WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_4", inserts), 3);
            this.setErrorMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_4", inserts));
            isValid = false;
        } else if (variableStr.contains(" ")) {
            inserts = new Object[]{WorkbenchPlugin.labels.getString("EDIT_TEMPLATE_WIZ_2")};
            this.msgControl.setValidationMessage((Control)this.textVariableString, WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_10", inserts), 3);
            this.setErrorMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_10", inserts));
            isValid = false;
        }
        if (isValid && this.editTemplateController.variableStringHasChanged(variableStr) && this.editTemplateController.isNewVariableStringTaken(variableStr)) {
            inserts = new Object[]{this.editTemplateController.getVarString()};
            this.msgControl.setValidationMessage((Control)this.textVariableString, WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_9", inserts), 3);
            this.setErrorMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_9", inserts));
            isValid = false;
        }
        if (isValid) {
            this.msgControl.clearValidationMessage((Control)this.textVariableString);
        } else {
            this.setPageComplete(false);
        }
        return isValid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.validatePage();
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            }
        }
    }

    protected EditTemplateWizard getWiz() {
        return (EditTemplateWizard)this.getWizard();
    }

    private boolean validateInputReplacementString(String inputStr) {
        if (inputStr == null || inputStr.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < inputStr.length()) {
            char currentChar = inputStr.charAt(i);
            if (currentChar == '@' || currentChar == '#' || currentChar == ' ' || com.ibm.im.ims.workbench.model.utilities.Utility.isSpecialChar((char)inputStr.charAt(i))) {
                return false;
            }
            if (Character.isLetter(currentChar) && !JavaConventions.validateIdentifier((String)inputStr.substring(i), (String)sourceLevel, (String)complianceLevel).isOK()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

