/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managesenfld;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.field.EditSenfldController;
import com.ibm.im.ims.workbench.controller.field.ManageSenfldsController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managesenfld.EditSenfldWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ManageSenfldsWizardPage1
extends WizardPage
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ManageSenfldsController msfController;
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private Group fieldGrp;
    private Table fieldTab;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private static final int margin = 5;

    protected ManageSenfldsWizardPage1(String pageName, ManageSenfldsController msfController) {
        super(pageName);
        this.msfController = msfController;
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_wizard_large")));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB605"));
        this.setTitle(WorkbenchPlugin.labels.getString("WB038B"));
    }

    public void createControl(Composite parent) {
        try {
            this.uih = new UIHelper();
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            this.composite.setLayoutData((Object)fd);
            FormLayout fldFL = new FormLayout();
            fldFL.marginHeight = 5;
            fldFL.marginWidth = 5;
            fd = this.uih.genFormData(new FormAttachment(0, 4), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment(100, 0));
            this.fieldGrp = new Group(this.composite, 0);
            this.fieldGrp.setText(WorkbenchPlugin.labels.getString("WB047A"));
            this.fieldGrp.setLayout((Layout)fldFL);
            this.fieldGrp.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.fieldGrp, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            fd.width = this.fieldGrp.getClientArea().width;
            Link fldHelpLink = new Link((Composite)this.fieldGrp, 16384);
            String textLink = WorkbenchPlugin.descriptions.getString("WB078A") + "  <a>" + WorkbenchPlugin.descriptions.getString("WB070") + "</a>";
            fldHelpLink.setText(textLink);
            fldHelpLink.setLayoutData((Object)fd);
            fldHelpLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_senfld");
                }
            });
            int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB008A")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB042A")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB009A"))};
            int buttonWidth = Utility.getMaxSize(labelSizes) + 5;
            fd = this.uih.genFormData(new FormAttachment((Control)fldHelpLink, 10), null, null, new FormAttachment(100, 0));
            fd.width = buttonWidth;
            this.addButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.addButton.setText(WorkbenchPlugin.labels.getString("WB008A"));
            this.addButton.setLayoutData((Object)fd);
            this.addButton.addSelectionListener((SelectionListener)this);
            this.addButton.setEnabled(true);
            fd = this.uih.genFormData(new FormAttachment((Control)this.addButton, 10), null, null, new FormAttachment(100, 0));
            fd.width = buttonWidth;
            this.editButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.editButton.setText(WorkbenchPlugin.labels.getString("WB042A"));
            this.editButton.setLayoutData((Object)fd);
            this.editButton.addSelectionListener((SelectionListener)this);
            this.editButton.setEnabled(false);
            fd = this.uih.genFormData(new FormAttachment((Control)this.editButton, 10), null, null, new FormAttachment(100, 0));
            fd.width = buttonWidth;
            this.removeButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.removeButton.setText(WorkbenchPlugin.labels.getString("WB009A"));
            this.removeButton.setLayoutData((Object)fd);
            this.removeButton.addSelectionListener((SelectionListener)this);
            this.removeButton.setEnabled(false);
            fd = this.uih.genFormData(new FormAttachment((Control)fldHelpLink, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment((Control)this.addButton, -10));
            this.fieldTab = new Table((Composite)this.fieldGrp, 268503042);
            this.fieldTab.addSelectionListener((SelectionListener)this);
            String[] columnLabels = new String[]{WorkbenchPlugin.noxlatlabels.getString("WB059"), WorkbenchPlugin.noxlatlabels.getString("WB061"), WorkbenchPlugin.noxlatlabels.getString("WB071")};
            this.fieldTab.setLinesVisible(true);
            this.fieldTab.setHeaderVisible(true);
            this.fieldTab.setLayoutData((Object)fd);
            this.setColumns(this.fieldTab, columnLabels);
            this.fieldGrp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = ManageSenfldsWizardPage1.this.fieldGrp.getClientArea();
                    int width = area.width - 2 * ManageSenfldsWizardPage1.this.fieldTab.getBorderWidth();
                    TableColumn[] tableColumns = ManageSenfldsWizardPage1.this.fieldTab.getColumns();
                    ManageSenfldsWizardPage1.this.fieldTab.setSize(area.width, area.height);
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            Control[] fieldGrpTabList = new Control[]{fldHelpLink, this.fieldTab, this.addButton, this.editButton, this.removeButton};
            this.fieldGrp.setTabList(fieldGrpTabList);
            this.getContainer().getShell().setMinimumSize(600, 500);
            this.setControl((Control)this.composite);
            this.refreshSenfldTable();
            if (this.msfController.isReadOnly()) {
                this.addButton.setEnabled(false);
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    public void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    public void setColumns(Table table, String[] columnsLabels) {
        int i = 0;
        while (i < columnsLabels.length) {
            this.setColumn(table, columnsLabels[i]);
            ++i;
        }
    }

    private void refreshSenfldTable() throws ModelException {
        ArrayList allFields = this.msfController.getFreshSenfldList();
        this.fieldTab.removeAll();
        if (allFields != null) {
            this.populateTableFromFields(allFields);
        }
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void populateTableFromFields(ArrayList<SenfieldModel> senflds) {
        int i = 0;
        while (i < senflds.size()) {
            SenfieldModel currField = senflds.get(i);
            TableItem newTableItem = new TableItem(this.fieldTab, 0);
            this.populateTableItemFromField(newTableItem, currField);
            ++i;
        }
        TableColumn[] cols = this.fieldTab.getColumns();
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2].pack();
            ++i2;
        }
    }

    private void populateTableItemFromField(TableItem currentTableItem, SenfieldModel senfldModel) {
        String fieldNameStr = senfldModel.getName();
        currentTableItem.setText(0, fieldNameStr);
        int startInt = senfldModel.getStart();
        String startStr = Integer.toString(startInt);
        currentTableItem.setText(1, startStr);
        DBDConstants repl = senfldModel.getReplace();
        currentTableItem.setText(2, repl.toString());
    }

    public void widgetSelected(SelectionEvent e) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", new Object[0]);
        try {
            if (e.widget == this.addButton) {
                logger.finest("Add button was clicked");
                this.handleAdd();
            } else if (e.widget == this.editButton) {
                logger.finest("Edit button was clicked");
                this.handleEdit();
            } else if (e.widget == this.removeButton) {
                logger.finest("Remove button was clicked.");
                this.handleRemove();
            }
            this.enableButtons();
            this.setPageComplete(true);
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", new Object[0]);
    }

    private void handleAdd() throws ModelException {
        EditSenfldController esfController = new EditSenfldController(null, this.msfController, "ADD", this.msfController.isReadOnly());
        EditSenfldWizard editSenfldWizard = new EditSenfldWizard(esfController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editSenfldWizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshSenfldTable();
        }
    }

    private void handleEdit() throws ModelException {
        TableItem selectedItem = this.fieldTab.getSelection()[0];
        SenfieldModel selectedSenfld = this.msfController.getSenfield(selectedItem.getText(0), selectedItem.getText(1), selectedItem.getText(2));
        EditSenfldController esfController = new EditSenfldController(selectedSenfld, this.msfController, "EDIT", this.msfController.isReadOnly());
        EditSenfldWizard editFieldWizard = new EditSenfldWizard(esfController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editFieldWizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshSenfldTable();
        }
    }

    private void handleRemove() throws ModelException {
        TableItem[] selectedItems = this.fieldTab.getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            String senfldName = selectedItems[i].getText(0);
            String senfldStart = selectedItems[i].getText(1);
            String senfldRepl = selectedItems[i].getText(2);
            SenfieldModel senfld = this.msfController.getSenfield(senfldName, senfldStart, senfldRepl);
            this.msfController.removeSenfld(senfld);
            ++i;
        }
        this.refreshSenfldTable();
    }

    private void enableButtons() {
        int numSelected = this.fieldTab.getSelectionCount();
        if (numSelected == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else if (numSelected == 1) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else if (numSelected > 1) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(true);
        }
        if (this.msfController.isReadOnly()) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

