/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managesenfld;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.field.EditSenfldController;
import com.ibm.im.ims.workbench.controller.field.IModelChangeListener;
import com.ibm.im.ims.workbench.controller.field.ModelChangeEvent;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.EAMessageControl;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditSenfldWizardPage1
extends WizardPage
implements VerifyListener,
ModifyListener,
IModelChangeListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditSenfldController esfController;
    private final int margin = 5;
    private final int status_label_space = 4;
    private final String[] yesOrNo = new String[]{WorkbenchPlugin.labels.getString("YES"), WorkbenchPlugin.labels.getString("NO")};
    private static final String[] pageAttrs = new String[]{"NAME", "START"};
    private EAMessageControl msgControl;
    private Combo comboFieldName;
    private Combo comboReplace;
    private Label labelFieldNameReq;
    private Label labelFieldName;
    private Label labelStartPosReq;
    private Label labelStartPos;
    private Label labelReplaceReq;
    private Label labelReplace;
    private Label labelRemarks;
    private Text textRemarks;
    private Text textStartPosition;

    protected EditSenfldWizardPage1(EditSenfldController esfController) {
        super("EditSenfldWizardPage1");
        this.esfController = esfController;
        esfController.addModelChangeListener((IModelChangeListener)this);
        if (esfController.getActionType().equals("EDIT")) {
            this.setTitle(WorkbenchPlugin.labels.getString("WB052A"));
        } else {
            this.setTitle(WorkbenchPlugin.labels.getString("WB052B"));
        }
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB078A"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_wizard_large")));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            UIHelper uih = new UIHelper();
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            composite.setLayout((Layout)layout);
            this.createUIControl(composite, uih);
            this.layoutUIControl(uih);
            this.manageMessages(composite);
            this.initWidgetValues();
            if (this.esfController.isReadOnly()) {
                this.comboFieldName.setEnabled(false);
                this.comboReplace.setEnabled(false);
                this.textRemarks.setEnabled(false);
                this.textStartPosition.setEnabled(false);
            }
            this.addListeners();
            if (this.esfController.getActionType().equals("EDIT")) {
                this.validatePage(false);
            } else {
                this.validatePage(true);
            }
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void createUIControl(Composite composite, UIHelper uih) {
        this.labelFieldNameReq = uih.genRequiredSymbol(composite, 0, null, composite.getDisplay().getSystemColor(3));
        this.labelFieldName = new Label(composite, 0);
        Object[] inserts = new Object[]{"NAME"};
        this.labelFieldName.setText(WorkbenchPlugin.labels.getString("SF_FIELD_NAME", inserts));
        this.labelFieldName.pack();
        this.comboFieldName = new Combo(composite, 2056);
        this.labelStartPosReq = uih.genRequiredSymbol(composite, 0, null, composite.getDisplay().getSystemColor(3));
        this.labelStartPos = new Label(composite, 0);
        inserts[0] = "START";
        this.labelStartPos.setText(WorkbenchPlugin.labels.getString("SF_FIELD_START", inserts));
        this.labelStartPos.setToolTipText(WorkbenchPlugin.descriptions.getString("WB601"));
        this.labelStartPos.pack();
        this.textStartPosition = new Text(composite, 2048);
        this.textStartPosition.setToolTipText(WorkbenchPlugin.descriptions.getString("WB602"));
        this.labelReplaceReq = uih.genRequiredSymbol(composite, 0, null, composite.getDisplay().getSystemColor(3));
        this.labelReplace = new Label(composite, 0);
        inserts[0] = "REPL";
        this.labelReplace.setText(WorkbenchPlugin.labels.getString("SF_FIELD_REPL", inserts));
        this.labelReplace.setToolTipText(WorkbenchPlugin.descriptions.getString("WB603"));
        this.labelReplace.pack();
        this.comboReplace = new Combo(composite, 2056);
        this.labelRemarks = new Label(composite, 0);
        this.labelRemarks.setText(WorkbenchPlugin.labels.getString("REMARKS_COLON"));
        this.labelRemarks.pack();
        this.textRemarks = new Text(composite, 2114);
        this.textRemarks.setTextLimit(256);
    }

    private void layoutUIControl(UIHelper uih) {
        int leftLabelSize = this.getMaxLeftLabelSize() + 25 + this.labelFieldNameReq.getSize().x;
        int rightLabelSize = this.getMaxRightLabelSize() + 25 + this.labelFieldNameReq.getSize().x;
        FormData fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.labelFieldNameReq.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.labelFieldNameReq, 5), null);
        this.labelFieldName.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, leftLabelSize), new FormAttachment(50, -20));
        this.comboFieldName.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(50, 5), null);
        this.labelStartPosReq.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.labelStartPosReq, 5), null);
        this.labelStartPos.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(50, rightLabelSize), new FormAttachment(100, -20));
        this.textStartPosition.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment((Control)this.comboFieldName, 5), null, new FormAttachment(0, 0), null);
        this.labelReplaceReq.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment((Control)this.comboFieldName, 5), null, new FormAttachment((Control)this.labelReplaceReq, 5), null);
        this.labelReplace.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment((Control)this.comboFieldName, 5), null, new FormAttachment(0, leftLabelSize), new FormAttachment(50, -20));
        this.comboReplace.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment((Control)this.comboReplace, 5), null, new FormAttachment((Control)this.labelReplaceReq, 5), null);
        this.labelRemarks.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment((Control)this.comboReplace, 5), new FormAttachment(80), new FormAttachment(0, leftLabelSize), new FormAttachment(100, -20));
        this.textRemarks.setLayoutData((Object)fd);
    }

    private void addListeners() {
        this.comboFieldName.addModifyListener((ModifyListener)this);
        this.textStartPosition.addModifyListener((ModifyListener)this);
        this.comboReplace.addModifyListener((ModifyListener)this);
        this.textRemarks.addModifyListener((ModifyListener)this);
        this.textRemarks.addVerifyListener((VerifyListener)this);
    }

    private void removeListeners() {
        this.comboFieldName.removeModifyListener((ModifyListener)this);
        this.textStartPosition.removeModifyListener((ModifyListener)this);
        this.comboReplace.removeModifyListener((ModifyListener)this);
        this.textRemarks.removeModifyListener((ModifyListener)this);
        this.textRemarks.removeVerifyListener((VerifyListener)this);
    }

    private int getMaxLeftLabelSize() {
        int[] allLeftLabelSize = new int[]{this.labelFieldName.getSize().x, this.labelReplace.getSize().x};
        return this.getMaxSize(allLeftLabelSize);
    }

    private int getMaxRightLabelSize() {
        int[] allLabelSize = new int[]{this.labelStartPos.getSize().x};
        return this.getMaxSize(allLabelSize);
    }

    private int getMaxSize(int[] lblSize) {
        Arrays.sort(lblSize);
        return lblSize[lblSize.length - 1];
    }

    private void manageMessages(Composite composite) {
        this.msgControl = new EAMessageControl(composite);
        this.msgControl.addControl((Control)this.comboFieldName);
        this.msgControl.setValidationMessage((Control)this.comboFieldName, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.comboFieldName);
        this.msgControl.addControl((Control)this.textStartPosition);
        this.msgControl.setValidationMessage((Control)this.textStartPosition, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.textStartPosition);
    }

    private void initWidgetValues() throws ModelException, CoreException {
        String[] fieldNames = this.esfController.getIMSFieldNames();
        this.comboFieldName.setItems(fieldNames);
        String fieldNameStr = this.esfController.getName();
        if (fieldNameStr != null) {
            this.comboFieldName.setText(fieldNameStr);
        }
        this.textStartPosition.setText(this.esfController.getStart());
        this.comboReplace.setItems(this.yesOrNo);
        DBDConstants replace = this.esfController.getReplace();
        if (replace == DBDConstants.Y) {
            this.comboReplace.setText(this.yesOrNo[0]);
        } else {
            this.comboReplace.setText(this.yesOrNo[1]);
        }
        this.textRemarks.setText(this.esfController.getRemarks());
    }

    private void validatePage(boolean suppressErrorMessage) {
        try {
            this.clearValidationMessages();
            this.validateInput();
            String[] attrsToCheck = new String[]{"NAME", "START"};
            this.esfController.validateRequiredFields(attrsToCheck);
            this.esfController.semanticCheck();
            this.setPageComplete(true);
        }
        catch (InvalidInputException ex) {
            String[] errorAttrs;
            if (!suppressErrorMessage) {
                String message = ex.getMessage();
                this.setErrorMessage(message);
                this.setValidationMessages(ex);
            }
            if (Utility.allAttrsOnPage(errorAttrs = ex.getAttrNames(), pageAttrs)) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void validateInput() throws InvalidInputException, ModelException, CoreException {
        this.esfController.setName(this.comboFieldName.getText());
        this.esfController.setReplace(this.getYesNoCharacter());
        this.esfController.setStart(this.textStartPosition.getText());
        this.esfController.setRemarks(this.textRemarks.getText());
    }

    private String getYesNoCharacter() {
        String retVal = DBDConstants.Y.value();
        String longName = this.comboReplace.getText();
        if (longName.equals(this.yesOrNo[1])) {
            retVal = DBDConstants.N.value();
        }
        return retVal;
    }

    private void clearValidationMessages() {
        this.setErrorMessage(null);
        this.msgControl.clearValidationMessage((Control)this.textStartPosition);
        this.msgControl.clearValidationMessage((Control)this.comboFieldName);
    }

    private void setValidationMessages(InvalidInputException iie) {
        String[] attrs = iie.getAttrNames();
        int i = 0;
        while (i < attrs.length) {
            String attrName = attrs[i];
            if (attrName.equals("NAME")) {
                this.msgControl.setValidationMessage((Control)this.comboFieldName, iie.getMessage(), 3);
            } else if (attrName.equals("START")) {
                this.msgControl.setValidationMessage((Control)this.textStartPosition, iie.getMessage(), 3);
            }
            ++i;
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            this.validatePage(false);
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    public void handleModelChange(ModelChangeEvent modelChangeEvent) {
        try {
            this.removeListeners();
            String[] stringArray = modelChangeEvent.getAttrs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (attr.equals("START")) {
                    this.textStartPosition.setText(this.esfController.getStart());
                }
                ++n2;
            }
            this.addListeners();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleModelChange(ModelChangeEvent modelChangeEvent)", e);
            logger.error(e);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            }
            this.setPageComplete(this.isPageComplete());
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }
}

