/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managemapping;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.mapping.EditCaseController;
import com.ibm.im.ims.workbench.controller.mapping.EditMappingController;
import com.ibm.im.ims.workbench.controller.mapping.ManageMappingController;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managemapping.EditCaseWizard;
import com.ibm.im.ims.workbench.wizard.managemapping.EditMappingWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Iterator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ManageMappingWizardPage2
extends WizardPage
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Button addMappingButton;
    private Button editMappingButton;
    private Button removeMappingButton;
    private Button addCaseButton;
    private Button editCaseButton;
    private Button removeCaseButton;
    private Link mappingHelpLink;
    private Link caseHelpLink;
    private Table mappingTable;
    private Table caseTable;
    private ManageMappingController mmController;
    public static final String PAGE_NAME = "MAPPING";
    private static final int margin = 5;

    public ManageMappingWizardPage2(ManageMappingController controller) {
        super(PAGE_NAME);
        Object[] inserts = new Object[]{controller.getClonedSegmentModel().getName()};
        this.setTitle(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_2", inserts));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("mapping_wizard_large")));
        this.setDescription(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_3"));
        this.mmController = controller;
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            UIHelper uih = new UIHelper();
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB008A")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB042A")), Utility.getTextWidth(parent, 0, WorkbenchPlugin.labels.getString("WB009A"))};
            int buttonWidth = Utility.getMaxSize(labelSizes) + 5;
            FormLayout mappingFL = new FormLayout();
            mappingFL.marginHeight = 5;
            mappingFL.marginWidth = 5;
            FormData formData = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            final Group mappingGrp = new Group(composite, 0);
            mappingGrp.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_4"));
            mappingGrp.setLayout((Layout)mappingFL);
            mappingGrp.setLayoutData((Object)formData);
            formData = uih.genFormData(new FormAttachment((Control)mappingGrp, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            formData.width = mappingGrp.getClientArea().width;
            this.mappingHelpLink = new Link((Composite)mappingGrp, 16384);
            String textLink = WorkbenchPlugin.descriptions.getString("MANAGE_MAPPING_1") + "  <a>" + WorkbenchPlugin.descriptions.getString("WB070") + "</a>";
            this.mappingHelpLink.setText(textLink);
            this.mappingHelpLink.setLayoutData((Object)formData);
            formData = uih.genFormData(new FormAttachment((Control)this.mappingHelpLink, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.addMappingButton = new Button((Composite)mappingGrp, 0x1000000);
            this.addMappingButton.setText(WorkbenchPlugin.labels.getString("WB008A"));
            this.addMappingButton.setLayoutData((Object)formData);
            this.addMappingButton.setEnabled(true);
            formData = uih.genFormData(new FormAttachment((Control)this.addMappingButton, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.editMappingButton = new Button((Composite)mappingGrp, 0x1000000);
            this.editMappingButton.setText(WorkbenchPlugin.labels.getString("WB042A"));
            this.editMappingButton.setLayoutData((Object)formData);
            this.editMappingButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.editMappingButton, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.removeMappingButton = new Button((Composite)mappingGrp, 0x1000000);
            this.removeMappingButton.setText(WorkbenchPlugin.labels.getString("WB009A"));
            this.removeMappingButton.setLayoutData((Object)formData);
            this.removeMappingButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.mappingHelpLink, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment((Control)this.addMappingButton, -10));
            formData.height = 120;
            this.mappingTable = new Table((Composite)mappingGrp, 268503042);
            String[] columnLabels = new String[]{WorkbenchPlugin.labels.getString("MANAGE_MAPPING_5"), WorkbenchPlugin.labels.getString("MANAGE_MAPPING_6")};
            this.mappingTable.setLinesVisible(true);
            this.mappingTable.setHeaderVisible(true);
            this.mappingTable.setLayoutData((Object)formData);
            this.setColumns(this.mappingTable, columnLabels);
            FormLayout caseFL = new FormLayout();
            caseFL.marginHeight = 5;
            caseFL.marginWidth = 5;
            formData = uih.genFormData(new FormAttachment((Control)mappingGrp, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment(100, 0));
            final Group caseGrp = new Group(composite, 0);
            caseGrp.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_9"));
            caseGrp.setLayout((Layout)caseFL);
            caseGrp.setLayoutData((Object)formData);
            formData = uih.genFormData(new FormAttachment((Control)caseGrp, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            formData.width = caseGrp.getClientArea().width;
            this.caseHelpLink = new Link((Composite)caseGrp, 16384);
            Object[] inserts = new Object[]{this.mmController.getClonedSegmentModel().getName()};
            String caseTextLink = WorkbenchPlugin.descriptions.getString("MANAGE_MAPPING_2", inserts) + "  <a>" + WorkbenchPlugin.descriptions.getString("WB070") + "</a>";
            this.caseHelpLink.setText(caseTextLink);
            this.caseHelpLink.setLayoutData((Object)formData);
            formData = uih.genFormData(new FormAttachment((Control)this.caseHelpLink, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.addCaseButton = new Button((Composite)caseGrp, 0x1000000);
            this.addCaseButton.setText(WorkbenchPlugin.labels.getString("WB008A"));
            this.addCaseButton.setLayoutData((Object)formData);
            this.addCaseButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.addCaseButton, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.editCaseButton = new Button((Composite)caseGrp, 0x1000000);
            this.editCaseButton.setText(WorkbenchPlugin.labels.getString("WB042A"));
            this.editCaseButton.setLayoutData((Object)formData);
            this.editCaseButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.editCaseButton, 10), null, null, new FormAttachment(100, 0));
            formData.width = buttonWidth;
            this.removeCaseButton = new Button((Composite)caseGrp, 0x1000000);
            this.removeCaseButton.setText(WorkbenchPlugin.labels.getString("WB009A"));
            this.removeCaseButton.setLayoutData((Object)formData);
            this.removeCaseButton.setEnabled(false);
            formData = uih.genFormData(new FormAttachment((Control)this.caseHelpLink, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment((Control)this.addCaseButton, -10));
            formData.height = 200;
            this.caseTable = new Table((Composite)caseGrp, 268503042);
            String[] caseColumnLabels = new String[]{WorkbenchPlugin.labels.getString("MANAGE_MAPPING_7"), WorkbenchPlugin.labels.getString("MANAGE_MAPPING_8"), WorkbenchPlugin.labels.getString("MANAGE_MAPPING_5")};
            this.caseTable.setLinesVisible(true);
            this.caseTable.setHeaderVisible(true);
            this.caseTable.setLayoutData((Object)formData);
            this.setColumns(this.caseTable, caseColumnLabels);
            Control[] caseGrpTabList = new Control[]{this.caseHelpLink, this.caseTable, this.addCaseButton, this.editCaseButton, this.removeCaseButton};
            caseGrp.setTabList(caseGrpTabList);
            this.setControl((Control)composite);
            this.setPageComplete(false);
            this.setErrorMessage(null);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.wb_mapping_over");
            this.initWidgetValues();
            this.addListeners();
            mappingGrp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = mappingGrp.getClientArea();
                    int width = area.width - 2 * ManageMappingWizardPage2.this.mappingTable.getBorderWidth();
                    TableColumn[] tableColumns = ManageMappingWizardPage2.this.mappingTable.getColumns();
                    ManageMappingWizardPage2.this.mappingTable.setSize(area.width, area.height);
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            caseGrp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = caseGrp.getClientArea();
                    int width = area.width - 2 * ManageMappingWizardPage2.this.caseTable.getBorderWidth();
                    TableColumn[] tableColumns = ManageMappingWizardPage2.this.caseTable.getColumns();
                    ManageMappingWizardPage2.this.caseTable.setSize(area.width, area.height);
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void addListeners() {
        this.mappingHelpLink.addSelectionListener((SelectionListener)this);
        this.caseHelpLink.addSelectionListener((SelectionListener)this);
        this.addMappingButton.addSelectionListener((SelectionListener)this);
        this.editMappingButton.addSelectionListener((SelectionListener)this);
        this.removeMappingButton.addSelectionListener((SelectionListener)this);
        this.addCaseButton.addSelectionListener((SelectionListener)this);
        this.editCaseButton.addSelectionListener((SelectionListener)this);
        this.removeCaseButton.addSelectionListener((SelectionListener)this);
        this.mappingTable.addSelectionListener((SelectionListener)this);
        this.caseTable.addSelectionListener((SelectionListener)this);
    }

    private void initWidgetValues() {
        this.populateTableFromMappings(this.mmController.getMappings());
        if (this.mappingTable.getItemCount() > 0) {
            this.mappingTable.setSelection(0);
            this.refreshCaseTable();
        }
        if (this.mmController.isReadOnly()) {
            this.addMappingButton.setEnabled(false);
            this.removeMappingButton.setEnabled(false);
            this.addCaseButton.setEnabled(false);
            this.removeCaseButton.setEnabled(false);
        }
    }

    private void populateTableFromMappings(Iterator<MappingModel> mappings) {
        while (mappings.hasNext()) {
            MappingModel currMapping = mappings.next();
            TableItem newTableItem = new TableItem(this.mappingTable, 0);
            this.populateTableItemFromMapping(newTableItem, currMapping);
        }
    }

    private void populateTableItemFromMapping(TableItem currentTableItem, MappingModel mappingModel) {
        String mappingName = mappingModel.getName();
        String controlField = mappingModel.getDependingOnField();
        currentTableItem.setText(0, mappingName);
        currentTableItem.setText(1, controlField);
    }

    private void populateTableItemFromCase(TableItem currentTableItem, MappingCaseModel caseModel) {
        String caseName = caseModel.getName();
        String controlFieldValue = caseModel.getDependingOnFieldValue().getValue();
        TableItem selectedItem = this.mappingTable.getSelection()[0];
        String mappingName = selectedItem.getText(0);
        currentTableItem.setText(0, caseName);
        currentTableItem.setText(1, controlFieldValue);
        currentTableItem.setText(2, mappingName);
    }

    private void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    private void setColumns(Table table, String[] columnsLabels) {
        int i = 0;
        while (i < columnsLabels.length) {
            this.setColumn(table, columnsLabels[i]);
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.mappingHelpLink || event.widget == this.caseHelpLink) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.wb_mapping_over");
        } else if (event.getSource() == this.mappingTable) {
            this.enableMappingButtons();
            this.refreshCaseTable();
            this.enableCaseButtons();
        } else if (event.getSource() == this.caseTable) {
            this.enableCaseButtons();
        } else if (event.getSource() == this.addMappingButton) {
            this.handleMappingAdd();
        } else if (event.getSource() == this.addCaseButton) {
            TableItem selectedItem = this.mappingTable.getSelection()[0];
            String mappingName = selectedItem.getText(0);
            EditCaseController ecController = new EditCaseController(mappingName, null, this.mmController, "ADD");
            EditCaseWizard editCaseWiz = new EditCaseWizard(ecController);
            WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editCaseWiz);
            dialog.create();
            dialog.getShell().setSize(editCaseWiz.getShell().getMinimumSize());
            dialog.open();
            this.refreshCaseTable();
            this.enableCaseButtons();
        } else if (event.getSource() == this.editMappingButton) {
            this.handleMappingEdit();
        } else if (event.getSource() == this.editCaseButton) {
            TableItem selectedItem = this.mappingTable.getSelection()[0];
            String mappingName = selectedItem.getText(0);
            TableItem selectedCaseItem = this.caseTable.getSelection()[0];
            String caseName = selectedCaseItem.getText(0);
            EditCaseController ecController = new EditCaseController(mappingName, caseName, this.mmController, "EDIT");
            EditCaseWizard editCaseWiz = new EditCaseWizard(ecController);
            WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editCaseWiz);
            dialog.create();
            dialog.getShell().setSize(editCaseWiz.getShell().getMinimumSize());
            dialog.open();
            this.refreshCaseTable();
            this.enableCaseButtons();
        } else if (event.getSource() == this.removeCaseButton) {
            this.handleRemoveCase();
        } else if (event.getSource() == this.removeMappingButton) {
            this.handleRemoveMapping();
        }
        if (this.mmController.isReadOnly()) {
            this.addMappingButton.setEnabled(false);
            this.removeMappingButton.setEnabled(false);
            this.addCaseButton.setEnabled(false);
            this.removeCaseButton.setEnabled(false);
        }
        this.setPageComplete(this.mmController.hasBeenEdited());
    }

    private void handleRemoveCase() {
        String mappingName = this.mappingTable.getSelection()[0].getText(0);
        TableItem[] selectedCaseItems = this.caseTable.getSelection();
        String[] caseNames = new String[selectedCaseItems.length];
        int i = 0;
        while (i < selectedCaseItems.length) {
            caseNames[i] = selectedCaseItems[i].getText(0);
            ++i;
        }
        this.mmController.removeCases(mappingName, caseNames);
        this.refreshCaseTable();
        this.enableCaseButtons();
    }

    private void handleRemoveMapping() {
        TableItem[] mappingItems = this.mappingTable.getSelection();
        String[] mappingNames = new String[mappingItems.length];
        int i = 0;
        while (i < mappingItems.length) {
            mappingNames[i] = mappingItems[i].getText(0);
            ++i;
        }
        this.mmController.removeMappings(mappingNames);
        this.refreshMappingTable();
        if (this.mappingTable.getItemCount() > 0) {
            this.mappingTable.setSelection(0);
        }
        this.enableMappingButtons();
        this.enableCaseButtons();
        this.refreshCaseTable();
    }

    private void refreshCaseTable() {
        if (this.mappingTable.getSelectionCount() == 1) {
            if (this.caseTable.getItemCount() > 0) {
                this.caseTable.removeAll();
            }
            TableItem item = this.mappingTable.getSelection()[0];
            String mappingName = item.getText(0);
            MappingModel mapping = this.mmController.getMapping(mappingName);
            Iterator caseIter = mapping.getMappingCases();
            while (caseIter.hasNext()) {
                MappingCaseModel currCase = (MappingCaseModel)caseIter.next();
                TableItem newTableItem = new TableItem(this.caseTable, 0);
                this.populateTableItemFromCase(newTableItem, currCase);
            }
        } else if (this.caseTable.getItemCount() > 0) {
            this.caseTable.removeAll();
        }
    }

    private void refreshMappingTable() {
        if (this.mappingTable.getItemCount() > 0) {
            this.mappingTable.removeAll();
        }
        this.populateTableFromMappings(this.mmController.getMappings());
    }

    public void enableMappingButtons() {
        int numSelected = this.mappingTable.getSelectionCount();
        if (numSelected == 0) {
            this.editMappingButton.setEnabled(false);
            this.removeMappingButton.setEnabled(false);
        } else if (numSelected == 1) {
            this.editMappingButton.setEnabled(true);
            this.removeMappingButton.setEnabled(true);
        } else if (numSelected > 1) {
            this.editMappingButton.setEnabled(false);
            this.removeMappingButton.setEnabled(true);
        }
    }

    public void enableCaseButtons() {
        int numMappingSelected = this.mappingTable.getSelectionCount();
        int numSelected = this.caseTable.getSelectionCount();
        if (numMappingSelected == 1) {
            this.addCaseButton.setEnabled(true);
        } else {
            this.addCaseButton.setEnabled(false);
        }
        if (numSelected == 0) {
            this.editCaseButton.setEnabled(false);
            this.removeCaseButton.setEnabled(false);
        } else if (numSelected == 1) {
            this.editCaseButton.setEnabled(true);
            this.removeCaseButton.setEnabled(true);
        } else if (numSelected > 1) {
            this.editCaseButton.setEnabled(false);
            this.removeCaseButton.setEnabled(true);
        }
    }

    private void handleMappingAdd() {
        EditMappingController emController = new EditMappingController(null, this.mmController, "ADD");
        EditMappingWizard editMappingWizard = new EditMappingWizard(emController, false);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editMappingWizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshMappingTable();
            String addedMappingName = emController.getMappingName();
            TableItem tabItem = this.getTableItemForMapping(addedMappingName);
            int tiIndex = this.mappingTable.indexOf(tabItem);
            this.mappingTable.select(tiIndex);
            this.refreshCaseTable();
            this.enableCaseButtons();
        }
    }

    private void handleMappingEdit() {
        TableItem selectedItem = this.mappingTable.getSelection()[0];
        int tiIndex = this.mappingTable.indexOf(selectedItem);
        String mappingName = selectedItem.getText(0);
        EditMappingController emController = new EditMappingController(mappingName, this.mmController, "EDIT");
        EditMappingWizard editMappingWizard = new EditMappingWizard(emController, false);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editMappingWizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshMappingTable();
            this.mappingTable.select(tiIndex);
        }
    }

    private TableItem getTableItemForMapping(String mappingName) {
        TableItem[] tableItemArray = this.mappingTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getText(0).equals(mappingName)) {
                return ti;
            }
            ++n2;
        }
        return null;
    }
}

