/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managemapping;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.mapping.ManageMappingController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.wizard.managemapping.ManageMappingWizardPage1;
import com.ibm.im.ims.workbench.wizard.managemapping.ManageMappingWizardPage2;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ManageMappingWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ManageMappingWizardPage1 page1;
    private ManageMappingWizardPage2 page2;
    private ManageMappingController controller;

    public ManageMappingWizard(ManageMappingController controller) {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_1"));
        this.setHelpAvailable(false);
        this.controller = controller;
    }

    public void addPages() {
        DbdModel dbdModel = this.controller.getClonedSegmentModel().getDbdModel();
        DBDConstants access = dbdModel.getAccessType();
        if (access == DBDConstants.GSAM || access == DBDConstants.MSDB || access == DBDConstants.LOGICAL || access == DBDConstants.INDEX) {
            try {
                this.page2 = new ManageMappingWizardPage2(this.controller);
                this.addPage((IWizardPage)this.page2);
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
                logger.error(e);
            }
        } else {
            try {
                this.page1 = new ManageMappingWizardPage1(this.controller);
                this.addPage((IWizardPage)this.page1);
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
                logger.error(e);
            }
        }
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.controller.hasBeenEdited()) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        try {
            this.controller.performFinish();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }
}

