/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managemapping;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.mapping.EditMappingController;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.ui.core.Utility;
import com.ibm.im.ims.workbench.utilities.EAInputControl;
import com.ibm.im.ims.workbench.utilities.Warnings;
import com.ibm.im.ims.workbench.wizard.managemapping.EditMappingWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditMappingWizardPage1
extends WizardPage
implements SelectionListener,
VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EAInputControl mappingName;
    private EAInputControl ctlSegmentName;
    private EAInputControl ctlFieldName;
    private EAInputControl commentsEA;
    private Combo comboCtlField;
    private Combo comboCtlSegment;
    private static int fieldBoxWidth = 140;
    private static int commentBoxWidth = 355;
    public static final String PAGE_NAME = "EditMappingWizardPage1";
    Text textMappingName;
    Text textRemarks;
    private EditMappingController emController;
    private String originalSegmentName;
    private String originalFieldName;
    private Boolean warnObsolete = false;

    public EditMappingWizardPage1(EditMappingController emController) {
        super(PAGE_NAME);
        this.emController = emController;
        this.setTitle(WorkbenchPlugin.labels.getString("EDIT_MAPPING_2"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("mapping_wizard_large")));
        this.setDescription(WorkbenchPlugin.labels.getString("EDIT_MAPPING_3"));
        this.originalSegmentName = emController.getCtlSegment();
        this.originalFieldName = emController.getCtlField();
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            UIHelper uih = new UIHelper();
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            composite.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.mappingName = new EAInputControl(composite, 0, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_10") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001") + WorkbenchPlugin.colon.getString("COLON"), true, 220);
            this.textMappingName = (Text)this.mappingName.getInputControls()[0];
            this.textMappingName.setSize(fieldBoxWidth, this.textMappingName.getSize().y);
            this.textMappingName.setFocus();
            this.textMappingName.setTextLimit(128);
            this.textMappingName.setToolTipText(WorkbenchPlugin.descriptions.getString("WB453"));
            this.mappingName.setLayoutData(fd);
            fd = uih.genFormData(new FormAttachment((Control)this.mappingName, 10), null, new FormAttachment(0, 0), null);
            this.comboCtlSegment = new Combo(composite, 2056);
            this.comboCtlSegment.setSize(fieldBoxWidth, this.comboCtlSegment.getSize().y);
            Vector segmentList = this.emController.getPotentialControlSegmentList();
            for (String currSegment : segmentList) {
                this.comboCtlSegment.add(currSegment);
            }
            this.ctlSegmentName = new EAInputControl(this.mappingName, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_13") + " " + WorkbenchPlugin.noxlatlabels.getString("WB076") + WorkbenchPlugin.colon.getString("COLON"), true, (Control)this.comboCtlSegment);
            this.ctlSegmentName.setMainLabelToolTipText(WorkbenchPlugin.descriptions.getString("WB509"));
            this.ctlSegmentName.setLayoutData(fd);
            fd = uih.genFormData(new FormAttachment((Control)this.ctlSegmentName, 10), null, new FormAttachment(0, 0), null);
            this.comboCtlField = new Combo(composite, 2056);
            this.comboCtlField.setSize(fieldBoxWidth, this.comboCtlField.getSize().y);
            Vector fieldList = this.emController.getPotentialControlFieldList(this.emController.getCtlSegment());
            for (FieldModel currField : fieldList) {
                this.comboCtlField.add(currField.getName());
            }
            this.ctlFieldName = new EAInputControl(this.mappingName, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_12") + " " + WorkbenchPlugin.noxlatlabels.getString("WB075") + WorkbenchPlugin.colon.getString("COLON"), true, (Control)this.comboCtlField);
            this.ctlFieldName.setMainLabelToolTipText(WorkbenchPlugin.descriptions.getString("WB510"));
            this.ctlFieldName.setLayoutData(fd);
            this.textRemarks = new Text(composite, 2626);
            this.textRemarks.setTextLimit(256);
            this.textRemarks.setSize(commentBoxWidth, 80);
            this.textRemarks.setToolTipText(WorkbenchPlugin.descriptions.getString("WB454"));
            fd = uih.genFormData(new FormAttachment((Control)this.ctlFieldName, 10, 1024), null, new FormAttachment(0, 0), null);
            this.commentsEA = new EAInputControl(this.mappingName, WorkbenchPlugin.labels.getString("WB019A") + WorkbenchPlugin.colon.getString("COLON"), false, (Control)this.textRemarks);
            this.commentsEA.setLayoutData(fd);
            this.commentsEA.setMainLabelToolTipText(WorkbenchPlugin.descriptions.getString("WB099"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.wb_mapping_over");
            this.setControl((Control)composite);
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.initWidgetValues();
            this.addListeners();
            Point point = this.getShell().computeSize(-1, -1, true);
            this.getShell().setMinimumSize(point);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void initWidgetValues() {
        if (this.emController.getActionType().equals("EDIT")) {
            this.textMappingName.setText(this.emController.getMappingName().toUpperCase());
            this.textMappingName.setEnabled(false);
            String controlSegment = this.emController.getCtlSegment();
            if (controlSegment != null && !controlSegment.isEmpty()) {
                this.comboCtlSegment.setText(controlSegment);
            } else {
                this.comboCtlSegment.setText(this.emController.getSegment());
            }
            this.comboCtlField.setText(this.emController.getCtlField());
            this.textRemarks.setText(this.emController.getRemarks());
        }
        if (this.emController.isReadOnly()) {
            this.textMappingName.setEnabled(false);
            this.comboCtlSegment.setEnabled(false);
            this.comboCtlField.setEnabled(false);
            this.textRemarks.setEnabled(false);
        }
    }

    private void addListeners() {
        this.comboCtlSegment.addSelectionListener((SelectionListener)this);
        this.comboCtlField.addSelectionListener((SelectionListener)this);
        this.textMappingName.addModifyListener((ModifyListener)this);
        this.textRemarks.addModifyListener((ModifyListener)this);
        this.textMappingName.addVerifyListener((VerifyListener)this);
        this.textRemarks.addVerifyListener((VerifyListener)this);
    }

    public void removeListeners() {
        this.comboCtlSegment.removeSelectionListener((SelectionListener)this);
        this.comboCtlField.removeSelectionListener((SelectionListener)this);
        this.textMappingName.removeModifyListener((ModifyListener)this);
        this.textRemarks.removeModifyListener((ModifyListener)this);
        this.textMappingName.removeVerifyListener((VerifyListener)this);
        this.textRemarks.removeVerifyListener((VerifyListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.comboCtlField) {
            if (!this.comboCtlField.getText().equals(this.originalFieldName) && (this.emController.getActionType().equals("EDIT") || this.emController.getActionType().equals("ADD")) && !this.warnObsolete.booleanValue() && this.emController.getMappingModel().getMappingCases().hasNext()) {
                this.warnUserOfObsoleteObjects();
            }
            this.setPageComplete(this.validatePage());
        }
        if (e.widget == this.comboCtlSegment) {
            if (!this.comboCtlSegment.getText().equals(this.originalSegmentName) && (this.emController.getActionType().equals("EDIT") || this.emController.getActionType().equals("ADD"))) {
                try {
                    Vector fieldList = this.emController.getPotentialControlFieldList(this.comboCtlSegment.getText());
                    Iterator it = fieldList.iterator();
                    this.comboCtlField.removeAll();
                    while (it.hasNext()) {
                        FieldModel currField = (FieldModel)it.next();
                        this.comboCtlField.add(currField.getName());
                    }
                    this.originalSegmentName = this.comboCtlSegment.getText();
                }
                catch (Throwable err) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
                    logger.error(err);
                }
                if (!this.warnObsolete.booleanValue() && this.emController.getMappingModel().getMappingCases().hasNext()) {
                    this.warnUserOfObsoleteObjects();
                }
            }
            this.setPageComplete(this.validatePage());
        }
    }

    private void warnUserOfObsoleteObjects() {
        this.warnObsolete = true;
        String mapCaseLabel = WorkbenchPlugin.labels.getString("MANAGE_MAPPING_9");
        String ctrlFieldValueLabel = WorkbenchPlugin.labels.getString("MANAGE_MAPPING_8");
        StringBuffer caseList = new StringBuffer();
        Iterator caseIter = this.emController.getMappingModel().getMappingCases();
        while (caseIter.hasNext()) {
            MappingCaseModel caseModel = (MappingCaseModel)caseIter.next();
            caseList.append(mapCaseLabel + ": " + this.getFixLengthCaseName(caseModel.getName()) + ctrlFieldValueLabel + ": " + caseModel.getDependingOnFieldValue().getValue() + System.getProperty("line.separator"));
        }
        Warnings warnings = new Warnings(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("EDITMAP_WIZ_005"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        warnings.setWarnings(caseList.toString());
        warnings.setFontName("Courier New");
        warnings.open();
    }

    private String getFixLengthCaseName(String caseName) {
        String flCaseName = null;
        String spaces = "                                    ";
        int defaultFixLength = 14;
        int minGapSize = 3;
        int caseNameLen = caseName.length();
        if (caseNameLen + minGapSize < defaultFixLength) {
            int remainingSpaces = defaultFixLength - caseNameLen;
            flCaseName = caseName + spaces.substring(0, remainingSpaces);
        } else {
            flCaseName = caseName.substring(0, defaultFixLength - minGapSize - 3) + "..." + spaces.substring(0, minGapSize);
        }
        return flCaseName;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public EditMappingWizard getWiz() {
        return (EditMappingWizard)this.getWizard();
    }

    public String getMappingName() {
        return this.textMappingName.getText();
    }

    public String getCtlSegment() {
        return this.comboCtlSegment.getText();
    }

    public String getCtlField() {
        return this.comboCtlField.getText();
    }

    public String getRemarks() {
        return this.textRemarks.getText();
    }

    public void modifyText(ModifyEvent e) {
        try {
            if (e.widget == this.textMappingName) {
                this.validateMappingNameInput();
            } else if (e.widget == this.comboCtlSegment) {
                this.validateCtlSegmentSelection();
            } else if (e.widget == this.comboCtlField) {
                this.validateCtlFieldSelection();
            }
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textMappingName && e.character >= 'a' && e.character <= 'z') {
                String upperCaseChar;
                e.text = upperCaseChar = e.text.toUpperCase();
            }
            if (e.widget == this.textRemarks) {
                if (e.character == '\r') {
                    e.text = null;
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.labels.getString("WB019A"), WorkbenchPlugin.labels.getString("WB019B")};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC11"));
                    MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)formatter.format(messageArguments));
                } else if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                }
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }

    private boolean validateCtlSegmentSelection() {
        String ctlSegment = this.getCtlSegment();
        boolean validCtlSegment = true;
        try {
            this.emController.validateCtlSegment(ctlSegment);
            this.ctlSegmentName.setValidationMessage(null, 0);
            this.setErrorMessage(null);
        }
        catch (InvalidInputException iie) {
            validCtlSegment = false;
            this.ctlSegmentName.setValidationMessage(iie.getMessage(), 3);
            this.setErrorMessage(iie.getMessage());
        }
        return validCtlSegment;
    }

    private boolean validateCtlFieldSelection() {
        String ctlField = this.getCtlField();
        boolean validCtlField = true;
        try {
            this.emController.validateCtlField(ctlField);
            this.ctlFieldName.setValidationMessage(null, 0);
            this.setErrorMessage(null);
        }
        catch (InvalidInputException iie) {
            validCtlField = false;
            this.ctlFieldName.setValidationMessage(iie.getMessage(), 3);
            this.setErrorMessage(iie.getMessage());
        }
        return validCtlField;
    }

    private boolean validateMappingNameInput() {
        String mappingNameStr = this.textMappingName.getText();
        boolean validMappingName = true;
        try {
            this.emController.validateMappingName(mappingNameStr);
            this.mappingName.setValidationMessage(null, 0);
            this.setErrorMessage(null);
        }
        catch (InvalidInputException iie) {
            validMappingName = false;
            this.mappingName.setValidationMessage(iie.getMessage(), 3);
            this.setErrorMessage(iie.getMessage());
        }
        return validMappingName;
    }

    private boolean validatePage() {
        boolean ctlSegmentSelected = this.validateCtlSegmentSelection();
        boolean ctlFieldSelected = this.validateCtlFieldSelection();
        boolean mappingNameSpecified = this.validateMappingNameInput();
        return ctlSegmentSelected && ctlFieldSelected && mappingNameSpecified;
    }
}

