/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managemapping;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.mapping.EditMappingController;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.wizard.managemapping.EditMappingWizardPage1;
import com.ibm.im.ims.workbench.wizard.managemapping.EditMappingWizardPage2;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EditMappingWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditMappingController emController;
    private Boolean ctlSegm;
    private EditMappingWizardPage1 editMappingWizardPage1;
    private EditMappingWizardPage2 editMappingWizardPage2;
    public MappingModel mapping;
    public SegmentModel segment;
    public String type;

    public EditMappingWizard(EditMappingController emController, Boolean ctlSegm) {
        this.emController = emController;
        this.ctlSegm = ctlSegm;
        this.setHelpAvailable(false);
        if (emController.getActionType().equals("ADD")) {
            this.setWindowTitle(WorkbenchPlugin.labels.getString("ADD_MAPPING_1"));
        } else {
            this.setWindowTitle(WorkbenchPlugin.labels.getString("EDIT_MAPPING_1"));
        }
        this.setHelpAvailable(false);
    }

    public void addPages() {
        try {
            if (this.ctlSegm.booleanValue()) {
                this.editMappingWizardPage1 = new EditMappingWizardPage1(this.emController);
                this.addPage((IWizardPage)this.editMappingWizardPage1);
            } else {
                this.editMappingWizardPage2 = new EditMappingWizardPage2(this.emController);
                this.addPage((IWizardPage)this.editMappingWizardPage2);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public boolean canFinish() {
        if (this.ctlSegm.booleanValue()) {
            return this.editMappingWizardPage1.isPageComplete();
        }
        return this.editMappingWizardPage2.isPageComplete();
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        try {
            if (this.ctlSegm.booleanValue()) {
                String mappingName = this.editMappingWizardPage1.getMappingName();
                this.emController.setMappingName(mappingName);
                String ctlSegmentName = this.editMappingWizardPage1.getCtlSegment();
                this.emController.setCtlSegment(ctlSegmentName);
                String ctlFieldName = this.editMappingWizardPage1.getCtlField();
                this.emController.setCtlField(ctlFieldName);
                String remarkStr = this.editMappingWizardPage1.getRemarks();
                this.emController.setRemarks(remarkStr);
                this.emController.performFinish();
            } else {
                String mappingName = this.editMappingWizardPage2.getMappingName();
                this.emController.setMappingName(mappingName);
                String ctlFieldName = this.editMappingWizardPage2.getCtlField();
                this.emController.setCtlField(ctlFieldName);
                String remarkStr = this.editMappingWizardPage2.getRemarks();
                this.emController.setRemarks(remarkStr);
                this.emController.performFinish();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }
}

