/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managemapping;

import com.ibm.im.ims.metadata.dbd.ValueDatatypeType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.mapping.EditCaseController;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managemapping.EditCaseWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditCaseWizardPage1
extends WizardPage
implements SelectionListener,
VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private UIHelper uih;
    private Text textCaseName;
    private Text textCaseId;
    private Text textRemarks;
    private Combo controlValueType;
    private EditCaseController ecController;
    private DBDConstants idType;
    private Label caseNameStatus;
    private Label caseIdStatus;
    private static final int SPACING = 12;
    private static final int TOP_OFFSET = 3;
    private static final int RIGHT = 97;
    private static final int MARGIN = 5;
    private static final String HEXADECIMAL = "X (" + WorkbenchPlugin.labels.getString("HEXADECIMAL") + ")";
    private static final String CHARACTER = "C (" + WorkbenchPlugin.labels.getString("CHARACTER") + ")";
    private static final String[] valueTypes = new String[]{HEXADECIMAL, CHARACTER};

    public EditCaseWizardPage1(String pageName, EditCaseController ecController) {
        super(pageName);
        this.ecController = ecController;
        this.uih = new UIHelper();
        this.setTitle(WorkbenchPlugin.labels.getString("EDIT_CASE_2"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("mapping_wizard_large")));
        this.setDescription(WorkbenchPlugin.descriptions.getString("EDIT_CASE_4"));
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            this.uih.setDisplay(parent.getDisplay());
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            int requiredLabelSize = Utility.getTextWidth(parent, 0, "*");
            int[] group1LabelSizes = new int[]{Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_11") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001") + WorkbenchPlugin.colon.getString("COLON")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")" + WorkbenchPlugin.colon.getString("COLON"))};
            int group1LabelSize = Utility.getMaxSize(group1LabelSizes) + requiredLabelSize;
            int[] group2LabelSizes = new int[]{Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_12") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001") + WorkbenchPlugin.colon.getString("COLON")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WILL_MAPPING2")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WILL_MAPPING1") + " " + WorkbenchPlugin.noxlatlabels.getString("WB055") + WorkbenchPlugin.colon.getString("COLON")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("EDIT_CASE_6") + " " + WorkbenchPlugin.noxlatlabels.getString("WB094") + WorkbenchPlugin.colon.getString("COLON")), Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WILL_MAPPING3") + " " + WorkbenchPlugin.noxlatlabels.getString("WB090") + WorkbenchPlugin.colon.getString("COLON"))};
            int group2LabelSize = Utility.getMaxSize(group2LabelSizes) + requiredLabelSize;
            FormData fd = this.uih.genFormData(new FormAttachment(0, 3), null, new FormAttachment(0, 0), null);
            Label caseReq = this.uih.genRequiredSymbol(composite, 0, fd, composite.getDisplay().getSystemColor(3));
            caseReq.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, requiredLabelSize), null);
            Label caseLabel = new Label(composite, 0);
            caseLabel.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_11") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001") + WorkbenchPlugin.colon.getString("COLON"));
            caseLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, -3), null, new FormAttachment(0, group1LabelSize), new FormAttachment(97));
            this.textCaseName = new Text(composite, 2048);
            this.textCaseName.setFocus();
            this.textCaseName.setTextLimit(128);
            this.textCaseName.setToolTipText(WorkbenchPlugin.descriptions.getString("WB453"));
            this.textCaseName.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, -5), null, new FormAttachment((Control)this.textCaseName, 0), null);
            this.caseNameStatus = new Label(composite, 0);
            this.caseNameStatus.setImage(FigureConstants.ERROR);
            this.caseNameStatus.setVisible(false);
            this.caseNameStatus.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.textCaseName, 12), null, new FormAttachment(0, 0), new FormAttachment(97));
            Group groupCaseIdType = new Group(composite, 0);
            groupCaseIdType.setLayout((Layout)layout);
            groupCaseIdType.setLayoutData((Object)fd);
            groupCaseIdType.setText(WorkbenchPlugin.labels.getString("EDIT_CASE_5"));
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, requiredLabelSize), null);
            Label controlFieldNameLabel = new Label((Composite)groupCaseIdType, 0);
            controlFieldNameLabel.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_12") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001") + WorkbenchPlugin.colon.getString("COLON"));
            controlFieldNameLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, -3), null, new FormAttachment(0, group2LabelSize), new FormAttachment(97));
            Text controlFieldNameText = new Text((Composite)groupCaseIdType, 2056);
            controlFieldNameText.setText(this.ecController.getControlFieldName());
            controlFieldNameText.setTextLimit(128);
            controlFieldNameText.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldNameLabel, 12), null, new FormAttachment(0, requiredLabelSize), null);
            Label controlFieldTypeLabel = new Label((Composite)groupCaseIdType, 0);
            controlFieldTypeLabel.setText(WorkbenchPlugin.labels.getString("WILL_MAPPING2"));
            controlFieldTypeLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldNameLabel, 9), null, new FormAttachment(0, group2LabelSize), new FormAttachment(97));
            Text controlFieldTypeText = new Text((Composite)groupCaseIdType, 2056);
            String controlFldType = this.ecController.getControlFieldType();
            if (controlFldType != null) {
                controlFieldTypeText.setText(controlFldType);
            }
            controlFieldTypeText.setTextLimit(128);
            controlFieldTypeText.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldTypeLabel, 12), null, new FormAttachment(0, requiredLabelSize), null);
            Label controlFieldLengthLabel = new Label((Composite)groupCaseIdType, 0);
            controlFieldLengthLabel.setText(WorkbenchPlugin.labels.getString("WILL_MAPPING1") + " " + WorkbenchPlugin.noxlatlabels.getString("WB055") + WorkbenchPlugin.colon.getString("COLON"));
            controlFieldLengthLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldTypeLabel, 9), null, new FormAttachment(0, group2LabelSize), new FormAttachment(97));
            Text controlFieldLengthText = new Text((Composite)groupCaseIdType, 2056);
            controlFieldLengthText.setText(String.valueOf(this.ecController.getControlFieldLength()));
            controlFieldLengthText.setTextLimit(128);
            controlFieldLengthText.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldLengthLabel, 12), null, new FormAttachment(0, requiredLabelSize), null);
            Label controlFieldValueTypeLabel = new Label((Composite)groupCaseIdType, 0);
            controlFieldValueTypeLabel.setText(WorkbenchPlugin.labels.getString("EDIT_CASE_6") + " " + WorkbenchPlugin.noxlatlabels.getString("WB094") + WorkbenchPlugin.colon.getString("COLON"));
            controlFieldValueTypeLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldLengthLabel, 9), null, new FormAttachment(0, group2LabelSize), new FormAttachment(97));
            this.controlValueType = new Combo((Composite)groupCaseIdType, 2056);
            this.controlValueType.setItems(valueTypes);
            this.controlValueType.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldValueTypeLabel, 15), null, new FormAttachment(0, 0), null);
            Label caseIdReq = this.uih.genRequiredSymbol((Composite)groupCaseIdType, 0, fd, composite.getDisplay().getSystemColor(3));
            caseIdReq.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldValueTypeLabel, 12), null, new FormAttachment(0, requiredLabelSize), null);
            Label caseIdLabel = new Label((Composite)groupCaseIdType, 0);
            caseIdLabel.setText(WorkbenchPlugin.labels.getString("WILL_MAPPING3") + " " + WorkbenchPlugin.noxlatlabels.getString("WB090") + WorkbenchPlugin.colon.getString("COLON"));
            caseIdLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldValueTypeLabel, 9), null, new FormAttachment(0, group2LabelSize), new FormAttachment(97));
            this.textCaseId = new Text((Composite)groupCaseIdType, 2048);
            this.textCaseId.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)controlFieldValueTypeLabel, 9), null, new FormAttachment((Control)this.textCaseId, 0), null);
            this.caseIdStatus = new Label((Composite)groupCaseIdType, 0);
            this.caseIdStatus.setImage(FigureConstants.ERROR);
            this.caseIdStatus.setVisible(false);
            this.caseIdStatus.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)groupCaseIdType, 12), null, new FormAttachment(0, requiredLabelSize), null);
            Label remarksLabel = new Label(composite, 0);
            remarksLabel.setText(WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")" + WorkbenchPlugin.colon.getString("COLON"));
            remarksLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB099"));
            remarksLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)groupCaseIdType, 9), new FormAttachment(100, -12), new FormAttachment(0, group1LabelSize), new FormAttachment(97));
            fd.height = 100;
            this.textRemarks = new Text(composite, 2626);
            this.textRemarks.setTextLimit(256);
            this.textRemarks.setToolTipText(WorkbenchPlugin.descriptions.getString("WB100"));
            this.textRemarks.setLayoutData((Object)fd);
            Point point = this.getShell().computeSize(-1, -1, true);
            this.getShell().setMinimumSize(point);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.wb_mapping_over");
            this.setControl((Control)composite);
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.initWidgetValues();
            this.addListeners();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void initWidgetValues() {
        try {
            if (this.ecController.getActionType().equals("ADD")) {
                this.controlValueType.setText(CHARACTER);
                this.idType = DBDConstants.C;
                this.textCaseId.setToolTipText(WorkbenchPlugin.descriptions.getString("WB453"));
            } else {
                this.textCaseName.setText(this.ecController.getCaseName().toUpperCase());
                this.textCaseName.setEnabled(false);
                this.textCaseId.setText(this.ecController.getCaseId());
                if (this.ecController.getCaseIdType() == ValueDatatypeType.C) {
                    this.controlValueType.setText(CHARACTER);
                    this.idType = DBDConstants.C;
                    this.textCaseId.setToolTipText(WorkbenchPlugin.descriptions.getString("WB453"));
                } else {
                    this.controlValueType.setText(HEXADECIMAL);
                    this.idType = DBDConstants.X;
                    Object[] inserts = new Object[]{String.valueOf(2 * this.ecController.getControlFieldLength()), String.valueOf(this.ecController.getControlFieldLength()), this.ecController.getControlFieldName()};
                    this.textCaseId.setToolTipText(WorkbenchPlugin.descriptions.getString("WB452", inserts));
                }
                String remarksStr = this.ecController.getRemarks();
                if (remarksStr != null) {
                    this.textRemarks.setText(remarksStr);
                }
                this.validatePage();
            }
            if (this.ecController.isReadOnly()) {
                this.textCaseName.setEnabled(false);
                this.textCaseId.setEnabled(false);
                this.textRemarks.setEnabled(false);
                this.controlValueType.setEnabled(false);
            }
        }
        catch (InvalidInputException iie) {
            this.setErrorMessage(iie.getMessage());
        }
    }

    public EditCaseWizard getWiz() {
        return (EditCaseWizard)this.getWizard();
    }

    private void addListeners() {
        this.controlValueType.addSelectionListener((SelectionListener)this);
        this.textCaseName.addModifyListener((ModifyListener)this);
        this.textCaseId.addModifyListener((ModifyListener)this);
        this.textRemarks.addModifyListener((ModifyListener)this);
        this.textCaseName.addVerifyListener((VerifyListener)this);
        this.textCaseId.addVerifyListener((VerifyListener)this);
        this.textRemarks.addVerifyListener((VerifyListener)this);
    }

    public void removeListeners() {
        this.controlValueType.removeSelectionListener((SelectionListener)this);
        this.textCaseName.removeModifyListener((ModifyListener)this);
        this.textCaseId.removeModifyListener((ModifyListener)this);
        this.textRemarks.removeModifyListener((ModifyListener)this);
        this.textCaseName.removeModifyListener((ModifyListener)this);
        this.textCaseId.removeModifyListener((ModifyListener)this);
        this.textRemarks.removeModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent e) {
        this.getWiz().page1HasBeenEdited = true;
        this.validatePage();
    }

    private void validatePage() {
        boolean validCaseName = true;
        boolean validCaseId = true;
        boolean validRemarks = true;
        this.setErrorMessage(null);
        try {
            this.ecController.setRemarks(this.textRemarks.getText());
        }
        catch (InvalidInputException iie) {
            validRemarks = false;
            this.setErrorMessage(iie.getMessage());
        }
        try {
            this.ecController.setCaseId(this.textCaseId.getText(), this.idType);
            this.caseIdStatus.setVisible(false);
            this.caseIdStatus.setToolTipText(null);
        }
        catch (InvalidInputException iie) {
            validCaseId = false;
            this.setErrorMessage(iie.getMessage());
            this.caseIdStatus.setVisible(true);
            this.caseIdStatus.setToolTipText(iie.getMessage());
        }
        try {
            this.ecController.setCaseName(this.textCaseName.getText());
            this.caseNameStatus.setVisible(false);
            this.caseNameStatus.setToolTipText(null);
        }
        catch (InvalidInputException iie) {
            validCaseName = false;
            this.setErrorMessage(iie.getMessage());
            this.caseNameStatus.setVisible(true);
            this.caseNameStatus.setToolTipText(iie.getMessage());
        }
        if (validCaseName && validCaseId && validRemarks) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            if ((e.widget == this.textCaseName || e.widget == this.textCaseId) && e.character >= 'a' && e.character <= 'z') {
                String upperCaseChar;
                e.text = upperCaseChar = e.text.toUpperCase();
            }
            if (e.widget == this.textRemarks) {
                if (e.character == '\r') {
                    e.text = null;
                    Object[] messageArguments = new Object[]{WorkbenchPlugin.labels.getString("WB019A"), WorkbenchPlugin.labels.getString("WB019B")};
                    MessageFormat formatter = new MessageFormat("");
                    formatter.setLocale(Locale.getDefault());
                    formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC11"));
                    MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)formatter.format(messageArguments));
                } else if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                }
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            try {
                this.removeListeners();
                this.getWiz().page1HasBeenEdited = true;
                if (e.widget == this.controlValueType) {
                    if (this.controlValueType.getText().equals(CHARACTER)) {
                        this.idType = DBDConstants.C;
                        this.textCaseId.setToolTipText(WorkbenchPlugin.descriptions.getString("WB449"));
                    } else {
                        this.idType = DBDConstants.X;
                        Object[] inserts = new Object[]{String.valueOf(2 * this.ecController.getControlFieldLength()), String.valueOf(this.ecController.getControlFieldLength()), this.ecController.getControlFieldName()};
                        this.textCaseId.setToolTipText(WorkbenchPlugin.descriptions.getString("WB452", inserts));
                    }
                    this.validatePage();
                }
            }
            catch (Throwable err) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
                logger.error(err);
                this.addListeners();
            }
        }
        finally {
            this.addListeners();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

