/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managefield;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.field.EditFieldController;
import com.ibm.im.ims.workbench.controller.field.ManageFieldsController;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.FieldModelImpl;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managefield.EditFieldWizard;
import com.ibm.im.ims.workbench.wizard.managefield.FieldSearchDialog;
import com.ibm.im.ims.workbench.wizard.managefield.ManageFieldWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ManageFieldWizardPage1
extends WizardPage
implements SelectionListener,
MouseListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private static final String LENGTH = WorkbenchPlugin.labels.getString("WB013A") + WorkbenchPlugin.colon.getString("COLON");
    private static final String BYTES = WorkbenchPlugin.labels.getString("WB444");
    private Label segLenLabel;
    private Text segLenText;
    private Label segLenByte;
    private Button updateSegLen;
    private Label mapLabel;
    private Combo mapCombo;
    private Label caseLabel;
    private Combo caseCombo;
    private Group fieldGrp;
    private Table fieldTab;
    public static final String PAGE_NAME = "FIELD";
    private boolean fieldWasAddedOrEdited = false;
    boolean isFieldEditorOpened = false;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button moveButton;
    private Button findButton;
    private ManageFieldsController mfController;
    private boolean isFindDialogOpen = false;
    public static String COMMON_FIELDS = WorkbenchPlugin.labels.getString("UNMAPPED_FIELDS");
    private static String INCREASE_SEGM_LENGTH = WorkbenchPlugin.labels.getString("INCREASE_SEGM_LENGTH");
    private static int margin = 5;

    public ManageFieldWizardPage1(String pageName, boolean genSchema, ManageFieldsController mfController) {
        super(PAGE_NAME);
        this.mfController = mfController;
        Object[] inserts = new Object[]{mfController.getSegmentModelClone().getName()};
        this.setTitle(WorkbenchPlugin.labels.getString("WB038A", inserts));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_edit_wizard_large")));
        this.setDescription(WorkbenchPlugin.labels.getString("WB203"));
    }

    private void createIncreaseSegLen(Composite composite) throws ModelException {
        this.segLenLabel = new Label(composite, 0);
        this.segLenLabel.setText(LENGTH);
        this.segLenText = new Text(composite, 8);
        this.segLenText.setText(String.valueOf(this.mfController.getSegmentModelClone().getMaxBytes()));
        this.segLenByte = new Label(composite, 8);
        this.segLenByte.setText(BYTES);
        this.updateSegLen = new Button(composite, 8);
        this.updateSegLen.setEnabled(false);
        this.updateSegLen.setText(INCREASE_SEGM_LENGTH);
        this.updateSegLen.addSelectionListener((SelectionListener)this);
        FormData lbl1 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(0, 0), null);
        this.segLenLabel.setLayoutData((Object)lbl1);
        int width = Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_10") + WorkbenchPlugin.colon.getString("COLON"));
        FormData txt1 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(0, width - margin), new FormAttachment(50, 0));
        this.segLenText.setLayoutData((Object)txt1);
        FormData lbl2 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.segLenText, margin * 5), null);
        this.segLenByte.setLayoutData((Object)lbl2);
        width = Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_11") + WorkbenchPlugin.colon.getString("COLON"));
        FormData cmbFD2 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(50, width + margin * 4), new FormAttachment(100, 0));
        cmbFD2.width = Utility.getTextWidth(composite, 0, INCREASE_SEGM_LENGTH);
        this.updateSegLen.setLayoutData((Object)cmbFD2);
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.uih = new UIHelper();
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = margin;
            layout.marginWidth = margin;
            this.composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            this.composite.setLayoutData((Object)fd);
            this.createIncreaseSegLen(this.composite);
            this.mapLabel = new Label(this.composite, 0);
            this.mapCombo = new Combo(this.composite, 780);
            this.caseLabel = new Label(this.composite, 0);
            this.caseCombo = new Combo(this.composite, 780);
            this.createListenerForMappingCombo();
            this.createListenerForCaseCombo();
            this.populateMappingCombo(this.mapCombo);
            FormLayout fldFL = new FormLayout();
            fldFL.marginHeight = margin;
            fldFL.marginWidth = margin;
            this.mapLabel.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_10") + WorkbenchPlugin.colon.getString("COLON"));
            FormData lblMap = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(0, 0), null);
            lblMap.top = new FormAttachment((Control)this.segLenLabel, margin * 3);
            this.mapLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB455"));
            this.mapLabel.setLayoutData((Object)lblMap);
            FormData cmbFD1 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.mapLabel, margin), new FormAttachment(50, 0));
            cmbFD1.top = new FormAttachment((Control)this.segLenLabel, margin * 3);
            cmbFD1.width = Utility.getTextWidth(parent, 0, COMMON_FIELDS);
            this.mapCombo.setLayoutData((Object)cmbFD1);
            this.caseLabel.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_11") + WorkbenchPlugin.colon.getString("COLON"));
            FormData lblCase = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.mapCombo, margin * 5), null);
            lblCase.top = new FormAttachment((Control)this.segLenLabel, margin * 3);
            this.caseLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB456"));
            this.caseLabel.setLayoutData((Object)lblCase);
            FormData cmbFD2 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.caseLabel, margin), new FormAttachment(100, 0));
            cmbFD2.top = new FormAttachment((Control)this.segLenLabel, margin * 3);
            cmbFD2.width = Utility.getTextWidth(parent, 0, INCREASE_SEGM_LENGTH);
            this.caseCombo.setLayoutData((Object)cmbFD2);
            FormData fldFD = this.uih.genFormData(new FormAttachment((Control)this.mapCombo, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment(100, 0));
            this.fieldGrp = new Group(this.composite, 0);
            this.fieldGrp.setText(WorkbenchPlugin.labels.getString("WB003A"));
            this.fieldGrp.setLayout((Layout)fldFL);
            this.fieldGrp.setLayoutData((Object)fldFD);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.fieldGrp, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            fldFD.width = this.fieldGrp.getClientArea().width;
            Link fldHelpLink = new Link((Composite)this.fieldGrp, 16384);
            String textLink = WorkbenchPlugin.descriptions.getString("WB078") + "  <a>" + WorkbenchPlugin.descriptions.getString("WB070") + "</a>";
            fldHelpLink.setText(textLink);
            fldHelpLink.setLayoutData((Object)fldFD);
            fldHelpLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_managefield1");
                }
            });
            int[] labelSizes = new int[]{Utility.getTextWidth((Composite)this.fieldGrp, 0, WorkbenchPlugin.labels.getString("WB008A")), Utility.getTextWidth((Composite)this.fieldGrp, 0, WorkbenchPlugin.labels.getString("WB042A")), Utility.getTextWidth((Composite)this.fieldGrp, 0, WorkbenchPlugin.labels.getString("WB009A")), Utility.getTextWidth((Composite)this.fieldGrp, 0, WorkbenchPlugin.labels.getString("WB009B"))};
            int buttonWidth = Utility.getMaxSize(labelSizes) + margin;
            fldFD = this.uih.genFormData(new FormAttachment((Control)fldHelpLink, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.addButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.addButton.setText(WorkbenchPlugin.labels.getString("WB008A"));
            this.addButton.setLayoutData((Object)fldFD);
            this.addButton.addSelectionListener((SelectionListener)this);
            if (this.mfController.isReadOnly()) {
                this.addButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(true);
            }
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.addButton, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.editButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.editButton.setText(WorkbenchPlugin.labels.getString("WB042A"));
            this.editButton.setLayoutData((Object)fldFD);
            this.editButton.addSelectionListener((SelectionListener)this);
            this.editButton.setEnabled(false);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.editButton, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.removeButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.removeButton.setText(WorkbenchPlugin.labels.getString("WB009A"));
            this.removeButton.setLayoutData((Object)fldFD);
            this.removeButton.addSelectionListener((SelectionListener)this);
            this.removeButton.setEnabled(false);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.removeButton, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.moveButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.moveButton.setText(WorkbenchPlugin.labels.getString("WB009B"));
            this.moveButton.setLayoutData((Object)fldFD);
            this.moveButton.addSelectionListener((SelectionListener)this);
            this.moveButton.setEnabled(false);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.moveButton, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.findButton = new Button((Composite)this.fieldGrp, 0x1000000);
            this.findButton.setText(WorkbenchPlugin.labels.getString("WB085A"));
            this.findButton.setLayoutData((Object)fldFD);
            this.findButton.addSelectionListener((SelectionListener)this);
            this.findButton.setEnabled(true);
            fldFD = this.uih.genFormData(new FormAttachment((Control)fldHelpLink, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment((Control)this.addButton, -margin * 2));
            this.fieldTab = new Table((Composite)this.fieldGrp, 268503042);
            this.fieldTab.addSelectionListener((SelectionListener)this);
            this.fieldTab.addMouseListener((MouseListener)this);
            String[] columnLabels = new String[]{WorkbenchPlugin.labels.getString("WB014"), WorkbenchPlugin.labels.getString("WB211"), WorkbenchPlugin.labels.getString("WB485"), WorkbenchPlugin.labels.getString("WB004A"), WorkbenchPlugin.labels.getString("WB012A"), WorkbenchPlugin.labels.getString("WB013A"), WorkbenchPlugin.labels.getString("WB212"), WorkbenchPlugin.labels.getString("WB018A"), WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_REDEFINES"), WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_DEPENDS_ON")};
            this.fieldTab.setLinesVisible(true);
            this.fieldTab.setHeaderVisible(true);
            this.fieldTab.setLayoutData((Object)fldFD);
            this.setColumns(this.fieldTab, columnLabels);
            this.fieldGrp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = ManageFieldWizardPage1.this.fieldGrp.getClientArea();
                    int width = area.width - 2 * ManageFieldWizardPage1.this.fieldTab.getBorderWidth();
                    TableColumn[] tableColumns = ManageFieldWizardPage1.this.fieldTab.getColumns();
                    ManageFieldWizardPage1.this.fieldTab.setSize(area.width, area.height);
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            Control[] fieldGrpTabList = new Control[]{fldHelpLink, this.fieldTab, this.addButton, this.editButton, this.removeButton};
            this.fieldGrp.setTabList(fieldGrpTabList);
            String mapName = this.mapCombo.getText();
            if (mapName.equals(COMMON_FIELDS)) {
                mapName = ManageFieldsController.COMMON_FIELDS;
            }
            Vector fieldList = this.mfController.getFreshFieldList(mapName, this.caseCombo.getText());
            this.addEmptyFields(fieldList);
            this.setControl((Control)this.composite);
            this.setPageComplete(false);
            this.setErrorMessage(null);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ies1_wb_managefield1");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void populateTableFromFields(Vector<FieldModel> fields) {
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = fields.get(i);
            TableItem newTableItem = new TableItem(this.fieldTab, 0);
            this.populateTableItemFromField(newTableItem, currField);
            ++i;
        }
        TableColumn[] cols = this.fieldTab.getColumns();
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2].pack();
            ++i2;
        }
    }

    public void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    public void setColumns(Table table, String[] columnsLabels) {
        int i = 0;
        while (i < columnsLabels.length) {
            this.setColumn(table, columnsLabels[i]);
            ++i;
        }
    }

    private void populateTableItemFromField(TableItem currentTableItem, FieldModel fieldModel) {
        String fieldNameStr = null;
        fieldNameStr = fieldModel.getImsName() != null ? fieldModel.getImsName() : "";
        currentTableItem.setText(0, fieldNameStr);
        String aliasStr = null;
        aliasStr = fieldModel.getName() != null ? fieldModel.getName() : "";
        currentTableItem.setText(1, aliasStr);
        FieldModel parentField = fieldModel.getParentField();
        if (parentField != null) {
            currentTableItem.setText(2, parentField.getName());
        } else {
            currentTableItem.setText(2, "");
        }
        if (fieldNameStr == null || fieldNameStr != null && fieldNameStr.equals("")) {
            currentTableItem.setText(3, WorkbenchPlugin.labels.getString("USER_DEFINED_FIELD"));
        } else if (fieldNameStr.equals(WorkbenchPlugin.labels.getString("WB350"))) {
            currentTableItem.setText(3, WorkbenchPlugin.labels.getString("WB357"));
        } else {
            currentTableItem.setText(3, WorkbenchPlugin.labels.getString("IMS_FIELD"));
        }
        int start = fieldModel.getStartPos();
        if (fieldModel.isSysRelField()) {
            currentTableItem.setText(4, "S=" + Integer.toString(start));
        } else if (fieldModel.getAppDatatype() != null && fieldModel.getAppDatatype().equals((Object)DBDConstants.XML) && start == 0) {
            currentTableItem.setText(4, "S=0");
        } else if (start == 0) {
            start = fieldModel.getRelativeStart();
            if (start == 0) {
                String startAfter = fieldModel.getStartAfter();
                if (startAfter != null && !startAfter.isEmpty()) {
                    currentTableItem.setText(4, "A=" + startAfter);
                } else {
                    currentTableItem.setText(4, "");
                }
            } else {
                currentTableItem.setText(4, "R=" + Integer.toString(start));
            }
        } else {
            currentTableItem.setText(4, "S=" + Integer.toString(start));
        }
        int bytes = fieldModel.getBytes();
        if (fieldModel.getAppDatatype() != null && fieldModel.getAppDatatype().equals((Object)DBDConstants.XML) && bytes == 0) {
            currentTableItem.setText(5, "0");
        } else if (bytes > 0) {
            currentTableItem.setText(5, Integer.toString(bytes));
        } else {
            currentTableItem.setText(5, "M=" + Integer.toString(fieldModel.getMaxBytes()));
        }
        DBDConstants appDatatype = fieldModel.getAppDatatype();
        if (appDatatype != null) {
            currentTableItem.setText(6, appDatatype.toString());
        } else {
            currentTableItem.setText(6, "");
        }
        DBDConstants physDatatype = fieldModel.getPhysicalDataType();
        String physDatatypeStr = null;
        if (physDatatype != null) {
            physDatatypeStr = physDatatype.toString();
            if (appDatatype == DBDConstants.CHAR && fieldModel.getIsDbcs() == DBDConstants.Y) {
                physDatatypeStr = "DBCS";
            }
            currentTableItem.setText(7, physDatatypeStr);
        } else {
            String userTypeConv = fieldModel.getUserTypeConverter();
            if (userTypeConv != null && !userTypeConv.isEmpty()) {
                currentTableItem.setText(7, DBDConstants.USER.toString());
            } else {
                currentTableItem.setText(7, "");
            }
        }
        String redefineField = fieldModel.getRedefines();
        if (redefineField != null) {
            currentTableItem.setText(8, redefineField);
        } else {
            currentTableItem.setText(8, "");
        }
        String dependOnField = fieldModel.getDependsOn();
        if (dependOnField != null) {
            currentTableItem.setText(9, dependOnField);
        } else {
            currentTableItem.setText(9, "");
        }
        DBDConstants seq = fieldModel.getSeqType();
        if (seq != null) {
            String seqStr = null;
            if (seq == DBDConstants.M) {
                seqStr = DBDConstants.M.toString() + " " + WorkbenchPlugin.descriptions.getString("WB08A");
            } else if (seq == DBDConstants.U) {
                seqStr = DBDConstants.U.toString() + " " + WorkbenchPlugin.descriptions.getString("WB07A");
            }
            currentTableItem.setData(DBDConstants.SEQ.toString(), (Object)seqStr);
        } else {
            currentTableItem.setData(DBDConstants.SEQ.toString(), (Object)"");
        }
        DBDConstants imsDatatype = fieldModel.getImsDatatype();
        if (imsDatatype != null) {
            String imsDatatypeStr = null;
            if (imsDatatype == DBDConstants.C) {
                imsDatatypeStr = DBDConstants.C.toString() + " " + WorkbenchPlugin.descriptions.getString("WB11A");
            } else if (imsDatatype == DBDConstants.F) {
                imsDatatypeStr = DBDConstants.F.toString() + " " + WorkbenchPlugin.descriptions.getString("WB13A");
            } else if (imsDatatype == DBDConstants.H) {
                imsDatatypeStr = DBDConstants.H.toString() + " " + WorkbenchPlugin.descriptions.getString("WB12A");
            } else if (imsDatatype == DBDConstants.P) {
                imsDatatypeStr = DBDConstants.P.toString() + " " + WorkbenchPlugin.descriptions.getString("WB10A");
            } else if (imsDatatype == DBDConstants.X) {
                imsDatatypeStr = DBDConstants.X.toString() + " " + WorkbenchPlugin.descriptions.getString("WB09A");
            }
            currentTableItem.setData(DBDConstants.TYPE.toString(), (Object)imsDatatypeStr);
        } else {
            currentTableItem.setData(DBDConstants.TYPE.toString(), (Object)"");
        }
        String patternStr = fieldModel.getPattern();
        if (patternStr != null) {
            currentTableItem.setData(DBDConstants.PATTERN.toString(), (Object)patternStr);
        } else {
            currentTableItem.setData(DBDConstants.PATTERN.toString(), (Object)"");
        }
        String commentStr = fieldModel.getRemarks();
        if (commentStr != null) {
            currentTableItem.setData(DBDConstants.REMARK.toString(), (Object)commentStr);
        } else {
            currentTableItem.setData(DBDConstants.REMARK.toString(), (Object)"");
        }
        String encodingStr = fieldModel.getEncoding();
        if (encodingStr != null) {
            currentTableItem.setData(DBDConstants.ENCODING.toString(), (Object)encodingStr);
        } else {
            currentTableItem.setData(DBDConstants.ENCODING.toString(), (Object)"");
        }
        String urlStr = fieldModel.getUrl();
        if (urlStr != null) {
            currentTableItem.setData(DBDConstants.XML.toString(), (Object)urlStr);
        } else {
            currentTableItem.setData(DBDConstants.XML.toString(), (Object)"");
        }
        String overflowStr = fieldModel.getOverflow();
        if (overflowStr != null) {
            currentTableItem.setData(DBDConstants.OVERFLOW.toString(), (Object)overflowStr);
        } else {
            currentTableItem.setData(DBDConstants.OVERFLOW.toString(), (Object)"");
        }
        Integer precisionInt = fieldModel.getPrecision();
        if (precisionInt != null) {
            currentTableItem.setData(DBDConstants.PRECISION.toString(), (Object)precisionInt.toString());
        } else {
            currentTableItem.setData(DBDConstants.PRECISION.toString(), (Object)"");
        }
        Integer scaleInt = fieldModel.getScale();
        if (scaleInt != null) {
            currentTableItem.setData(DBDConstants.SCALE.toString(), (Object)scaleInt.toString());
        } else {
            currentTableItem.setData(DBDConstants.SCALE.toString(), (Object)"");
        }
        DBDConstants isSigned = fieldModel.getIsSigned();
        if (isSigned != null) {
            currentTableItem.setData(DBDConstants.ISSIGNED.toString(), (Object)isSigned.toString());
        } else {
            currentTableItem.setData(DBDConstants.ISSIGNED.toString(), (Object)"");
        }
        String userClassNameStr = fieldModel.getUserTypeConverter();
        if (userClassNameStr != null) {
            currentTableItem.setData(DBDConstants.USERCLASS.toString(), (Object)userClassNameStr);
        } else {
            currentTableItem.setData(DBDConstants.USERCLASS.toString(), (Object)"");
        }
        if (physDatatypeStr != null && physDatatypeStr.equalsIgnoreCase(DBDConstants.USER.toString())) {
            ArrayList<String> propertyList = new ArrayList<String>();
            int propertyLstSize = fieldModel.getPropertyListSize();
            if (propertyLstSize > 0) {
                int i = 0;
                while (i < propertyLstSize) {
                    String propertyName = fieldModel.getPropertyName(i);
                    String propertyVal = fieldModel.getPropertyValue(i);
                    propertyList.add(propertyName);
                    propertyList.add(propertyVal);
                    ++i;
                }
            }
            currentTableItem.setData(DBDConstants.PROPERTIES.toString(), propertyList);
        }
    }

    public Table getFieldTab() {
        return this.fieldTab;
    }

    ManageFieldWizard getWiz() {
        return (ManageFieldWizard)this.getWizard();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", new Object[0]);
        try {
            if (e.widget == this.addButton) {
                logger.finest("Add button was clicked");
                this.handleAdd();
            } else if (e.widget == this.editButton) {
                logger.finest("Edit button was clicked");
                this.handleEdit();
            } else if (e.widget == this.removeButton) {
                logger.finest("Remove button was clicked.");
                this.handleRemove();
            } else if (e.widget == this.moveButton) {
                logger.finest("Move button was clicked.");
                this.handleMove();
            } else if (e.widget == this.findButton) {
                logger.finest("find button was clicked.");
                this.handleFind();
            } else if (e.widget == this.fieldTab) {
                this.enableButtons();
            } else if (e.widget == this.mapCombo) {
                String userSelection = this.mapCombo.getText();
                if (userSelection.equals(COMMON_FIELDS)) {
                    this.caseCombo.removeAll();
                    this.setEnableCaseCombo(false);
                } else {
                    this.setEnableCaseCombo(true);
                    this.populateMappingCaseCombo(userSelection, this.caseCombo);
                }
                this.refreshFieldTable();
            } else if (e.widget == this.caseCombo) {
                this.refreshFieldTable();
            } else if (e.widget == this.updateSegLen) {
                this.handleSegmentLength();
            }
        }
        catch (InvalidInputException iie) {
            if (iie.getErrorCode() == 12) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                this.setPageComplete(false);
            } else if (iie.getErrorCode() == 4) {
                this.setMessage(iie.getMessage(), 2);
                this.setPageComplete(true);
                this.updateSegLen.setEnabled(true);
            } else {
                this.setErrorMessage(iie.getMessage());
                this.setPageComplete(false);
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", new Object[0]);
    }

    private void enableButtons() {
        int numSelected = this.fieldTab.getSelectionCount();
        if (this.mfController.isReadOnly()) {
            TableItem selectedItem;
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.moveButton.setEnabled(false);
            if (numSelected == 1 && !(selectedItem = this.fieldTab.getSelection()[0]).getText(0).equals(WorkbenchPlugin.labels.getString("WB350"))) {
                this.editButton.setEnabled(true);
            }
        } else if (numSelected == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.moveButton.setEnabled(false);
        } else if (numSelected == 1) {
            TableItem selectedItem = this.fieldTab.getSelection()[0];
            if (selectedItem.getText(0).equals(WorkbenchPlugin.labels.getString("WB350"))) {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.moveButton.setEnabled(false);
            } else {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.moveButton.setEnabled(true);
            }
        } else if (numSelected > 1) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(true);
            this.moveButton.setEnabled(true);
        }
    }

    public void setVisible(boolean visible) {
        try {
            super.setVisible(visible);
            if (visible) {
                this.editButton.setFocus();
                this.refreshFieldTable();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", e);
            logger.error(e);
        }
    }

    private void handleRemove() throws ModelException, InvalidInputException {
        String mappingName = this.mapCombo.getText();
        String caseName = this.caseCombo.getText();
        if (mappingName.equals(COMMON_FIELDS)) {
            mappingName = ManageFieldsController.COMMON_FIELDS;
        }
        TableItem[] selectedItems = this.fieldTab.getSelection();
        String fieldName = this.fieldTab.getItem(0).getText(1);
        int index = this.fieldTab.getSelectionIndices()[0];
        if (index > 0) {
            fieldName = this.fieldTab.getItem(index - 1).getText(1);
        }
        String[] selectedFields = new String[selectedItems.length];
        int i = 0;
        while (i < selectedItems.length) {
            String fieldAlias;
            selectedFields[i] = fieldAlias = selectedItems[i].getText(1);
            ++i;
        }
        this.mfController.validateMoveOrRemoveFieldsSelection(selectedFields, mappingName, caseName, "");
        this.mfController.removeField(selectedFields, mappingName, caseName);
        this.refreshFieldTable();
        if (index == 0 && this.fieldTab.getItemCount() > 0) {
            fieldName = this.fieldTab.getItem(0).getText(1);
        }
        this.selectFields(new String[]{fieldName});
        this.enableButtons();
    }

    private void handleAdd() throws ModelException, InvalidInputException {
        EditFieldWizard editFieldWizard = null;
        EditFieldController efController = null;
        String mapName = this.mapCombo.getText();
        String caseName = this.caseCombo.getText();
        if (mapName.equals(COMMON_FIELDS)) {
            mapName = ManageFieldsController.COMMON_FIELDS;
        }
        if (this.fieldTab.getSelectionCount() == 1) {
            TableItem selectedItem = this.fieldTab.getSelection()[0];
            if (selectedItem.getText(0).equals(WorkbenchPlugin.labels.getString("WB350"))) {
                String start = selectedItem.getText(4);
                String startValue = start.substring(2);
                String bytes = selectedItem.getText(5);
                if (bytes.indexOf("=") != -1) {
                    bytes = bytes.substring(bytes.indexOf("=")).trim();
                }
                efController = new EditFieldController(null, mapName, caseName, this.mfController, "ADD");
                efController.setStartPos(startValue);
                if (Integer.valueOf(bytes) <= 255) {
                    efController.setBytes(bytes);
                }
            } else {
                String selectedFieldName = selectedItem.getText(1);
                efController = new EditFieldController(selectedFieldName, mapName, caseName, this.mfController, "ADD");
            }
        } else {
            efController = new EditFieldController(null, mapName, caseName, this.mfController, "ADD");
        }
        editFieldWizard = new EditFieldWizard(efController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editFieldWizard);
        dialog.create();
        dialog.getShell().setSize(editFieldWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshFieldTable();
            this.selectFields(new String[]{efController.getName()});
        }
        if (!this.fieldWasAddedOrEdited && dialog.getReturnCode() == 0) {
            this.fieldWasAddedOrEdited = true;
        }
    }

    private void handleEdit() throws ModelException {
        TableItem selectedItem = this.fieldTab.getSelection()[0];
        String fieldName = selectedItem.getText(1);
        EditFieldWizard editFieldWizard = null;
        String mapName = this.mapCombo.getText();
        if (mapName.equals(COMMON_FIELDS)) {
            mapName = ManageFieldsController.COMMON_FIELDS;
        }
        EditFieldController efController = new EditFieldController(fieldName, mapName, this.caseCombo.getText(), this.mfController, "EDIT");
        editFieldWizard = new EditFieldWizard(efController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editFieldWizard);
        dialog.create();
        dialog.getShell().setSize(editFieldWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshFieldTable();
            this.enableButtons();
            this.selectFields(new String[]{fieldName});
        }
        if (!this.fieldWasAddedOrEdited && dialog.getReturnCode() == 0) {
            this.fieldWasAddedOrEdited = true;
        }
    }

    private void handleMove() throws ModelException, InvalidInputException {
        String[] fieldList = new String[this.fieldTab.getSelectionCount()];
        int i = 0;
        while (i < this.fieldTab.getSelectionCount()) {
            fieldList[i] = this.fieldTab.getSelection()[i].getText(1);
            ++i;
        }
        String mapName = this.mapCombo.getText();
        if (mapName.equals(COMMON_FIELDS)) {
            mapName = ManageFieldsController.COMMON_FIELDS;
        }
        String caseName = this.caseCombo.getText();
        this.mfController.validateMoveOrRemoveFieldsSelection(fieldList, mapName, caseName, "MOVE");
        String[] updatedFieldList = this.mfController.addStartAfterFields(fieldList, mapName, caseName);
        EditFieldController efController = new EditFieldController(updatedFieldList, mapName, caseName, this.mfController);
        EditFieldWizard editFieldWizard = new EditFieldWizard(efController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editFieldWizard);
        dialog.create();
        dialog.getShell().setSize(editFieldWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshFieldTable();
            this.enableButtons();
            this.selectFields(fieldList);
        }
        if (!this.fieldWasAddedOrEdited && dialog.getReturnCode() == 0) {
            this.fieldWasAddedOrEdited = true;
        }
    }

    private void selectFields(String[] fieldNames) {
        int[] indices = new int[fieldNames.length];
        int i = 0;
        while (i < fieldNames.length) {
            int index = this.getTableItemIndex(fieldNames[i]);
            if (index >= 0) {
                indices[i] = index;
            }
            ++i;
        }
        this.fieldTab.setSelection(indices);
    }

    private int getTableItemIndex(String fieldName) {
        int retVal = -1;
        int i = 0;
        while (i < this.fieldTab.getItems().length) {
            String fldName = this.fieldTab.getItem(i).getText(1);
            if (fldName.equals(fieldName)) {
                retVal = i;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private synchronized boolean testAndSetFindDialogOpen() {
        boolean retVal = this.isFindDialogOpen;
        this.isFindDialogOpen = true;
        return retVal;
    }

    private void handleFind() {
        boolean findDialogOpenAlreadyOpen = this.testAndSetFindDialogOpen();
        if (!findDialogOpenAlreadyOpen) {
            FieldSearchDialog dialog = new FieldSearchDialog(this.getContainer().getShell(), WorkbenchPlugin.labels.getString("WB086A"), this);
            dialog.open();
        }
    }

    private void handleSegmentLength() {
        try {
            if (this.updateSegLen != null) {
                FieldModel lastField = (FieldModel)this.mfController.getTopLevelFieldList(COMMON_FIELDS, null).lastElement();
                int length = lastField.getMaxBytes();
                if (length == 0) {
                    length = lastField.getBytes();
                }
                int start = lastField.getStartPos();
                int newMaxBytes = length + start - 1;
                this.mfController.getSegmentModelClone().setMaxBytes(newMaxBytes);
                this.segLenText.setText(String.valueOf(newMaxBytes));
                this.updateSegLen.setEnabled(false);
                this.setMessage(WorkbenchPlugin.labels.getString("WB203"));
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleSegmentLength()", e);
            logger.error(e);
        }
    }

    public void setFieldWasAddedOrEdited(boolean fieldWasAddedOrEdited) {
        this.fieldWasAddedOrEdited = fieldWasAddedOrEdited;
    }

    private void populateMappingCombo(Combo mapCombo) {
        Iterator maps = this.mfController.getMappingList();
        mapCombo.removeAll();
        mapCombo.add(COMMON_FIELDS);
        while (maps.hasNext()) {
            MappingModel map = (MappingModel)maps.next();
            if (!map.getMappingCases().hasNext()) continue;
            mapCombo.add(map.getName());
        }
        mapCombo.select(0);
        this.setEnableCaseCombo(false);
    }

    private void populateMappingCaseCombo(String mapName, Combo caseCombo) {
        MappingModel map = this.getMappingModelFromSegment(mapName);
        Iterator mapCases = map.getMappingCases();
        caseCombo.removeAll();
        while (mapCases.hasNext()) {
            MappingCaseModel mCase = (MappingCaseModel)mapCases.next();
            caseCombo.add(mCase.getName());
        }
        if (caseCombo.getItemCount() > 0) {
            caseCombo.select(0);
        }
    }

    private MappingModel getMappingModelFromSegment(String mappingName) {
        Iterator allMappings = this.mfController.getMappingList();
        while (allMappings.hasNext()) {
            MappingModel map = (MappingModel)allMappings.next();
            if (!map.getName().equals(mappingName)) continue;
            return map;
        }
        return null;
    }

    public void createListenerForMappingCombo() {
        this.mapCombo.addSelectionListener((SelectionListener)this);
    }

    public void createListenerForCaseCombo() {
        this.caseCombo.addSelectionListener((SelectionListener)this);
    }

    private void setEnableCaseCombo(boolean enableFlag) {
        this.caseLabel.setEnabled(enableFlag);
        this.caseCombo.setEnabled(enableFlag);
    }

    private void refreshFieldTable() throws ModelException {
        try {
            this.updateSegLen.setEnabled(false);
            String mapName = this.mapCombo.getText();
            if (mapName.equals(COMMON_FIELDS)) {
                mapName = ManageFieldsController.COMMON_FIELDS;
            }
            Vector allFields = this.mfController.getFreshFieldList(mapName, this.caseCombo.getText());
            this.addEmptyFields(allFields);
            this.fieldTab.removeAll();
            this.populateTableFromFields(allFields);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.mfController.semanticCheck(allFields);
            this.setErrorMessage(null);
            this.setPageComplete(true);
            this.setMessage(WorkbenchPlugin.labels.getString("WB203"));
        }
        catch (InvalidInputException iie) {
            if (iie.getErrorCode() == 4) {
                this.setMessage(iie.getMessage(), 2);
                this.setPageComplete(true);
                this.updateSegLen.setEnabled(true);
            }
            this.setErrorMessage(iie.getMessage());
            this.setPageComplete(false);
        }
    }

    public TableItem[] getTableItems() {
        return this.getFieldTab().getItems();
    }

    public int getSelectionIndex() {
        return this.getFieldTab().getSelectionIndex();
    }

    public void setSelection(int index) {
        this.getFieldTab().setSelection(index);
        this.getFieldTab().showSelection();
    }

    private void addEmptyFields(Vector<FieldModel> fields) {
        int segmentLength = this.mfController.getSegmentModelClone().getMaxBytes();
        if (fields.size() == 0) {
            FieldModel emptyField = this.createNewEmptyField();
            emptyField.setStartPos(1);
            int lengthBytes = this.mfController.getSegmentModelClone().getMaxBytes();
            emptyField.setBytes(lengthBytes);
            fields.add(0, emptyField);
            return;
        }
        int lastByteCovered = 0;
        int firstFieldStart = fields.get(0).getStartPos();
        if (firstFieldStart > 1) {
            FieldModel emptyField = this.createNewEmptyField();
            emptyField.setStartPos(1);
            int lengthBytes = firstFieldStart - 1;
            emptyField.setBytes(lengthBytes);
            fields.add(0, emptyField);
            lastByteCovered = firstFieldStart - 1;
        }
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = fields.get(i);
            int currFieldStart = currField.getStartPos();
            int currFieldBytes = currField.getBytes();
            if (currFieldBytes <= 0) {
                currFieldBytes = currField.getMaxBytes();
            }
            int currFieldEnd = currFieldStart + currFieldBytes - 1;
            if (currFieldStart > lastByteCovered + 1) {
                FieldModel emptyField = this.createNewEmptyField();
                emptyField.setStartPos(lastByteCovered + 1);
                int lengthBytes = currFieldStart - lastByteCovered - 1;
                if (currFieldStart > segmentLength) {
                    lengthBytes = segmentLength - lastByteCovered;
                }
                emptyField.setBytes(lengthBytes);
                fields.add(i, emptyField);
            }
            if (currFieldEnd > lastByteCovered) {
                lastByteCovered = currFieldEnd;
            }
            if (lastByteCovered >= segmentLength) break;
            ++i;
        }
        if (lastByteCovered < segmentLength) {
            FieldModel emptyField = this.createNewEmptyField();
            emptyField.setStartPos(lastByteCovered + 1);
            int lengthBytes = segmentLength - lastByteCovered;
            emptyField.setBytes(lengthBytes);
            fields.add(i, emptyField);
        }
    }

    private FieldModel createNewEmptyField() {
        FieldModelImpl emptyField = new FieldModelImpl();
        emptyField.setImsName(WorkbenchModelBundle.getLabel().getString("WB350"));
        emptyField.setName(WorkbenchModelBundle.getLabel().getString("WB351"));
        return emptyField;
    }

    public void mouseDoubleClick(MouseEvent arg0) {
        try {
            if (this.fieldTab.getSelection().length > 0) {
                TableItem selectedItem = this.fieldTab.getSelection()[0];
                if (selectedItem.getText(0).equals(WorkbenchPlugin.labels.getString("WB350"))) {
                    this.handleAdd();
                } else {
                    this.handleEdit();
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "mouseDoubleClick(MouseEvent e)", e);
            logger.error(e);
        }
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void setFindDialogOpen(boolean isFindDialogOpen) {
        this.isFindDialogOpen = isFindDialogOpen;
    }
}

