/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managefield;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.field.ManageFieldsController;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.wizard.managefield.ManageFieldWizardPage1;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ManageFieldWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ManageFieldsController mfController;
    private SegmentGEFModel gefSegment;
    private FieldGEFModel gefField;
    public DbGEFModel dbGefModel;
    private ManageFieldWizardPage1 page1;

    public ManageFieldWizard(SegmentGEFModel gefSegment, ManageFieldsController mfController) {
        Object[] inserts = new Object[]{gefSegment.getSegmentAlias()};
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB038A", inserts));
        this.setHelpAvailable(false);
        this.gefSegment = gefSegment;
        this.dbGefModel = gefSegment.getDbGEFModel();
        this.mfController = mfController;
    }

    public FieldGEFModel getFieldInfo() {
        return this.gefField;
    }

    public FieldGEFModel getGefField() {
        return this.gefField;
    }

    public void setFieldInfo(FieldGEFModel dliFieldModel) {
        this.gefField = dliFieldModel;
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        try {
            this.gefSegment.removeAllFields();
            this.mfController.performFinish();
            this.gefSegment.refreshFieldList();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }

    public SegmentGEFModel getGefSegment() {
        return this.gefSegment;
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.page1.isPageComplete()) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public void addPages() {
        try {
            this.page1 = new ManageFieldWizardPage1("FIELD1", false, this.mfController);
            this.addPage((IWizardPage)this.page1);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }
}

