/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managefield;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.wizard.managefield.ManageFieldWizardPage1;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FieldSearchDialog
extends Dialog
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String searchDialogTitle;
    private static final int margin = 10;
    private UIHelper uih;
    private Label searchLabel;
    private Text searchText;
    private ManageFieldWizardPage1 parentWizPage;
    private Group groupDirection;
    private Button buttonForward;
    private Button buttonBackward;

    public FieldSearchDialog(Shell parentShell, String searchDialogTitle, ManageFieldWizardPage1 parentWizPage) {
        super(parentShell);
        this.searchDialogTitle = searchDialogTitle;
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
        this.uih = new UIHelper();
        this.parentWizPage = parentWizPage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.searchDialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, WorkbenchPlugin.labels.getString("FSD_FINDNEXT"), true);
        this.createButton(parent, 1, WorkbenchPlugin.labels.getString("FSD_CLOSE"), false);
    }

    protected Control createDialogArea(Composite dialogParent) {
        Composite parent = (Composite)super.createDialogArea(dialogParent);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        parent.setLayoutData((Object)gd);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        parent.setLayout((Layout)formLayout);
        Display display = parent.getDisplay();
        this.uih.setDisplay(display);
        FormData fd_search = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment(0, 10), null);
        this.searchLabel = new Label(parent, 64);
        this.searchLabel.setText(WorkbenchPlugin.labels.getString("FSD_SEARCHTEXT") + WorkbenchPlugin.colon.getString("COLON"));
        this.searchLabel.setToolTipText(WorkbenchPlugin.labels.getString("FSD_TYPEFIELD"));
        this.searchLabel.setLayoutData((Object)fd_search);
        FormData fd_searchTxt = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment((Control)this.searchLabel, 10), new FormAttachment(100, 0));
        this.searchText = new Text(parent, 2116);
        this.searchText.setLayoutData((Object)fd_searchTxt);
        this.searchText.forceFocus();
        FormData fldTypeFD = this.uih.genFormData(new FormAttachment((Control)this.searchText, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        this.groupDirection = new Group(parent, 0);
        this.groupDirection.setText(WorkbenchPlugin.labels.getString("FSD_DIRECTION"));
        FormLayout groupDirectionFL = new FormLayout();
        groupDirectionFL.marginHeight = 10;
        groupDirectionFL.marginWidth = 10;
        this.groupDirection.setLayout((Layout)groupDirectionFL);
        this.groupDirection.setLayoutData((Object)fldTypeFD);
        FormData fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        this.buttonForward = new Button((Composite)this.groupDirection, 16);
        this.buttonForward.setText(WorkbenchPlugin.labels.getString("FSD_FORWARD"));
        this.buttonForward.setLayoutData((Object)fd);
        this.buttonForward.setSelection(true);
        fd = this.uih.genFormData(new FormAttachment((Control)this.buttonForward, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        this.buttonBackward = new Button((Composite)this.groupDirection, 16);
        this.buttonBackward.setText(WorkbenchPlugin.labels.getString("FSD_BACKWARD"));
        this.buttonBackward.setLayoutData((Object)fd);
        return parent;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        block7: {
            try {
                Button findButton = this.getButton(1025);
                if (event.widget != findButton) break block7;
                String searchPattern = this.searchText.getText().toUpperCase();
                int currSelIx = this.parentWizPage.getSelectionIndex();
                TableItem[] tableItems = this.parentWizPage.getTableItems();
                if (this.buttonForward.getSelection()) {
                    if (currSelIx >= tableItems.length - 1) break block7;
                    int i = currSelIx + 1;
                    while (i < tableItems.length) {
                        String currFieldAlias = tableItems[i].getText(1);
                        if (currFieldAlias.contains(searchPattern)) {
                            this.parentWizPage.setSelection(i);
                            break block7;
                        }
                        ++i;
                    }
                    break block7;
                }
                if (currSelIx <= 0) break block7;
                int i = currSelIx - 1;
                while (i >= 0) {
                    String currFieldName = tableItems[i].getText(0);
                    String currFieldAlias = tableItems[i].getText(1);
                    if (currFieldAlias.contains(searchPattern) || currFieldName != null && currFieldName.contains(searchPattern)) {
                        this.parentWizPage.setSelection(i);
                        break;
                    }
                    --i;
                }
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
                logger.error(e);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bBar = super.createButtonBar(parent);
        Button findButton = this.getButton(1025);
        findButton.addSelectionListener((SelectionListener)this);
        findButton.setEnabled(true);
        return bBar;
    }

    public boolean close() {
        this.parentWizPage.setFindDialogOpen(false);
        return super.close();
    }
}

