/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managefield;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.field.EditFieldController;
import com.ibm.im.ims.workbench.controller.field.IModelChangeListener;
import com.ibm.im.ims.workbench.controller.field.ModelChangeEvent;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.EAMessageControl;
import com.ibm.im.ims.workbench.utilities.TextFocusHightlightListener;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managefield.EditFieldWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditFieldWizardPage1
extends WizardPage
implements SelectionListener,
VerifyListener,
ModifyListener,
IModelChangeListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditFieldController efController;
    private static final String[] pageAttrs = new String[]{"IMS_NAME", "ALIAS", "SEQUENCE"};
    private static final String C_IMS_DATA_TYPE = DBDConstants.C.toString() + " " + WorkbenchPlugin.descriptions.getString("WB11A");
    private static final String X_IMS_DATA_TYPE = DBDConstants.X.toString() + " " + WorkbenchPlugin.descriptions.getString("WB09A");
    private static final String P_IMS_DATA_TYPE = DBDConstants.P.toString() + " " + WorkbenchPlugin.descriptions.getString("WB10A");
    private static final String F_IMS_DATA_TYPE = DBDConstants.F.toString() + " " + WorkbenchPlugin.descriptions.getString("WB13A");
    private static final String H_IMS_DATA_TYPE = DBDConstants.H.toString() + " " + WorkbenchPlugin.descriptions.getString("WB12A");
    private static final String M_SEQUENCE_FIELD = DBDConstants.M.toString() + " " + WorkbenchPlugin.descriptions.getString("WB08A");
    private static final String U_SEQUENCE_FIELD = DBDConstants.U.toString() + " " + WorkbenchPlugin.descriptions.getString("WB07A");
    private static final int adjustment = 2;
    private static final int require_label_space = 3;
    private static final int status_label_space = 4;
    private static final int margin = 5;
    private UIHelper uih;
    private Display display;
    private EAMessageControl msgControl = null;
    private TextFocusHightlightListener textFocusHighLight;
    private Group groupFieldType;
    private Link textLink;
    private Label labelReqFieldName;
    private Label labelFieldName;
    private Text textFieldName;
    private Label labelReqFieldAlias;
    private Label labelFieldAlias;
    private Text textFieldAlias;
    private Label labelSequence;
    private Combo comboSequence;
    private Label labelImsDataType;
    private Combo comboImsDataType;
    private Button buttonImsfld;
    private Button buttonUdfld;
    private Composite composite = null;

    protected EditFieldWizardPage1(EditFieldController efController) {
        super("EditFieldWizardPage1");
        this.efController = efController;
        this.efController.addModelChangeListener((IModelChangeListener)this);
        this.setTitle(WorkbenchPlugin.descriptions.getString("WB34A"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_wizard_large")));
        if (efController.getActionType().equals("EDIT")) {
            this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_edit_wizard_large")));
        } else if (efController.getActionType().equals("MOVE")) {
            this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_move_wizard_large")));
        }
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB29A"));
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.uih = new UIHelper();
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            this.composite = new Composite(parent, 0);
            this.composite.setLayout((Layout)layout);
            this.textFocusHighLight = new TextFocusHightlightListener();
            this.createUIControl();
            this.addMessageControls();
            this.initWidgetValues();
            if (this.efController.getActionType().equals("EDIT")) {
                this.validatePage(false, false, false);
            } else {
                this.validatePage(true, false, false);
            }
            this.handleEnablement();
            this.setControl((Control)this.composite);
            this.addListeners();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ies1_wb_managefield1");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void createUIControl() {
        int leftLabelSize = this.getMaxLeftLabelSize() + 25 + Utility.getTextWidth(this.composite, 0, "*");
        int rightLabelSize = this.getMaxRightLabelSize() + 25 + Utility.getTextWidth(this.composite, 0, "*");
        FormData fd = this.uih.genFormData(new FormAttachment(0), null, new FormAttachment(0), new FormAttachment(100));
        this.groupFieldType = new Group(this.composite, 0);
        this.groupFieldType.setText(WorkbenchPlugin.labels.getString("WB004A"));
        this.groupFieldType.setLayout((Layout)new FormLayout());
        this.groupFieldType.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, 5), null, new FormAttachment(0, 5), new FormAttachment(100, -5));
        this.textLink = new Link((Composite)this.groupFieldType, 0);
        this.textLink.setText(WorkbenchPlugin.descriptions.getString("WB089"));
        this.textLink.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.textLink, 5), new FormAttachment(100, -5), new FormAttachment(0, 5), new FormAttachment(50, -20));
        this.buttonUdfld = new Button((Composite)this.groupFieldType, 16);
        this.buttonUdfld.setText(WorkbenchPlugin.labels.getString("USER_DEFINED_FIELD"));
        this.buttonUdfld.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.textLink, 5), new FormAttachment(100, -5), new FormAttachment(50, 5), new FormAttachment(100, -5));
        this.buttonImsfld = new Button((Composite)this.groupFieldType, 16);
        this.buttonImsfld.setText(WorkbenchPlugin.labels.getString("IMS_FIELD"));
        this.buttonImsfld.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.groupFieldType, 8), null, new FormAttachment(0, 5), null);
        this.labelReqFieldName = this.uih.genRequiredSymbol(this.composite, 0, null, this.composite.getDisplay().getSystemColor(3));
        this.labelReqFieldName.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.groupFieldType, 5), null, new FormAttachment((Control)this.labelReqFieldName, 5), null);
        this.labelFieldName = new Label(this.composite, 0);
        this.labelFieldName.setText(WorkbenchPlugin.labels.getString("WB010A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001") + WorkbenchPlugin.colon.getString("COLON"));
        this.labelFieldName.setLayoutData((Object)fd);
        this.labelFieldName.setToolTipText(WorkbenchPlugin.descriptions.getString("WB097"));
        fd = this.uih.genFormData(new FormAttachment((Control)this.groupFieldType, 3), null, new FormAttachment(0, leftLabelSize), new FormAttachment(50, -20));
        this.textFieldName = new Text(this.composite, 2052);
        this.textFieldName.setTextLimit(8);
        this.textFieldName.setToolTipText(WorkbenchPlugin.descriptions.getString("WB079"));
        this.textFieldName.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.groupFieldType, 8), null, new FormAttachment(50, 5), null);
        this.labelReqFieldAlias = this.uih.genRequiredSymbol(this.composite, 0, null, this.composite.getDisplay().getSystemColor(3));
        this.labelReqFieldAlias.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.groupFieldType, 5), null, new FormAttachment((Control)this.labelReqFieldAlias, 5), null);
        this.labelFieldAlias = new Label(this.composite, 0);
        this.labelFieldAlias.setText(WorkbenchPlugin.labels.getString("WB211") + " " + WorkbenchPlugin.noxlatlabels.getString("WB091") + WorkbenchPlugin.colon.getString("COLON"));
        this.labelFieldAlias.setToolTipText(WorkbenchPlugin.descriptions.getString("WB098"));
        this.labelFieldAlias.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.groupFieldType, 3), null, new FormAttachment(50, rightLabelSize), new FormAttachment(100, -20));
        this.textFieldAlias = new Text(this.composite, 2052);
        this.textFieldAlias.setTextLimit(255);
        this.textFieldAlias.setToolTipText(WorkbenchPlugin.descriptions.getString("WB203"));
        this.textFieldAlias.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.textFieldName, 5), null, new FormAttachment((Control)this.labelReqFieldName, 5), null);
        this.labelSequence = new Label(this.composite, 0);
        this.labelSequence.setText(WorkbenchPlugin.labels.getString("WB011A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB052") + WorkbenchPlugin.colon.getString("COLON"));
        this.labelSequence.setToolTipText(WorkbenchPlugin.descriptions.getString("WB06A"));
        this.labelSequence.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.textFieldName, 3), null, new FormAttachment(0, leftLabelSize), new FormAttachment(50, -20));
        this.comboSequence = new Combo(this.composite, 2056);
        this.comboSequence.setItems(new String[]{"", M_SEQUENCE_FIELD, U_SEQUENCE_FIELD});
        this.comboSequence.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.textFieldAlias, 5), null, new FormAttachment((Control)this.labelReqFieldAlias, 5), null);
        this.labelImsDataType = new Label(this.composite, 0);
        this.labelImsDataType.setText(WorkbenchPlugin.labels.getString("WB020A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB053") + WorkbenchPlugin.colon.getString("COLON"));
        this.labelImsDataType.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.textFieldAlias, 3), null, new FormAttachment(50, rightLabelSize), new FormAttachment(100, -20));
        this.comboImsDataType = new Combo(this.composite, 12);
        this.comboImsDataType.setItems(this.getImsDataTypes());
        this.comboImsDataType.setLayoutData((Object)fd);
    }

    private void addMessageControls() {
        this.msgControl = new EAMessageControl(this.composite);
        this.msgControl.addControl((Control)this.textFieldName);
        this.msgControl.addControl((Control)this.textFieldAlias);
        this.msgControl.addControl((Control)this.comboSequence);
        this.msgControl.setValidationMessage((Control)this.textFieldName, "", 3);
        this.msgControl.clearValidationMessage((Control)this.textFieldName);
        this.msgControl.setValidationMessage((Control)this.textFieldAlias, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.textFieldAlias);
        this.msgControl.setValidationMessage((Control)this.comboSequence, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.comboSequence);
    }

    private String[] getImsDataTypes() {
        Vector<String> imsDataTypes = new Vector<String>();
        imsDataTypes.add("");
        imsDataTypes.add(C_IMS_DATA_TYPE);
        imsDataTypes.add(P_IMS_DATA_TYPE);
        imsDataTypes.add(X_IMS_DATA_TYPE);
        DBDConstants accessType = this.efController.getAccessType();
        if (accessType != null && accessType == DBDConstants.MSDB) {
            imsDataTypes.add(F_IMS_DATA_TYPE);
            imsDataTypes.add(H_IMS_DATA_TYPE);
        }
        return imsDataTypes.toArray(new String[imsDataTypes.size()]);
    }

    private void initWidgetValues() throws ModelException {
        this.initFieldName();
        this.initAlias();
        this.setComboSeqFromField();
        this.setComboIMSDatatypeFromField();
        String fieldNameStr = this.efController.getImsName();
        if (fieldNameStr == null || fieldNameStr != null && fieldNameStr.equals("")) {
            this.buttonUdfld.setSelection(true);
            this.doUdfldSelected();
        } else {
            this.buttonImsfld.setSelection(true);
            this.doIMSfldSelected();
        }
    }

    private void initAlias() {
        String aliasStr = this.efController.getName();
        if (aliasStr != null) {
            this.textFieldAlias.setText(aliasStr);
        }
    }

    private void initFieldName() {
        String fieldNameStr = this.efController.getImsName();
        if (fieldNameStr != null) {
            this.textFieldName.setText(fieldNameStr);
        }
    }

    private void handleEnablement() {
        if (this.efController.isReadOnly()) {
            this.textFieldName.setEnabled(false);
            this.textFieldAlias.setEnabled(false);
            this.buttonUdfld.setEnabled(false);
            this.comboSequence.setEnabled(false);
            this.comboImsDataType.setEnabled(false);
        } else if (this.buttonImsfld.getSelection()) {
            boolean isCKField = false;
            boolean isSXField = false;
            String imsName = this.textFieldName.getText();
            if (imsName != null && !imsName.isEmpty()) {
                if (imsName.startsWith("/SX")) {
                    isSXField = true;
                } else if (imsName.startsWith("/CK")) {
                    isCKField = true;
                }
                if (isSXField || isCKField) {
                    this.buttonUdfld.setEnabled(false);
                    this.comboSequence.setEnabled(false);
                    this.comboImsDataType.setEnabled(false);
                } else {
                    this.buttonUdfld.setEnabled(true);
                    this.comboSequence.setEnabled(true);
                    this.comboImsDataType.setEnabled(true);
                }
            }
        }
    }

    private void setComboSeqFromField() {
        DBDConstants seqObj = this.efController.getSeqType();
        String seqStr = "";
        if (seqObj != null) {
            if (seqObj == DBDConstants.M) {
                seqStr = M_SEQUENCE_FIELD;
            } else if (seqObj == DBDConstants.U) {
                seqStr = U_SEQUENCE_FIELD;
            }
        }
        this.comboSequence.setText(seqStr);
    }

    private void setComboIMSDatatypeFromField() {
        DBDConstants imsDatatypeObj = this.efController.getImsDatatype();
        String imsDatatypeStr = "";
        if (imsDatatypeObj != null) {
            if (imsDatatypeObj == DBDConstants.C) {
                imsDatatypeStr = C_IMS_DATA_TYPE;
            } else if (imsDatatypeObj == DBDConstants.F) {
                imsDatatypeStr = F_IMS_DATA_TYPE;
            } else if (imsDatatypeObj == DBDConstants.H) {
                imsDatatypeStr = H_IMS_DATA_TYPE;
            } else if (imsDatatypeObj == DBDConstants.P) {
                imsDatatypeStr = P_IMS_DATA_TYPE;
            } else if (imsDatatypeObj == DBDConstants.X) {
                imsDatatypeStr = X_IMS_DATA_TYPE;
            }
        }
        this.comboImsDataType.setText(imsDatatypeStr);
    }

    public void addListeners() {
        this.buttonUdfld.addSelectionListener((SelectionListener)this);
        this.buttonImsfld.addSelectionListener((SelectionListener)this);
        this.textFieldName.addModifyListener((ModifyListener)this);
        this.textFieldName.addFocusListener((FocusListener)this.textFocusHighLight);
        this.textFieldAlias.addModifyListener((ModifyListener)this);
        this.textFieldAlias.addFocusListener((FocusListener)this.textFocusHighLight);
        this.comboSequence.addModifyListener((ModifyListener)this);
        this.comboImsDataType.addModifyListener((ModifyListener)this);
        this.textFieldName.addVerifyListener((VerifyListener)this);
        this.textFieldAlias.addVerifyListener((VerifyListener)this);
    }

    private void removeListeners() {
        this.buttonUdfld.removeSelectionListener((SelectionListener)this);
        this.buttonImsfld.removeSelectionListener((SelectionListener)this);
        this.textFieldName.removeModifyListener((ModifyListener)this);
        this.textFieldName.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.textFieldAlias.removeModifyListener((ModifyListener)this);
        this.textFieldAlias.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.comboSequence.removeModifyListener((ModifyListener)this);
        this.comboImsDataType.removeModifyListener((ModifyListener)this);
        this.textFieldName.removeVerifyListener((VerifyListener)this);
        this.textFieldAlias.removeVerifyListener((VerifyListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            try {
                this.validateAttributeChangeable(e.widget);
            }
            catch (InvalidInputException iie) {
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                return;
            }
            if (e.widget == this.buttonUdfld) {
                if (this.buttonUdfld.getSelection()) {
                    this.efController.setIMSFieldSelected(false);
                    this.doUdfldSelected();
                    this.validatePage(false, true, false);
                }
            } else if (e.widget == this.buttonImsfld && this.buttonImsfld.getSelection()) {
                this.efController.setIMSFieldSelected(true);
                this.doIMSfldSelected();
                this.validatePage(false, true, false);
            }
            this.handleEnablement();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
    }

    private void validateAttributeChangeable(Widget widget) throws InvalidInputException, ModelException {
        InvalidInputException iie = null;
        if (widget == this.buttonUdfld) {
            if (this.buttonUdfld.getSelection()) {
                iie = this.efController.validateAttrChangable("USERDEFINED_FIELD", null);
            }
        } else if (widget == this.textFieldAlias) {
            iie = this.efController.validateAttrChangable("ALIAS", null);
        }
        if (iie != null) {
            throw iie;
        }
    }

    private void doIMSfldSelected() {
        this.labelReqFieldAlias.setVisible(false);
        this.labelReqFieldName.setVisible(true);
        this.textFieldName.setEnabled(true);
        this.comboImsDataType.setEnabled(true);
        this.comboSequence.setEnabled(true);
        this.textFieldName.setFocus();
    }

    private void doUdfldSelected() {
        this.labelReqFieldAlias.setVisible(true);
        this.labelReqFieldName.setVisible(false);
        this.textFieldName.setEnabled(false);
        this.comboImsDataType.setEnabled(false);
        this.comboSequence.setEnabled(false);
        this.comboSequence.setText("");
        this.textFieldName.setText("");
        this.comboImsDataType.setText("");
        this.textFieldAlias.setFocus();
    }

    protected EditFieldWizard getWiz() {
        return (EditFieldWizard)this.getWizard();
    }

    public void verifyText(VerifyEvent e) {
        try {
            if ((e.widget == this.textFieldName || e.widget == this.textFieldAlias) && e.character >= 'a' && e.character <= 'z') {
                String upperCaseChar;
                e.text = upperCaseChar = e.text.toUpperCase();
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            try {
                this.validateAttributeChangeable(e.widget);
            }
            catch (InvalidInputException iie) {
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                return;
            }
            boolean editImsName = false;
            if (e.widget == this.textFieldName) {
                editImsName = true;
            }
            this.validatePage(false, true, editImsName);
            this.handleEnablement();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void validateInput(boolean editImsName) throws InvalidInputException {
        String imsDatatypeStr = this.comboImsDataType.getText();
        if (imsDatatypeStr.equals("")) {
            this.efController.setImsDatatype(null);
        } else if (imsDatatypeStr.substring(0, 1).equalsIgnoreCase("C")) {
            this.efController.setImsDatatype(DBDConstants.C);
        } else if (imsDatatypeStr.substring(0, 1).equalsIgnoreCase("X")) {
            this.efController.setImsDatatype(DBDConstants.X);
        } else if (imsDatatypeStr.substring(0, 1).equalsIgnoreCase("P")) {
            this.efController.setImsDatatype(DBDConstants.P);
        } else if (imsDatatypeStr.substring(0, 1).equalsIgnoreCase("F")) {
            this.efController.setImsDatatype(DBDConstants.F);
        } else if (imsDatatypeStr.substring(0, 1).equalsIgnoreCase("H")) {
            this.efController.setImsDatatype(DBDConstants.H);
        }
        String oldIMSName = this.efController.getImsName();
        this.efController.setImsName(this.textFieldName.getText());
        String newAlias = this.textFieldAlias.getText();
        if (editImsName) {
            String newIMSName = this.textFieldName.getText();
            if (oldIMSName.equalsIgnoreCase(newAlias) && newIMSName != null && !newIMSName.isEmpty()) {
                newAlias = newIMSName;
                this.textFieldAlias.removeVerifyListener((VerifyListener)this);
                this.textFieldAlias.removeModifyListener((ModifyListener)this);
                this.textFieldAlias.removeFocusListener((FocusListener)this.textFocusHighLight);
                this.textFieldAlias.setText(newAlias);
                this.textFieldAlias.addVerifyListener((VerifyListener)this);
                this.textFieldAlias.addModifyListener((ModifyListener)this);
                this.textFieldAlias.addFocusListener((FocusListener)this.textFocusHighLight);
            }
        }
        this.efController.setName(newAlias);
        this.efController.setSequence(this.comboSequence.getText());
    }

    public void validatePage(boolean suppressErrorMessage, boolean invokedDueToUserEdit, boolean editImsName) throws ModelException {
        block6: {
            try {
                this.clearValidationMessages();
                if (invokedDueToUserEdit) {
                    this.validateInput(editImsName);
                }
                String[] attrsToCheck = new String[]{"IMS_NAME", "ALIAS"};
                this.efController.validateRequiredFields(attrsToCheck);
                this.efController.semanticCheck();
                this.setPageComplete(true);
            }
            catch (InvalidInputException ex) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "", (Throwable)ex);
                if (!suppressErrorMessage) {
                    this.setErrorMessage(ex.getMessage());
                    this.setValidationMessages(ex);
                    if (ex.getErrorCode() == 12) {
                        this.setErrorMessage(null);
                        this.msgControl.clearValidationMessage((Control)this.textFieldAlias);
                    }
                }
                if (ex.getErrorCode() == 12) break block6;
                String[] errorAttrs = ex.getAttrNames();
                if (Utility.allAttrsOnPage(errorAttrs, pageAttrs)) {
                    this.setPageComplete(false);
                }
                this.setPageComplete(true);
            }
        }
    }

    public String getFieldType() {
        if (this.buttonImsfld.getSelection()) {
            return WorkbenchPlugin.labels.getString("IMS_FIELD");
        }
        return WorkbenchPlugin.labels.getString("USER_DEFINED_FIELD");
    }

    private void setValidationMessages(InvalidInputException iie) {
        String[] attrs = iie.getAttrNames();
        String message = iie.getMessage();
        int i = 0;
        while (i < attrs.length) {
            String attrName = attrs[i];
            if (attrName.equals("SEQUENCE")) {
                this.msgControl.setValidationMessage((Control)this.comboSequence, message, 3);
            } else if (attrName.equals("ALIAS")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                    String originalAlias = this.efController.getOriginalAlias();
                    this.textFieldAlias.setText(originalAlias);
                }
                this.msgControl.setValidationMessage((Control)this.textFieldAlias, message, 3);
            } else if (attrName.equals("IMS_NAME")) {
                this.msgControl.setValidationMessage((Control)this.textFieldName, message, 3);
            } else if (attrName.equals("FIELD_TYPE") && iie.getErrorCode() == 1) {
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                this.setErrorMessage(null);
            }
            ++i;
        }
    }

    private void clearValidationMessages() {
        this.setErrorMessage(null);
        this.msgControl.clearValidationMessage((Control)this.comboSequence);
        this.msgControl.clearValidationMessage((Control)this.textFieldAlias);
        this.msgControl.clearValidationMessage((Control)this.textFieldName);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.validatePage(false, this.efController.hasBeenEdited(), false);
                this.handleEnablement();
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
                logger.error(e);
            }
            this.setFocus();
        }
    }

    public String getIMSName() {
        return this.textFieldName.getText().trim();
    }

    public String getAlias() {
        return this.textFieldAlias.getText().trim();
    }

    public String getSeq() {
        return this.comboSequence.getText();
    }

    public String getIMSDatatype() {
        return this.comboImsDataType.getText();
    }

    private int getMaxLeftLabelSize() {
        int[] allLeftLabelSize = new int[]{Utility.getTextWidth(this.composite, 0, WorkbenchPlugin.labels.getString("WB010A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB001") + WorkbenchPlugin.colon.getString("COLON")), Utility.getTextWidth(this.composite, 0, WorkbenchPlugin.labels.getString("WB011A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB052") + WorkbenchPlugin.colon.getString("COLON"))};
        return Utility.getMaxSize(allLeftLabelSize);
    }

    private int getMaxRightLabelSize() {
        int[] allLabelSize = new int[]{Utility.getTextWidth(this.composite, 0, WorkbenchPlugin.labels.getString("WB211") + " " + WorkbenchPlugin.noxlatlabels.getString("WB091") + WorkbenchPlugin.colon.getString("COLON")), Utility.getTextWidth(this.composite, 0, WorkbenchPlugin.labels.getString("WB020A") + " " + WorkbenchPlugin.noxlatlabels.getString("WB053") + WorkbenchPlugin.colon.getString("COLON"))};
        return Utility.getMaxSize(allLabelSize);
    }

    public IWizardPage getNextPage() {
        IWizardPage nextWizardPage = super.getNextPage();
        if (this.efController.getImsName() != null && this.efController.getImsName().startsWith("/SX")) {
            ((WizardPage)nextWizardPage).setPageComplete(true);
            return null;
        }
        return nextWizardPage;
    }

    private void setFocus() {
        if (this.buttonImsfld.getSelection()) {
            this.textFieldName.setFocus();
        } else if (this.buttonUdfld.getSelection()) {
            this.textFieldAlias.setFocus();
        }
    }

    public void handleModelChange(ModelChangeEvent e) {
        try {
            this.removeListeners();
            String[] stringArray = e.getAttrs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (attr.equals("USERDEFINED_FIELD")) {
                    this.buttonUdfld.setSelection(false);
                    this.buttonImsfld.setSelection(true);
                } else if (attr.equals("ALIAS")) {
                    this.initAlias();
                }
                ++n2;
            }
            this.addListeners();
        }
        catch (Throwable exc) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", exc);
            logger.error(exc);
        }
    }
}

