/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managefield;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.field.EditFieldController;
import com.ibm.im.ims.workbench.controller.field.IModelChangeListener;
import com.ibm.im.ims.workbench.controller.field.ManageFieldsController;
import com.ibm.im.ims.workbench.controller.field.ModelChangeEvent;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.EAMessageControl;
import com.ibm.im.ims.workbench.utilities.TextFocusHightlightListener;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.managefield.EditFieldWizard;
import com.ibm.im.ims.workbench.wizard.managefield.ManageFieldWizardPage1;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditFieldWizardPage0
extends WizardPage
implements SelectionListener,
VerifyListener,
ModifyListener,
FocusListener,
IModelChangeListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditFieldController efController;
    private static final int adjustment = 2;
    private static final int require_label_space = 3;
    private static final int status_label_space = 4;
    private static final int margin = 5;
    private static final String[] pageAttrs = new String[]{"START", "REDEFINES", "REMARKS"};
    private static final String CONTAINER_LABEL = WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_LOCATION_CONTAINER") + WorkbenchPlugin.colon.getString("COLON");
    private static final String CASE_LABEL = WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_LOCATION_CASE") + WorkbenchPlugin.colon.getString("COLON");
    private static final String PARENT_LABEL = WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_LOCATION_PARENT") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB433") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String START_AFTER_LABEL = WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER") + WorkbenchPlugin.colon.getString("COLON");
    private static final String START_POSITION_LABEL = WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_POSITION_START_POSITION") + WorkbenchPlugin.colon.getString("COLON");
    private static final String REMARKS_LABEL = WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String CASE_LABEL_HOVER_TEXT = WorkbenchPlugin.descriptions.getString("WB460");
    private static final String PARENT_LABEL_HOVER_TEXT = WorkbenchPlugin.descriptions.getString("WB460C");
    private static final String START_POS_LABEL_HOVER_TEXT = WorkbenchPlugin.descriptions.getString("WB460D");
    private static final String START_POS_TEXT_HOVER_TEXT = WorkbenchPlugin.descriptions.getString("WB03A");
    private static final String REMARKS_LABEL_HOVER_TEXT = WorkbenchPlugin.descriptions.getString("WB099");
    private static final String REMARKS_TEXT_HOVER_TEXT = WorkbenchPlugin.descriptions.getString("WB100");
    private static final String REDEFINES_LABEL = WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_REDEFINES") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB480") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private Combo comboContainer;
    private Combo comboCaseName;
    private Combo comboParentField;
    private Combo comboStartAfter;
    private Button buttonStartAfter;
    private Button buttonStartPosition;
    private Text textStartPosition;
    private Text textRemarks;
    private EAMessageControl msgControl;
    private TextFocusHightlightListener textFocusHighLight;
    private Label labelContainer;
    private Label labelCaseReq;
    private Label labelCase;
    private Label labelParentField;
    private Label labelRemarks;
    private Label labelRedefines;
    private Combo comboRedefinesField;
    private Label startPositionReq;
    private Label startAfterReq;
    private Label containerReq;

    protected EditFieldWizardPage0(EditFieldController efController) {
        super("EditFieldWizardPage0");
        this.efController = efController;
        this.efController.addModelChangeListener((IModelChangeListener)this);
        String fieldName = efController.getName();
        if (fieldName == null || fieldName.isEmpty()) {
            this.setTitle(WorkbenchPlugin.descriptions.getString("WB34A2"));
        } else {
            Object[] inserts = new Object[]{fieldName};
            this.setTitle(WorkbenchPlugin.descriptions.getString("WB34A1", inserts));
        }
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_wizard_large")));
        if (efController.getActionType().equals("EDIT")) {
            this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_edit_wizard_large")));
        } else if (efController.getActionType().equals("MOVE")) {
            this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("field_move_wizard_large")));
        }
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            this.msgControl = new EAMessageControl(composite);
            UIHelper uih = new UIHelper();
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            composite.setLayout((Layout)layout);
            this.textFocusHighLight = new TextFocusHightlightListener();
            FormData fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            Group fieldLocationGroup = new Group(composite, 0);
            fieldLocationGroup.setLayout((Layout)layout);
            fieldLocationGroup.setLayoutData((Object)fd);
            fieldLocationGroup.setText(WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_LOCATION"));
            fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 5), new FormAttachment(100, -5));
            Link fieldLocationDescription = new Link((Composite)fieldLocationGroup, 0);
            fieldLocationDescription.setLayoutData((Object)fd);
            fieldLocationDescription.setText(WorkbenchPlugin.descriptions.getString("WB460A") + " <a>" + WorkbenchPlugin.labels.getString("WB439") + "</a>");
            fieldLocationDescription.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.wb_mapping_over");
                }
            });
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationDescription, 8), null, new FormAttachment(0, 5), null);
            this.containerReq = uih.genRequiredSymbol((Composite)fieldLocationGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationDescription, 5), null, new FormAttachment((Control)this.containerReq, 5), null);
            this.labelContainer = new Label((Composite)fieldLocationGroup, 0);
            this.labelContainer.setText(CONTAINER_LABEL);
            this.labelContainer.pack();
            this.labelContainer.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationDescription, 3), null, new FormAttachment((Control)this.labelContainer, 5), new FormAttachment(50, -20));
            this.comboContainer = new Combo((Composite)fieldLocationGroup, 2056);
            this.comboContainer.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationDescription, 8), null, new FormAttachment(50, 5), null);
            this.labelCaseReq = uih.genRequiredSymbol((Composite)fieldLocationGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationDescription, 5), null, new FormAttachment((Control)this.labelCaseReq, 5), null);
            this.labelCase = new Label((Composite)fieldLocationGroup, 0);
            this.labelCase.setText(CASE_LABEL);
            this.labelCase.setToolTipText(CASE_LABEL_HOVER_TEXT);
            this.labelCase.pack();
            this.labelCase.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationDescription, 3), null, new FormAttachment((Control)this.labelCase, 5), new FormAttachment(100, -20));
            this.comboCaseName = new Combo((Composite)fieldLocationGroup, 2056);
            this.comboCaseName.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.comboContainer, 7), null, new FormAttachment((Control)this.containerReq, 5), null);
            this.labelParentField = new Label((Composite)fieldLocationGroup, 0);
            this.labelParentField.setText(PARENT_LABEL);
            this.labelParentField.setToolTipText(PARENT_LABEL_HOVER_TEXT);
            this.labelParentField.pack();
            this.labelParentField.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.comboContainer, 3), null, new FormAttachment((Control)this.labelParentField, 5), new FormAttachment(50, -20));
            this.comboParentField = new Combo((Composite)fieldLocationGroup, 2056);
            this.comboParentField.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationGroup, 5), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            Group fieldPositionGroup = new Group(composite, 0);
            fieldPositionGroup.setLayoutData((Object)fd);
            fieldPositionGroup.setLayout((Layout)layout);
            fieldPositionGroup.setText(WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_POSITION"));
            fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 5), new FormAttachment(100, -5));
            Link fieldPositionDescription = new Link((Composite)fieldPositionGroup, 0);
            fieldPositionDescription.setLayoutData((Object)fd);
            fieldPositionDescription.setText(WorkbenchPlugin.descriptions.getString("WB460B"));
            fd = uih.genFormData(new FormAttachment((Control)fieldPositionDescription, 8), null, new FormAttachment(0, 5), null);
            this.startAfterReq = uih.genRequiredSymbol((Composite)fieldPositionGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            fd = uih.genFormData(new FormAttachment((Control)fieldPositionDescription, 5), null, new FormAttachment((Control)this.startAfterReq, 5), null);
            this.buttonStartAfter = new Button((Composite)fieldPositionGroup, 16);
            this.buttonStartAfter.setText(START_AFTER_LABEL);
            this.buttonStartAfter.pack();
            this.buttonStartAfter.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldPositionDescription, 3), null, new FormAttachment((Control)this.buttonStartAfter, 5), new FormAttachment(50, -20));
            this.comboStartAfter = new Combo((Composite)fieldPositionGroup, 2056);
            this.comboStartAfter.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldPositionDescription, 8), null, new FormAttachment(50, 5), null);
            this.startPositionReq = uih.genRequiredSymbol((Composite)fieldPositionGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            fd = uih.genFormData(new FormAttachment((Control)fieldPositionDescription, 5), null, new FormAttachment((Control)this.startPositionReq, 5), null);
            this.buttonStartPosition = new Button((Composite)fieldPositionGroup, 16);
            this.buttonStartPosition.setText(START_POSITION_LABEL);
            this.buttonStartPosition.setToolTipText(START_POS_LABEL_HOVER_TEXT);
            this.buttonStartPosition.pack();
            this.buttonStartPosition.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldPositionDescription, 3), null, new FormAttachment((Control)this.buttonStartPosition, 5), new FormAttachment(100, -20));
            this.textStartPosition = new Text((Composite)fieldPositionGroup, 2048);
            this.textStartPosition.setToolTipText(START_POS_TEXT_HOVER_TEXT);
            this.textStartPosition.setLayoutData((Object)fd);
            FormData fd1 = uih.genFormData(new FormAttachment((Control)fieldPositionGroup, 10), null, new FormAttachment((Control)this.containerReq, 5), null);
            this.labelRedefines = new Label(composite, 0);
            this.labelRedefines.setText(REDEFINES_LABEL);
            this.labelRedefines.setToolTipText(WorkbenchPlugin.descriptions.getString("WB63A"));
            this.labelRedefines.pack();
            this.labelRedefines.setLayoutData((Object)fd1);
            FormData fd2 = uih.genFormData(new FormAttachment((Control)fieldPositionGroup, 8), null, new FormAttachment((Control)this.labelRedefines, 5), new FormAttachment(50, -20));
            this.comboRedefinesField = new Combo(composite, 2056);
            this.comboRedefinesField.setLayoutData((Object)fd2);
            fd = uih.genFormData(new FormAttachment((Control)this.comboRedefinesField, 10), null, new FormAttachment((Control)this.containerReq, 5), null);
            this.labelRemarks = new Label(composite, 0);
            this.labelRemarks.setText(REMARKS_LABEL);
            this.labelRemarks.setToolTipText(REMARKS_LABEL_HOVER_TEXT);
            this.labelRemarks.pack();
            this.labelRemarks.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.comboRedefinesField, 8), new FormAttachment(80), new FormAttachment((Control)this.labelRemarks, 5), new FormAttachment(100, -24));
            this.textRemarks = new Text(composite, 2114);
            this.textRemarks.setToolTipText(REMARKS_TEXT_HOVER_TEXT);
            this.textRemarks.setTextLimit(256);
            this.textRemarks.setLayoutData((Object)fd);
            this.alignControls();
            this.initWidgetValues();
            this.addMessageControls();
            if (this.efController.getActionType().equals("EDIT")) {
                this.validatePage(false, false);
            } else if (this.efController.getActionType().equals("ADD")) {
                this.validatePage(true, false);
            }
            this.handleEnablement();
            this.addListeners();
            int[] leftLabelSizes = new int[]{Utility.getTextWidth(parent, 0, CONTAINER_LABEL), Utility.getTextWidth(parent, 0, PARENT_LABEL), Utility.getTextWidth(parent, 0, START_AFTER_LABEL), Utility.getTextWidth(parent, 0, REDEFINES_LABEL), Utility.getTextWidth(parent, 0, REMARKS_LABEL)};
            int leftLabelSize = Utility.getMaxSize(leftLabelSizes) + 5;
            int[] rightLabelSizes = new int[]{Utility.getTextWidth(parent, 0, CASE_LABEL), Utility.getTextWidth(parent, 0, START_POSITION_LABEL)};
            int rightLabelSize = Utility.getMaxSize(rightLabelSizes) + 5;
            int comboWidth = Utility.getTextWidth(composite, 0, ManageFieldWizardPage1.COMMON_FIELDS);
            int minimumSize = leftLabelSize + rightLabelSize + comboWidth * 4 + 20;
            this.getContainer().getShell().setMinimumSize(minimumSize, 655);
            this.setControl((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.ies1_wb_managefield1");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void addMessageControls() {
        this.msgControl.addControl((Control)this.comboStartAfter);
        this.msgControl.setValidationMessage((Control)this.comboStartAfter, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.comboStartAfter);
        this.msgControl.addControl((Control)this.textStartPosition);
        this.msgControl.setValidationMessage((Control)this.textStartPosition, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.textStartPosition);
        this.msgControl.addControl((Control)this.comboRedefinesField);
        this.msgControl.addControl((Control)this.textRemarks);
    }

    private void alignControls() {
        this.alignLeftControls();
        this.alignRightControls();
    }

    private void alignLeftControls() {
        int leftOffset = this.getMaxLeftLabelSize() + 5;
        this.setFormDataLayout((Control)this.comboContainer, 0, leftOffset);
        this.setFormDataLayout((Control)this.comboParentField, 0, leftOffset);
        this.setFormDataLayout((Control)this.comboStartAfter, 0, leftOffset);
        this.setFormDataLayout((Control)this.comboRedefinesField, 0, leftOffset + 10);
        this.setFormDataLayout((Control)this.textRemarks, 0, leftOffset + 10);
    }

    private void alignRightControls() {
        int rightOffset = this.getMaxRightLabelSize() - 5;
        this.setFormDataLayout((Control)this.comboCaseName, 50, rightOffset);
        this.setFormDataLayout((Control)this.textStartPosition, 50, rightOffset);
    }

    private void setFormDataLayout(Control control, int startPos, int offset) {
        FormData fd = (FormData)control.getLayoutData();
        fd.left = new FormAttachment(startPos, offset + 25 + this.labelCaseReq.getSize().x);
        control.setLayoutData((Object)fd);
    }

    private int getMaxSize(int[] labelSize) {
        Arrays.sort(labelSize);
        return labelSize[labelSize.length - 1];
    }

    private int getMaxLeftLabelSize() {
        int[] allLeftLabelSize = new int[]{this.labelContainer.getSize().x, this.labelParentField.getSize().x, this.buttonStartAfter.getSize().x, this.labelRedefines.getSize().x, this.labelRemarks.getSize().x};
        return this.getMaxSize(allLeftLabelSize);
    }

    private int getMaxRightLabelSize() {
        int[] allRightLabelSize = new int[]{this.labelCase.getSize().x, this.buttonStartPosition.getSize().x};
        return this.getMaxSize(allRightLabelSize);
    }

    private void initWidgetValues() throws ModelException, InvalidInputException {
        this.initContainerCombo();
        this.initCaseCombo(false);
        this.initParentFieldCombo();
        this.initFieldPosition();
        this.initRedefinesCombo();
        this.initRemarks();
    }

    private void initContainerCombo() {
        this.comboContainer.removeAll();
        String segmentName = this.efController.getSegmentName();
        this.comboContainer.add(segmentName);
        Iterator mapIterator = this.efController.getMappingList();
        while (mapIterator.hasNext()) {
            MappingModel mappingModel = (MappingModel)mapIterator.next();
            if (!mappingModel.getMappingCases().hasNext()) continue;
            this.comboContainer.add(mappingModel.getName());
        }
        String mapName = this.efController.getMapName();
        if (!mapName.equals(ManageFieldsController.COMMON_FIELDS)) {
            this.comboContainer.setText(mapName);
        } else {
            this.comboContainer.setText(segmentName);
        }
    }

    private void initCaseCombo(boolean isNewMap) throws ModelException, InvalidInputException {
        this.comboCaseName.removeAll();
        String mapName = this.efController.getMapName();
        if (!mapName.equals(ManageFieldsController.COMMON_FIELDS) && this.comboContainer.getItemCount() > 1 && mapName != null) {
            MappingModel selectedMap = null;
            Iterator mappingModelIter = this.efController.getMappingList();
            while (mappingModelIter.hasNext()) {
                selectedMap = (MappingModel)mappingModelIter.next();
                if (selectedMap.getName().equals(mapName)) break;
            }
            Iterator caseIterator = selectedMap.getMappingCases();
            while (caseIterator.hasNext()) {
                MappingCaseModel caseModel = (MappingCaseModel)caseIterator.next();
                this.comboCaseName.add(caseModel.getName());
            }
            if (!isNewMap) {
                this.comboCaseName.setText(this.efController.getCaseName());
            } else {
                this.comboCaseName.setText(this.comboCaseName.getItem(0));
                this.efController.setCaseName(this.comboCaseName.getItem(0));
            }
        }
    }

    private void setCaseWidgets(boolean isEnable) {
        this.labelCaseReq.setVisible(isEnable);
        this.labelCase.setVisible(isEnable);
        this.comboCaseName.setVisible(isEnable);
    }

    private void initParentFieldCombo() throws ModelException {
        this.comboParentField.removeAll();
        String parentField = this.efController.getParentField();
        List fieldList = this.efController.getFieldList();
        if (fieldList != null) {
            this.comboParentField.add("");
            for (FieldModel fieldModel : fieldList) {
                DBDConstants appDataType = fieldModel.getAppDatatype();
                if (appDataType == null || !appDataType.equals((Object)DBDConstants.ARRAY) && !appDataType.equals((Object)DBDConstants.STRUCT) || fieldModel.getName().equals(this.efController.getName()) || !this.efController.isValidParent(fieldModel)) continue;
                this.comboParentField.add(fieldModel.getName());
            }
            this.comboParentField.setText(parentField);
        }
    }

    private void initStartAfterCombo() throws ModelException {
        boolean isSubField;
        this.comboStartAfter.removeAll();
        String fieldName = this.efController.getName();
        String parentFieldName = this.efController.getParentField();
        boolean isNewField = this.efController.getActionType().equals("ADD");
        boolean bl = isSubField = parentFieldName != null && !parentFieldName.isEmpty();
        if (isSubField) {
            this.comboStartAfter.add("NONE");
        } else {
            this.comboStartAfter.add("");
        }
        List fieldList = this.efController.getFieldList();
        if (fieldList != null) {
            for (FieldModel currentFieldModel : fieldList) {
                FieldModel currentParentFieldModel = currentFieldModel.getParentField();
                String currentParentField = "";
                if (currentParentFieldModel != null) {
                    currentParentField = currentParentFieldModel.getName();
                }
                if (!isNewField && currentFieldModel.getName().equals(fieldName) || currentParentField != parentFieldName) continue;
                this.comboStartAfter.add(currentFieldModel.getName());
            }
        }
    }

    private void initFieldPosition() throws ModelException {
        this.initStartAfterCombo();
        if (this.efController.isStartAfterSelected()) {
            this.setStartButtonSelection(true);
            String startAfterStr = this.efController.getStartAfter();
            if (startAfterStr != null && !startAfterStr.isEmpty()) {
                this.comboStartAfter.setText(startAfterStr);
            } else {
                this.comboStartAfter.setText("NONE");
            }
            this.textStartPosition.setText("");
        } else {
            this.setStartButtonSelection(false);
            this.textStartPosition.setText(this.efController.getStartPos());
        }
    }

    private void initRemarks() throws ModelException {
        String remarksStr = this.efController.getRemarks();
        if (remarksStr != null) {
            this.textRemarks.setText(remarksStr);
        }
    }

    private void initRedefinesCombo() throws ModelException {
        this.comboRedefinesField.removeAll();
        if (!this.efController.getActionType().equals("MOVE")) {
            String followsField = this.comboStartAfter.getText();
            String redefinesName = this.efController.getRedefines();
            if (followsField != null && !followsField.isEmpty() && !followsField.equals("NONE")) {
                this.comboRedefinesField.add("");
                this.comboRedefinesField.add(followsField);
                if (redefinesName != null) {
                    this.comboRedefinesField.setText(redefinesName);
                }
            }
        }
    }

    private void validateInput() throws InvalidInputException, ModelException {
        String mapName = this.comboContainer.getText();
        if (mapName.equals(this.efController.getSegmentName())) {
            mapName = ManageFieldsController.COMMON_FIELDS;
        } else {
            this.efController.setCaseName(this.comboCaseName.getText());
        }
        this.efController.setMapName(mapName);
        this.efController.setParentField(this.comboParentField.getText());
        if (this.buttonStartAfter.getSelection()) {
            this.efController.setStartAfterSelected(true);
        } else {
            this.efController.setStartAfterSelected(false);
        }
        if (!this.efController.isStartAfterSelected()) {
            this.efController.setStartPos(this.textStartPosition.getText());
        } else {
            this.efController.setStartAfter(this.comboStartAfter.getText());
        }
        this.efController.setRedefines(this.comboRedefinesField.getText());
        this.efController.setRemarks(this.textRemarks.getText());
    }

    public void modifyText(ModifyEvent e) {
        try {
            try {
                this.validateAttributeChangeable(e.widget);
            }
            catch (InvalidInputException iie) {
                if (e.widget == this.comboRedefinesField) {
                    this.comboRedefinesField.removeModifyListener((ModifyListener)this);
                    this.comboRedefinesField.removeFocusListener((FocusListener)this);
                    this.comboRedefinesField.setText(this.efController.getRedefines());
                    this.comboRedefinesField.addModifyListener((ModifyListener)this);
                    this.comboRedefinesField.addFocusListener((FocusListener)this);
                }
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                return;
            }
            this.validatePage(false, true);
            this.handleEnablement();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void validateAttributeChangeable(Widget widget) throws InvalidInputException, ModelException {
        InvalidInputException iie = null;
        if (widget == this.comboContainer) {
            iie = this.efController.validateAttrChangable("CONTAINER_NAME", null);
        } else if (widget == this.comboCaseName) {
            iie = this.efController.validateAttrChangable("CASE_NAME", null);
        } else if (widget == this.comboParentField) {
            iie = this.efController.validateAttrChangable("PARENT", null);
        } else if (widget == this.buttonStartAfter) {
            if (this.buttonStartAfter.getSelection()) {
                iie = this.efController.validateAttrChangable("FOLLOWSBUTTON", null);
            }
        } else if (widget == this.buttonStartPosition) {
            if (this.buttonStartPosition.getSelection()) {
                iie = this.efController.validateAttrChangable("STARTBUTTON", null);
            }
        } else if (widget == this.comboStartAfter) {
            iie = this.efController.validateAttrChangable("FOLLOWS", null);
        } else if (widget == this.textStartPosition) {
            iie = this.efController.validateAttrChangable("FOLLOWS", null);
        } else if (widget == this.comboRedefinesField) {
            iie = this.efController.validateAttrChangable("REDEFINES", null);
        }
        if (iie != null) {
            throw iie;
        }
    }

    public void validatePage(boolean suppressErrorMessage, boolean invokedDueToUserEdit) throws ModelException {
        try {
            this.clearValidationMessages();
            if (invokedDueToUserEdit) {
                this.validateInput();
            }
            String[] attrsToCheck = new String[]{"START"};
            this.efController.validateRequiredFields(attrsToCheck);
            this.efController.semanticCheck();
            this.setPageComplete(true);
        }
        catch (InvalidInputException iie) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", (Throwable)iie);
            if (!suppressErrorMessage) {
                String message = iie.getMessage();
                this.setErrorMessage(message);
                this.setValidationMessages(iie);
            }
            if (this.efController.getActionType().equals("MOVE")) {
                this.setPageComplete(false);
            }
            String[] errorAttrs = iie.getAttrNames();
            if (Utility.allAttrsOnPage(errorAttrs, pageAttrs)) {
                this.setPageComplete(false);
            }
            this.setPageComplete(true);
        }
    }

    private void clearValidationMessages() {
        this.setErrorMessage(null);
        this.msgControl.clearValidationMessage((Control)this.textStartPosition);
        this.msgControl.clearValidationMessage((Control)this.comboStartAfter);
        this.msgControl.clearValidationMessage((Control)this.comboRedefinesField);
        this.msgControl.clearValidationMessage((Control)this.textRemarks);
    }

    private void setValidationMessages(InvalidInputException iie) throws ModelException {
        String[] attrs = iie.getAttrNames();
        String message = iie.getMessage();
        int i = 0;
        while (i < attrs.length) {
            String attrName = attrs[i];
            if (attrName.equals("CONTAINER_NAME")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                }
            } else if (attrName.equals("CASE_NAME")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                }
            } else if (attrName.equals("PARENT")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                }
            } else if (attrName.equals("STARTBUTTON")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                }
            } else if (attrName.equals("FOLLOWSBUTTON")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                }
            } else if (attrName.equals("FOLLOWS")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                }
            } else if (attrName.equals("START")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                }
                if (this.buttonStartPosition.getSelection()) {
                    this.msgControl.setValidationMessage((Control)this.textStartPosition, message, 3);
                } else {
                    this.msgControl.setValidationMessage((Control)this.comboStartAfter, message, 3);
                }
            } else if (attrName.equals("REDEFINES")) {
                this.msgControl.setValidationMessage((Control)this.comboRedefinesField, message, 3);
            } else if (attrName.equals("REMARKS")) {
                this.msgControl.setValidationMessage((Control)this.textRemarks, message, 3);
            }
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            if (visible && this.canFlipToNextPage() && !this.efController.getActionType().equals("MOVE")) {
                this.validatePage(false, this.efController.hasBeenEdited());
                this.handleEnablement();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            logger.error(e);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            }
            this.setPageComplete(this.isPageComplete());
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            try {
                this.validateAttributeChangeable(e.widget);
            }
            catch (InvalidInputException iie) {
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)iie.getMessage());
                return;
            }
            if (e.widget == this.buttonStartAfter && this.buttonStartAfter.getSelection()) {
                this.validatePage(false, true);
                this.handleEnablement();
                this.comboStartAfter.setFocus();
            } else if (e.widget == this.buttonStartPosition && this.buttonStartPosition.getSelection()) {
                this.validatePage(false, true);
                this.handleEnablement();
                this.textStartPosition.setFocus();
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void setStartButtonSelection(boolean isStartAfterSelected) {
        this.buttonStartAfter.setSelection(isStartAfterSelected);
        this.buttonStartPosition.setSelection(!isStartAfterSelected);
    }

    private void handleEnablement() {
        if (this.efController.isReadOnly()) {
            this.comboContainer.setEnabled(false);
            this.comboCaseName.setEnabled(false);
            this.comboParentField.setEnabled(false);
            this.buttonStartAfter.setEnabled(false);
            this.comboStartAfter.setEnabled(false);
            this.buttonStartPosition.setEnabled(false);
            this.textStartPosition.setEnabled(false);
            this.buttonStartAfter.setEnabled(false);
            this.comboRedefinesField.setEnabled(false);
            this.textRemarks.setEnabled(false);
        } else {
            String mapName = this.efController.getMapName();
            if (mapName.equals(ManageFieldsController.COMMON_FIELDS)) {
                this.setCaseWidgets(false);
            } else {
                this.setCaseWidgets(true);
            }
            boolean moveAction = this.efController.getActionType().equals("MOVE");
            if (moveAction) {
                this.comboRedefinesField.setEnabled(false);
                this.textRemarks.setEnabled(false);
            } else {
                this.comboRedefinesField.setEnabled(true);
                this.textRemarks.setEnabled(true);
            }
            DBDConstants adt = this.efController.getAppDatatype();
            String redefinesStr = this.efController.getRedefines();
            if (adt != null && adt.equals((Object)DBDConstants.XML)) {
                this.comboContainer.setEnabled(true);
                this.comboCaseName.setEnabled(false);
                this.comboParentField.setEnabled(false);
                this.buttonStartAfter.setEnabled(false);
                this.comboStartAfter.setEnabled(false);
                this.buttonStartPosition.setEnabled(true);
                this.textStartPosition.setEnabled(true);
                this.buttonStartAfter.setEnabled(false);
                this.comboRedefinesField.setEnabled(false);
            } else {
                this.comboContainer.setEnabled(true);
                this.comboCaseName.setEnabled(true);
                this.comboParentField.setEnabled(true);
                this.buttonStartAfter.setEnabled(true);
                this.comboStartAfter.setEnabled(true);
                this.buttonStartPosition.setEnabled(true);
                this.textStartPosition.setEnabled(true);
                this.buttonStartAfter.setEnabled(true);
                this.comboRedefinesField.setEnabled(false);
            }
            if (redefinesStr != null && !redefinesStr.isEmpty()) {
                this.comboContainer.setEnabled(false);
                this.comboCaseName.setEnabled(false);
                this.comboParentField.setEnabled(false);
                this.buttonStartAfter.setEnabled(false);
                this.comboStartAfter.setEnabled(false);
                this.buttonStartPosition.setEnabled(false);
                this.textStartPosition.setEnabled(false);
            } else {
                this.comboContainer.setEnabled(true);
                this.comboCaseName.setEnabled(true);
                this.comboParentField.setEnabled(true);
                this.buttonStartAfter.setEnabled(true);
                this.buttonStartPosition.setEnabled(true);
            }
            if (this.efController.isStartAfterSelected()) {
                this.textStartPosition.setEnabled(false);
                this.comboStartAfter.setEnabled(true);
            } else {
                this.textStartPosition.setEnabled(true);
                this.comboStartAfter.setEnabled(false);
            }
            if (this.buttonStartAfter.getSelection()) {
                this.startAfterReq.setVisible(true);
                this.startPositionReq.setVisible(false);
            } else {
                this.startPositionReq.setVisible(true);
                this.startAfterReq.setVisible(false);
            }
            String redefineStr = this.efController.getRedefines();
            if (redefineStr != null && !redefinesStr.isEmpty()) {
                this.startAfterReq.setVisible(false);
                this.startPositionReq.setVisible(false);
                this.containerReq.setVisible(false);
            } else {
                this.containerReq.setVisible(true);
            }
            String imsName = this.efController.getImsName();
            if (imsName != null && (imsName.startsWith("/SX") || imsName.startsWith("/CK"))) {
                this.containerReq.setVisible(false);
                this.comboContainer.setEnabled(false);
                this.comboParentField.setEnabled(false);
                this.buttonStartAfter.setEnabled(false);
                this.comboStartAfter.setEnabled(false);
                this.comboRedefinesField.setEnabled(false);
            } else {
                this.containerReq.setVisible(true);
                this.comboContainer.setEnabled(true);
                this.comboParentField.setEnabled(true);
                this.buttonStartAfter.setEnabled(true);
                this.comboStartAfter.setEnabled(true);
                this.comboRedefinesField.setEnabled(!moveAction);
            }
            if (this.buttonStartPosition.getSelection()) {
                this.comboStartAfter.setEnabled(false);
            }
        }
    }

    protected String getStartPosition() {
        return this.textStartPosition.getText();
    }

    private void addListeners() {
        this.buttonStartAfter.addSelectionListener((SelectionListener)this);
        this.buttonStartPosition.addSelectionListener((SelectionListener)this);
        this.comboContainer.addModifyListener((ModifyListener)this);
        this.comboCaseName.addModifyListener((ModifyListener)this);
        this.comboParentField.addModifyListener((ModifyListener)this);
        this.comboStartAfter.addModifyListener((ModifyListener)this);
        this.textStartPosition.addModifyListener((ModifyListener)this);
        this.textStartPosition.addFocusListener((FocusListener)this.textFocusHighLight);
        this.comboRedefinesField.addModifyListener((ModifyListener)this);
        this.comboRedefinesField.addFocusListener((FocusListener)this);
        this.textRemarks.addModifyListener((ModifyListener)this);
        this.textRemarks.addVerifyListener((VerifyListener)this);
    }

    private void removeListeners() {
        this.buttonStartAfter.removeSelectionListener((SelectionListener)this);
        this.buttonStartPosition.removeSelectionListener((SelectionListener)this);
        this.comboContainer.removeModifyListener((ModifyListener)this);
        this.comboCaseName.removeModifyListener((ModifyListener)this);
        this.comboParentField.removeModifyListener((ModifyListener)this);
        this.comboStartAfter.removeModifyListener((ModifyListener)this);
        this.textStartPosition.removeModifyListener((ModifyListener)this);
        this.textStartPosition.removeFocusListener((FocusListener)this.textFocusHighLight);
        this.comboRedefinesField.removeModifyListener((ModifyListener)this);
        this.comboRedefinesField.removeFocusListener((FocusListener)this);
        this.textRemarks.removeModifyListener((ModifyListener)this);
        this.textRemarks.removeVerifyListener((VerifyListener)this);
    }

    protected String getRemarks() {
        return this.textRemarks.getText();
    }

    protected String getStartAfterFieldName() {
        return this.comboStartAfter.getText();
    }

    protected EditFieldWizard getWiz() {
        return (EditFieldWizard)this.getWizard();
    }

    public void focusGained(FocusEvent arg0) {
        if (this.buttonStartPosition.getSelection()) {
            this.textRemarks.setFocus();
            Object[] inserts = new Object[]{WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_REDEFINES"), WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER"), WorkbenchPlugin.labels.getString("EDIT_FIELD_WIZARD_POSITION_START_POSITION")};
            String infoMsg = WorkbenchPlugin.errors.getString("EDIT_FIELD_WIZ_12", inserts);
            MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)WorkbenchPlugin.errors.getString("EISRC25"), (String)infoMsg);
        }
    }

    public void focusLost(FocusEvent arg0) {
    }

    public void handleModelChange(ModelChangeEvent e) {
        try {
            this.removeListeners();
            String[] stringArray = e.getAttrs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (attr.equals("CASE_NAME")) {
                    this.initCaseCombo(true);
                } else if (attr.equals("PARENT")) {
                    this.initParentFieldCombo();
                } else if (attr.equals("START")) {
                    this.initFieldPosition();
                } else if (attr.equals("REDEFINES")) {
                    this.initRedefinesCombo();
                } else if (attr.equals("CONTAINER_NAME")) {
                    this.initContainerCombo();
                }
                ++n2;
            }
            this.addListeners();
        }
        catch (Throwable exc) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", exc);
            logger.error(exc);
        }
    }
}

