/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.managefield;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.field.EditFieldController;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.wizard.managefield.EditFieldWizardPage0;
import com.ibm.im.ims.workbench.wizard.managefield.EditFieldWizardPage1;
import com.ibm.im.ims.workbench.wizard.managefield.EditFieldWizardPage2;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EditFieldWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public ArrayList<String> propertyList;
    private EditFieldWizardPage0 editFieldWizardPage0;
    private EditFieldWizardPage1 editFieldWizardPage1;
    private EditFieldWizardPage2 editFieldWizardPage2;
    private EditFieldController efController;

    public EditFieldWizard(EditFieldController efController) {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB039A"));
        if (efController.getActionType().equals("ADD")) {
            this.setWindowTitle(WorkbenchPlugin.labels.getString("WB258"));
        } else if (efController.getActionType().equals("MOVE")) {
            this.setWindowTitle(WorkbenchPlugin.labels.getString("WB039B"));
        }
        this.efController = efController;
        this.setHelpAvailable(false);
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        try {
            this.efController.performFinish();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }

    public boolean canFinish() {
        boolean hasBeenEdited = this.efController.hasBeenEdited();
        boolean page0Complete = this.editFieldWizardPage0.isPageComplete();
        boolean page1Complete = this.editFieldWizardPage1 == null || this.editFieldWizardPage1.isPageComplete();
        boolean page2Complete = this.editFieldWizardPage2 == null || this.editFieldWizardPage2.isPageComplete();
        boolean semanticErrorsExist = false;
        try {
            if (this.editFieldWizardPage1 != null && this.editFieldWizardPage2 != null) {
                this.efController.semanticCheck();
            }
        }
        catch (InvalidInputException invalidInputException) {
            semanticErrorsExist = true;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
        return page0Complete && page1Complete && page2Complete && hasBeenEdited && !semanticErrorsExist;
    }

    public void addPages() {
        try {
            this.editFieldWizardPage0 = new EditFieldWizardPage0(this.efController);
            this.addPage((IWizardPage)this.editFieldWizardPage0);
            if (!this.efController.getActionType().equals("MOVE")) {
                this.editFieldWizardPage1 = new EditFieldWizardPage1(this.efController);
                this.editFieldWizardPage2 = new EditFieldWizardPage2(this.efController);
                this.addPage((IWizardPage)this.editFieldWizardPage1);
                this.addPage((IWizardPage)this.editFieldWizardPage2);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public String getIMSName() {
        return this.editFieldWizardPage1.getIMSName();
    }

    protected String getStartAfterFieldName() {
        return this.editFieldWizardPage0.getStartAfterFieldName();
    }

    protected String getStartPosition() {
        return this.editFieldWizardPage0.getStartPosition();
    }
}

