/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importsrc;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.builder.WarningsWithoutCheckboxNoPrompt;
import com.ibm.im.ims.workbench.controller.importer.source.CatalogProvider;
import com.ibm.im.ims.workbench.controller.importer.source.HostProvider;
import com.ibm.im.ims.workbench.controller.importer.source.IMSResourceToImport;
import com.ibm.im.ims.workbench.controller.importer.source.ImportProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceController;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceType;
import com.ibm.im.ims.workbench.controller.importer.source.LocalProvider;
import com.ibm.im.ims.workbench.dialogs.ConfirmationDialog;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.model.utilities.ImporterException;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.utilities.Warnings;
import com.ibm.im.ims.workbench.wizard.importsrc.CatalogImportWizard;
import com.ibm.im.ims.workbench.wizard.importsrc.ImportSourceWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.wizard.importdataset.ImportDataSetWizard;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ImportSourceWizardPage3
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAGE_NAME = "ImportSourceWizardPage3";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final int ADD_TYPE_PSB = 0;
    private static final int ADD_TYPE_DBD = 1;
    private static final String COLON_LABEL = WorkbenchPlugin.colon.getString("COLON");
    private Composite composite;
    private UIHelper uih;
    private TableViewer psbTabViewer;
    private TableViewer dbdTabViewer;
    private TableViewer needDBDViewer;
    private Table psbTab;
    private Table dbdTab;
    private Table needDBDTab;
    private TableColumn psbCol1;
    private TableColumn psbCol2;
    private TableColumn dbdCol1;
    private TableColumn dbdCol2;
    private TableColumn dbdCol3;
    private TableColumn needDBDCol1;
    private TableColumn needDBDCol2;
    private TableItem[] itemSelected;
    private TableCursor cursor = null;
    private Group psbGrp;
    private Group dbdGrp;
    private Label importPSBlbl;
    private Label importDBDlbl;
    private Label warningImgLbl;
    private Label needImportlbl;
    private Label needImportlbl2;
    private Button addPSBButton;
    private Button removePSBButton;
    private Button addDBDButton;
    private Button removeDBDButton;
    private ImageDescriptor warningImgDesc;
    private Image warningImg;
    private ImportSourceController impSrcCtrl;
    private ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    private NullProgressMonitor nullMonitor = new NullProgressMonitor();
    public static final int MAX_DEPTH = 1;
    private boolean needTableExists = false;
    private boolean isImportDbd;
    private Object[] confirmationInserts;
    private int mergeReturnCode = 0;
    private Vector<ImporterException> importerExceptions = new Vector();
    private boolean needTableMessageNotShownYet = true;
    private static final String PREV_ZOS_SOURCE = "ImportSourceWizardPage3.PREV_ZOS_SOURCE";

    public ImportSourceWizardPage3(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.uih = new UIHelper();
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("vlImportWizard")));
    }

    public ImportSourceWizardPage3(ImportSourceController impSrcCtrl) {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.impSrcCtrl = impSrcCtrl;
        this.uih = new UIHelper();
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("vlImportWizard")));
    }

    public void createControl(Composite parent) {
        try {
            this.composite = new Composite(parent, 0);
            this.uih.setDisplay(parent.getDisplay());
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            FormData psbFD = new FormData();
            psbFD.left = new FormAttachment(0, 0);
            psbFD.right = new FormAttachment(100, 0);
            this.composite.setLayoutData((Object)psbFD);
            this.psbGrp = new Group(this.composite, 0);
            this.psbGrp.setText("PSB " + WorkbenchPlugin.labels.getString("WB007"));
            this.psbGrp.setLayout((Layout)layout);
            this.psbGrp.setLayoutData((Object)psbFD);
            psbFD = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.importPSBlbl = this.uih.genLabel((Composite)this.psbGrp, 16384, WorkbenchPlugin.labels.getString("WB016A"), this.uih.black, psbFD);
            psbFD = this.uih.genFormData(new FormAttachment((Control)this.importPSBlbl, 10), null, new FormAttachment(0, 0), new FormAttachment(75, 0));
            psbFD.height = 80;
            this.psbTabViewer = new TableViewer((Composite)this.psbGrp, 68354);
            this.psbTab = this.psbTabViewer.getTable();
            this.createColumns(this.psbTab);
            this.psbTab.setLinesVisible(false);
            this.psbTab.setHeaderVisible(true);
            TableLayout psbTL = new TableLayout();
            this.psbTab.setLayout((Layout)psbTL);
            this.psbTab.setLayoutData((Object)psbFD);
            this.psbTab.setToolTipText(WorkbenchPlugin.descriptions.getString("WB008"));
            this.psbTab.setSortColumn(this.psbCol1);
            this.initListViewer(this.psbTabViewer, this.psbTab, this.psbGrp);
            psbFD = this.uih.genFormData(new FormAttachment((Control)this.importPSBlbl, 10), null, new FormAttachment((Control)this.psbTab, 10), new FormAttachment(100, -10));
            this.addPSBButton = new Button((Composite)this.psbGrp, 8);
            this.computeButtonSize(this.addPSBButton);
            this.addPSBButton.setText(WorkbenchPlugin.labels.getString("ADD_PSB") + "...");
            this.addPSBButton.setLayoutData((Object)psbFD);
            psbFD = this.uih.genFormData(new FormAttachment((Control)this.addPSBButton, 10), null, new FormAttachment((Control)this.psbTab, 10), new FormAttachment(100, -10));
            this.removePSBButton = new Button((Composite)this.psbGrp, 8);
            this.removePSBButton.setText(WorkbenchPlugin.labels.getString("DELETE_PSB"));
            this.computeButtonSize(this.removePSBButton);
            this.removePSBButton.setLayoutData((Object)psbFD);
            this.removePSBButton.setEnabled(false);
            FormLayout dbdFL = new FormLayout();
            dbdFL.marginHeight = 5;
            dbdFL.marginWidth = 5;
            FormData dbdFD = this.uih.genFormData(new FormAttachment((Control)this.psbGrp, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            this.dbdGrp = new Group(this.composite, 0);
            this.dbdGrp.setText("DBD " + WorkbenchPlugin.labels.getString("WB011"));
            this.dbdGrp.setLayout((Layout)dbdFL);
            this.dbdGrp.setLayoutData((Object)dbdFD);
            dbdFD = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.importDBDlbl = this.uih.genLabel((Composite)this.dbdGrp, 16384, WorkbenchPlugin.labels.getString("WB016B"), this.uih.black, dbdFD);
            dbdFD = this.uih.genFormData(new FormAttachment((Control)this.importDBDlbl, 10), null, new FormAttachment(0, 0), new FormAttachment(75, 0));
            dbdFD.height = 80;
            this.dbdTabViewer = new TableViewer((Composite)this.dbdGrp, 68354);
            this.dbdTab = this.dbdTabViewer.getTable();
            this.createColumns(this.dbdTab);
            this.dbdTab.setLinesVisible(false);
            this.dbdTab.setHeaderVisible(true);
            TableLayout dbdTL = new TableLayout();
            this.dbdTab.setLayout((Layout)dbdTL);
            this.dbdTab.setLayoutData((Object)dbdFD);
            this.dbdTab.setToolTipText(WorkbenchPlugin.descriptions.getString("WB009"));
            this.dbdTab.setSortColumn(this.dbdCol1);
            this.initListViewer(this.dbdTabViewer, this.dbdTab, this.dbdGrp);
            dbdFD = this.uih.genFormData(new FormAttachment((Control)this.importDBDlbl, 10), null, new FormAttachment((Control)this.dbdTab, 10), new FormAttachment(100, -10));
            this.addDBDButton = new Button((Composite)this.dbdGrp, 8);
            this.addDBDButton.setText(WorkbenchPlugin.labels.getString("ADD_DBD") + "...");
            this.addDBDButton.setLayoutData((Object)dbdFD);
            dbdFD = this.uih.genFormData(new FormAttachment((Control)this.addDBDButton, 10), null, new FormAttachment((Control)this.dbdTab, 10), new FormAttachment(100, -10));
            this.removeDBDButton = new Button((Composite)this.dbdGrp, 8);
            this.removeDBDButton.setText(WorkbenchPlugin.labels.getString("DELETE_DBD"));
            this.removeDBDButton.setLayoutData((Object)dbdFD);
            this.removeDBDButton.setEnabled(false);
            this.warningImg = this.sharedImages.getImage("IMG_DEC_FIELD_WARNING");
            dbdFD = this.uih.genFormData(new FormAttachment((Control)this.dbdTab, 10), null, new FormAttachment(0, 0), null);
            this.warningImgLbl = this.uih.genLabel((Composite)this.dbdGrp, 16384, "     ", this.uih.black, dbdFD);
            this.warningImgLbl.setVisible(true);
            dbdFD = this.uih.genFormData(new FormAttachment((Control)this.dbdTab, 10), null, new FormAttachment(5, 0), null);
            this.needImportlbl = this.uih.genLabel((Composite)this.dbdGrp, 16384, WorkbenchPlugin.labels.getString("WB602"), this.uih.black, dbdFD);
            this.needImportlbl.setVisible(false);
            dbdFD = this.uih.genFormData(new FormAttachment((Control)this.needImportlbl, 10), null, new FormAttachment(0, 0), null);
            dbdFD.width = 350;
            this.needImportlbl2 = this.uih.genLabel((Composite)this.dbdGrp, 16448, WorkbenchPlugin.descriptions.getString("WB087"), this.uih.black, dbdFD);
            this.needImportlbl2.setVisible(false);
            dbdFD = this.uih.genFormData(new FormAttachment((Control)this.needImportlbl2, 10), null, new FormAttachment(0, 0), new FormAttachment(75, 0));
            dbdFD.height = 80;
            this.needDBDViewer = new TableViewer((Composite)this.dbdGrp, 67586);
            this.needDBDTab = this.needDBDViewer.getTable();
            this.createColumns(this.needDBDTab);
            this.needDBDTab.setLinesVisible(false);
            this.needDBDTab.setHeaderVisible(true);
            TableLayout needDBDTL = new TableLayout();
            this.needDBDTab.setLayout((Layout)needDBDTL);
            this.needDBDTab.setLayoutData((Object)dbdFD);
            this.needDBDTab.setToolTipText(WorkbenchPlugin.descriptions.getString("WB010"));
            this.needDBDTab.setSortColumn(this.needDBDCol1);
            this.needDBDTab.setVisible(false);
            this.initialize();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ImportResourceWizard");
            this.setControl((Control)this.composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void initListViewer(TableViewer viewer, final Table t, final Group grp) {
        ListViewerProvider listProvider = new ListViewerProvider();
        viewer.setContentProvider((IContentProvider)listProvider);
        viewer.setLabelProvider((IBaseLabelProvider)listProvider);
        this.setCursor(t);
        t.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ImportSourceWizardPage3.this.itemSelected = null;
                    ImportSourceWizardPage3.this.itemSelected = t.getSelection();
                    t.setSelection(ImportSourceWizardPage3.this.itemSelected);
                    ImportSourceWizardPage3.this.cursor.getRow();
                    ImportSourceWizardPage3.this.updateRemoveButtonState(t);
                    ImportSourceWizardPage3.this.updateSelection(t);
                }
                catch (Throwable ex) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", ex);
                    logger.error(ex);
                }
            }
        });
        grp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                try {
                    Rectangle area = grp.getClientArea();
                    Point size = t.computeSize(-1, -1);
                    ScrollBar vBar = t.getVerticalBar();
                    int width = area.width - t.computeTrim((int)0, (int)0, (int)0, (int)0).width;
                    if (size.y > area.height + t.getHeaderHeight()) {
                        Point vBarSize = vBar.getSize();
                        width -= vBarSize.x;
                    }
                    Point oldSize = t.getSize();
                    if (oldSize.x > area.width) {
                        if (t.equals(ImportSourceWizardPage3.this.psbTab)) {
                            ImportSourceWizardPage3.this.psbCol1.setWidth(width / 4);
                            ImportSourceWizardPage3.this.psbCol2.setWidth(width - ImportSourceWizardPage3.this.psbCol1.getWidth());
                        } else if (t.equals(ImportSourceWizardPage3.this.dbdTab)) {
                            ImportSourceWizardPage3.this.dbdCol1.setWidth(width / 4);
                            ImportSourceWizardPage3.this.dbdCol2.setWidth(width / 3);
                            ImportSourceWizardPage3.this.dbdCol3.setWidth(width - (ImportSourceWizardPage3.this.dbdCol1.getWidth() + ImportSourceWizardPage3.this.dbdCol2.getWidth()));
                        } else if (t.equals(ImportSourceWizardPage3.this.needDBDTab)) {
                            ImportSourceWizardPage3.this.needDBDCol1.setWidth(width / 4);
                            ImportSourceWizardPage3.this.needDBDCol2.setWidth(width - ImportSourceWizardPage3.this.needDBDCol1.getWidth());
                        }
                        t.setSize(area.width, area.height);
                    } else {
                        t.setSize(area.width, area.height);
                        if (t.equals(ImportSourceWizardPage3.this.psbTab)) {
                            ImportSourceWizardPage3.this.psbCol1.setWidth(width / 4);
                            ImportSourceWizardPage3.this.psbCol2.setWidth(width - ImportSourceWizardPage3.this.psbCol1.getWidth());
                        } else if (t.equals(ImportSourceWizardPage3.this.dbdTab)) {
                            ImportSourceWizardPage3.this.dbdCol1.setWidth(width / 4);
                            ImportSourceWizardPage3.this.dbdCol2.setWidth(width / 3);
                            ImportSourceWizardPage3.this.dbdCol3.setWidth(width - (ImportSourceWizardPage3.this.dbdCol1.getWidth() + ImportSourceWizardPage3.this.dbdCol2.getWidth()));
                        } else if (t.equals(ImportSourceWizardPage3.this.needDBDTab)) {
                            ImportSourceWizardPage3.this.needDBDCol1.setWidth(width / 4);
                            ImportSourceWizardPage3.this.needDBDCol2.setWidth(width - ImportSourceWizardPage3.this.needDBDCol1.getWidth());
                        }
                    }
                }
                catch (Throwable ex) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "controlResized(ControlEvent e)", ex);
                    logger.error(ex);
                }
            }
        });
    }

    public void updateRemoveButtonState(Table t) {
        int selectionCount = t.getSelectionCount();
        if (selectionCount > 0) {
            if (t.equals(this.psbTab)) {
                this.removePSBButton.setEnabled(true);
            } else if (t.equals(this.dbdTab)) {
                this.removeDBDButton.setEnabled(true);
            }
        } else if (t.equals(this.psbTab)) {
            this.removePSBButton.setEnabled(false);
        } else if (t.equals(this.dbdTab)) {
            this.removeDBDButton.setEnabled(false);
        }
    }

    private void updateSelection(Table t) {
        if (this.itemSelected.length > 0) {
            int i = 0;
            while (i < this.itemSelected.length) {
                t.setSelection(this.itemSelected);
                ++i;
            }
        }
    }

    private boolean validatePage(int numPsbs, int numDbds) {
        boolean retVal = true;
        if (numPsbs == 0 && numDbds == 0) {
            retVal = false;
        }
        return retVal;
    }

    private void createColumns(Table table) {
        if (table.equals(this.psbTab)) {
            this.psbCol1 = new TableColumn(this.psbTab, 0);
            this.psbCol1.setText("PSB " + WorkbenchPlugin.labels.getString("WB014"));
            this.psbCol1.setResizable(true);
            this.psbCol1.setMoveable(true);
            this.psbCol2 = new TableColumn(this.psbTab, 0);
            this.psbCol2.setText(WorkbenchPlugin.labels.getString("WB016"));
            this.psbCol2.setResizable(true);
            this.psbCol2.setMoveable(true);
        } else if (table.equals(this.dbdTab)) {
            this.dbdCol1 = new TableColumn(this.dbdTab, 0);
            this.dbdCol1.setText("DBD " + WorkbenchPlugin.labels.getString("WB014"));
            this.dbdCol1.setResizable(true);
            this.dbdCol1.setMoveable(true);
            this.dbdCol2 = new TableColumn(this.dbdTab, 0);
            this.dbdCol2.setText(WorkbenchPlugin.labels.getString("WB001B"));
            this.dbdCol2.setResizable(true);
            this.dbdCol2.setMoveable(true);
            this.dbdCol3 = new TableColumn(this.dbdTab, 0);
            this.dbdCol3.setText(WorkbenchPlugin.labels.getString("WB016"));
            this.dbdCol3.setResizable(true);
            this.dbdCol3.setMoveable(true);
        } else if (table.equals(this.needDBDTab)) {
            this.needDBDCol1 = new TableColumn(this.needDBDTab, 0);
            this.needDBDCol1.setText("DBD " + WorkbenchPlugin.labels.getString("WB014"));
            this.needDBDCol1.setResizable(true);
            this.needDBDCol1.setMoveable(true);
            this.needDBDCol2 = new TableColumn(this.needDBDTab, 0);
            this.needDBDCol2.setText(WorkbenchPlugin.labels.getString("WB001B"));
            this.needDBDCol2.setResizable(true);
            this.needDBDCol2.setMoveable(true);
        }
    }

    private void computeButtonSize(Button button) {
        Point buttonSize = button.computeSize(-1, -1);
        button.setSize(buttonSize);
    }

    private void setCursor(Table t) {
        this.cursor = new TableCursor(t, 27);
    }

    private void initialize() {
        this.addListeners();
        this.initListViewer(this.needDBDViewer, this.needDBDTab, this.dbdGrp);
    }

    private void addListeners() {
        this.addPSBButton.addListener(13, (Listener)this);
        this.removePSBButton.addListener(13, (Listener)this);
        this.addDBDButton.addListener(13, (Listener)this);
        this.removeDBDButton.addListener(13, (Listener)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            if (visible) {
                this.addPSBButton.setFocus();
                ImportSourceType type = this.impSrcCtrl.getSourceType();
                if (type == ImportSourceType.ZOS) {
                    this.setTitle(WorkbenchPlugin.labels.getString("WB605"));
                } else if (type == ImportSourceType.LOCAL) {
                    this.setTitle(WorkbenchPlugin.labels.getString("WB604"));
                } else {
                    this.setTitle(WorkbenchPlugin.labels.getString("WB611"));
                }
                if (this.getWiz().isImportFromCatNav() && this.impSrcCtrl.getNumResourcesSelected() <= 0) {
                    this.createCatalogProvider(this.getWiz().getSelectedPsbs(), this.getWiz().getSelectedDbds(), this.getWiz().getConnProfileNameUsed());
                    this.doCatalogAdd();
                    this.refreshTables();
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            logger.error(e);
        }
    }

    private ImportSourceWizard getWiz() {
        return (ImportSourceWizard)this.getWizard();
    }

    public void handleEvent(Event event) {
        try {
            if (event.widget == this.addPSBButton) {
                ImportSourceType sourceType = this.impSrcCtrl.getSourceType();
                if (sourceType == ImportSourceType.LOCAL) {
                    this.addFromLocal();
                } else if (sourceType == ImportSourceType.CATALOG) {
                    this.addFromCatalog(0);
                } else if (sourceType == ImportSourceType.ZOS) {
                    this.addFromZos();
                }
                this.refreshTables();
            } else if (event.widget == this.addDBDButton) {
                ImportSourceType sourceType = this.impSrcCtrl.getSourceType();
                if (sourceType == ImportSourceType.LOCAL) {
                    this.addFromLocal();
                } else if (sourceType == ImportSourceType.CATALOG) {
                    this.addFromCatalog(1);
                } else if (sourceType == ImportSourceType.ZOS) {
                    this.addFromZos();
                }
                this.refreshTables();
            } else if (event.widget == this.removePSBButton) {
                this.handleRemovePSB();
                this.refreshTables();
            } else if (event.widget == this.removeDBDButton) {
                this.handleRemoveDBD();
                this.refreshTables();
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    private void refreshTables() {
        int numPsbs = this.refreshPSBTable();
        int numDbds = this.refreshDBDTable();
        this.refreshNeedTable();
        this.setPageComplete(this.validatePage(numPsbs, numDbds));
    }

    private int refreshPSBTable() {
        int numSelectedPsbs = 0;
        this.psbTab.removeAll();
        Iterator psbListIt = this.impSrcCtrl.getSelectedPSBList();
        while (psbListIt.hasNext()) {
            ++numSelectedPsbs;
            IMSResourceToImport localPsbToImport = (IMSResourceToImport)psbListIt.next();
            String psbName = localPsbToImport.getPsbName();
            String localPath = localPsbToImport.getPath();
            this.addPsbOrNeedTableItem(this.psbTab, psbName, localPath);
        }
        this.psbTab.setSelection(0);
        this.psbTab.showSelection();
        this.updateRemoveButtonState(this.psbTab);
        return numSelectedPsbs;
    }

    private void addPsbOrNeedTableItem(Table t, String name, String pathOrRefName) {
        TableItem tabItem = new TableItem(t, 0);
        tabItem.setText(0, name);
        if (pathOrRefName == null) {
            tabItem.setText(1, "");
        } else {
            tabItem.setText(1, pathOrRefName);
        }
    }

    private int refreshDBDTable() {
        this.dbdTab.removeAll();
        List<Object> refPsbList = new ArrayList();
        Iterator dbdListIt = this.impSrcCtrl.getSelectedDBDList();
        int counter = 0;
        while (dbdListIt.hasNext()) {
            ++counter;
            IMSResourceToImport localDbdToImport = (IMSResourceToImport)dbdListIt.next();
            Object referencerList = "";
            String filePath = localDbdToImport.getPath();
            String localDbdName = localDbdToImport.getDbdName();
            ArrayList referencerNames = localDbdToImport.referencerList;
            for (String referencerName : referencerNames) {
                refPsbList = this.splitPSBList((String)referencerList);
                if (refPsbList.contains(referencerName)) continue;
                referencerList = (String)referencerList + "," + referencerName;
                referencerList = this.formatString((String)referencerList);
            }
            this.addDbdTableItem(this.dbdTab, localDbdName, (String)referencerList, filePath);
            if (counter % 10 == 0) {
                logger.fine("Added TableItem for DBD: " + localDbdName + " counter: " + counter);
                long freeMemory = Runtime.getRuntime().freeMemory();
                logger.fine("Free memory: " + freeMemory);
            }
            this.dbdTab.setSelection(0);
            this.dbdTab.showSelection();
        }
        this.updateRemoveButtonState(this.dbdTab);
        return counter;
    }

    private void addDbdTableItem(Table t, String name, String refName, String path) {
        TableItem tabItem = new TableItem(t, 0);
        tabItem.setText(0, name);
        tabItem.setText(1, refName);
        if (path == null) {
            tabItem.setText(2, "");
        } else {
            tabItem.setText(2, path);
        }
    }

    private String formatString(String str) {
        String tempStr = new String();
        if (str.contains(",,")) {
            tempStr = str.replace(",,", ",");
        } else if (str.endsWith(",")) {
            int index = str.lastIndexOf(",");
            tempStr = str.substring(0, index);
        } else {
            tempStr = str.startsWith(",") ? str.substring(1) : str;
        }
        return tempStr;
    }

    private List<String> splitPSBList(String psbName) {
        ArrayList<String> refPSBList = new ArrayList<String>();
        String[] refList = new String[1];
        if (psbName.contains(",")) {
            refList = psbName.split(",");
            int i = 0;
            while (i < refList.length) {
                refPSBList.add(refList[i]);
                ++i;
            }
        } else {
            refPSBList.add(psbName);
        }
        return refPSBList;
    }

    private void refreshNeedTable() {
        this.needTableExists = false;
        this.needDBDTab.removeAll();
        Iterator iter = this.impSrcCtrl.getNeededDBDList();
        while (iter.hasNext()) {
            IMSResourceToImport refDbd = (IMSResourceToImport)iter.next();
            String dbdName = refDbd.getDbdName();
            ArrayList referencerNames = refDbd.referencerList;
            Object referencerNameList = null;
            for (String currRef : referencerNames) {
                referencerNameList = referencerNameList != null ? (String)referencerNameList + "," + currRef : currRef;
            }
            this.addPsbOrNeedTableItem(this.needDBDTab, dbdName, (String)referencerNameList);
            this.needDBDTab.setSelection(0);
            this.needDBDTab.showSelection();
            this.updateRemoveButtonState(this.needDBDTab);
            if (this.needDBDTab.getItems().length <= 0) {
                this.needImportlbl.setVisible(false);
                this.needImportlbl2.setVisible(false);
                this.needDBDTab.setVisible(false);
                this.warningImgLbl.setVisible(false);
                continue;
            }
            this.needTableExists = true;
            this.needDBDTab.setVisible(true);
            this.needImportlbl2.setVisible(true);
            this.needImportlbl.setVisible(true);
            this.warningImgLbl.setImage(this.warningImg);
            this.warningImgLbl.setVisible(true);
        }
    }

    private void handleRemovePSB() {
        TableItem[] psbTabItem = this.psbTab.getSelection();
        int i = 0;
        while (i < psbTabItem.length) {
            String psbToBeRemoved = psbTabItem[i].getText(0);
            this.impSrcCtrl.removePsb(psbToBeRemoved);
            ++i;
        }
    }

    private void handleRemoveDBD() {
        TableItem[] dbdTabItem = this.dbdTab.getSelection();
        int i = 0;
        while (i < dbdTabItem.length) {
            String dbdToBeRemoved = dbdTabItem[i].getText(0);
            this.impSrcCtrl.removeDbd(dbdToBeRemoved);
            ++i;
        }
    }

    private void addFromLocal() throws IOException, ImporterException, InvocationTargetException, InterruptedException, CoreException, ModelException, ConnectionException {
        Vector<String> selectedFiles = this.browseForFiles();
        this.createLocalProvider(selectedFiles);
        ISchedulingRule rule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        rule = ruleFactory.modifyRule((IResource)ProjectTreeFileHelper.getProject((String)"IMS_Explorer_Catalog_ReadOnly"));
        ImportSource op = new ImportSource(rule);
        Shell activeShell = this.getWizard().getContainer().getShell();
        try {
            new ProgressMonitorDialog(activeShell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {}
        this.checkForPsbAlreadyInProject();
        this.handleDbdsAlreadyInProject();
        this.displayImportErrors();
        this.displayNeedTableMessage();
    }

    private void displayNeedTableMessage() {
        this.needTableExists = this.impSrcCtrl.getNeededDBDList().hasNext();
        if (this.needTableExists && this.needTableMessageNotShownYet) {
            MessageDialog infoDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.errors.getString("EISRC25"), null, WorkbenchPlugin.descriptions.getString("WB087A"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            infoDialog.open();
            this.needTableMessageNotShownYet = false;
        }
    }

    private void displayImportErrors() {
        this.importerExceptions = this.impSrcCtrl.getImporterExceptions();
        if (this.importerExceptions != null && this.importerExceptions.size() > 0) {
            String buf = this.getMultiExceptionMessage(this.importerExceptions);
            this.showImportWarning(buf);
            this.importerExceptions.removeAllElements();
        }
    }

    private void handleDbdsAlreadyInProject() throws InvocationTargetException, ModelException, CoreException, InterruptedException, IOException, ImporterException, ConnectionException {
        this.mergeReturnCode = -1;
        Vector dbdsAlreadyInProject = this.impSrcCtrl.getDbdsAlreadyInProject();
        if (dbdsAlreadyInProject != null) {
            int i = 0;
            while (i < dbdsAlreadyInProject.size()) {
                IMSResourceToImport currDbRes = (IMSResourceToImport)dbdsAlreadyInProject.get(i);
                String projectName = this.impSrcCtrl.getProjectName();
                this.confirmationInserts = new Object[2];
                this.confirmationInserts[0] = currDbRes.resourceName;
                this.confirmationInserts[1] = projectName;
                if (this.mergeReturnCode != 4) {
                    this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ConfirmationDialog cd = new ConfirmationDialog(ImportSourceWizardPage3.this.getShell(), WorkbenchPlugin.errors.getString("DIALOG001", ImportSourceWizardPage3.this.confirmationInserts), "DIALOG001");
                            ImportSourceWizardPage3.this.mergeReturnCode = cd.open();
                        }
                    });
                }
                if (this.mergeReturnCode == 2) {
                    this.impSrcCtrl.mergeNewDbdWithExisting(currDbRes, (IProgressMonitor)this.nullMonitor);
                } else if (this.mergeReturnCode == 4) {
                    Shell activeShell = this.getContainer().getShell();
                    MergeAllDbds mergeOp = new MergeAllDbds(dbdsAlreadyInProject, i);
                    new ProgressMonitorDialog(activeShell).run(true, false, (IRunnableWithProgress)mergeOp);
                    break;
                }
                ++i;
            }
        }
    }

    private void checkForPsbAlreadyInProject() {
        Vector psbsAlreadyInProject = this.impSrcCtrl.getPsbsAlreadyInProject();
        if (psbsAlreadyInProject != null && !psbsAlreadyInProject.isEmpty()) {
            Object psbList = COLON_LABEL;
            int i = 0;
            while (i < psbsAlreadyInProject.size()) {
                psbList = (String)psbList + "\n\t" + ((IMSResourceToImport)psbsAlreadyInProject.get((int)i)).resourceName;
                ++i;
            }
            Warnings warnings = new Warnings(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.labels.getString("WB496P"), null, WorkbenchPlugin.errors.getString("DHB1753"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            warnings.setWarnings(WorkbenchPlugin.errors.getString("DHB1752", (Object[])new String[]{psbList}));
            warnings.open();
        }
    }

    private void showImportWarning(final String buf) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                    if (!store.getBoolean("explorer_wizard_skip_warning_flag")) {
                        Warnings warnings = new Warnings(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.errors.getString("EISRC27"), null, WorkbenchPlugin.errors.getString("IOGWB0058"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                        warnings.setWarnings(buf.toString());
                        warnings.open();
                    }
                }
                catch (Throwable e) {
                    logger.throwing(this.getClass().getName(), "handleEvent(Event event)", e);
                    logger.error(e);
                }
            }
        });
    }

    private String getMultiExceptionMessage(Vector<ImporterException> exceptions) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < exceptions.size()) {
            buf.append(exceptions.get(i).getMessage());
            buf.append("\n\n");
            ++i;
        }
        return buf.toString();
    }

    private void createLocalProvider(Vector<String> selectedFiles) throws IOException, ImporterException {
        LocalProvider localProvider = (LocalProvider)this.impSrcCtrl.getLocalProvider();
        if (localProvider == null) {
            localProvider = new LocalProvider(this.impSrcCtrl);
            this.impSrcCtrl.setLocalProvider((ImportProvider)localProvider);
        }
        localProvider.setFilePaths(selectedFiles);
    }

    private HostProvider getHostProvider() {
        HostProvider hostProvider = (HostProvider)this.impSrcCtrl.getHostProvider();
        if (hostProvider == null) {
            hostProvider = new HostProvider(this.impSrcCtrl);
            this.impSrcCtrl.setHostProvider((ImportProvider)hostProvider);
        }
        return hostProvider;
    }

    private Vector<String> browseForFiles() {
        FileDialog fDialog = new FileDialog(this.getShell(), 2);
        fDialog.open();
        String path = fDialog.getFilterPath();
        String[] files = fDialog.getFileNames();
        if (files.length == 0) {
            return new Vector<String>();
        }
        int i = 0;
        while (i < files.length) {
            files[i] = path + File.separator + files[i];
            ++i;
        }
        Vector<String> selectedFiles = new Vector<String>(Arrays.asList(files));
        return selectedFiles;
    }

    private boolean isAlreadyInList(Vector<IMSResourceToImport> existingList, String fileName) {
        if (existingList != null) {
            for (IMSResourceToImport rsc : existingList) {
                if (!rsc.filePath.equals(fileName)) continue;
                return true;
            }
        }
        return false;
    }

    private Vector<String> trimCatalogResourceNames(Vector<String> unTrimmedNames) {
        Iterator<String> it = unTrimmedNames.iterator();
        Vector<String> retVal = new Vector<String>();
        while (it.hasNext()) {
            retVal.add(it.next().trim());
        }
        return retVal;
    }

    private boolean sourceAlreadySelected() {
        int numDbdsInTable = this.dbdTab.getItemCount();
        int numPsbsInTable = this.psbTab.getItemCount();
        return numDbdsInTable > 0 || numPsbsInTable > 0;
    }

    private void addFromCatalog(int addType) throws InvocationTargetException, InterruptedException, IOException, ImporterException, CoreException, ModelException, ConnectionException {
        this.isImportDbd = addType != 0;
        List connProfiles = ImsDbUtils.getConnectionProfileNames();
        if (connProfiles.size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchPlugin.errors.getString("DHB1703"), (String)WorkbenchPlugin.errors.getString("CATALOG_IMPORT_ERROR03"));
        } else {
            boolean sourceAlreadySelected = this.sourceAlreadySelected();
            CatalogImportWizard catImportWiz = new CatalogImportWizard(this.isImportDbd, sourceAlreadySelected);
            WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)catImportWiz);
            int retCode = dialog.open();
            if (retCode == 0) {
                String connProfileNameUsed = catImportWiz.getConnProfileNameUsed();
                Vector<String> userSelectedSources = this.trimCatalogResourceNames(catImportWiz.getSourceNames());
                if (!this.isImportDbd) {
                    this.createCatalogProvider(userSelectedSources, null, connProfileNameUsed);
                } else {
                    this.createCatalogProvider(null, userSelectedSources, connProfileNameUsed);
                }
                this.doCatalogAdd();
            }
        }
    }

    private void doCatalogAdd() throws CoreException, InvocationTargetException, ModelException, InterruptedException, IOException, ImporterException, ConnectionException {
        ISchedulingRule rule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        rule = ruleFactory.modifyRule((IResource)ProjectTreeFileHelper.getProject((String)"IMS_Explorer_Catalog_ReadOnly"));
        ImportSource op = new ImportSource(rule);
        Shell activeShell = this.getWizard().getContainer().getShell();
        try {
            new ProgressMonitorDialog(activeShell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {}
        Vector unfoundCatalogDbds = this.impSrcCtrl.getUnfoundCatalogDbds();
        if (unfoundCatalogDbds != null && !unfoundCatalogDbds.isEmpty()) {
            Object msgStr = "";
            int i = 0;
            while (i < unfoundCatalogDbds.size()) {
                msgStr = (String)msgStr + (String)unfoundCatalogDbds.get(i) + "\n";
                ++i;
            }
            WarningsWithoutCheckboxNoPrompt warnings = new WarningsWithoutCheckboxNoPrompt(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.labels.getString("WDT_DIALOG_TITLE"), null, WorkbenchPlugin.descriptions.getString("DBDS_MISSING_CATALOG"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            warnings.setWarnings((String)msgStr);
            warnings.open();
        }
        this.checkForPsbAlreadyInProject();
        this.handleDbdsAlreadyInProject();
        this.displayImportErrors();
        this.displayNeedTableMessage();
    }

    private void createCatalogProvider(Vector<String> psbNamesToImport, Vector<String> dbdNamesToImport, String connProfileNameUsed) {
        CatalogProvider catalogProvider = (CatalogProvider)this.impSrcCtrl.getCatalogProvider();
        if (catalogProvider == null) {
            catalogProvider = new CatalogProvider(this.impSrcCtrl);
            catalogProvider.setConnProfileNameUsed(connProfileNameUsed);
            this.impSrcCtrl.setCatalogProvider((ImportProvider)catalogProvider);
        }
        if (psbNamesToImport != null) {
            catalogProvider.setPsbNamesToImport(psbNamesToImport);
        }
        if (dbdNamesToImport != null) {
            catalogProvider.setDbdNamesToImport(dbdNamesToImport);
        }
    }

    private void addFromZos() throws IOException, ImporterException, InvocationTargetException, InterruptedException, ModelException, CoreException, ConnectionException {
        this.clearPreviousImpliedDatasets();
        ImportDataSetWizard importDataSetWizard = new ImportDataSetWizard(2, true, this.getLastDatasetName());
        importDataSetWizard.setCallingWizard((IWizard)this.getWiz());
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)importDataSetWizard);
        dialog.open();
        Vector zOSFiles = importDataSetWizard.getSelectedMembers();
        if (zOSFiles == null || zOSFiles.size() == 0) {
            return;
        }
        this.getHostProvider().setDataEntries(zOSFiles);
        this.addImpliedDataSets(importDataSetWizard);
        ISchedulingRule rule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        rule = ruleFactory.modifyRule((IResource)ProjectTreeFileHelper.getProject((String)"IMS_Explorer_Catalog_ReadOnly"));
        ImportSource op = new ImportSource(rule);
        Shell activeShell = this.getWizard().getContainer().getShell();
        try {
            new ProgressMonitorDialog(activeShell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {}
        this.checkForPsbAlreadyInProject();
        this.handleDbdsAlreadyInProject();
        this.displayImportErrors();
        this.displayNeedTableMessage();
    }

    private void clearPreviousImpliedDatasets() {
        HostProvider hostProvider = this.getHostProvider();
        if (hostProvider != null) {
            hostProvider.clearPreviousImpliedDatasets();
        }
    }

    private void addImpliedDataSets(ImportDataSetWizard wiz) {
        HostProvider hostProvider = this.getHostProvider();
        HashMap memberMap = wiz.getImpliedPdsMembers();
        for (PartitionedDataSet pds : memberMap.keySet()) {
            hostProvider.addImpliedDataSet(pds, (Vector)memberMap.get(pds));
            this.saveDatasetName(pds.getFullPath());
        }
    }

    private void saveDatasetName(String datasetName) {
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            settings.put(PREV_ZOS_SOURCE, datasetName);
        }
    }

    private String getLastDatasetName() {
        String retVal = null;
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            retVal = settings.get(PREV_ZOS_SOURCE);
        }
        return retVal;
    }

    class ImportSource
    extends WorkspaceModifyOperation {
        public ImportSource(ISchedulingRule modifyRule) {
            super(modifyRule);
        }

        protected void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            try {
                ImportSourceWizardPage3.this.impSrcCtrl.addIMSResources(monitor);
                monitor.done();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "run()", e);
                logger.error(e);
            }
        }
    }

    private class ListViewerProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private ListViewerProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object o, int columnIndex) {
            return null;
        }

        public Object[] getElements(Object o) {
            if (o instanceof Collection) {
                return ((Collection)o).toArray();
            }
            return new Object[0];
        }
    }

    class MergeAllDbds
    implements IRunnableWithProgress {
        private Vector<IMSResourceToImport> dbdsAlreadyInProject;
        int currIx;

        public MergeAllDbds(Vector<IMSResourceToImport> dbdsAlreadyInProject, int currIx) {
            this.dbdsAlreadyInProject = dbdsAlreadyInProject;
            this.currIx = currIx;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            try {
                monitor.beginTask("Merging DBDs...", this.dbdsAlreadyInProject.size() - this.currIx);
                int i = this.currIx;
                while (i < this.dbdsAlreadyInProject.size()) {
                    IMSResourceToImport currDbRes = this.dbdsAlreadyInProject.get(i);
                    ImportSourceWizardPage3.this.impSrcCtrl.mergeNewDbdWithExisting(currDbRes, (IProgressMonitor)ImportSourceWizardPage3.this.nullMonitor);
                    monitor.subTask("Merged DBD: " + currDbRes.getDbdName());
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "run()", e);
                logger.error(e);
            }
        }
    }
}

