/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importsrc;

import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.source.HostProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ImportProvider;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceController;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceType;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.importsrc.ImportSourceWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.wizard.importdataset.ImportDataSetWizard;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ImportSourceWizardPage2
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ImportSourceController impSrcCtrl;
    private static final String[] sourceTypes = new String[]{WorkbenchPlugin.labels.getString("WB005"), WorkbenchPlugin.labels.getString("WB801"), WorkbenchPlugin.labels.getString("IMPORT_WIZARD009")};
    private static final Object[] COLON = new Object[]{WorkbenchPlugin.colon.getString("COLON")};
    private static final String[] sourceTypePrereq = new String[]{WorkbenchPlugin.descriptions.getString("WB13B", COLON), WorkbenchPlugin.descriptions.getString("WB59A", COLON), WorkbenchPlugin.descriptions.getString("IMPORT_WIZARD001", COLON)};
    private static final int margin = 5;
    private static final int width = 400;
    private Composite composite;
    private Composite tableComposite;
    private Display display;
    private UIHelper uih;
    private Label prereqlbl;
    private Label tableLabel;
    private Label autoSearchDscrLabel;
    private Combo importSourceTypes;
    private Button autoSearchCheckBox;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Table datasetNameTable;
    private static final String PREV_ZOS_SOURCE = "ImportSourceWizardPage2.PREV_ZOS_SOURCE";

    public ImportSourceWizardPage2(ImportSourceController impSrcCtrl, String pageName) {
        super(pageName);
        this.setTitle(WorkbenchPlugin.labels.getString("WB603"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("vlImportWizard")));
        this.setPageComplete(false);
        this.uih = new UIHelper();
        this.impSrcCtrl = impSrcCtrl;
    }

    public void createControl(Composite parent) {
        try {
            this.setPageComplete(true);
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            FormData psbFD = new FormData();
            this.composite.setLayoutData((Object)psbFD);
            this.createSourceTypes();
            this.createSourceAutoSearch();
            this.createDatasetConcatenationForSearch();
            this.addListeners();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ImportResourceWizard");
            this.setControl((Control)this.composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void createSourceTypes() {
        FormData fd = this.uih.genFormData(new FormAttachment(0, 2), null, new FormAttachment(0, 0), null);
        Label sourceTypeLabel = this.uih.genLabel(this.composite, 16384, WorkbenchPlugin.labels.getString("WB004"), this.uih.black, fd);
        fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)sourceTypeLabel, 5), null);
        this.importSourceTypes = new Combo(this.composite, 8);
        this.importSourceTypes.setLayoutData((Object)fd);
        this.importSourceTypes.setItems(sourceTypes);
        fd = this.uih.genFormData(new FormAttachment((Control)this.importSourceTypes, 5), null, new FormAttachment(0, 0), new FormAttachment(100, -5));
        fd.width = 400;
        this.prereqlbl = this.uih.genLabel(this.composite, 64, sourceTypePrereq[0], this.uih.black, fd);
    }

    private void addListeners() {
        this.importSourceTypes.addListener(13, (Listener)this);
        this.autoSearchCheckBox.addListener(13, (Listener)this);
        this.addButton.addListener(13, (Listener)this);
        this.removeButton.addListener(13, (Listener)this);
        this.upButton.addListener(13, (Listener)this);
        this.downButton.addListener(13, (Listener)this);
        this.datasetNameTable.addListener(13, (Listener)this);
    }

    private void createSourceAutoSearch() {
        FormData fd = this.uih.genFormData(new FormAttachment((Control)this.prereqlbl, 20), null, new FormAttachment(0, 0), null);
        this.autoSearchCheckBox = new Button(this.composite, 32);
        this.autoSearchCheckBox.setText(WorkbenchPlugin.labels.getString("IMPORT_WIZARD011"));
        this.autoSearchCheckBox.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.autoSearchCheckBox, 5), null, new FormAttachment(0, 0), new FormAttachment(100, -5));
        fd.width = 400;
        this.autoSearchDscrLabel = this.uih.genLabel(this.composite, 64, WorkbenchPlugin.descriptions.getString("IMPORT_WIZARD002", COLON), this.uih.black, fd);
    }

    private void initWidgetValues() {
        ImportSourceType importSourceType = this.impSrcCtrl.getSourceType();
        if (this.getWiz().isImportFromCatNav()) {
            importSourceType = ImportSourceType.CATALOG;
            this.impSrcCtrl.setSourceType(importSourceType);
            this.importSourceTypes.setEnabled(false);
        }
        if (importSourceType == ImportSourceType.LOCAL) {
            this.importSourceTypes.setText(sourceTypes[0]);
        } else if (importSourceType == ImportSourceType.ZOS) {
            this.importSourceTypes.setText(sourceTypes[1]);
        } else if (importSourceType == ImportSourceType.CATALOG) {
            this.importSourceTypes.setText(sourceTypes[2]);
        }
        this.autoSearchCheckBox.setSelection(this.impSrcCtrl.isAutoImportRefDbds());
    }

    private ImportSourceWizard getWiz() {
        return (ImportSourceWizard)this.getWizard();
    }

    private void updateDynWidgets() {
        ImportSourceType newImportSourceType = this.impSrcCtrl.getSourceType();
        boolean isAutoSearch = this.impSrcCtrl.isAutoImportRefDbds();
        if (newImportSourceType == ImportSourceType.LOCAL) {
            this.prereqlbl.setText(sourceTypePrereq[0]);
            this.tableComposite.setVisible(false);
        } else if (newImportSourceType == ImportSourceType.ZOS) {
            this.prereqlbl.setText(sourceTypePrereq[1]);
            if (isAutoSearch) {
                this.tableComposite.setVisible(true);
            } else {
                this.tableComposite.setVisible(false);
            }
        } else if (newImportSourceType == ImportSourceType.CATALOG) {
            this.prereqlbl.setText(sourceTypePrereq[2]);
            this.tableComposite.setVisible(false);
        }
    }

    private void createDatasetConcatenationForSearch() {
        FormLayout layout = new FormLayout();
        FormData fd = this.uih.genFormData(new FormAttachment((Control)this.autoSearchDscrLabel, 20), new FormAttachment(100), new FormAttachment(0, 0), new FormAttachment(100));
        this.tableComposite = new Composite(this.composite, 0);
        this.tableComposite.setVisible(false);
        this.tableComposite.setLayout((Layout)layout);
        this.tableComposite.setLayoutData((Object)fd);
        int[] labelSizes = new int[]{Utility.getTextWidth(this.tableComposite, 0, WorkbenchPlugin.labels.getString("WB008A")), Utility.getTextWidth(this.tableComposite, 0, WorkbenchPlugin.labels.getString("WB009A")), Utility.getTextWidth(this.tableComposite, 0, WorkbenchPlugin.labels.getString("WB033A")), Utility.getTextWidth(this.tableComposite, 0, WorkbenchPlugin.labels.getString("WB034A"))};
        int buttonWidth = Utility.getMaxSize(labelSizes) + 5;
        fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.tableLabel = this.uih.genLabel(this.tableComposite, 16384, WorkbenchPlugin.labels.getString("IMPORT_WIZARD012") + WorkbenchPlugin.colon.getString("COLON"), this.uih.black, fd);
        this.tableLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.tableLabel, 5), null, null, new FormAttachment(100, 0));
        fd.width = buttonWidth;
        this.addButton = new Button(this.tableComposite, 0x1000000);
        this.addButton.setText(WorkbenchPlugin.labels.getString("WB008A"));
        this.addButton.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.addButton, 5), null, null, new FormAttachment(100, 0));
        fd.width = buttonWidth;
        this.removeButton = new Button(this.tableComposite, 0x1000000);
        this.removeButton.setText(WorkbenchPlugin.labels.getString("WB009A"));
        this.removeButton.setLayoutData((Object)fd);
        this.removeButton.setEnabled(false);
        fd = this.uih.genFormData(new FormAttachment((Control)this.removeButton, 5), null, null, new FormAttachment(100, 0));
        fd.width = buttonWidth;
        this.upButton = new Button(this.tableComposite, 0x1000000);
        this.upButton.setText(WorkbenchPlugin.labels.getString("WB033A"));
        this.upButton.setLayoutData((Object)fd);
        this.upButton.setEnabled(false);
        fd = this.uih.genFormData(new FormAttachment((Control)this.upButton, 5), null, null, new FormAttachment(100, 0));
        fd.width = buttonWidth;
        this.downButton = new Button(this.tableComposite, 0x1000000);
        this.downButton.setText(WorkbenchPlugin.labels.getString("WB034A"));
        this.downButton.setLayoutData((Object)fd);
        this.downButton.setEnabled(false);
        fd = this.uih.genFormData(new FormAttachment((Control)this.tableLabel, 5), new FormAttachment(100, -5), new FormAttachment(0, 0), new FormAttachment((Control)this.addButton, -5));
        this.datasetNameTable = new Table(this.tableComposite, 67588);
        this.datasetNameTable.setLayoutData((Object)fd);
        this.datasetNameTable.setLinesVisible(true);
        this.datasetNameTable.setHeaderVisible(false);
        TableColumn tableColumn = new TableColumn(this.datasetNameTable, 0);
        tableColumn.setWidth(400);
    }

    public void handleEvent(Event event) {
        try {
            if (event.widget == this.importSourceTypes) {
                ImportSourceType newImportSourceType = this.getImportSourceType();
                this.impSrcCtrl.setSourceType(newImportSourceType);
                this.updateDynWidgets();
            } else if (event.widget == this.autoSearchCheckBox) {
                this.impSrcCtrl.setAutoImportRefDbds(this.autoSearchCheckBox.getSelection());
                this.updateDynWidgets();
                this.buttonsEnablement();
            } else if (event.widget == this.addButton) {
                this.addSearchDataSet();
                this.buttonsEnablement();
            } else if (event.widget == this.removeButton) {
                this.getHostProvider().removeSearchPds(this.datasetNameTable.getSelectionIndex());
                this.refreshTable();
                this.buttonsEnablement();
            } else if (event.widget == this.upButton) {
                this.getHostProvider().moveSearchPdsUp(this.datasetNameTable.getSelectionIndex());
                this.refreshTable();
                this.buttonsEnablement();
            } else if (event.widget == this.downButton) {
                this.getHostProvider().moveSearchPdsDown(this.datasetNameTable.getSelectionIndex());
                this.refreshTable();
                this.buttonsEnablement();
            } else if (event.widget == this.datasetNameTable) {
                this.buttonsEnablement();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(final Event event)", e);
            logger.error(e);
        }
    }

    private HostProvider getHostProvider() {
        HostProvider hostProvider = (HostProvider)this.impSrcCtrl.getHostProvider();
        if (hostProvider == null) {
            hostProvider = new HostProvider(this.impSrcCtrl);
            this.impSrcCtrl.setHostProvider((ImportProvider)hostProvider);
        }
        return hostProvider;
    }

    private void addSearchDataSet() {
        ImportDataSetWizard importDataSetWizard = new ImportDataSetWizard(3, true, this.getLastDatasetName());
        importDataSetWizard.setCallingWizard((IWizard)this.getWiz());
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)importDataSetWizard);
        dialog.open();
        Vector pdsList = importDataSetWizard.getImpliedPdsList();
        if (pdsList != null && pdsList.size() == 1) {
            HashMap impliedPdsMembers = importDataSetWizard.getImpliedPdsMembers();
            PartitionedDataSet pds = (PartitionedDataSet)pdsList.get(0);
            Vector allPdsMembers = (Vector)impliedPdsMembers.get(pds);
            this.getHostProvider().addSearchDataSet(pds, allPdsMembers);
            this.saveDatasetName(pds.getFullPath());
            this.refreshTable();
        }
    }

    private void refreshTable() {
        this.datasetNameTable.removeAll();
        Vector pdsList = this.getHostProvider().getPdsSearchList();
        int i = 0;
        while (i < pdsList.size()) {
            PartitionedDataSet currPds = (PartitionedDataSet)pdsList.get(i);
            TableItem newTableItem = new TableItem(this.datasetNameTable, 0);
            newTableItem.setText(currPds.getName());
            ++i;
        }
    }

    private void buttonsEnablement() {
        boolean autoSearchSelected = this.autoSearchCheckBox.getSelection();
        this.addButton.setEnabled(autoSearchSelected);
        int[] selectedItems = this.datasetNameTable.getSelectionIndices();
        boolean someItemsSelected = selectedItems.length > 0 && autoSearchSelected;
        this.removeButton.setEnabled(someItemsSelected);
        boolean topItemSelected = false;
        boolean bottomItemSelected = false;
        if (someItemsSelected) {
            if (selectedItems.length == this.datasetNameTable.getItemCount()) {
                someItemsSelected = false;
            } else {
                int i = 0;
                while (i < selectedItems.length) {
                    int currentIndex = selectedItems[i];
                    if (currentIndex == this.datasetNameTable.getItemCount() - 1) {
                        bottomItemSelected = true;
                    } else if (currentIndex == 0) {
                        topItemSelected = true;
                    }
                    ++i;
                }
            }
        }
        this.upButton.setEnabled(someItemsSelected && !topItemSelected);
        this.downButton.setEnabled(someItemsSelected && !bottomItemSelected);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            if (visible) {
                this.initWidgetValues();
                this.updateDynWidgets();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(final Event event)", e);
            logger.error(e);
        }
    }

    protected ImportSourceType getImportSourceType() {
        ImportSourceType retVal = null;
        if (this.importSourceTypes.getText().equals(sourceTypes[0])) {
            retVal = ImportSourceType.LOCAL;
        } else if (this.importSourceTypes.getText().equals(sourceTypes[1])) {
            retVal = ImportSourceType.ZOS;
        } else if (this.importSourceTypes.getText().equals(sourceTypes[2])) {
            retVal = ImportSourceType.CATALOG;
        }
        return retVal;
    }

    private void saveDatasetName(String datasetName) {
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            settings.put(PREV_ZOS_SOURCE, datasetName);
        }
    }

    private String getLastDatasetName() {
        String retVal = null;
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            retVal = settings.get(PREV_ZOS_SOURCE);
        }
        return retVal;
    }
}

