/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importsrc;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceController;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.ui.core.Utility;
import com.ibm.im.ims.workbench.wizard.importsrc.ImportSourceWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.common.util.PosixPortablePathValidator;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportSourceWizardPage1
extends WizardPage
implements SelectionListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ImportSourceController impSrcCtrl;
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private IStructuredSelection selection;
    private Label projectNameLabel;
    private Combo projectNameCombo;
    private Text projectNameField;
    public static final String PAGE_NAME = "ImportWizardPage1";
    private static final int margin = 5;
    HashMap<String, String> projHash = null;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean pageComplete = ImportSourceWizardPage1.this.validatePage();
            ImportSourceWizardPage1.this.setPageComplete(pageComplete);
            if (pageComplete) {
                ImportSourceWizardPage1.this.getWizard().canFinish();
                if (ImportSourceWizardPage1.this.projectNameCombo != null) {
                    ImportSourceWizardPage1.this.impSrcCtrl.setProjectName(ImportSourceWizardPage1.this.projectNameCombo.getText().trim());
                } else if (ImportSourceWizardPage1.this.projectNameField != null) {
                    ImportSourceWizardPage1.this.impSrcCtrl.setProjectName(ImportSourceWizardPage1.this.projectNameField.getText().trim());
                }
            }
        }
    };

    public ImportSourceWizardPage1(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.uih = new UIHelper();
        this.selection = selection;
        this.setTitle(WorkbenchPlugin.labels.getString("WB001"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB103"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("newProjWizard")));
    }

    public ImportSourceWizardPage1(ImportSourceController impSrcCtrl, IStructuredSelection selection) {
        super(PAGE_NAME);
        this.uih = new UIHelper();
        this.impSrcCtrl = impSrcCtrl;
        this.selection = selection;
        this.setTitle(WorkbenchPlugin.labels.getString("WB001"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB103"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("newProjWizard")));
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        try {
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            this.composite.setFont(parent.getFont());
            this.projHash = ProjectTreeFileHelper.getAllProjectFromOS();
            boolean isImport = true;
            if (this.getWizard() instanceof ImportSourceWizard) {
                isImport = ((ImportSourceWizard)this.getWizard()).isImport();
            }
            if (isImport) {
                this.createAdvanceNameField(this.composite, true);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.im.ims.workbench.NewProjectWizard");
            } else {
                this.createBasicNameField(this.composite);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.NewProjectWizard");
            }
            this.setControl((Control)this.composite);
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void createBasicNameField(Composite composite) {
        this.setTitle(WorkbenchPlugin.descriptions.getString("WB101"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB102"));
        FormData fd1 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.projectNameLabel = this.uih.genRequiredLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB103"), this.uih.black, fd1);
        FormData fd2 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.projectNameLabel, 10), new FormAttachment(100, 0));
        this.projectNameField = this.uih.genTextField(composite, 2048, "", 100, fd2, this.nameModifyListener, 24);
        this.projectNameField.setFocus();
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createAdvanceNameField(Composite composite, boolean isImport) throws CoreException {
        if (isImport) {
            this.setTitle(WorkbenchPlugin.labels.getString("WB001"));
        } else {
            this.setTitle(WorkbenchPlugin.labels.getString("WB818"));
        }
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB103"));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        Vector<String> projectNames = new Vector<String>();
        String selectedName = this.getSelectedProjectName(this.selection);
        int i = 0;
        while (i < projects.length) {
            String projName;
            IProjectNature nature;
            IProject currentProject = projects[i];
            if (currentProject.isOpen() && (nature = currentProject.getNature("com.ibm.im.ims.workbench.nature")) != null && !(projName = currentProject.getName()).equals("IMS_Explorer_Catalog_ReadOnly")) {
                projectNames.add(projName);
            }
            ++i;
        }
        FormData fd1 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        this.projectNameLabel = this.uih.genRequiredLabel(composite, 16384, WorkbenchPlugin.labels.getString("WB103"), this.uih.black, fd1);
        FormData fd2 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.projectNameLabel, 10), new FormAttachment(100, 0));
        this.projectNameCombo = new Combo(composite, 8);
        this.projectNameCombo.setItems(projectNames.toArray(new String[projectNames.size()]));
        this.projectNameCombo.setText(selectedName);
        this.projectNameCombo.setLayoutData((Object)fd2);
        this.projectNameCombo.addListener(24, this.nameModifyListener);
        this.projectNameCombo.setFocus();
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.getProjectName();
        if (projectName == null || projectName.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchPlugin.descriptions.getString("WB102"));
            return false;
        }
        if (!PosixPortablePathValidator.isPortableName((String)projectName)) {
            this.setErrorMessage(WorkbenchPlugin.errors.getString("INVALID_PROJECT_NAME", new Object[]{projectName}));
            this.setMessage(null);
            return false;
        }
        IProject handle = this.getProjectHandle();
        IWizard wizard = this.getWizard();
        boolean isImportExport = true;
        isImportExport = wizard instanceof ImportSourceWizard ? ((ImportSourceWizard)wizard).isImport() : true;
        if (handle.exists() && !isImportExport) {
            this.setErrorMessage(WorkbenchPlugin.descriptions.getString("WB104"));
            this.setMessage(null);
            return false;
        }
        if (!handle.exists() && isImportExport) {
            Object[] inserts = new Object[]{handle.getName()};
            this.setErrorMessage(WorkbenchPlugin.errors.getString("IOGWB0301", inserts));
            this.setMessage(null);
            return false;
        }
        if (this.projHash.get(projectName.toUpperCase()) != null && !isImportExport) {
            Object[] inserts = new Object[]{Platform.getLocation().toString()};
            this.setErrorMessage(WorkbenchPlugin.errors.getString("IOGWB0302", inserts));
            this.setMessage(null);
            return false;
        }
        return true;
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        String projectName = "";
        if (this.projectNameField == null && this.projectNameCombo == null) {
            return "";
        }
        if (this.projectNameCombo != null) {
            projectName = this.projectNameCombo.getText();
        } else if (this.projectNameField != null) {
            projectName = this.projectNameField.getText();
        }
        return projectName;
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getSelectedProjectName(IStructuredSelection selection) {
        String selectedProject = "";
        if (selection == null || selection.isEmpty()) {
            return selectedProject;
        }
        if (selection.getFirstElement() instanceof IProject) {
            selectedProject = ((IProject)selection.getFirstElement()).getName();
        } else if (selection.getFirstElement() instanceof IResource) {
            selectedProject = ((IResource)selection.getFirstElement()).getProject().getName();
        } else if (selection.getFirstElement() instanceof IFile) {
            selectedProject = ((IFile)selection.getFirstElement()).getProject().getName();
        }
        return selectedProject;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            try {
                if (this.impSrcCtrl != null) {
                    this.impSrcCtrl.setProjectName(this.getProjectName());
                }
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
                logger.error(e);
            }
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

