/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importsrc;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceController;
import com.ibm.im.ims.workbench.controller.importer.source.ImportSourceType;
import com.ibm.im.ims.workbench.controller.template.ManageTemplateController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.utilities.GetProjectInfo;
import com.ibm.im.ims.workbench.utilities.MessageDialogRunner;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.utilities.WizardDialogRunner;
import com.ibm.im.ims.workbench.wizard.importsrc.ImportSourceWizardPage1;
import com.ibm.im.ims.workbench.wizard.importsrc.ImportSourceWizardPage2;
import com.ibm.im.ims.workbench.wizard.importsrc.ImportSourceWizardPage3;
import com.ibm.im.ims.workbench.wizard.managetemplate.ManageTemplateWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ImportSourceWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ImportSourceWizardPage1 importSourcePage1;
    private ImportSourceWizardPage2 importSourcePage2;
    private ImportSourceWizardPage3 importSourcePage3;
    private String connProfileNameUsed;
    private Vector<String> selectedPsbs = null;
    private Vector<String> selectedDbds = null;
    private IStructuredSelection selection;
    private boolean isImport;
    private ImportSourceController impSrcCtrl;
    public static final String PREV_IMPORT_SOURCE = "ImportSourceWizard.PREV_IMPORT_SOURCE";
    public static final String PREV_AUTO_SEARCH = "ImportSourceWizard.PREV_AUTO_SEARCH";

    public ImportSourceWizard(boolean isImport) throws CoreException, IOException {
        if (isImport) {
            this.setWindowTitle(WorkbenchPlugin.labels.getString("WB001"));
        } else {
            this.setWindowTitle(WorkbenchPlugin.labels.getString("WB101"));
        }
        this.setNeedsProgressMonitor(true);
        this.isImport = isImport;
        this.initController();
    }

    public ImportSourceWizard(Vector<String> selectedPsbs, Vector<String> selectedDbds, String connProfileNameUsed, boolean createNewProject) throws CoreException, IOException {
        this(!createNewProject);
        this.selectedPsbs = selectedPsbs;
        this.selectedDbds = selectedDbds;
        this.connProfileNameUsed = connProfileNameUsed;
    }

    public ImportSourceWizard() throws CoreException, IOException {
        this(true);
    }

    public void addPages() {
        try {
            this.importSourcePage1 = new ImportSourceWizardPage1(this.impSrcCtrl, this.selection);
            this.importSourcePage2 = new ImportSourceWizardPage2(this.impSrcCtrl, "Page2");
            this.importSourcePage3 = new ImportSourceWizardPage3(this.impSrcCtrl);
            this.addPage((IWizardPage)this.importSourcePage1);
            this.addPage((IWizardPage)this.importSourcePage2);
            this.addPage((IWizardPage)this.importSourcePage3);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public void setSpecificInstanceTSVers(String instanceTSVers) {
        this.impSrcCtrl.setSpecificInstanceTSVers(instanceTSVers);
    }

    public boolean isImportFromCatNav() {
        return this.selectedDbds != null;
    }

    public Vector<String> getSelectedPsbs() {
        return this.selectedPsbs;
    }

    public Vector<String> getSelectedDbds() {
        return this.selectedDbds;
    }

    public String getConnProfileNameUsed() {
        return this.connProfileNameUsed;
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.importSourcePage3.isPageComplete()) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public boolean performFinish() {
        try {
            this.saveWidgetHistory();
            String projectName = this.impSrcCtrl.getProjectName();
            Shell activeShell = this.getContainer().getShell();
            PrepareForFinish prepOp = new PrepareForFinish();
            new ProgressMonitorDialog(activeShell).run(true, false, (IRunnableWithProgress)prepOp);
            String projectUUID = ProjectTreeFileHelper.getUUIDForProject((String)projectName, (String)"com.ibm.im.ims.workbench");
            this.impSrcCtrl.setProjectUUID(projectUUID);
            this.openTemplatePrompt();
            ISchedulingRule combinedRule = null;
            ISchedulingRule rule = null;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rule = ruleFactory.modifyRule((IResource)ProjectTreeFileHelper.getProject((String)projectName));
            combinedRule = MultiRule.combine((ISchedulingRule)rule, combinedRule);
            rule = ruleFactory.modifyRule((IResource)ProjectTreeFileHelper.getProject((String)"IMS_Explorer_Catalog_ReadOnly"));
            combinedRule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)combinedRule);
            PerformFinishWorkspaceOp workspaceOp = new PerformFinishWorkspaceOp(combinedRule);
            new ProgressMonitorDialog(activeShell).run(true, false, (IRunnableWithProgress)workspaceOp);
            if (FieldImportWorkflowModelUtil.isProjectWorkflowEnabled((String)projectName)) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IViewPart view = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile((String)projectName);
                page.openEditor((IEditorInput)new FileEditorInput(wfFile), "com.ibm.im.ims.catalog.ui.workflow.WorkflowManager");
                if (view != null) {
                    ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)wfFile));
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.selection = selection;
    }

    public ImportSourceWizardPage1 getImportSourcePage1() {
        return this.importSourcePage1;
    }

    public ImportSourceWizardPage2 getImportSourcePage2() {
        return this.importSourcePage2;
    }

    public ImportSourceWizardPage3 getImportSourcePage3() {
        return this.importSourcePage3;
    }

    public boolean isImport() {
        return this.isImport;
    }

    private void openTemplatePrompt() throws InvocationTargetException {
        ArrayList listImportedPsbNames = this.impSrcCtrl.getImportedPSBNames();
        String projectName = this.impSrcCtrl.getProjectName();
        if (listImportedPsbNames != null) {
            boolean havePromptedUser = false;
            boolean userWantsTemplateWiz = false;
            int i = 0;
            while (i < listImportedPsbNames.size()) {
                Runnable runner;
                String psbName = (String)listImportedPsbNames.get(i);
                if (havePromptedUser) break;
                String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
                if (!JavaConventions.validateIdentifier((String)psbName, (String)sourceLevel, (String)complianceLevel).isOK()) {
                    MessageDialog messageDialog = new MessageDialog(this.getShell(), WorkbenchPlugin.labels.getString("MANAGE_TEMPLATE_7"), null, WorkbenchPlugin.errors.getString("IMPORT_WIZ_011"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    runner = new MessageDialogRunner(messageDialog);
                    this.getShell().getDisplay().syncExec(runner);
                    havePromptedUser = true;
                    boolean bl = userWantsTemplateWiz = messageDialog.getReturnCode() == 0;
                }
                if (userWantsTemplateWiz) {
                    try {
                        ManageTemplateController controller = new ManageTemplateController(projectName);
                        ManageTemplateWizard wizard = new ManageTemplateWizard(controller);
                        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                        runner = new WizardDialogRunner(dialog);
                        this.getShell().getDisplay().syncExec(runner);
                        userWantsTemplateWiz = false;
                    }
                    catch (ModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                ++i;
            }
        }
    }

    private void initController() throws CoreException, IOException {
        this.impSrcCtrl = new ImportSourceController(WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection"));
        String prevSourceType = this.getLastImportSource();
        if (prevSourceType != null) {
            this.impSrcCtrl.setSourceType(ImportSourceType.valueOf((String)prevSourceType));
            this.impSrcCtrl.setAutoImportRefDbds(this.getLastAutoSearchValue());
        } else {
            this.initAutoSearchToTrue();
            this.impSrcCtrl.setSourceType(ImportSourceType.ZOS);
            this.impSrcCtrl.setAutoImportRefDbds(true);
        }
    }

    private String getLastImportSource() {
        String retVal = null;
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            retVal = settings.get(PREV_IMPORT_SOURCE);
        }
        return retVal;
    }

    private boolean getLastAutoSearchValue() {
        boolean retVal = true;
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            retVal = settings.getBoolean(PREV_AUTO_SEARCH);
        }
        return retVal;
    }

    private void initAutoSearchToTrue() {
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            settings.put(PREV_AUTO_SEARCH, true);
        }
    }

    public void saveWidgetHistory() {
        ImportSourceType currImportSourceType = this.impSrcCtrl.getSourceType();
        boolean currAutoSearchValue = this.impSrcCtrl.isAutoImportRefDbds();
        IDialogSettings settings = Utility.getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (settings != null) {
            settings.put(PREV_IMPORT_SOURCE, currImportSourceType.toString());
            settings.put(PREV_AUTO_SEARCH, currAutoSearchValue);
        }
    }

    public ImportSourceController getImpSrcCtrl() {
        return this.impSrcCtrl;
    }

    class PerformFinishWorkspaceOp
    extends WorkspaceModifyOperation {
        public PerformFinishWorkspaceOp(ISchedulingRule modifyRule) {
            super(modifyRule);
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                ImportSourceWizard.this.impSrcCtrl.setDbView(WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("explorer_enable_ims_jdbc"));
                ImportSourceWizard.this.impSrcCtrl.performFinish(monitor);
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "run()", e);
                logger.error(e);
            }
        }
    }

    class PrepareForFinish
    implements IRunnableWithProgress {
        PrepareForFinish() {
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            try {
                String selectedProject = GetProjectInfo.getProjectName(ImportSourceWizard.this.selection);
                String containerName = ImportSourceWizard.this.impSrcCtrl.getProjectName();
                if (selectedProject == null || !selectedProject.equals(containerName)) {
                    ProjectTreeFileHelper.createNewProject((String)containerName);
                    ImportSourceWizard.this.impSrcCtrl.setNewProject(true);
                }
                ImportSourceWizard.this.impSrcCtrl.calculateDBViews2(monitor);
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "run()", e);
                logger.error(e);
            }
        }
    }
}

