/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importsrc;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionException;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.PickList;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.importsrc.CatalogImportWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class CatalogImportWizardPage1
extends WizardPage
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private UIHelper uih;
    private Composite composite;
    private Label profileLbl;
    private PickList sourcefilePicklist;
    private Combo profileCombo;
    private String currentConnProfileName = "";
    private IImsDbConnection connection = null;
    private boolean isImportDbd;
    private String profileToConnect;
    private Vector<String> availSourceList = new Vector();
    private Vector<String> selectedSourceList = new Vector();

    public CatalogImportWizardPage1(String pageName) {
        super(pageName);
        this.setTitle(WorkbenchPlugin.labels.getString("WB611"));
        this.setPageComplete(false);
        this.uih = new UIHelper();
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("vlImportWizard")));
    }

    public CatalogImportWizardPage1(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setTitle(WorkbenchPlugin.labels.getString("WB611"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("vlImportWizard")));
        this.setPageComplete(false);
        this.uih = new UIHelper();
    }

    public void createControl(Composite parent) {
        try {
            String selected;
            String available;
            CatalogImportWizard wizard = (CatalogImportWizard)this.getWizard();
            this.isImportDbd = wizard.getImportSourceType();
            this.composite = new Composite(parent, 0);
            this.uih.setDisplay(parent.getDisplay());
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            FormData connGrpfd = this.uih.genFormData(new FormAttachment((Control)this.composite, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            Group connectionGrp = new Group(this.composite, 0);
            FormLayout connectionFL = new FormLayout();
            connectionFL.marginHeight = 5;
            connectionFL.marginWidth = 5;
            connectionGrp.setLayout((Layout)connectionFL);
            connectionGrp.setLayoutData((Object)connGrpfd);
            connectionGrp.setText(WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL01"));
            Link textLink = new Link((Composite)connectionGrp, 16384);
            String txt = WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL10");
            textLink.setText(txt);
            textLink.setLayoutData((Object)connGrpfd);
            connGrpfd = this.uih.genFormData(new FormAttachment((Control)connectionGrp, 20), null, null, null);
            this.profileLbl = this.uih.genLabel((Composite)connectionGrp, 16384, WorkbenchPlugin.labels.getString("PROFILE") + WorkbenchPlugin.colon.getString("COLON"), this.uih.black, connGrpfd);
            connGrpfd = this.uih.genFormData(new FormAttachment((Control)connectionGrp, 20), null, new FormAttachment((Control)this.profileLbl, 10, 131072), null);
            this.profileCombo = new Combo((Composite)connectionGrp, 12);
            this.profileCombo.setSize(180, 10);
            this.profileCombo.setLayoutData((Object)connGrpfd);
            Group importGrp = new Group(this.composite, 0);
            FormData importfd = this.uih.genFormData(new FormAttachment((Control)connectionGrp, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            FormLayout importfl = new FormLayout();
            importfl.marginHeight = 5;
            importfl.marginWidth = 5;
            importGrp.setText(WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL11"));
            importGrp.setLayout((Layout)importfl);
            importGrp.setLayoutData((Object)importfd);
            importfd = this.uih.genFormData(new FormAttachment((Control)importGrp, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            importfd.width = importGrp.getClientArea().width;
            if (this.isImportDbd) {
                available = WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL07");
                selected = WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL08");
            } else {
                available = WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL05");
                selected = WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL06");
            }
            Label availColLabel = new Label((Composite)importGrp, 0);
            availColLabel.setText(available);
            importfd = this.uih.genFormData(new FormAttachment((Control)importGrp), null, new FormAttachment((Control)importGrp, 0, 16384), null);
            availColLabel.setLayoutData((Object)importfd);
            Label selectedColLabel = new Label((Composite)importGrp, 0);
            selectedColLabel.setText(selected);
            this.sourcefilePicklist = new PickList((Composite)importGrp, 268503042, false);
            int rightButtonNumerator = this.sourcefilePicklist.getRightButtonNumerator() + 1;
            importfd = this.uih.genFormData(new FormAttachment((Control)importGrp), null, new FormAttachment(rightButtonNumerator), null);
            selectedColLabel.setLayoutData((Object)importfd);
            this.sourcefilePicklist.setHeaderVisible(false);
            this.sourcefilePicklist.setLinesVisible(false);
            String[] colNames = new String[]{availColLabel.getText(), selectedColLabel.getText()};
            this.sourcefilePicklist.setColumns(colNames);
            importfd = this.uih.genFormData(new FormAttachment((Control)availColLabel, 10, 1024), null, new FormAttachment(0), new FormAttachment(100));
            this.sourcefilePicklist.setLayoutData(importfd);
            this.sourcefilePicklist.refreshAllButtons();
            this.initWidgetValues();
            this.addListeners();
            this.setControl((Control)this.composite);
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", err);
            logger.error(err);
        }
    }

    private void initWidgetValues() {
        List connProfiles = ImsDbUtils.getConnectionProfileNames();
        if (connProfiles.size() >= 1) {
            int i = 0;
            while (i < connProfiles.size()) {
                this.profileCombo.add((String)connProfiles.get(i));
                ++i;
            }
            this.profileCombo.add(WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL09"));
            this.profileCombo.setText(WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL09"));
        }
    }

    public void modifyText(ModifyEvent e) {
        block9: {
            try {
                if (e.widget == this.sourcefilePicklist) {
                    if (this.sourcefilePicklist.getSelectedItems().length > 0) {
                        this.profileCombo.setEnabled(false);
                    } else {
                        this.profileCombo.setEnabled(true);
                    }
                    this.sourcefilePicklist.refreshAllButtons();
                    this.setPageComplete(this.validatePage());
                    break block9;
                }
                if (e.widget != this.profileCombo) break block9;
                this.setErrorMessage(null);
                this.sourcefilePicklist.removeAll();
                this.sourcefilePicklist.refreshAllButtons();
                String connectionSelected = this.profileCombo.getText();
                if (connectionSelected.equals(WorkbenchPlugin.labels.getString("CATALOG_IMPORT_LABEL09"))) break block9;
                String nextProfile2 = null;
                List connProfiles = ImsDbUtils.getConnectionProfileNames();
                for (String nextProfile2 : connProfiles) {
                    if (connectionSelected.equals(nextProfile2)) break;
                }
                this.profileToConnect = nextProfile2;
                CreateNewConnection cnc = new CreateNewConnection();
                Shell activeShell = this.getWizard().getContainer().getShell();
                boolean hasError = false;
                try {
                    new ProgressMonitorDialog(activeShell).run(true, false, (IRunnableWithProgress)cnc);
                }
                catch (InvocationTargetException ite) {
                    hasError = true;
                    this.setErrorMessage(ite.getTargetException().getMessage());
                }
                if (!hasError) {
                    this.sourcefilePicklist.setAvailableItems(cnc.getAvailableSource());
                    this.sourcefilePicklist.packAvailableTable();
                    this.sourcefilePicklist.packSelectedTable();
                    this.sourcefilePicklist.refreshAllButtons();
                }
            }
            catch (Throwable err) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "", err);
                logger.error(err);
            }
        }
    }

    public boolean validatePage() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[0]);
        boolean retVal = false;
        TableItem[] files = this.sourcefilePicklist.getSelectedItems();
        if (files.length > 0) {
            this.selectedSourceList.removeAllElements();
            int i = 0;
            while (i < files.length) {
                this.selectedSourceList.add(files[i].getText());
                ++i;
            }
            retVal = true;
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[]{retVal});
        return retVal;
    }

    public Vector<String> getSelectedFiles() {
        return this.selectedSourceList;
    }

    private Object[][] populatePickList() throws ImsDbConnectionException {
        Object[][] availableSource = null;
        this.availSourceList.removeAllElements();
        if (this.isImportDbd) {
            this.availSourceList.addAll(this.connection.getDbdList());
        } else {
            this.availSourceList.addAll(this.connection.getPsbList());
        }
        availableSource = new Object[this.availSourceList.size()][1];
        int i = 0;
        while (i < this.availSourceList.size()) {
            availableSource[i][0] = this.availSourceList.elementAt(i);
            ++i;
        }
        return availableSource;
    }

    private void addListeners() {
        this.profileCombo.addModifyListener((ModifyListener)this);
        this.sourcefilePicklist.addModifyListener(this);
    }

    public String getConnProfileNameUsed() {
        return this.currentConnProfileName;
    }

    public void setConnProfileNameUsed(String connProfileNameUsed) {
        this.currentConnProfileName = connProfileNameUsed;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                if (this.currentConnProfileName != null && !this.currentConnProfileName.isEmpty()) {
                    this.profileCombo.setText(this.currentConnProfileName);
                }
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
                logger.error(e);
            }
        }
    }

    class CreateNewConnection
    implements IRunnableWithProgress {
        private Object[][] availableSource;

        CreateNewConnection() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask(WorkbenchPlugin.labels.getString("IMPORT_WIZARD013"), -1);
                CatalogImportWizardPage1.this.currentConnProfileName = CatalogImportWizardPage1.this.profileToConnect;
                CatalogImportWizardPage1.this.connection = ImsDbUtils.getConnectionByName((String)CatalogImportWizardPage1.this.currentConnProfileName, (boolean)true);
                this.availableSource = CatalogImportWizardPage1.this.populatePickList();
                monitor.done();
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "", e);
                logger.error(e);
                throw new InvocationTargetException(e);
            }
        }

        public Object[][] getAvailableSource() {
            return this.availableSource;
        }
    }
}

