/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importds;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.datastructure.PreviewAndSelectDSController;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PreviewAndSelectDataStructureDialog
extends Dialog
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Combo dsName;
    private Text dsContents;
    private PreviewAndSelectDSController controller;

    public PreviewAndSelectDataStructureDialog(Shell parentShell, PreviewAndSelectDSController controller) {
        super(parentShell);
        this.controller = controller;
    }

    protected Control createDialogArea(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createDialogArea(Composite parent)", new Object[0]);
        this.getShell().setText(WorkbenchPlugin.labels.getString("WFM_PRVIEW_TITLE"));
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)area.getLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        Composite container = new Composite(area, 0);
        GridLayout gl_container = new GridLayout(1, true);
        gl_container.marginBottom = 0;
        gl_container.marginLeft = 0;
        gl_container.marginRight = 0;
        gl_container.marginTop = 0;
        gl_container.horizontalSpacing = 5;
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1808));
        String[] dsNames = this.controller.getWorkflowCandidateDSNames();
        this.dsName = new Combo(container, 8);
        this.dsName.setItems(dsNames);
        this.dsName.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (dsNames.length > 0) {
            this.dsName.setText(dsNames[0]);
        }
        this.dsContents = new Text(container, 2826);
        this.dsContents.setBackground(Display.getDefault().getSystemColor(1));
        this.dsContents.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.dsName.addSelectionListener((SelectionListener)this);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createDialogArea(Composite parent)", new Object[0]);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, WorkbenchPlugin.labels.getString("WFM_SELECT"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateContents();
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2128);
        this.setBlockOnOpen(false);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent event)", new Object[0]);
        this.updateContents();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent event)", new Object[0]);
    }

    private void updateContents() {
        String contents = this.controller.getDataStructureContents(this.dsName.getSelectionIndex());
        this.dsContents.setText(contents);
        this.getButton(0).setEnabled(!contents.isEmpty());
    }
}

