/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importds;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.zos.model.DataSet;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.model.PermissionDeniedException;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.datastructure.DSSA;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportDsToDbdController;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportParseException;
import com.ibm.im.ims.workbench.controller.importer.datastructure.InformationException;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.MappingCaseModel;
import com.ibm.im.ims.workbench.model.MappingModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.model.utilities.ParseException;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.utilities.Warnings;
import com.ibm.im.ims.workbench.wizard.importds.ImportDSExceptionDialog;
import com.ibm.im.ims.workbench.wizard.importds.ImportDataStructureWizard;
import com.ibm.im.ims.workbench.wizard.managefield.ManageFieldWizardPage1;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.wizard.importdataset.ImportDataSetWizard;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportDataStructureWizardPage
extends WizardPage
implements Listener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ImportDsToDbdController controller;
    private static final String[] sourceTypes = new String[]{WorkbenchPlugin.labels.getString("WB005"), WorkbenchPlugin.labels.getString("WB801")};
    private static final String STORE_LOCAL_SOURCE_NAMES_ID = "ImportDataStructureWizardPage.STORE_LOCAL_SOURCE_NAMES_ID";
    private static final String STORE_HOST_SOURCE_NAMES_ID = "ImportDataStructureWizardPage.STORE_HOST_SOURCE_NAMES_ID";
    private static final String COBOL_PERIOD = ".";
    private static final String COBOL_PIC = " PIC ";
    private static final String COBOL_PICTURE = " PICTURE ";
    private static final String COBOL_COPY = " COPY ";
    private static final String PLI_COMMA = ",";
    private static final String PLI_DCL = " DCL ";
    private static final String PLI_DECLARE = " DECLARE ";
    private static final String PLI_INCLUDE = " %INCLUDE ";
    private UIHelper uih;
    private Group associationGroup;
    private Group tableGroup;
    private Label mapLabel;
    private Label caseLabel;
    private Label folderLabel;
    private Label fileLabel;
    private Combo importFromField;
    private Combo sourceTypeField;
    private Combo folderNameField;
    private Button sourceBrowseButton;
    private Combo fileNameField;
    private Combo dataStructureField;
    private Combo segmentNameField;
    private Text segmentTextField;
    private Combo mappingNameField;
    private Combo caseNameField;
    private Button associateButton;
    private Button removeButton;
    private Table associationTable;
    Composite parent;
    private static final int margin = 5;
    private static final int adjust = -4;
    private int col2LabelWidth;
    private int buttonWidth;
    private FormAttachment rightColumnLabelStart1;
    private FormAttachment rightColumnComboStart1;
    private FormAttachment rightColumnComboEnd1;
    private ResourceEditorPage editor;
    public Vector<InformationException> parsingInformationExceptionList;

    protected ImportDataStructureWizardPage(ImportDsToDbdController controller, ResourceEditorPage editor) {
        super(WorkbenchPlugin.labels.getString("WB496"));
        this.controller = controller;
        this.editor = editor;
        this.setTitle(WorkbenchPlugin.labels.getString("WB496A"));
        this.setDescription(WorkbenchPlugin.labels.getString("WB496B"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("impCbl")));
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.parent = new Composite(composite, 0);
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 5;
            this.parent.setLayout((Layout)formLayout);
            this.uih = new UIHelper();
            Display display = this.parent.getDisplay();
            this.uih.setDisplay(display);
            Color reqColor = this.parent.getDisplay().getSystemColor(3);
            int comboWidth = Utility.getTextWidth(composite, 0, WorkbenchPlugin.labels.getString("WB005"));
            int requiredLabelWidth = Utility.getTextWidth(composite, 0, "*");
            int[] labelSizes = new int[]{Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496D")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496G")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496H"))};
            this.buttonWidth = Utility.getMaxSize(labelSizes) + 10;
            int[] col1LabelSizes = new int[]{Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB004")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496C")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496E")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496C1")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496E1")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496R"))};
            int col1LabelWidth = Utility.getMaxSize(col1LabelSizes) + requiredLabelWidth;
            int[] col2LabelSizes = new int[]{Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496T")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("WB496F")), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_10") + ":"), Utility.getTextWidth(this.parent, 0, WorkbenchPlugin.labels.getString("MANAGE_MAPPING_11") + ":")};
            this.col2LabelWidth = Utility.getMaxSize(col2LabelSizes) + requiredLabelWidth;
            FormAttachment leftColumnLabelStart = new FormAttachment(0, requiredLabelWidth - 5);
            FormAttachment leftColumnLabelStart1 = new FormAttachment(0, requiredLabelWidth - 5 - -2);
            FormAttachment leftColumnComboStart = new FormAttachment(0, col1LabelWidth - 5);
            FormAttachment leftColumnComboStart1 = new FormAttachment(0, col1LabelWidth - 5 - -2);
            FormAttachment leftColumnComboEnd = new FormAttachment(50, -this.buttonWidth / 2 - 5);
            FormAttachment leftColumnComboEnd1 = new FormAttachment(50, -this.buttonWidth / 2 - 5 - -2);
            FormAttachment rightColumnLabelStart = new FormAttachment(50, -this.buttonWidth / 2 + requiredLabelWidth - 5);
            this.rightColumnLabelStart1 = new FormAttachment(50, -this.buttonWidth / 2 + requiredLabelWidth - 5 - -2);
            FormAttachment rightColumnComboStart = new FormAttachment(50, -this.buttonWidth / 2 + this.col2LabelWidth - 5);
            this.rightColumnComboStart1 = new FormAttachment(50, -this.buttonWidth / 2 + this.col2LabelWidth - 5 - -2);
            FormAttachment rightColumnComboEnd = new FormAttachment(100, -this.buttonWidth - 5);
            this.rightColumnComboEnd1 = new FormAttachment(100, -this.buttonWidth - 5 - -2);
            FormAttachment buttonEnd = new FormAttachment(100, -3);
            FormData fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredSymbol(this.parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, leftColumnLabelStart, null);
            Label importFromLabel = new Label(this.parent, 0);
            importFromLabel.setText(WorkbenchPlugin.labels.getString("WB004"));
            importFromLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, leftColumnComboStart, leftColumnComboEnd);
            this.importFromField = new Combo(this.parent, 2056);
            this.importFromField.setLayoutData((Object)fd);
            this.importFromField.setItems(sourceTypes);
            if (this.controller.isLocalImport()) {
                this.importFromField.setText(sourceTypes[0]);
            } else {
                this.importFromField.setText(sourceTypes[1]);
            }
            fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(50, -this.buttonWidth / 2), null);
            this.uih.genRequiredSymbol(this.parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, rightColumnLabelStart, null);
            Label sourceTypeLabel = new Label(this.parent, 0);
            sourceTypeLabel.setText(WorkbenchPlugin.labels.getString("WB496T"));
            sourceTypeLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, rightColumnComboStart, rightColumnComboEnd);
            this.sourceTypeField = new Combo(this.parent, 2056);
            this.sourceTypeField.setLayoutData((Object)fd);
            this.sourceTypeField.setItems(ImportDsToDbdController.fileTypes);
            this.sourceTypeField.setText(this.controller.getFileType());
            fd = this.uih.genFormData(new FormAttachment((Control)this.importFromField, 19), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredSymbol(this.parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment((Control)this.importFromField, 17), null, leftColumnLabelStart, null);
            this.folderLabel = new Label(this.parent, 0);
            if (this.controller.isLocalImport()) {
                this.folderLabel.setText(WorkbenchPlugin.labels.getString("WB496C"));
            } else {
                this.folderLabel.setText(WorkbenchPlugin.labels.getString("WB496C1"));
            }
            this.folderLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.importFromField, 15), null, leftColumnComboStart, rightColumnComboEnd);
            this.folderNameField = new Combo(this.parent, 2056);
            this.folderNameField.setLayoutData((Object)fd);
            this.restoreFolderValues();
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 19), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredSymbol(this.parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 17), null, leftColumnLabelStart, null);
            this.fileLabel = new Label(this.parent, 0);
            if (this.controller.isLocalImport()) {
                this.fileLabel.setText(WorkbenchPlugin.labels.getString("WB496E"));
            } else {
                this.fileLabel.setText(WorkbenchPlugin.labels.getString("WB496E1"));
            }
            this.fileLabel.setLayoutData((Object)fd);
            this.fileLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB432"));
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 15), null, leftColumnComboStart, rightColumnComboEnd);
            this.fileNameField = new Combo(this.parent, 2056);
            this.fileNameField.setLayoutData((Object)fd);
            if (this.controller.isLocalImport() && !this.folderNameField.getText().isEmpty()) {
                this.populateFileCombo();
            } else {
                this.fileNameField.setEnabled(false);
            }
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 13), null, new FormAttachment((Control)this.fileNameField, 5), new FormAttachment(100, -5));
            fd.width = this.buttonWidth;
            this.sourceBrowseButton = new Button(this.parent, 8);
            this.sourceBrowseButton.setText(WorkbenchPlugin.labels.getString("WB496D"));
            this.sourceBrowseButton.setLayoutData((Object)fd);
            FormLayout formLayout1 = new FormLayout();
            formLayout1.marginBottom = 5;
            fd = this.uih.genFormData(new FormAttachment((Control)this.fileNameField, 5), null, new FormAttachment(0, -4), new FormAttachment(100));
            this.associationGroup = new Group(this.parent, 0);
            this.associationGroup.setText(WorkbenchPlugin.labels.getString("WB496E2"));
            this.associationGroup.setLayout((Layout)formLayout1);
            this.associationGroup.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(0, 2), null);
            this.uih.genRequiredSymbol((Composite)this.associationGroup, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, leftColumnLabelStart1, null);
            Label dataStructureLabel = new Label((Composite)this.associationGroup, 0);
            dataStructureLabel.setText(WorkbenchPlugin.labels.getString("WB496R"));
            dataStructureLabel.setLayoutData((Object)fd);
            dataStructureLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB432A"));
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, leftColumnComboStart1, leftColumnComboEnd1);
            this.dataStructureField = new Combo((Composite)this.associationGroup, 2056);
            this.dataStructureField.setLayoutData((Object)fd);
            this.dataStructureField.setEnabled(!this.fileNameField.getText().isEmpty());
            fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(50, -this.buttonWidth / 2 - -2), null);
            this.uih.genRequiredSymbol((Composite)this.associationGroup, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, this.rightColumnLabelStart1, null);
            Label segmentLabel = new Label((Composite)this.associationGroup, 0);
            segmentLabel.setText(WorkbenchPlugin.labels.getString("WB496F"));
            segmentLabel.setLayoutData((Object)fd);
            segmentLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB433"));
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, this.rightColumnComboStart1, this.rightColumnComboEnd1);
            if (this.controller.getSegment() == null) {
                fd.width = comboWidth;
                this.segmentTextField = new Text((Composite)this.associationGroup, 2048);
                this.segmentTextField.setLayoutData((Object)fd);
                this.segmentTextField.setEnabled(false);
                fd = this.uih.genFormData(new FormAttachment(0, 2), null, new FormAttachment((Control)this.segmentTextField, 5), buttonEnd);
            } else {
                fd.width = comboWidth;
                this.segmentNameField = new Combo((Composite)this.associationGroup, 2056);
                this.segmentNameField.setLayoutData((Object)fd);
                this.segmentNameField.setEnabled(false);
                this.populateSegmentCombo();
                fd = this.uih.genFormData(new FormAttachment(0, 2), null, new FormAttachment((Control)this.segmentNameField, 5), buttonEnd);
            }
            fd.width = this.buttonWidth;
            this.associateButton = new Button((Composite)this.associationGroup, 8);
            this.associateButton.setText(WorkbenchPlugin.labels.getString("WB496G"));
            this.associateButton.setLayoutData((Object)fd);
            this.associateButton.setEnabled(false);
            FormLayout formLayout2 = new FormLayout();
            formLayout2.marginLeft = 5;
            formLayout2.marginBottom = 5;
            fd = this.uih.genFormData(new FormAttachment((Control)this.associationGroup, 5), new FormAttachment(100, -5), new FormAttachment(0, -4), new FormAttachment(100));
            fd.height = 350;
            this.tableGroup = new Group(this.parent, 0);
            this.tableGroup.setText(WorkbenchPlugin.labels.getString("WB496E3"));
            this.tableGroup.setLayout((Layout)formLayout2);
            this.tableGroup.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, -2), new FormAttachment(100));
            Label tableLabel = new Label((Composite)this.tableGroup, 64);
            tableLabel.setText(WorkbenchPlugin.labels.getString("WB496M"));
            tableLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)tableLabel, 5), new FormAttachment(100), new FormAttachment(0, -2), this.rightColumnComboEnd1);
            this.associationTable = new Table((Composite)this.tableGroup, 67586);
            this.associationTable.setHeaderVisible(true);
            this.associationTable.setLinesVisible(true);
            this.associationTable.setLayoutData((Object)fd);
            this.associationTable.setEnabled(false);
            this.setColumns();
            fd = this.uih.genFormData(new FormAttachment((Control)tableLabel, this.associationTable.getHeaderHeight() + 5), null, new FormAttachment((Control)this.associationTable, 5), buttonEnd);
            fd.width = this.buttonWidth;
            this.removeButton = new Button((Composite)this.tableGroup, 8);
            this.removeButton.setText(WorkbenchPlugin.labels.getString("WB496H"));
            this.removeButton.setLayoutData((Object)fd);
            this.removeButton.setEnabled(false);
            this.addListeners();
            this.addMapCaseListeners();
            Point point = this.getShell().computeSize(-1, -1, true);
            this.getShell().setMinimumSize(point);
            this.setControl((Control)this.parent);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.ies1_wb_import_datastructure");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void addMapCaseListeners() {
        if (this.mappingNameField != null) {
            this.mappingNameField.addModifyListener((ModifyListener)this);
        }
        if (this.caseNameField != null) {
            this.caseNameField.addModifyListener((ModifyListener)this);
        }
    }

    private void addListeners() {
        this.removeButton.addListener(13, (Listener)this);
        this.associationTable.addListener(13, (Listener)this);
        this.associateButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.fileNameField.addModifyListener((ModifyListener)this);
        this.sourceTypeField.addModifyListener((ModifyListener)this);
        this.importFromField.addModifyListener((ModifyListener)this);
        this.folderNameField.addModifyListener((ModifyListener)this);
        this.dataStructureField.addModifyListener((ModifyListener)this);
        if (this.segmentNameField != null) {
            this.segmentNameField.addModifyListener((ModifyListener)this);
        }
        if (this.segmentTextField != null) {
            this.segmentTextField.addModifyListener((ModifyListener)this);
        }
        this.tableGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ImportDataStructureWizardPage.this.resizeColumns();
            }
        });
    }

    private void resizeColumns() {
        Rectangle area = this.tableGroup.getClientArea();
        int width = area.width - 2 * this.associationTable.getBorderWidth() - this.buttonWidth - 5;
        TableColumn[] tableColumns = this.associationTable.getColumns();
        this.associationTable.setSize(area.width, area.height);
        int i = 0;
        while (i < tableColumns.length) {
            tableColumns[i].setWidth(width / tableColumns.length);
            ++i;
        }
    }

    private void setColumns() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setColumns()", new Object[0]);
        String[] columnLabels = new String[]{WorkbenchPlugin.labels.getString("WB496I"), WorkbenchPlugin.labels.getString("WB496J"), WorkbenchPlugin.labels.getString("MANAGE_MAPPING_5"), WorkbenchPlugin.labels.getString("MANAGE_MAPPING_7"), WorkbenchPlugin.labels.getString("WB496K")};
        String[] stringArray = new String[5];
        stringArray[0] = WorkbenchPlugin.descriptions.getString("WB433");
        stringArray[4] = WorkbenchPlugin.descriptions.getString("WB432");
        String[] columnTooltips = stringArray;
        int i = 0;
        while (i < columnLabels.length) {
            this.setColumn(columnLabels[i], columnTooltips[i]);
            ++i;
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setColumns()", new Object[0]);
    }

    private void setColumn(String columnLabel, String columnTooltip) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setColumn(String label)", new Object[0]);
        TableColumn tableColumn = new TableColumn(this.associationTable, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setColumn(String label)", new Object[0]);
    }

    public void handleEvent(Event event) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", new Object[0]);
        try {
            if (event.widget == this.sourceBrowseButton) {
                this.handleSourceBrowseButtonPressed();
            } else if (event.widget == this.associateButton) {
                this.handleAssociateButtonPressed();
            } else if (event.widget == this.associationTable) {
                this.removeButton.setEnabled(this.associationTable.getSelectionCount() > 0);
                this.setMessage(null, 2);
            } else if (event.widget == this.removeButton) {
                this.handleRemoveButtonPressed();
            }
            this.setPageComplete(this.associationTable.getItemCount() > 0);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", new Object[0]);
    }

    private void handleSourceBrowseButtonPressed() throws FileNotFoundException, PermissionDeniedException, ConnectionException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleSourceBrowseButtonPressed()", new Object[0]);
        if (this.controller.isLocalImport()) {
            FileDialog dialog = new FileDialog(new Shell(), 4096);
            dialog.setFilterPath(this.folderNameField.getText() + File.separator);
            dialog.setText(WorkbenchPlugin.labels.getString("WB496S"));
            String selectedFile = dialog.open();
            if (selectedFile != null) {
                int index = selectedFile.lastIndexOf(File.separator);
                String folderPath = selectedFile.substring(0, index);
                String fileName = selectedFile.substring(index + 1);
                this.setSelectedFolderName(folderPath);
                this.populateFileCombo();
                this.fileNameField.setText(fileName);
                this.updateWidgetEnablements();
            }
        } else {
            ImportDataSetWizard importDataSetWizard = new ImportDataSetWizard(1, false, this.folderNameField.getText());
            importDataSetWizard.setCallingWizard(this.getWizard());
            WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)importDataSetWizard);
            dialog.open();
            Vector impliedPdsList = importDataSetWizard.getImpliedPdsList();
            if (impliedPdsList != null && impliedPdsList.size() == 1) {
                Vector selectedMember;
                PartitionedDataSet pds = (PartitionedDataSet)impliedPdsList.get(0);
                if (!this.controller.pdsAlreadyInList(pds)) {
                    HashMap impliedPdsMembers = importDataSetWizard.getImpliedPdsMembers();
                    Vector pds_members = (Vector)impliedPdsMembers.get(pds);
                    this.controller.addPdsAndMembers(pds, pds_members);
                    this.setDataEntryName(pds.getPath());
                    this.populateMemberCombo(pds_members);
                }
                if ((selectedMember = importDataSetWizard.getSelectedMembers()).size() > 0) {
                    this.fileNameField.setText(((Member)selectedMember.elementAt(0)).getName());
                } else {
                    this.fileNameField.setText("");
                }
                this.updateWidgetEnablements();
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleSourceBrowseButtonPressed()", new Object[0]);
    }

    private void setSelectedFolderName(String folderPath) {
        this.folderNameField.removeModifyListener((ModifyListener)this);
        String[] folderNames = this.folderNameField.getItems();
        boolean folderAlreadyInList = false;
        String[] stringArray = folderNames;
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            if (folderName.equals(folderPath)) {
                this.folderNameField.setText(folderPath);
                this.controller.setLastDirectory(folderPath);
                folderAlreadyInList = true;
                break;
            }
            ++n2;
        }
        if (!folderAlreadyInList) {
            this.folderNameField.add(folderPath);
            this.folderNameField.setText(folderPath);
            this.controller.setLastDirectory(folderPath);
            this.saveFolderValues();
        }
        this.folderNameField.addModifyListener((ModifyListener)this);
    }

    private void setDataEntryName(String dePath) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setDataEntryName(String path)", new Object[0]);
        if (dePath != null && !dePath.isEmpty()) {
            String[] currentItems = this.folderNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(dePath)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                this.folderNameField.add(dePath);
                this.folderNameField.setText(dePath);
                this.saveFolderValues();
            } else {
                this.restoreFolderValues();
                this.folderNameField.select(selectionIndex);
            }
        } else {
            this.fileNameField.removeAll();
        }
        this.dataStructureField.removeAll();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setDataEntryName(String path)", new Object[0]);
    }

    private void populateMemberCombo(Vector<Member> selectedMembers) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateMemberCombo()", new Object[0]);
        if (selectedMembers != null) {
            String[] memberNames = new String[selectedMembers.size()];
            int i = 0;
            while (i < selectedMembers.size()) {
                memberNames[i] = selectedMembers.get(i).getName();
                ++i;
            }
            this.fileNameField.setItems(memberNames);
            if (this.fileNameField.getItems().length == 0) {
                this.setMessage(WorkbenchPlugin.errors.getString("IMPORT_ERR_03"), 2);
            } else {
                this.setMessage(null, 2);
                this.folderNameField.setEnabled(true);
            }
            this.controller.setLastDirectory(this.folderNameField.getText());
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateMemberCombo()", new Object[0]);
    }

    private void handleAssociateButtonPressed() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleAssociateButtonPressed()", new Object[0]);
        DSSA newDssa = new DSSA();
        newDssa.dataStructureName = this.dataStructureField.getText();
        if (this.segmentNameField != null) {
            newDssa.segmentName = this.segmentNameField.getText();
        }
        if (this.segmentTextField != null) {
            newDssa.segmentName = this.segmentTextField.getText();
        }
        newDssa.dsFileName = this.controller.getFullFileName();
        if (!this.isDisposed((Control)this.mappingNameField)) {
            newDssa.mapName = this.mappingNameField.getText();
            newDssa.caseName = this.caseNameField.getText();
        }
        if (this.controller.getAssocationIndex(newDssa) == -1) {
            this.controller.addDsSegmentAssociation(newDssa);
            this.refreshAssociationsTable();
            this.updateWidgetEnablements();
            this.associateButton.setEnabled(false);
        } else {
            this.associateButton.setEnabled(false);
            if (newDssa.mapName != null && !newDssa.mapName.isEmpty()) {
                Object[] messageArguments = new Object[]{newDssa.dataStructureName, newDssa.segmentName, newDssa.mapName};
                String msg = WorkbenchModelBundle.getError().getString("IMPORT_ERR_02", messageArguments);
                this.setMessage(msg, 2);
            } else {
                Object[] messageArguments = new Object[]{newDssa.dataStructureName, newDssa.segmentName};
                String msg = WorkbenchModelBundle.getError().getString("IMPORT_ERR_02A", messageArguments);
                this.setMessage(msg, 2);
            }
        }
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleAssociateButtonPressed()", new Object[0]);
    }

    private void refreshAssociationsTable() {
        this.associationTable.removeAll();
        Vector associations = this.controller.getDsSegmentAssociations();
        for (DSSA dssa : associations) {
            TableItem item = new TableItem(this.associationTable, 0);
            item.setText(0, dssa.segmentName);
            item.setText(1, dssa.dataStructureName);
            if (dssa.mapName != null) {
                item.setText(2, dssa.mapName);
            }
            if (dssa.caseName != null) {
                item.setText(3, dssa.caseName);
            }
            item.setText(4, dssa.dsFileName);
        }
    }

    private boolean isDisposed(Control cntr) {
        return cntr == null || cntr.isDisposed();
    }

    private void handleRemoveButtonPressed() {
        TableItem[] seletedItems;
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleRemoveButtonPressed()", new Object[0]);
        TableItem[] tableItemArray = seletedItems = this.associationTable.getSelection();
        int n = seletedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DSSA dssaToRemove = new DSSA();
            dssaToRemove.segmentName = item.getText(0);
            dssaToRemove.dataStructureName = item.getText(1);
            dssaToRemove.mapName = item.getText(2);
            dssaToRemove.caseName = item.getText(3);
            dssaToRemove.dsFileName = item.getText(4);
            this.controller.removeDsSegmentAssociation(dssaToRemove);
            ++n2;
        }
        this.refreshAssociationsTable();
        this.updateWidgetEnablements();
        this.setMessage(null, 2);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleRemoveButtonPressed()", new Object[0]);
    }

    private void updateImportFromField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateImportFromField()", new Object[0]);
        this.setImportFrom();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateImportFromField()", new Object[0]);
    }

    private void updateSourceTypeField() throws InvocationTargetException, InterruptedException, ConnectionException, CoreException, IOException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateSourceTypeField()", new Object[0]);
        this.setSourceType();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateSourceTypeField()", new Object[0]);
    }

    private void updateFromFolderField() throws FileNotFoundException, PermissionDeniedException, ConnectionException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromFolderField()", new Object[0]);
        this.populateFileCombo();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromFolderField()", new Object[0]);
    }

    private void updateFromFileField() throws InvocationTargetException, InterruptedException, ConnectionException, CoreException, IOException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromFileField()", new Object[0]);
        String folderName = this.folderNameField.getText();
        String fileName = this.fileNameField.getText();
        if (fileName != null && !fileName.isEmpty()) {
            this.controller.setFolderName(folderName);
            this.controller.setFileName(fileName);
            this.controller.prepareForInitialParse();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    ImportDataStructureWizardPage.this.controller.parseDataStructureSourceFile(monitor);
                }
            };
            new ProgressMonitorDialog(this.getShell()).run(true, false, op);
            this.setMessage(null, 2);
            Throwable currentException = this.controller.getCurrentException();
            if (currentException != null) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "populateDataStructureComboModel()", currentException);
                if (currentException instanceof ParseException) {
                    ImportDSExceptionDialog errorDialog = new ImportDSExceptionDialog(this.getShell(), WorkbenchPlugin.labels.getString("WB496N"), this.controller);
                    errorDialog.create();
                    errorDialog.getShell().setSize(700, 570);
                    errorDialog.open();
                    String[] dsNames = this.controller.getDataStructureNames();
                    if (dsNames != null && dsNames.length > 0) {
                        String importLanguage = this.controller.getFileType();
                        this.sourceTypeField.setText(importLanguage);
                        this.dataStructureField.setItems(dsNames);
                        this.parsingInformationExceptionList = errorDialog.getInformationExceptionList();
                        this.setMessage(null, 2);
                    } else {
                        this.dataStructureField.setItems(new String[0]);
                        this.dataStructureField.setEnabled(false);
                        this.segmentNameField.setEnabled(false);
                        if (!this.isDisposed((Control)this.mappingNameField)) {
                            this.mappingNameField.setEnabled(false);
                        }
                        if (!this.isDisposed((Control)this.caseNameField)) {
                            this.caseNameField.setEnabled(false);
                        }
                        this.setMessage(this.controller.getParseErrorMessage(), 2);
                        this.associateButton.setEnabled(false);
                        this.fileNameField.setFocus();
                    }
                } else if (currentException instanceof ImportParseException) {
                    Warnings warnings = new Warnings(this.getShell(), WorkbenchPlugin.labels.getString("WB496N"), null, WorkbenchPlugin.labels.getString("WB496O"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    warnings.setWarnings(currentException.getMessage() != null ? currentException.getMessage() : "");
                    warnings.open();
                    this.dataStructureField.setItems(new String[0]);
                    this.dataStructureField.setEnabled(false);
                    this.segmentNameField.setEnabled(false);
                    if (!this.isDisposed((Control)this.mappingNameField)) {
                        this.mappingNameField.setEnabled(false);
                    }
                    if (!this.isDisposed((Control)this.mappingNameField)) {
                        this.caseNameField.setEnabled(false);
                    }
                    this.associateButton.setEnabled(false);
                    this.setMessage(this.controller.getParseErrorMessage(), 2);
                    this.fileNameField.setFocus();
                } else {
                    logger.error(currentException);
                }
            } else {
                this.dataStructureField.setItems(this.controller.getDataStructureNames());
            }
            this.updateWidgetEnablements();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromFileField()", new Object[0]);
    }

    private void updateFromDataStructureField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromDataStructureField()", new Object[0]);
        this.setDataStructureName(this.dataStructureField.getText());
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromDataStructureField()", new Object[0]);
    }

    private void updateFromSegmentField() throws ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromSegmentField()", new Object[0]);
        this.populateMappingCombo();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromSegmentField()", new Object[0]);
    }

    private void updateFromSegmentTextField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromSegmentTextField()", new Object[0]);
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromSegmentTextField()", new Object[0]);
    }

    private void updateFromMappingField() throws ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromMappingField()", new Object[0]);
        this.setMappingName(this.mappingNameField.getText());
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromMappingField()", new Object[0]);
    }

    private void updateFromCaseField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromCaseField()", new Object[0]);
        this.setCaseName(this.caseNameField.getText());
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromCaseField()", new Object[0]);
    }

    private void updateWidgetEnablements() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateWidgetEnablements()", new Object[0]);
        this.fileNameField.setEnabled(!this.folderNameField.getText().isEmpty());
        if (this.dataStructureField.getItemCount() == 0) {
            return;
        }
        if (this.dataStructureField.getItemCount() == 1) {
            this.dataStructureField.select(0);
        }
        this.dataStructureField.setEnabled(!this.fileNameField.getText().isEmpty());
        if (this.segmentNameField != null) {
            this.segmentNameField.setEnabled(this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty());
        }
        if (this.segmentTextField != null) {
            this.segmentTextField.setEnabled(this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty());
        }
        if (!this.isDisposed((Control)this.mappingNameField) && !this.isDisposed((Control)this.caseNameField)) {
            this.mappingNameField.setEnabled(this.segmentNameField.isEnabled() && !this.segmentNameField.getText().isEmpty());
            this.caseNameField.setEnabled(this.mappingNameField.isEnabled() && !this.mappingNameField.getText().isEmpty() && this.mappingNameField.getItemCount() > 1 && !this.mappingNameField.getText().equals(ManageFieldWizardPage1.COMMON_FIELDS));
            this.associateButton.setEnabled(this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty() && this.segmentNameField.isEnabled() && !this.segmentNameField.getText().isEmpty() && this.mappingNameField.isEnabled() && !this.mappingNameField.getText().isEmpty() && (!this.caseNameField.isEnabled() || this.caseNameField.isEnabled() && !this.caseNameField.getText().isEmpty()));
        } else {
            if (this.segmentNameField != null) {
                this.associateButton.setEnabled(this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty() && this.segmentNameField.isEnabled() && !this.segmentNameField.getText().isEmpty());
            }
            if (this.segmentTextField != null) {
                this.associateButton.setEnabled(this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty() && this.segmentTextField.isEnabled() && !this.segmentTextField.getText().isEmpty());
            }
        }
        this.associationTable.setEnabled(this.associationTable.getItemCount() > 0);
        this.removeButton.setEnabled(this.associationTable.getSelectionCount() > 0);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateWidgetEnablements()", new Object[0]);
    }

    private void setImportFrom() {
        boolean existingIsLocalImportValue;
        logger.entering(((Object)((Object)this)).getClass().getName(), "setImportFrom()", new Object[0]);
        boolean newImportFromLocalValue = true;
        if (this.importFromField.getText().equals(sourceTypes[1])) {
            newImportFromLocalValue = false;
        }
        if ((existingIsLocalImportValue = this.controller.isLocalImport()) != newImportFromLocalValue) {
            this.controller.setLocalImport(newImportFromLocalValue);
            if (newImportFromLocalValue) {
                this.folderLabel.setText(WorkbenchPlugin.labels.getString("WB496C"));
                this.fileLabel.setText(WorkbenchPlugin.labels.getString("WB496E"));
            } else {
                this.folderLabel.setText(WorkbenchPlugin.labels.getString("WB496C1"));
                this.fileLabel.setText(WorkbenchPlugin.labels.getString("WB496E1"));
            }
            this.fileLabel.getParent().layout();
            this.restoreFolderValues();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setImportFrom()", new Object[0]);
    }

    private void setSourceType() throws InvocationTargetException, InterruptedException, ConnectionException, CoreException, IOException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setSourceType()", new Object[0]);
        String existingImportLanguage = this.controller.getFileType();
        String newImportLanguage = this.sourceTypeField.getText();
        if (existingImportLanguage == null || !existingImportLanguage.equals(newImportLanguage)) {
            this.controller.setFileType(newImportLanguage);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setSourceType()", new Object[0]);
    }

    private void setDataStructureName(String path) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setDataStructureName(String path)", new Object[0]);
        if (path != null && !path.isEmpty()) {
            String[] currentItems = this.dataStructureField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.dataStructureField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.dataStructureField.select(selectionIndex);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setDataStructureName(String path)", new Object[0]);
    }

    private void setMappingName(String mappingName) throws ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setMappingName(String mappingName)", new Object[0]);
        if (mappingName.length() > 0) {
            String[] currentItems = this.mappingNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(mappingName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = mappingName;
                this.mappingNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.mappingNameField.select(selectionIndex);
            this.populateCaseCombo();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setMappingName(String mappingName)", new Object[0]);
    }

    private void setCaseName(String caseName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setCaseName(String mappingName)", new Object[0]);
        if (caseName.length() > 0) {
            String[] currentItems = this.caseNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(caseName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = caseName;
                this.caseNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.caseNameField.select(selectionIndex);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setCaseName(String mappingName)", new Object[0]);
    }

    private void populateSegmentCombo() throws ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateSegmentCombo()", new Object[0]);
        Vector segments = this.controller.getSegmentModels();
        Vector<String> segmentNames = new Vector<String>();
        for (SegmentModel sgmt : segments) {
            DBDConstants dbdAccessType = sgmt.getDbdModel().getAccessType();
            if (sgmt.isVirtualLogicalChild()) continue;
            if (dbdAccessType == DBDConstants.GSAM) {
                segmentNames.add(sgmt.getName());
                continue;
            }
            segmentNames.add(sgmt.getImsName());
        }
        this.segmentNameField.setItems(segmentNames.toArray(new String[segmentNames.size()]));
        DBDConstants dbdAccessType = this.controller.getSegment().getDbdModel().getAccessType();
        if (dbdAccessType == DBDConstants.GSAM) {
            this.segmentNameField.setText(this.controller.getSegment().getName());
        } else {
            this.segmentNameField.setText(this.controller.getSegment().getImsName());
        }
        this.populateMappingCombo();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateSegmentCombo()", new Object[0]);
    }

    private void populateMappingCombo() throws ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateMappingCombo()", new Object[0]);
        if (!this.segmentNameField.getText().isEmpty()) {
            SegmentModel segmentModel = this.controller.getExistingSegmentModel(this.segmentNameField.getText());
            Iterator iterator = segmentModel.getMappingList();
            if (iterator.hasNext()) {
                this.addMapCaseWidgets();
                this.mappingNameField.removeAll();
                this.mappingNameField.add(ManageFieldWizardPage1.COMMON_FIELDS);
                while (iterator.hasNext()) {
                    MappingModel mappingModel = (MappingModel)iterator.next();
                    this.mappingNameField.add(mappingModel.getName());
                }
                this.mappingNameField.select(0);
                if (this.caseNameField != null) {
                    this.populateCaseCombo();
                }
            } else {
                this.disposeMapCaseWidgets();
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateMappingCombo()", new Object[0]);
    }

    private void populateCaseCombo() throws ModelException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateCaseCombo()", new Object[0]);
        this.caseNameField.setItems(new String[0]);
        if (!this.mappingNameField.getText().equals(ManageFieldWizardPage1.COMMON_FIELDS)) {
            SegmentModel segmentModel = this.controller.getExistingSegmentModel(this.segmentNameField.getText());
            MappingModel mappingModel = segmentModel.getMapping(this.mappingNameField.getText());
            Vector<String> caseNames = new Vector<String>();
            if (mappingModel != null) {
                Iterator iterator = mappingModel.getMappingCases();
                while (iterator.hasNext()) {
                    MappingCaseModel caseModel = (MappingCaseModel)iterator.next();
                    caseNames.add(caseModel.getName());
                }
            }
            if (caseNames.size() > 0) {
                String[] items = new String[caseNames.size()];
                int i = 0;
                while (i < caseNames.size()) {
                    items[i] = (String)caseNames.get(i);
                    ++i;
                }
                this.caseNameField.setItems(items);
                if (this.caseNameField.getItemCount() == 1) {
                    this.caseNameField.select(0);
                }
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateCaseCombo()", new Object[0]);
    }

    private void populateFileCombo() throws FileNotFoundException, PermissionDeniedException, ConnectionException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateFileCombo(String)", new Object[0]);
        this.fileNameField.removeAll();
        String[] memberNameList = null;
        String folderPath = this.folderNameField.getText();
        if (folderPath != null) {
            folderPath = folderPath.trim();
        }
        if (this.controller.isLocalImport()) {
            File folder = new File(folderPath);
            if (folder != null && folder.exists()) {
                File[] allFiles = folder.listFiles();
                if (allFiles != null) {
                    Vector<String> fileNames = new Vector<String>(allFiles.length);
                    int i = 0;
                    while (i < allFiles.length) {
                        if (allFiles[i].isFile()) {
                            String currentFileName = allFiles[i].getName();
                            fileNames.add(currentFileName);
                        }
                        ++i;
                    }
                    memberNameList = fileNames.toArray(new String[fileNames.size()]);
                } else {
                    this.setMessage(WorkbenchPlugin.errors.getString("IMPORT_ERR_01"), 2);
                }
            }
        } else {
            DataSet dataSet;
            IConnectionService connService = ConnectionsPlugin.getDefault().getConnectionService();
            IZOSConnectable zosConn = (IZOSConnectable)connService.getConnectable("com.ibm.cics.zos.comm.connection");
            if (zosConn != null && zosConn.isConnected() && folderPath != null && !folderPath.isEmpty() && (dataSet = zosConn.getDataSet(folderPath)) instanceof PartitionedDataSet) {
                PartitionedDataSet pds = (PartitionedDataSet)dataSet;
                Vector<Member> memberVector = null;
                if (!this.controller.pdsAlreadyInList(pds)) {
                    memberVector = new Vector<Member>();
                }
                List memberList = zosConn.getMembers(pds);
                memberNameList = new String[memberList.size()];
                int i = 0;
                while (i < memberList.size()) {
                    Member currMember = (Member)memberList.get(i);
                    memberNameList[i] = currMember.getName();
                    if (memberVector != null) {
                        memberVector.add(currMember);
                    }
                    ++i;
                }
                if (memberVector != null) {
                    this.controller.addPdsAndMembers(pds, memberVector);
                }
            }
        }
        if (memberNameList != null && memberNameList.length > 0) {
            Arrays.sort(memberNameList);
            this.fileNameField.setItems(memberNameList);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateFileCombo(String)", new Object[0]);
    }

    public static String removeFileExt(String name) {
        int marker = name.indexOf(COBOL_PERIOD);
        if (marker > -1) {
            return name.substring(0, marker);
        }
        return name;
    }

    public static String getShortFileName(String fullPath) {
        String shortFileName = null;
        int index = fullPath.lastIndexOf(File.separator);
        if (index > 0) {
            shortFileName = fullPath.substring(index + 1);
        }
        return shortFileName;
    }

    private boolean hascobolcontent(ByteArrayOutputStream baos) throws IOException {
        if (baos == null) {
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(is);
        boolean retVal = this.hasCobolContent(dis);
        dis.close();
        is.close();
        return retVal;
    }

    private boolean hasPliContent(ByteArrayOutputStream baos) throws IOException {
        if (baos == null) {
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(is);
        boolean retVal = this.hasPliContent(dis);
        dis.close();
        is.close();
        return retVal;
    }

    private boolean hasCobolContent(DataInputStream dis) throws IOException {
        String currentLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(dis));
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.indexOf(COBOL_PIC) < 0 && currentLine.indexOf(COBOL_PICTURE) < 0 && currentLine.indexOf(COBOL_COPY) < 0 || !currentLine.endsWith(COBOL_PERIOD)) continue;
            br.close();
            return true;
        }
        br.close();
        return false;
    }

    private boolean hasPliContent(DataInputStream dis) throws IOException {
        String currentLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(dis));
        while ((currentLine = br.readLine()) != null) {
            if ((currentLine = currentLine.toUpperCase()).indexOf(PLI_DCL) < 0 && currentLine.indexOf(PLI_DECLARE) < 0 && currentLine.indexOf(PLI_INCLUDE) < 0 || currentLine.indexOf(PLI_COMMA) <= 0) continue;
            br.close();
            return true;
        }
        br.close();
        return false;
    }

    private ImportDataStructureWizard getWiz() {
        return (ImportDataStructureWizard)this.getWizard();
    }

    protected Table getAssociationTable() {
        return this.associationTable;
    }

    private void addMapCaseWidgets() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "addMapCaseWidgets()", new Object[0]);
        if (this.mapLabel != null) {
            return;
        }
        FormData fd = this.uih.genFormData(new FormAttachment((Control)this.dataStructureField, 17), null, this.rightColumnLabelStart1, null);
        this.mapLabel = new Label((Composite)this.associationGroup, 0);
        this.mapLabel.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_10") + WorkbenchPlugin.colon.getString("COLON"));
        this.mapLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB450"));
        this.mapLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.dataStructureField, 15), null, this.rightColumnComboStart1, this.rightColumnComboEnd1);
        fd.width = Utility.getTextWidth((Composite)this.associationGroup, 0, ManageFieldWizardPage1.COMMON_FIELDS);
        this.mappingNameField = new Combo((Composite)this.associationGroup, 2056);
        this.mappingNameField.setLayoutData((Object)fd);
        this.mappingNameField.setEnabled(false);
        fd = this.uih.genFormData(new FormAttachment((Control)this.mappingNameField, 17), null, this.rightColumnLabelStart1, null);
        this.caseLabel = new Label((Composite)this.associationGroup, 0);
        this.caseLabel.setText(WorkbenchPlugin.labels.getString("MANAGE_MAPPING_11") + WorkbenchPlugin.colon.getString("COLON"));
        this.caseLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB451"));
        this.caseLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.mappingNameField, 15), null, this.rightColumnComboStart1, this.rightColumnComboEnd1);
        fd.width = Utility.getTextWidth((Composite)this.associationGroup, 0, ManageFieldWizardPage1.COMMON_FIELDS);
        this.caseNameField = new Combo((Composite)this.associationGroup, 2056);
        this.caseNameField.setLayoutData((Object)fd);
        this.caseNameField.setEnabled(false);
        this.associationGroup.layout();
        this.parent.layout();
        this.addMapCaseListeners();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "addMapCaseWidgets()", new Object[0]);
    }

    private void disposeMapCaseWidgets() {
        this.disposeWidget((Control)this.mapLabel);
        this.mapLabel = null;
        this.disposeWidget((Control)this.mappingNameField);
        this.mappingNameField = null;
        this.disposeWidget((Control)this.caseLabel);
        this.caseLabel = null;
        this.disposeWidget((Control)this.caseNameField);
        this.caseNameField = null;
        this.associationGroup.layout();
        this.parent.layout();
    }

    private void disposeWidget(Control control) {
        if (control != null) {
            control.dispose();
        }
    }

    public void modifyText(ModifyEvent event) {
        try {
            if (event.widget == this.fileNameField) {
                this.updateFromFileField();
            } else if (event.widget == this.segmentNameField) {
                this.segmentNameField.setToolTipText(WorkbenchPlugin.labels.getString("IMSNAME_LBL") + WorkbenchPlugin.colon.getString("COLON") + " " + this.getSegmentIMSName(this.segmentNameField.getText()));
                this.updateFromSegmentField();
            } else if (event.widget == this.segmentTextField) {
                this.updateFromSegmentTextField();
            } else if (event.widget == this.importFromField) {
                this.updateImportFromField();
            } else if (event.widget == this.sourceTypeField) {
                this.updateSourceTypeField();
            } else if (event.widget == this.folderNameField) {
                this.updateFromFolderField();
            } else if (event.widget == this.dataStructureField) {
                this.updateFromDataStructureField();
            } else if (event.widget == this.mappingNameField) {
                this.updateFromMappingField();
            } else if (event.widget == this.caseNameField) {
                this.updateFromCaseField();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
    }

    private String getSegmentIMSName(String selectedSegment) {
        Vector segments = this.controller.getSegmentModels();
        for (SegmentModel sgmt : segments) {
            if (sgmt.isVirtualLogicalChild() || !selectedSegment.equals(sgmt.getName())) continue;
            return sgmt.getImsName();
        }
        return "";
    }

    private void restoreFolderValues() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "restoreFolderValues()", new Object[0]);
        this.folderNameField.removeAll();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LOCAL_SOURCE_NAMES_ID);
            if (!this.controller.isLocalImport()) {
                sourceNames = settings.getArray(STORE_HOST_SOURCE_NAMES_ID);
            }
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                if (!sourceNames[i].isEmpty()) {
                    this.folderNameField.add(sourceNames[i]);
                }
                ++i;
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "restoreFolderValues()", new Object[0]);
    }

    private void saveFolderValues() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "saveFolderValues()", new Object[0]);
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LOCAL_SOURCE_NAMES_ID);
            if (!this.controller.isLocalImport()) {
                sourceNames = settings.getArray(STORE_HOST_SOURCE_NAMES_ID);
            }
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = Utility.addToHistory(sourceNames, this.folderNameField.getText());
            if (!this.controller.isLocalImport()) {
                settings.put(STORE_HOST_SOURCE_NAMES_ID, sourceNames);
            } else {
                settings.put(STORE_LOCAL_SOURCE_NAMES_ID, sourceNames);
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "saveFolderValues()", new Object[0]);
    }

    protected IDialogSettings getDialogSettings() {
        return Utility.getDialogSettings("ImportDataStructureWizard.STORE_IMPORT_DATA_STRUCTURE_ID");
    }

    protected static String getImporterFileType(String fileType) {
        if (fileType.equals(ImportDsToDbdController.fileTypes[0])) {
            return "DS";
        }
        if (fileType.equals(ImportDsToDbdController.fileTypes[1])) {
            return "FP";
        }
        if (fileType.equals(ImportDsToDbdController.fileTypes[2])) {
            return String.valueOf(1);
        }
        if (fileType.equals(ImportDsToDbdController.fileTypes[3])) {
            return String.valueOf(0);
        }
        return null;
    }

    class ValidExtension
    implements FilenameFilter {
        String[] ext;

        public ValidExtension(String[] ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            int i = 0;
            while (i < this.ext.length) {
                if (name.toLowerCase().endsWith(this.ext[i].toLowerCase())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

