/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importds;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportDsToDbdController;
import com.ibm.im.ims.workbench.controller.importer.datastructure.InformationException;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.utilities.MessageDialogRunner;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.utilities.Warnings;
import com.ibm.im.ims.workbench.wizard.importds.ImportDataStructureWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ImportDataStructureWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    protected static final String STORE_IMPORT_DATA_STRUCTURE_ID = "ImportDataStructureWizard.STORE_IMPORT_DATA_STRUCTURE_ID";
    private static final String STORE_LAST_FOLDER_ID = "ImportDataStructureWizard.STORE_LAST_FOLDER_ID";
    private static final String STORE_LAST_SOURCE_TYPE_ID = "ImportDataStructureWizard.STORE_LAST_SOURCE_TYPE_ID";
    private static final String STORE_LAST_SOURCE_LANGUAGE_ID = "ImportDataStructureWizard.STORE_LAST_SOURCE_LANGUAGE_ID";
    private ImportDsToDbdController controller;
    private ImportDataStructureWizardPage page;
    private Vector<InformationException> informationExceptionList;
    private ResourceEditorPage editor;

    public ImportDataStructureWizard(ImportDsToDbdController controller, ResourceEditorPage editor) {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB496"));
        this.controller = controller;
        this.restoreWidgetValues();
        this.setNeedsProgressMonitor(false);
        this.editor = editor;
    }

    public boolean canFinish() {
        return this.page.isPageComplete();
    }

    public void addPages() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "addPages()", new Object[0]);
        try {
            this.page = new ImportDataStructureWizardPage(this.controller, this.editor);
            this.addPage((IWizardPage)this.page);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "addPages()", new Object[0]);
    }

    public boolean performFinish() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        try {
            this.saveWidgetValues();
            boolean isDirty = this.controller.doFinishModel();
            if (this.editor != null) {
                this.editor.getPsbMultiPageEditor().setDirty(isDirty);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        return true;
    }

    public String getProjectName() {
        return this.controller.getProjectName();
    }

    private void buildInformationExceptionList4SelectedItems(Vector<InformationException> informationExceptionList, Table associationTable) {
        if (informationExceptionList != null) {
            for (InformationException currException : informationExceptionList) {
                List currResourceList = currException.getResourceList();
                if (currResourceList == null) continue;
                int length = currResourceList.size();
                int j = 0;
                while (j < length) {
                    String search;
                    boolean selected = false;
                    String currResource = (String)currResourceList.get(j);
                    int k = currResource.indexOf(search = ":");
                    if (k != -1) {
                        String dataStructureName = currResource.substring(0, k);
                        int i = 0;
                        while (i < associationTable.getItemCount() && !selected) {
                            TableItem item = associationTable.getItem(i);
                            if (item.getText(1).equals(dataStructureName)) {
                                selected = true;
                            }
                            ++i;
                        }
                        if (!selected) {
                            currResourceList.remove(j);
                        }
                    }
                    ++j;
                }
            }
        }
    }

    private void informationExceptionHandling(Vector<InformationException> informationExceptionList) {
        StringBuffer buf = new StringBuffer();
        if (informationExceptionList != null && informationExceptionList.size() > 0) {
            int i = 0;
            while (i < informationExceptionList.size()) {
                InformationException currException = informationExceptionList.get(i);
                if (currException.getResourceList() != null) {
                    buf.append(currException.getMessage());
                    List resourceList = informationExceptionList.get(i).getResourceList();
                    if (resourceList != null) {
                        int j = 0;
                        while (j < resourceList.size()) {
                            String ds = (String)resourceList.get(j);
                            buf.append(ds);
                            buf.append("\n");
                            ++j;
                        }
                    }
                    buf.append("\n\n");
                }
                ++i;
            }
            try {
                IPreferenceStore store2 = WorkbenchPlugin.getDefault().getPreferenceStore();
                if (!store2.getBoolean("explorer_wizard_skip_warning_flag")) {
                    Warnings warnings = new Warnings(this.getShell(), WorkbenchPlugin.errors.getString("EISRC25"), null, WorkbenchPlugin.errors.getString("IMPORT_ERR_12"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    warnings.setWarnings(buf.toString());
                    MessageDialogRunner runner = new MessageDialogRunner(warnings);
                    this.getShell().getDisplay().asyncExec((Runnable)runner);
                }
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "informationExceptionHandling", e);
                logger.error(e);
            }
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String lastDirectory = settings.get(STORE_LAST_FOLDER_ID);
            boolean isLocalSource = settings.getBoolean(STORE_LAST_SOURCE_TYPE_ID);
            String fileType = settings.get(STORE_LAST_SOURCE_LANGUAGE_ID);
            if (fileType == null) {
                isLocalSource = true;
                fileType = ImportDsToDbdController.fileTypes[0];
            }
            this.controller.setLastDirectory(lastDirectory);
            this.controller.setLocalImport(isLocalSource);
            this.controller.setFileType(fileType);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_LAST_FOLDER_ID, this.controller.getLastDirectory());
            settings.put(STORE_LAST_SOURCE_TYPE_ID, this.controller.isLocalImport());
            settings.put(STORE_LAST_SOURCE_LANGUAGE_ID, this.controller.getFileType());
        }
    }

    public IDialogSettings getDialogSettings() {
        return Utility.getDialogSettings(STORE_IMPORT_DATA_STRUCTURE_ID);
    }
}

