/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.importds;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.importer.datastructure.ImportDsToDbdController;
import com.ibm.im.ims.workbench.controller.importer.datastructure.InformationException;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportDSExceptionDialog
extends Dialog
implements Listener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    String dialogTitle;
    String[] dialogButtonLabels;
    int defaultIndex;
    private static final int margin = 5;
    private Label messageLbl;
    private Label fileTypeLbl;
    private Label requireFileLabel;
    private Label imageLbl;
    private Combo fileTypeCombo;
    private Button reParse;
    private Text sourceFile;
    private Text parseError;
    private UIHelper uih;
    private ImportDsToDbdController controller;
    private ArrayList<SegmentModel> segModels;
    private Vector<InformationException> parsingInformationExceptionList;
    private static final String SUCCESS_MSG = WorkbenchPlugin.labels.getString("SUCCESSFUL");
    private static final String REPARSE_BUTTON = WorkbenchPlugin.labels.getString("REPARSE_BUTTON");

    public ImportDSExceptionDialog(Shell parentShell, String dialogTitle, ImportDsToDbdController controller) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
        this.controller = controller;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite dialogParent) {
        Composite parent = null;
        try {
            parent = (Composite)super.createDialogArea(dialogParent);
            GridData gd = new GridData(4, 4, true, true, 1, 1);
            parent.setLayoutData((Object)gd);
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 5;
            parent.setLayout((Layout)formLayout);
            this.uih = new UIHelper();
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormData fd_img = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment(0, 10), null);
            this.imageLbl = new Label(parent, 64);
            this.imageLbl.setImage(display.getSystemImage(1));
            this.imageLbl.setLayoutData((Object)fd_img);
            FormData fd_msg = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment((Control)this.imageLbl, 10), new FormAttachment(100, -5));
            this.messageLbl = new Label(parent, 64);
            String fileName = this.controller.getParseFileName();
            String newFileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
            Object[] inserts = new Object[]{newFileName.lastIndexOf(".") >= 0 ? newFileName.substring(0, newFileName.lastIndexOf(".")) : newFileName};
            if (this.controller.isLocalImport()) {
                FALSE_MSG = WorkbenchPlugin.errors.getString("IMPORT_ERR_14a", inserts);
                this.setMessageLbl(FALSE_MSG, true);
            } else {
                FALSE_MSG = WorkbenchPlugin.errors.getString("IMPORT_ERR_14", inserts);
                this.setMessageLbl(FALSE_MSG, true);
            }
            this.imageLbl.setLayoutData((Object)fd_img);
            this.messageLbl.setLayoutData((Object)fd_msg);
            FormData fd0 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment(0, 0), null);
            this.requireFileLabel = this.uih.genRequiredSymbol(parent, 0, fd0, parent.getDisplay().getSystemColor(3));
            FormData fd1 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment((Control)this.requireFileLabel, 5), null);
            this.fileTypeLbl = new Label(parent, 0);
            this.fileTypeLbl.setText(WorkbenchPlugin.labels.getString("WB496T"));
            this.fileTypeLbl.setToolTipText(WorkbenchPlugin.labels.getString("WB496T"));
            this.fileTypeLbl.setLayoutData((Object)fd1);
            FormData fd2 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment((Control)this.fileTypeLbl, 20), null);
            this.fileTypeCombo = new Combo(parent, 2056);
            this.fileTypeCombo.setLayoutData((Object)fd2);
            this.fileTypeCombo.setItems(ImportDsToDbdController.fileTypes);
            String importLanguage = this.controller.getFileType();
            this.fileTypeCombo.setText(importLanguage);
            this.fileTypeCombo.setToolTipText(importLanguage);
            this.fileTypeCombo.addModifyListener((ModifyListener)this);
            FormData fd3 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment((Control)this.fileTypeCombo, 20), null);
            this.reParse = new Button(parent, 8);
            this.reParse.setText(REPARSE_BUTTON);
            this.reParse.setToolTipText(REPARSE_BUTTON);
            this.reParse.setLayoutData((Object)fd3);
            this.reParse.setEnabled(true);
            this.reParse.addListener(13, (Listener)this);
            FormData fd4 = this.uih.genFormData(new FormAttachment((Control)this.fileTypeCombo, 25), new FormAttachment((Control)this.fileTypeCombo, 200), new FormAttachment(0, 0), new FormAttachment(100, -5));
            Group srcGroup = new Group(parent, 0);
            srcGroup.setText(WorkbenchPlugin.labels.getString("SOURCE_CONTENT"));
            srcGroup.setToolTipText(WorkbenchPlugin.labels.getString("SOURCE_CONTENT"));
            srcGroup.setLayoutData((Object)fd4);
            srcGroup.setLayout((Layout)new FillLayout());
            this.sourceFile = new Text((Composite)srcGroup, 2890);
            this.sourceFile.setBackground(this.getShell().getDisplay().getSystemColor(1));
            this.sourceFile.setText("");
            FormData fd5 = this.uih.genFormData(new FormAttachment((Control)srcGroup, 25), new FormAttachment((Control)srcGroup, 320), new FormAttachment(0, 0), new FormAttachment(100, -5));
            Group errGroup = new Group(parent, 0);
            errGroup.setText(WorkbenchPlugin.labels.getString("PARSE_ERROR"));
            errGroup.setToolTipText(WorkbenchPlugin.labels.getString("PARSE_ERROR"));
            errGroup.setLayoutData((Object)fd5);
            errGroup.setLayout((Layout)new FillLayout());
            this.parseError = new Text((Composite)errGroup, 2890);
            this.parseError.setBackground(this.getShell().getDisplay().getSystemColor(1));
            this.setParseErrorMessage(this.controller.getCurrentException().getMessage());
            String parseFileName = this.controller.getParseFileName();
            File parseFile = new File(parseFileName);
            this.setFileContent(this.controller.readFileToString(parseFile));
            parent.pack();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
        return parent;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.fileTypeCombo) {
            this.fileTypeCombo.setToolTipText(this.fileTypeCombo.getText());
            this.updateFileType();
        }
    }

    public void handleEvent(Event event) {
        try {
            if (event.widget == this.reParse) {
                this.handleReParse();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
    }

    private void handleReParse() throws InvocationTargetException, InterruptedException, IOException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleReParse()", new Object[0]);
        this.controller.prepareForReparse();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ImportDSExceptionDialog.this.controller.parseDataStructureSourceFile(monitor);
            }
        };
        new ProgressMonitorDialog(this.getShell()).run(true, false, op);
        Throwable currentException = this.controller.getCurrentException();
        if (currentException != null) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "populateDataStructureComboModel()", currentException);
            String errorMessage = currentException.getMessage();
            this.setParseErrorMessage(errorMessage);
        } else {
            super.okPressed();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleReParse()", new Object[0]);
    }

    protected Vector<InformationException> getInformationExceptionList() {
        return this.parsingInformationExceptionList;
    }

    public void setFileContent(String fileContent) {
        this.sourceFile.setText(fileContent);
    }

    public void setParseErrorMessage(String parseErrorMessage) {
        this.parseError.setText(parseErrorMessage);
    }

    private void updateFileType() {
        String existingFileType = this.controller.getFileType();
        String newFileType = this.fileTypeCombo.getText();
        if (existingFileType == null || !existingFileType.equals(newFileType)) {
            this.controller.setFileType(newFileType);
        }
        this.parseError.setText("");
    }

    private void setMessageLbl(String message, boolean isError) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setMessageLbl(String message, boolean isError)", new Object[0]);
        this.messageLbl.setText(message);
        if (isError) {
            this.imageLbl.setImage(this.imageLbl.getParent().getDisplay().getSystemImage(1));
        } else {
            this.imageLbl.setImage(this.imageLbl.getParent().getDisplay().getSystemImage(2));
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFileType()", new Object[0]);
    }

    public boolean isSuccessful() {
        return this.parseError.getText() != null && this.parseError.getText().length() == 0;
    }

    public ArrayList<SegmentModel> getSegmentModels() {
        return this.segModels;
    }

    protected void okPressed() {
        try {
            this.deleteTempFile();
        }
        catch (Throwable e) {
            logger.error(e);
        }
        super.okPressed();
    }

    public boolean close() {
        try {
            this.deleteTempFile();
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return super.close();
    }

    private void deleteTempFile() {
        this.controller.deleteTempFile();
    }
}

