/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.exportsrc;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.PickList;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.exportsrc.ExportIMSSourceWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class ExportIMSSourceWizardPage2
extends WizardPage
implements Listener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private PickList exportPicklist;
    protected Button[] exportRadios;
    private Button[] targetRadios;
    private Label availColLabel;
    private Label selectedColLabel;
    private List<IFile> availDbd;
    private List<IFile> availPsb;
    private boolean isListDBD = false;
    boolean pageComplete = false;
    public static final String PAGE_NAME = "FTP_EXPORT";
    private String currentProject = "";

    public ExportIMSSourceWizardPage2(String pageName) {
        super(PAGE_NAME);
        this.setTitle(WorkbenchPlugin.labels.getString("WB821"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("export_zos")));
    }

    public void createControl(Composite parent) {
        try {
            this.uih = new UIHelper();
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            this.composite.setLayoutData((Object)fd);
            Group targetTypeGrp = new Group(this.composite, 0);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            FormLayout targetTypeGrpLayout = new FormLayout();
            targetTypeGrpLayout.marginHeight = 5;
            targetTypeGrpLayout.marginWidth = 5;
            targetTypeGrp.setText(WorkbenchPlugin.labels.getString("WB823"));
            targetTypeGrp.setLayout((Layout)targetTypeGrpLayout);
            targetTypeGrp.setLayoutData((Object)fd);
            this.targetRadios = new Button[2];
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.targetRadios[0] = new Button((Composite)targetTypeGrp, 16);
            this.targetRadios[0].setText(WorkbenchPlugin.labels.getString("WB824"));
            this.targetRadios[0].setSelection(false);
            this.targetRadios[0].setLayoutData((Object)fd);
            this.targetRadios[0].addListener(13, (Listener)this);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(50, 0), null);
            this.targetRadios[1] = new Button((Composite)targetTypeGrp, 16);
            this.targetRadios[1].setText(WorkbenchPlugin.labels.getString("WB825"));
            this.targetRadios[1].setSelection(true);
            this.targetRadios[1].setLayoutData((Object)fd);
            this.targetRadios[1].addListener(13, (Listener)this);
            Group resourceTypeGrp = new Group(this.composite, 0);
            fd = this.uih.genFormData(new FormAttachment((Control)targetTypeGrp, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            FormLayout resourceTypeGrpLayout = new FormLayout();
            resourceTypeGrpLayout.marginHeight = 5;
            resourceTypeGrpLayout.marginWidth = 5;
            resourceTypeGrp.setText(WorkbenchPlugin.labels.getString("WB810"));
            resourceTypeGrp.setLayout((Layout)resourceTypeGrpLayout);
            resourceTypeGrp.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.exportRadios = new Button[2];
            this.exportRadios[0] = new Button((Composite)resourceTypeGrp, 16);
            this.exportRadios[0].setText(WorkbenchPlugin.labels.getString("WB811"));
            this.exportRadios[0].setSelection(true);
            this.exportRadios[0].setLayoutData((Object)fd);
            this.exportRadios[0].addListener(13, (Listener)this);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(50, 0), null);
            this.exportRadios[1] = new Button((Composite)resourceTypeGrp, 16);
            this.exportRadios[1].setText(WorkbenchPlugin.labels.getString("WB812"));
            this.exportRadios[1].setSelection(false);
            this.exportRadios[1].setLayoutData((Object)fd);
            this.exportRadios[1].addListener(13, (Listener)this);
            Group picklistGrp = new Group(this.composite, 0);
            FormData indicesfd = this.uih.genFormData(new FormAttachment((Control)resourceTypeGrp, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            FormLayout indicesfl = new FormLayout();
            indicesfl.marginHeight = 5;
            indicesfl.marginWidth = 5;
            picklistGrp.setText(WorkbenchPlugin.labels.getString("WB817"));
            picklistGrp.setLayout((Layout)indicesfl);
            picklistGrp.setLayoutData((Object)indicesfd);
            this.availColLabel = new Label((Composite)picklistGrp, 0);
            this.availColLabel.setText(WorkbenchPlugin.labels.getString("SENSEG_WIZ1") + " " + WorkbenchPlugin.labels.getString("WB815") + WorkbenchPlugin.colon.getString("COLON"));
            this.availColLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)picklistGrp, 15), null, new FormAttachment((Control)picklistGrp, 0, 16384), null);
            this.availColLabel.setLayoutData((Object)fd);
            this.selectedColLabel = new Label((Composite)picklistGrp, 0);
            this.selectedColLabel.setText(WorkbenchPlugin.labels.getString("SENSEG_WIZ2") + " " + WorkbenchPlugin.labels.getString("WB815") + WorkbenchPlugin.colon.getString("COLON"));
            this.exportPicklist = new PickList((Composite)picklistGrp, 268503042, false);
            int lefttButtonNumerator = this.exportPicklist.getSelectedTableLeftNumerator();
            fd = this.uih.genFormData(new FormAttachment((Control)picklistGrp, 15), null, new FormAttachment(lefttButtonNumerator, 0), null);
            this.selectedColLabel.setLayoutData((Object)fd);
            this.exportPicklist.setHeaderVisible(false);
            this.exportPicklist.setLinesVisible(false);
            String[] colNames = new String[]{"resources"};
            this.exportPicklist.setColumns(colNames);
            fd = this.uih.genFormData(new FormAttachment((Control)this.availColLabel, 10, 1024), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            this.exportPicklist.setLayoutData(fd);
            this.getContainer().getShell().setMinimumSize(300, 500);
            this.registerListeners();
            this.setControl((Control)this.composite);
            this.setErrorMessage(null);
            this.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            String newProject = this.getWiz().getProjectName();
            if (!newProject.equalsIgnoreCase(this.currentProject)) {
                this.currentProject = newProject;
                this.initPickList();
            }
        }
        catch (Throwable t) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", t);
            logger.error(t);
        }
    }

    private void initDBDPickList() throws CoreException {
        this.exportPicklist.handleRemove(true);
        Object selectedItems = null;
        ArrayList<String> availableDbdNames = new ArrayList<String>();
        this.availDbd = this.targetRadios[0].getSelection() ? (ArrayList)ProjectTreeFileHelper.getGenedSrcDbdList((String)this.getWiz().getProjectName()) : (ArrayList)ProjectTreeFileHelper.getGenedSrcCatalogDbdList((String)this.getWiz().getProjectName());
        for (IFile tempFile : this.availDbd) {
            availableDbdNames.add(tempFile.getName());
        }
        if (availableDbdNames != null) {
            int i;
            Vector<String> availToRemove = new Vector<String>();
            for (String currAvail : availableDbdNames) {
                if (selectedItems == null) continue;
                i = 0;
                while (i < (selectedItems).length) {
                    if (currAvail.equalsIgnoreCase((String)selectedItems[i][0])) {
                        availToRemove.add(currAvail);
                    }
                    ++i;
                }
            }
            int i2 = 0;
            while (i2 < availToRemove.size()) {
                availableDbdNames.remove(availToRemove.get(i2));
                ++i2;
            }
            int numAvail = availableDbdNames.size();
            Object[][] availableItems = new Object[numAvail][1];
            i = 0;
            while (i < numAvail) {
                availableItems[i][0] = availableDbdNames.get(i);
                ++i;
            }
            this.exportPicklist.setAvailableItems(availableItems);
            this.isListDBD = true;
        }
    }

    private void initPickList() throws CoreException {
        if (this.exportRadios[0].getSelection()) {
            this.initPSBPickList();
        } else if (this.exportRadios[1].getSelection()) {
            this.initDBDPickList();
        }
    }

    private void initPSBPickList() throws CoreException {
        this.exportPicklist.handleRemove(true);
        Object selectedItems = null;
        ArrayList<String> availablePSBNames = new ArrayList<String>();
        this.availPsb = (ArrayList)ProjectTreeFileHelper.getGenedSrcPsbList((String)this.getWiz().getProjectName());
        for (IFile tempFile : this.availPsb) {
            availablePSBNames.add(tempFile.getName());
        }
        if (availablePSBNames != null) {
            int i;
            Vector<String> availToRemove = new Vector<String>();
            for (String currAvail : availablePSBNames) {
                if (selectedItems == null) continue;
                i = 0;
                while (i < (selectedItems).length) {
                    if (currAvail.equalsIgnoreCase((String)selectedItems[i][0])) {
                        availToRemove.add(currAvail);
                    }
                    ++i;
                }
            }
            int i2 = 0;
            while (i2 < availToRemove.size()) {
                availablePSBNames.remove(availToRemove.get(i2));
                ++i2;
            }
            int numAvail = availablePSBNames.size();
            Object[][] availableItems = new Object[numAvail][1];
            i = 0;
            while (i < numAvail) {
                availableItems[i][0] = availablePSBNames.get(i);
                ++i;
            }
            this.exportPicklist.setAvailableItems(availableItems);
            this.isListDBD = false;
        }
    }

    public boolean isListDBD() {
        return this.isListDBD;
    }

    public List<IFile> getAvailableDBDs() {
        return this.availDbd;
    }

    public List<IFile> getAvailablePSBs() {
        return this.availPsb;
    }

    private void registerListeners() {
        this.exportPicklist.addModifyListener(this);
    }

    public TableItem[] getSelectedFiles() {
        return this.exportPicklist.getSelectedItems();
    }

    ExportIMSSourceWizard getWiz() {
        return (ExportIMSSourceWizard)this.getWizard();
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.exportPicklist) {
            this.setPageComplete(this.validatePage());
        }
    }

    public boolean validatePage() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[0]);
        boolean retVal = false;
        if (this.exportPicklist.getSelectedItems().length > 0) {
            retVal = true;
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[]{retVal});
        return retVal;
    }

    public void handleEvent(Event event) {
        try {
            if (event.widget == this.exportRadios[0]) {
                if (this.exportRadios[0].getSelection()) {
                    this.availColLabel.setText(WorkbenchPlugin.labels.getString("SENSEG_WIZ1") + " " + WorkbenchPlugin.labels.getString("WB815") + WorkbenchPlugin.colon.getString("COLON"));
                    this.selectedColLabel.setText(WorkbenchPlugin.labels.getString("SENSEG_WIZ2") + " " + WorkbenchPlugin.labels.getString("WB815") + WorkbenchPlugin.colon.getString("COLON"));
                    this.initPSBPickList();
                }
            } else if (event.widget == this.exportRadios[1]) {
                if (this.exportRadios[1].getSelection()) {
                    this.availColLabel.setText(WorkbenchPlugin.labels.getString("SENSEG_WIZ1") + " " + WorkbenchPlugin.labels.getString("WB816") + WorkbenchPlugin.colon.getString("COLON"));
                    this.selectedColLabel.setText(WorkbenchPlugin.labels.getString("SENSEG_WIZ2") + " " + WorkbenchPlugin.labels.getString("WB816") + WorkbenchPlugin.colon.getString("COLON"));
                    this.initDBDPickList();
                }
            } else if (event.widget == this.targetRadios[0] && this.exportRadios[1].getSelection()) {
                this.initDBDPickList();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(final Event event)", e);
            logger.error(e);
        }
    }
}

