/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.exportsrc;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.model.PermissionDeniedException;
import com.ibm.cics.zos.model.UpdateFailedException;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.dialogs.ConfirmationDialog;
import com.ibm.im.ims.workbench.project.wizard.IMSWorkbenchNewProjectWizardPage;
import com.ibm.im.ims.workbench.utilities.MessageDialogRunner;
import com.ibm.im.ims.workbench.wizard.exportsrc.ExportDataSetWizardPage3;
import com.ibm.im.ims.workbench.wizard.exportsrc.ExportIMSSourceWizardPage2;
import com.ibm.im.ims.workbench.wizard.exportsrc.ExporterException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ExportIMSSourceWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IMSWorkbenchNewProjectWizardPage wbNewProjectPage;
    private ExportIMSSourceWizardPage2 exportIMSSourcePage2;
    private ExportDataSetWizardPage3 exportDataSetWizardPage3;
    private IStructuredSelection selection;
    private ArrayList<IFile> resourcesToSend;
    private ExportDataSetRunnable exporter;
    String containerName = null;
    boolean interrupted = false;
    private Object[] confirmationExport;
    private int exportReturnCode = 0;
    public static final int NUM_WORKED_SEARCH_REF_PER_FILE = 100;
    public static final int NUM_WORKED_PARSE_PER_FILE = 100;

    public ExportIMSSourceWizard() {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB818"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        try {
            this.wbNewProjectPage = new IMSWorkbenchNewProjectWizardPage("page1", this.selection);
            this.exportIMSSourcePage2 = new ExportIMSSourceWizardPage2("page3");
            this.exportDataSetWizardPage3 = new ExportDataSetWizardPage3();
            this.addPage((IWizardPage)this.wbNewProjectPage);
            this.addPage((IWizardPage)this.exportIMSSourcePage2);
            this.addPage((IWizardPage)this.exportDataSetWizardPage3);
            this.wbNewProjectPage.setUsage(1);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.exportIMSSourcePage2.isPageComplete() && this.exportDataSetWizardPage3.isPageComplete()) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public boolean performFinish() {
        boolean success = true;
        try {
            ArrayList imsResources = this.exportIMSSourcePage2.isListDBD() ? (ArrayList)this.exportIMSSourcePage2.getAvailableDBDs() : (ArrayList)this.exportIMSSourcePage2.getAvailablePSBs();
            TableItem[] selectedItems = this.exportIMSSourcePage2.getSelectedFiles();
            this.resourcesToSend = this.prepareList(imsResources, selectedItems);
            this.exporter = new ExportDataSetRunnable();
            Shell activeShell = this.getContainer().getShell();
            this.interrupted = false;
            new ProgressMonitorDialog(activeShell).run(true, true, (IRunnableWithProgress)this.exporter);
            if (this.interrupted) {
                success = false;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return success;
    }

    private ArrayList<IFile> prepareList(ArrayList<IFile> imsResources, TableItem[] items) {
        ArrayList<IFile> resourcesToSend = new ArrayList<IFile>();
        Iterator<IFile> iter = imsResources.iterator();
        int i = 0;
        while (i < items.length) {
            TableItem currItem = items[i];
            while (iter.hasNext()) {
                IFile temp = iter.next();
                if (!currItem.getText().equalsIgnoreCase(temp.getName())) continue;
                resourcesToSend.add(temp);
                break;
            }
            ++i;
        }
        return resourcesToSend;
    }

    public String getProjectName() {
        if (this.containerName == null) {
            this.containerName = this.wbNewProjectPage.getProjectName();
        }
        return this.containerName;
    }

    public boolean performCancel() {
        try {
            this.dispose();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performCancel()", e);
            logger.error(e);
        }
        return true;
    }

    public void init(IWorkbench wb, IStructuredSelection selection) {
        this.selection = selection;
    }

    class ExportDataSetRunnable
    implements IRunnableWithProgress {
        ExportDataSetRunnable() {
        }

        public void run(IProgressMonitor monitor) {
            try {
                this.runFunc(monitor);
            }
            catch (InterruptedException interruptedException) {
                ExportIMSSourceWizard.this.interrupted = true;
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "run(IProgressMonitor monitor)", e);
                logger.error(e);
            }
        }

        public void runFunc(IProgressMonitor monitor) throws InterruptedException, ExporterException, CoreException, ConnectionException {
            PartitionedDataSet pds = (PartitionedDataSet)ExportIMSSourceWizard.this.exportDataSetWizardPage3.getSelectedItem();
            ArrayList<IFile> resources = ExportIMSSourceWizard.this.resourcesToSend;
            IZOSConnectable zOSConnectable = ExportIMSSourceWizard.this.exportDataSetWizardPage3.zOSConnectable;
            boolean exportAll = false;
            String memberName = null;
            boolean memberFound = true;
            try {
                Iterator iter = resources.iterator();
                monitor.beginTask(WorkbenchPlugin.labels.getString("WB819") + WorkbenchPlugin.colon.getString("COLON") + String.valueOf(resources.get(0)), resources.size() * 200);
                while (iter.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    memberFound = true;
                    IFile temp = (IFile)iter.next();
                    memberName = temp.getName();
                    monitor.setTaskName(WorkbenchPlugin.labels.getString("WB819") + WorkbenchPlugin.colon.getString("COLON") + memberName);
                    Member newMemberToCreate = new Member(pds.getFullPath(), memberName, zOSConnectable);
                    try {
                        zOSConnectable.getDataSetMember(pds, memberName);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        memberFound = false;
                        zOSConnectable.save((DataEntry)newMemberToCreate, temp.getContents());
                    }
                    if (memberFound && !exportAll) {
                        ExportIMSSourceWizard.this.confirmationExport = new Object[2];
                        ExportIMSSourceWizard.this.confirmationExport[0] = memberName;
                        ExportIMSSourceWizard.this.confirmationExport[1] = pds.getFullPath();
                        ExportIMSSourceWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ConfirmationDialog cd = new ConfirmationDialog(ExportIMSSourceWizard.this.getShell(), WorkbenchPlugin.errors.getString("DIALOG003", ((ExportDataSetRunnable)ExportDataSetRunnable.this).ExportIMSSourceWizard.this.confirmationExport), "DIALOG002");
                                ((ExportDataSetRunnable)ExportDataSetRunnable.this).ExportIMSSourceWizard.this.exportReturnCode = cd.open();
                            }
                        });
                        if (ExportIMSSourceWizard.this.exportReturnCode == 4) {
                            exportAll = true;
                        }
                        if (exportAll || ExportIMSSourceWizard.this.exportReturnCode == 2) {
                            zOSConnectable.save((DataEntry)newMemberToCreate, temp.getContents());
                        }
                    }
                    monitor.worked(100);
                }
            }
            catch (UpdateFailedException e) {
                Object[] error = new String[]{memberName, pds.getFullPath()};
                ExporterException db = new ExporterException(WorkbenchPlugin.errors.getString("DHB1755", error));
                db.initCause(e);
                logger.throwing(this.getClass().getName(), "runFunc(IProgressMonitor monitor) ", (Throwable)db);
                String errorMsg = WorkbenchPlugin.errors.getString("DHB1755", error) + WorkbenchPlugin.colon.getString("COLON") + "\n" + e.getMessage();
                try {
                    MessageDialog infoDialog = new MessageDialog(ExportIMSSourceWizard.this.getShell(), WorkbenchPlugin.errors.getString("DHB1703"), null, errorMsg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    MessageDialogRunner runner = new MessageDialogRunner(infoDialog);
                    ExportIMSSourceWizard.this.getShell().getDisplay().asyncExec((Runnable)runner);
                }
                catch (Throwable ex) {
                    logger.throwing(this.getClass().getName(), "run()", ex);
                    logger.error((Throwable)e);
                }
                throw db;
            }
            catch (PermissionDeniedException e) {
                Object[] error = new String[]{memberName, pds.getFullPath()};
                ExporterException db = new ExporterException(WorkbenchPlugin.errors.getString("DHB1756", error));
                db.initCause(e);
                logger.throwing(this.getClass().getName(), "runFunc(IProgressMonitor monitor) ", (Throwable)db);
                String errorMsg = WorkbenchPlugin.errors.getString("DHB1756", error) + WorkbenchPlugin.colon.getString("COLON") + "\n" + e.getMessage();
                try {
                    MessageDialog infoDialog = new MessageDialog(ExportIMSSourceWizard.this.getShell(), WorkbenchPlugin.errors.getString("DHB1703"), null, errorMsg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    MessageDialogRunner runner = new MessageDialogRunner(infoDialog);
                    ExportIMSSourceWizard.this.getShell().getDisplay().asyncExec((Runnable)runner);
                }
                catch (Throwable ex) {
                    logger.throwing(this.getClass().getName(), "run()", ex);
                    logger.error((Throwable)e);
                }
                throw db;
            }
            catch (CoreException e) {
                Object[] error = new String[]{memberName, pds.getFullPath()};
                ExporterException db = new ExporterException(WorkbenchPlugin.errors.getString("DHB1754", error));
                db.initCause(e);
                logger.throwing(this.getClass().getName(), "runFunc(IProgressMonitor monitor)", (Throwable)db);
                throw db;
            }
            monitor.done();
        }
    }
}

