/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.exportmetadata;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.ui.core.Utility;
import com.ibm.im.ims.workbench.wizard.exportmetadata.MetadataExportController;
import com.ibm.im.ims.workbench.wizard.exportmetadata.MetadataExportOp;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MetadataExportWizardPage1
extends WizardPage
implements SelectionListener,
ICheckStateListener {
    private MetadataExportController exportController;
    private Object[] selectedPSBs;
    private Object[] selectedDBDs;
    protected Button compressContentsCheckbox;
    private Button buttonDeselectAll;
    private Button buttonSelectAll;
    private Button buttonBrowse;
    private CheckboxTableViewer psbListViewer;
    private CheckboxTableViewer dbdListViewer;
    private Label psbLabel;
    private Label dbdLabel;
    private Label labelFileBrowse;
    private Text textArchiveFile;
    private String filePath;

    protected MetadataExportWizardPage1(String name, MetadataExportController exportController) {
        super(name);
        this.setTitle(WorkbenchPlugin.labels.getString("MEW_WIZARD_TITLE"));
        this.setMessage(WorkbenchPlugin.labels.getString("MEW_WIZARD_MESSAGE"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("export_local_metadata_large")));
        this.exportController = exportController;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createListGroup(composite);
        this.createFileBrowseComposite(composite);
        this.setControl((Control)composite);
        this.addListeners();
        this.setPageComplete(false);
    }

    private void createListGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        optionsGroup.setLayoutData((Object)gd);
        optionsGroup.setText(WorkbenchPlugin.labels.getString("MEW_GROUP_TITLE"));
        optionsGroup.setFont(parent.getFont());
        this.psbLabel = new Label((Composite)optionsGroup, 0);
        this.psbLabel.setText("PSBs:");
        this.dbdLabel = new Label((Composite)optionsGroup, 0);
        this.dbdLabel.setText("DBDs:");
        this.psbListViewer = CheckboxTableViewer.newCheckList((Composite)optionsGroup, (int)2048);
        this.exportController.fleshOutPSBListViewer((Composite)optionsGroup, this.psbListViewer);
        this.dbdListViewer = CheckboxTableViewer.newCheckList((Composite)optionsGroup, (int)2048);
        this.exportController.fleshOutDBDListViewer((Composite)optionsGroup, this.dbdListViewer);
        this.createListButtonGroup((Composite)optionsGroup);
    }

    private void createListButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.buttonSelectAll = new Button(composite, 0);
        this.buttonSelectAll.setText(WorkbenchPlugin.labels.getString("PPEW_SELECT_ALL"));
        this.buttonDeselectAll = new Button(composite, 0);
        this.buttonDeselectAll.setText(WorkbenchPlugin.labels.getString("PPEW_DESELECT_ALL"));
    }

    private void createFileBrowseComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.labelFileBrowse = new Label(composite, 0);
        this.labelFileBrowse.setText(WorkbenchPlugin.labels.getString("MEW_BROWSE_TITLE"));
        this.textArchiveFile = new Text(composite, 2048);
        this.textArchiveFile.setLayoutData((Object)new GridData(768));
        this.textArchiveFile.setEditable(false);
        this.buttonBrowse = new Button(composite, 0);
        this.buttonBrowse.setText(WorkbenchPlugin.labels.getString("WB496D"));
    }

    private void handleBrowse() {
        FileDialog dialog = new FileDialog(new Shell(), 8192);
        dialog.setText(WorkbenchPlugin.labels.getString("WB496S"));
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setFileName(this.exportController.getProjectName());
        dialog.setOverwrite(true);
        String selectedFile = dialog.open();
        if (selectedFile != null) {
            this.filePath = selectedFile;
            this.textArchiveFile.setText(this.filePath);
        }
    }

    private void addListeners() {
        this.buttonSelectAll.addSelectionListener((SelectionListener)this);
        this.buttonDeselectAll.addSelectionListener((SelectionListener)this);
        this.buttonBrowse.addSelectionListener((SelectionListener)this);
        this.psbListViewer.addCheckStateListener((ICheckStateListener)this);
        this.dbdListViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected boolean executeExportOperation(MetadataExportOp op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return true;
    }

    public boolean finish() throws CoreException {
        this.exportController.exportLocalMetadataSetup(this.selectedPSBs, this.selectedDBDs, this.filePath);
        return this.executeExportOperation(new MetadataExportOp(this.exportController));
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        try {
            if (event.widget == this.buttonSelectAll) {
                this.psbListViewer.setAllChecked(true);
                this.dbdListViewer.setAllChecked(true);
                this.setPageComplete(this.isComplete());
            } else if (event.widget == this.buttonDeselectAll) {
                this.psbListViewer.setAllChecked(false);
                this.dbdListViewer.setAllChecked(false);
                this.setPageComplete(this.isComplete());
            } else if (event.widget == this.buttonBrowse) {
                this.handleBrowse();
                this.setPageComplete(this.isComplete());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isChecked() {
        return this.selectedPSBs != null && this.selectedDBDs != null && (this.selectedPSBs.length > 0 || this.selectedDBDs.length > 0);
    }

    public boolean isComplete() {
        Boolean retval = false;
        this.selectedPSBs = this.psbListViewer.getCheckedElements();
        this.selectedDBDs = this.dbdListViewer.getCheckedElements();
        retval = this.filePath != null && this.isChecked() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return retval;
    }

    public void checkStateChanged(CheckStateChangedEvent arg0) {
        this.setPageComplete(this.isComplete());
    }
}

