/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.exportmetadata;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.wizard.exportmetadata.ZipFileExporter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class MetadataExportController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IStructuredSelection selection;
    private Vector<String> dbdNames;
    private Vector<String> psbNames;
    private ArrayList<IResource> resourcesToExport;
    private IProgressMonitor monitor;
    private ZipFileExporter exporter;
    private String destinationFilename;
    private String projectName;

    public MetadataExportController(IStructuredSelection selection) {
        this.selection = selection;
        this.projectName = this.getSelectedProjectName();
    }

    public void fleshOutDBDListViewer(Composite parent, CheckboxTableViewer listViewer) {
        GridData data = new GridData(1808);
        listViewer.setUseHashlookup(true);
        listViewer.getTable().setLayoutData((Object)data);
        listViewer.getTable().setFont(parent.getFont());
        try {
            this.dbdNames = ProjectTreeFileHelper.getDbdNamesInProject((String)this.projectName);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (String dbdName : this.dbdNames) {
            listViewer.add((Object)dbdName);
        }
    }

    public void fleshOutPSBListViewer(Composite parent, CheckboxTableViewer listViewer) {
        GridData data = new GridData(1808);
        listViewer.setUseHashlookup(true);
        listViewer.getTable().setLayoutData((Object)data);
        listViewer.getTable().setFont(parent.getFont());
        try {
            this.psbNames = ProjectTreeFileHelper.getPSBNamesInProject((String)this.projectName);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (String psbName : this.psbNames) {
            listViewer.add((Object)psbName);
        }
    }

    public void exportLocalMetadataSetup(Object[] selectedPSBs, Object[] selectedDBDs, String filePath) throws CoreException {
        IResource[] psbResources;
        int n;
        IResource[] dbdResources;
        this.destinationFilename = filePath;
        this.resourcesToExport = new ArrayList();
        IResource[] iResourceArray = dbdResources = ProjectTreeFileHelper.getProject((String)this.projectName).getFolder("DBD").members();
        int n2 = dbdResources.length;
        int n3 = 0;
        while (n3 < n2) {
            IResource dbdResource = iResourceArray[n3];
            Object[] objectArray = selectedDBDs;
            n = selectedDBDs.length;
            int n4 = 0;
            while (n4 < n) {
                Object selectedDBD = objectArray[n4];
                if (dbdResource.getName().equals(selectedDBD.toString().concat(".dbd"))) {
                    this.resourcesToExport.add(dbdResource);
                }
                ++n4;
            }
            ++n3;
        }
        IResource[] iResourceArray2 = psbResources = ProjectTreeFileHelper.getProject((String)this.projectName).getFolder("PSB").members();
        int n5 = psbResources.length;
        n2 = 0;
        while (n2 < n5) {
            IResource psbResource = iResourceArray2[n2];
            Object[] objectArray = selectedPSBs;
            int n6 = selectedPSBs.length;
            n = 0;
            while (n < n6) {
                Object selectedPSB = objectArray[n];
                if (psbResource.getName().equals(selectedPSB.toString().concat(".psb"))) {
                    this.resourcesToExport.add(psbResource);
                }
                ++n;
            }
            ++n2;
        }
    }

    public void exportResources(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        this.monitor = progressMonitor;
        try {
            try {
                this.exporter = new ZipFileExporter(this.destinationFilename, true);
                int totalWork = -1;
                this.monitor.beginTask(WorkbenchPlugin.labels.getString("MEW_CREATING_ZIP"), totalWork);
                this.exportSpecifiedResources();
                this.exporter.finished();
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            this.monitor.done();
        }
    }

    protected void exportSpecifiedResources() throws InterruptedException, InvocationTargetException {
        int i = 0;
        while (i < this.resourcesToExport.size()) {
            IResource currentResource = this.resourcesToExport.get(i);
            this.exportResource(currentResource);
            ++i;
        }
    }

    protected void exportResource(IResource exportResource) throws InterruptedException, InvocationTargetException {
        if (!exportResource.isAccessible()) {
            return;
        }
        if (exportResource.getType() == 1) {
            String destinationName = this.createDestinationName(1, exportResource);
            int extIndex = destinationName.indexOf(".");
            destinationName = destinationName.substring(0, extIndex);
            destinationName = destinationName.concat(".xml");
            this.monitor.subTask(destinationName);
            try {
                this.exporter.write((IFile)exportResource, destinationName);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        }
    }

    private String createDestinationName(int leadupDepth, IResource exportResource) {
        IPath fullPath = exportResource.getFullPath();
        return fullPath.removeFirstSegments(fullPath.segmentCount() - leadupDepth).toString();
    }

    public String getProjectName() {
        return this.projectName;
    }

    private String getSelectedProjectName() {
        String selectedProject = "";
        if (this.selection == null || this.selection.isEmpty()) {
            return selectedProject;
        }
        if (this.selection.getFirstElement() instanceof IProject) {
            selectedProject = ((IProject)this.selection.getFirstElement()).getName();
        } else if (this.selection.getFirstElement() instanceof IResource) {
            selectedProject = ((IResource)this.selection.getFirstElement()).getProject().getName();
        } else if (this.selection.getFirstElement() instanceof IFile) {
            selectedProject = ((IFile)this.selection.getFirstElement()).getProject().getName();
        }
        return selectedProject;
    }
}

