/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.editsenseg;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.editsenseg.EditSenSegWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class EditSenSegWizardPage3
extends WizardPage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private Table senfldTab;
    private TableEditor senfldEditor;
    private TableColumn senfldTabCol1;
    private TableColumn senfldTabCol2;
    private TableColumn senfldTabCol3;
    boolean pageComplete = false;
    public static final String PAGE_NAME = "SENFLD";
    List<FieldGEFModel> sortedFieldLst = null;
    boolean senfldsEdited = false;
    private SensegModel sensegModel = null;
    String[] YNItems = new String[]{WorkbenchPlugin.labels.getString("YES"), WorkbenchPlugin.labels.getString("NO")};

    public EditSenSegWizardPage3(String pageName) {
        super(PAGE_NAME);
        this.setTitle(WorkbenchPlugin.labels.getString("WB052A"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB096"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("senseg_wizard_large")));
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.uih = new UIHelper();
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            this.composite.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.composite, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            fd.height = 200;
            this.senfldTab = new Table(this.composite, 0x10010A0A);
            this.senfldTab.setHeaderVisible(true);
            this.senfldTab.setLinesVisible(true);
            this.senfldTab.addListener(41, new Listener(){

                public void handleEvent(Event event) {
                    event.height = 18;
                }
            });
            this.senfldTab.setLayoutData((Object)fd);
            this.senfldTabCol1 = new TableColumn(this.senfldTab, 16384);
            this.senfldTabCol1.setText(WorkbenchPlugin.labels.getString("WB056A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB059") + ")");
            this.senfldTabCol1.setMoveable(false);
            this.senfldTabCol1.setResizable(true);
            this.senfldTabCol2 = new TableColumn(this.senfldTab, 16384);
            this.senfldTabCol2.setText(WorkbenchPlugin.labels.getString("WB057A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB061") + ")");
            this.senfldTabCol2.setMoveable(false);
            this.senfldTabCol2.setResizable(true);
            this.senfldTabCol3 = new TableColumn(this.senfldTab, 16384);
            this.senfldTabCol3.setText(WorkbenchPlugin.labels.getString("WB048A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB071") + ")");
            this.senfldTabCol3.setMoveable(false);
            this.senfldTabCol3.setResizable(true);
            this.composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = EditSenSegWizardPage3.this.composite.getClientArea();
                    int width = area.width - 2 * EditSenSegWizardPage3.this.senfldTab.getBorderWidth();
                    TableColumn[] tableColumns = EditSenSegWizardPage3.this.senfldTab.getColumns();
                    EditSenSegWizardPage3.this.senfldTab.setSize(area.width, area.height);
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            this.initWidgetValues();
            this.InsertTabItemEditors();
            this.setControl((Control)this.composite);
            this.setErrorMessage(null);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ies1_wb_senfld");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void initWidgetValues() throws ModelException {
        SegmentGEFModel gefSeg = this.getWiz().getGefSegment();
        SegmentModel segModel = gefSeg.getSegmentModel();
        this.sensegModel = gefSeg.getSenSeg();
        Vector<FieldGEFModel> fields = gefSeg.getFieldsList();
        ArrayList<FieldGEFModel> senfldList = new ArrayList<FieldGEFModel>();
        FieldGEFModel fld = null;
        int x = 0;
        while (x < fields.size()) {
            fld = (FieldGEFModel)fields.get(x);
            if (fld.isSenfld()) {
                senfldList.add(fld);
            }
            ++x;
        }
        FieldGEFModel field = null;
        int i = 0;
        while (i < senfldList.size()) {
            TableItem currentTableItem = new TableItem(this.senfldTab, 0);
            field = (FieldGEFModel)senfldList.get(i);
            String imsNameStr = field.getIMSName();
            currentTableItem.setText(0, imsNameStr);
            if (imsNameStr == null || imsNameStr != null && imsNameStr.equals("")) {
                currentTableItem.setText(0, field.getAlias());
            } else {
                currentTableItem.setText(0, field.getIMSName());
            }
            currentTableItem.setText(1, Integer.toString(field.getStartPos()));
            SenfieldModel senField = this.sensegModel.getSenfield(imsNameStr, "", "");
            if (senField != null) {
                DBDConstants replaceVal = senField.getReplace();
                if (replaceVal != null) {
                    if (replaceVal == DBDConstants.Y) {
                        currentTableItem.setText(2, this.YNItems[0]);
                    } else {
                        currentTableItem.setText(2, this.YNItems[1]);
                    }
                }
                currentTableItem.setData(DBDConstants.MODEL.toString(), (Object)senField);
            } else {
                currentTableItem.setText(2, this.YNItems[0]);
                currentTableItem.setData(DBDConstants.MODEL.toString(), (Object)new SenfieldModel(field.getField(), segModel));
            }
            ++i;
        }
        this.senfldTabCol1.pack();
        this.senfldTabCol2.pack();
        this.senfldTabCol3.pack();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.composite.setFocus();
        }
    }

    protected void saveSenfldReplaceValues() {
        TableItem[] items = this.senfldTab.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem currItem = items[i];
            SenfieldModel currSenfld = (SenfieldModel)currItem.getData(DBDConstants.MODEL.toString());
            String replaceValueStr = currItem.getText(2);
            if (replaceValueStr.equals(this.YNItems[1])) {
                this.sensegModel.removeField(currSenfld);
                currSenfld.setReplace(DBDConstants.N);
                this.sensegModel.addField(currSenfld);
            } else {
                this.sensegModel.removeField(currSenfld);
                currSenfld.setReplace(DBDConstants.Y);
                this.sensegModel.addField(currSenfld);
            }
            ++i;
        }
    }

    private void InsertTabItemEditors() {
        final TableEditor editor = new TableEditor(this.senfldTab);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        this.senfldTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Combo newEditor = new Combo((Composite)EditSenSegWizardPage3.this.senfldTab, 8);
                newEditor.setItems(EditSenSegWizardPage3.this.YNItems);
                newEditor.setText(item.getText(2));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Combo combo = (Combo)editor.getEditor();
                        editor.getItem().setText(2, combo.getText());
                        (this).EditSenSegWizardPage3.this.senfldsEdited = true;
                        (this).EditSenSegWizardPage3.this.getWiz().page3HasBeenEdited = true;
                        EditSenSegWizardPage3.this.setPageComplete(true);
                    }
                });
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 2);
            }
        });
    }

    public boolean isSenfldsEdited() {
        return this.senfldsEdited;
    }

    EditSenSegWizard getWiz() {
        return (EditSenSegWizard)this.getWizard();
    }

    public DBDConstants getReplace() {
        DBDConstants rep = null;
        String repstr = null;
        repstr = this.senfldEditor.getItem().getText(2);
        rep = repstr.equalsIgnoreCase("Yes") ? DBDConstants.Y : DBDConstants.N;
        return rep;
    }
}

