/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.editsenseg;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.im.ims.workbench.wizard.editsenseg.EditSenSegWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class EditSenSegWizardPage2
extends WizardPage
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Display display;
    private UIHelper uih;
    private boolean validProcopt4Update = false;
    private Button[][] radios = new Button[8][3];
    private Composite[] radioGroup = new Composite[8];
    private Composite composite;
    private static int spacing = 10;
    private boolean isReadOnly;

    public EditSenSegWizardPage2(String pageName, String segmentName, boolean isReadOnly) {
        super("SENSEGSSPTR");
        Object[] inserts = new Object[]{segmentName};
        this.setTitle(WorkbenchPlugin.labels.getString("WB044A", inserts));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB095"));
        this.setImageDescriptor(Utility.getImageDescriptor(WorkbenchPlugin.icons.getString("senseg_wizard_large")));
        this.isReadOnly = isReadOnly;
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.uih = new UIHelper();
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            this.composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            this.composite.setLayoutData((Object)fd);
            Group ssptrGrp = new Group(this.composite, 0);
            fd = this.uih.genFormData(new FormAttachment((Control)this.composite, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            FormLayout ssptrfl = new FormLayout();
            ssptrfl.marginWidth = 5;
            ssptrGrp.setText(WorkbenchPlugin.labels.getString("WB055A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB434") + ")");
            ssptrGrp.setLayout((Layout)ssptrfl);
            ssptrGrp.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)ssptrGrp, spacing), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            fd.width = ssptrGrp.getClientArea().width;
            Link textLink = new Link((Composite)ssptrGrp, 16384);
            String txt = WorkbenchPlugin.descriptions.getString("WB31A") + "  <a>" + WorkbenchPlugin.descriptions.getString("WB070") + "</a>";
            textLink.setText(txt);
            textLink.setLayoutData((Object)fd);
            textLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.ies1_wb_ssptr");
                }
            });
            Label[] ssptrNum = new Label[8];
            this.initRadiotButtons(0, ssptrNum, (Composite)ssptrGrp, (Control)textLink);
            this.initRadiotButtons(1, ssptrNum, (Composite)ssptrGrp, (Control)this.radioGroup[0]);
            this.initRadiotButtons(2, ssptrNum, (Composite)ssptrGrp, (Control)this.radioGroup[1]);
            this.initRadiotButtons(3, ssptrNum, (Composite)ssptrGrp, (Control)this.radioGroup[2]);
            this.initRadiotButtons(4, ssptrNum, (Composite)ssptrGrp, (Control)this.radioGroup[3]);
            this.initRadiotButtons(5, ssptrNum, (Composite)ssptrGrp, (Control)this.radioGroup[4]);
            this.initRadiotButtons(6, ssptrNum, (Composite)ssptrGrp, (Control)this.radioGroup[5]);
            this.initRadiotButtons(7, ssptrNum, (Composite)ssptrGrp, (Control)this.radioGroup[6]);
            this.setControl((Control)this.composite);
            this.initWidgetValues();
            this.registerListeners();
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.disableForReadOnly();
            ssptrGrp.layout(true, true);
            this.composite.layout(true, true);
            this.getShell().setMinimumSize(this.getShell().computeSize(-1, -1, true));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.ies1_wb_senseg");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void initRadiotButtons(int i, Label[] ssptrNum, Composite parent, Control topComposite) {
        FormData fd = this.uih.genFormData(new FormAttachment(topComposite, spacing), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        fd.width = parent.getClientArea().width;
        this.radioGroup[i] = new Composite(parent, 0);
        this.radioGroup[i].setLayoutData((Object)fd);
        this.radioGroup[i].setLayout(parent.getLayout());
        fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        ssptrNum[i] = this.uih.genLabel(this.radioGroup[i], 0, String.valueOf(i + 1).trim(), this.uih.black, fd);
        ssptrNum[i].setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)ssptrNum[i], 50), null);
        this.radios[i][0] = new Button(this.radioGroup[i], 16);
        this.radios[i][0].setText(WorkbenchPlugin.labels.getString("WB046A") + " (" + DBDConstants.R.toString() + ")");
        this.radios[i][0].setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.radios[i][0], 50), null);
        this.radios[i][1] = new Button(this.radioGroup[i], 16);
        this.radios[i][1].setText(WorkbenchPlugin.labels.getString("WB051A") + " (" + DBDConstants.U.toString() + ")");
        this.radios[i][1].setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)this.radios[i][1], 50), null);
        this.radios[i][2] = new Button(this.radioGroup[i], 16);
        this.radios[i][2].setText(WorkbenchPlugin.labels.getString("NONE") + " (" + DBDConstants.NONE.toString() + ")");
        this.radios[i][2].setLayoutData((Object)fd);
        this.radioGroup[i].setEnabled(true);
        this.radioGroup[i].setVisible(i == 0);
    }

    private void initWidgetValues() {
        SensegModel sseg = this.getWiz().getGefSegment().getSenSeg();
        int i = 0;
        while (i < sseg.getSsptrListSize()) {
            this.radioGroup[i].setVisible(true);
            String sensitivity = sseg.getSsptrSensitivity(i);
            if (sensitivity.equalsIgnoreCase(DBDConstants.R.value())) {
                this.radios[i][0].setSelection(true);
            } else if (sensitivity.equalsIgnoreCase(DBDConstants.U.value())) {
                this.radios[i][1].setSelection(true);
            } else {
                this.radios[i][2].setSelection(true);
            }
            if (i < 7) {
                this.radioGroup[i + 1].setVisible(!this.radios[i][2].getSelection());
            }
            ++i;
        }
    }

    private void registerListeners() {
        int i = 0;
        while (i < 8) {
            this.radios[i][0].addSelectionListener((SelectionListener)this);
            this.radios[i][1].addSelectionListener((SelectionListener)this);
            this.radios[i][2].addSelectionListener((SelectionListener)this);
            ++i;
        }
    }

    private EditSenSegWizard getWiz() {
        return (EditSenSegWizard)this.getWizard();
    }

    public boolean isPageComplete() {
        return false;
    }

    private void setValidForUpdate() {
        try {
            String[] procopts = this.getWiz().page1.getProcopts();
            String pcbProcOpt = this.getWiz().gefSegment.getDbGEFModel().getPcbModel().getProcopt();
            this.validProcopt4Update = false;
            int i = 0;
            while (i < procopts.length) {
                if (procopts[0].isEmpty() && (pcbProcOpt.isEmpty() || pcbProcOpt.indexOf("A") >= 0 || pcbProcOpt.indexOf("R") >= 0 || pcbProcOpt.indexOf("I") >= 0 || pcbProcOpt.indexOf("D") >= 0) || procopts[i].equals("A") || procopts[i].equals("R") || procopts[i].equals("I") || procopts[i].equals("D")) {
                    this.validProcopt4Update = true;
                    break;
                }
                ++i;
            }
            this.setUpdatable();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setValidForUpdate()", e);
            logger.error(e);
        }
    }

    private void setUpdatable() {
        if (this.getWiz().page2HasBeenEdited) {
            int i = 0;
            while (i < 8) {
                this.radios[i][1].setEnabled(this.validProcopt4Update);
                if (this.radios[i][1].getSelection()) {
                    this.radios[i][0].setSelection(true);
                    this.radios[i][1].setSelection(false);
                }
                ++i;
            }
        } else {
            SensegModel sseg = this.getWiz().getGefSegment().getSenSeg();
            int i = 0;
            while (i < 8) {
                if (i < 7) {
                    this.radioGroup[i + 1].setVisible(!this.radios[i][2].getSelection() && i < sseg.getSsptrListSize());
                }
                this.radios[i][1].setEnabled(this.validProcopt4Update);
                if (!this.validProcopt4Update && this.radios[i][1].getSelection()) {
                    this.radios[i][0].setSelection(true);
                    this.radios[i][1].setSelection(false);
                }
                ++i;
            }
        }
        this.disableForReadOnly();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setValidForUpdate();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            int i = 0;
            while (i < 8) {
                if (e.widget == this.radios[i][2]) {
                    int j = i + 1;
                    while (j < 8) {
                        this.radioGroup[j].setVisible(false);
                        this.unSelectRadioButtons(j);
                        ++j;
                    }
                    break;
                }
                if (e.widget == this.radios[i][0] || e.widget == this.radios[i][1]) {
                    if (i >= 7 || this.radioGroup[i + 1].isVisible()) break;
                    this.radioGroup[i + 1].setVisible(true);
                    this.unSelectRadioButtons(i + 1);
                    break;
                }
                ++i;
            }
            this.disableForReadOnly();
            this.getWiz().page2HasBeenEdited = true;
            this.validatePage();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
    }

    private void disableForReadOnly() {
        if (this.isReadOnly) {
            int i = 0;
            while (i < 8) {
                int j = 0;
                while (j < 3) {
                    this.radios[i][j].setEnabled(false);
                    ++j;
                }
                ++i;
            }
        }
    }

    private void unSelectRadioButtons(int i) {
        this.radios[i][0].setSelection(false);
        this.radios[i][1].setSelection(false);
        this.radios[i][2].setSelection(false);
    }

    public Vector<String> getSSPTRs() {
        Vector<String> ssptrList = new Vector<String>();
        int i = 0;
        while (i < 8) {
            if (this.radios[i][2].getSelection()) break;
            if (this.radios[i][0].getSelection()) {
                ssptrList.add("R");
            } else if (this.radios[i][1].getSelection()) {
                ssptrList.add("U");
            }
            ++i;
        }
        return ssptrList;
    }

    public void validatePage() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[0]);
        boolean retVal = false;
        if (this.getWiz().page2HasBeenEdited) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[]{retVal});
    }
}

