/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.editsenseg;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.SenfieldModel;
import com.ibm.im.ims.workbench.model.SensegModel;
import com.ibm.im.ims.workbench.wizard.editsenseg.EditSenSegWizardPage1;
import com.ibm.im.ims.workbench.wizard.editsenseg.EditSenSegWizardPage2;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EditSenSegWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public SegmentGEFModel gefSegment;
    private FieldGEFModel gefField;
    public DbGEFModel dbGefModel;
    public SenfieldModel senField;
    public EditSenSegWizardPage1 page1;
    public EditSenSegWizardPage2 page2;
    public boolean page1HasBeenEdited = false;
    public boolean page2HasBeenEdited = false;
    public boolean page3HasBeenEdited = false;
    private ResourceEditorPage page;
    private PcbDBModel pcbModel;
    private boolean isReadOnly;

    public EditSenSegWizard(SegmentGEFModel gefSegment, DbGEFModel dbGefModel, ResourceEditorPage page, PcbDBModel pcbModel, boolean isReadOnly) {
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB043A"));
        this.setHelpAvailable(false);
        this.gefSegment = gefSegment;
        this.dbGefModel = dbGefModel;
        this.page = page;
        this.pcbModel = pcbModel;
        this.isReadOnly = isReadOnly;
    }

    public void setGefSegment(SegmentGEFModel gefSegment) {
        this.gefSegment = gefSegment;
    }

    public SegmentGEFModel getGefSegment() {
        return this.gefSegment;
    }

    public FieldGEFModel getFieldInfo() {
        return this.gefField;
    }

    public FieldGEFModel getGefField() {
        return this.gefField;
    }

    public void setFieldInfo(FieldGEFModel dliFieldModel) {
        this.gefField = dliFieldModel;
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        try {
            this.saveSenSegVal();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }

    private void saveSenSegVal() {
        this.saveProcopt();
        this.saveIndices();
        if (this.isDEDB()) {
            this.saveSsptrs();
        }
    }

    private void saveSsptrs() {
        SensegModel sseg = this.getGefSegment().getSenSeg();
        Vector<String> ssptrStrings = this.page2.getSSPTRs();
        sseg.clearAllSsptrs();
        int i = 0;
        while (i < ssptrStrings.size()) {
            sseg.addSsptrSensitivity(ssptrStrings.get(i), i + 1);
            ++i;
        }
    }

    private void saveProcopt() {
        SensegModel sseg = this.getGefSegment().getSenSeg();
        String procopt = null;
        if (this.page1.getProcopts().length > 0) {
            String[] procopts = this.page1.getProcopts();
            procopt = procopts[0] + procopts[1] + procopts[2] + procopts[3];
            sseg.setProcopt(procopt.trim());
        }
    }

    private void saveIndices() {
        SensegModel sseg = this.getGefSegment().getSenSeg();
        String[] indexStrings = this.page1.getIndices();
        List indexList = sseg.getIndices();
        indexList.clear();
        if (indexStrings != null && indexStrings.length > 0 && indexStrings != null) {
            int i = 0;
            while (i < indexStrings.length) {
                indexList.add(indexStrings[i]);
                ++i;
            }
        }
    }

    public boolean canFinish() {
        boolean retVal = false;
        try {
            if (this.isDEDB()) {
                if (this.page1HasBeenEdited || this.page2HasBeenEdited) {
                    retVal = true;
                }
            } else if (this.page1HasBeenEdited || this.page3HasBeenEdited) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
        return retVal;
    }

    public void addPages() {
        try {
            String segmentName = this.gefSegment.getSegmentName();
            this.page1 = new EditSenSegWizardPage1("SENSEG", segmentName, this.isReadOnly);
            this.page2 = new EditSenSegWizardPage2("SENSEGSSPTR", segmentName, this.isReadOnly);
            this.addPage((IWizardPage)this.page1);
            this.addPage((IWizardPage)this.page2);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    private boolean isKSpecified() {
        String[] procopts = this.page1.getProcopts();
        return procopts[0].equals("K");
    }

    private boolean isProcoptIorL() {
        String[] procopts = this.page1.getProcopts();
        boolean noSensegProcopts = true;
        int i = 0;
        while (i < procopts.length) {
            String currChar = procopts[i];
            if (currChar.length() > 0) {
                noSensegProcopts = false;
            }
            if (currChar.equals("I") || currChar.equals("L")) {
                return true;
            }
            ++i;
        }
        if (noSensegProcopts) {
            String pcbProcoptStr = this.pcbModel.getProcopt();
            int i2 = 0;
            while (i2 < pcbProcoptStr.length()) {
                char currChar = pcbProcoptStr.charAt(i2);
                if (currChar == 'I' || currChar == 'L') {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    private boolean isDEDB() {
        return this.dbGefModel.getDbdModel().getAccessType().equals((Object)DBDConstants.DEDB) || this.dbGefModel.getDbdModel().getAccessType().equals((Object)DBDConstants.MSDB);
    }

    private boolean isFieldLogicalChild() {
        return this.gefSegment.getSegmentModel().isRealLogicalChild() || this.gefSegment.getSegmentModel().isVirtualLogicalChild();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage currPage = this.getContainer().getCurrentPage();
        if (currPage.equals((Object)this.page1)) {
            if (this.isDEDB()) {
                return this.page2;
            }
            return null;
        }
        return null;
    }

    public String getProjectName() {
        return this.page.getPsbMultiPageEditor().getProjectName();
    }
}

