/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.editpcb;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.form.PsbSummaryPage;
import com.ibm.im.ims.workbench.editors.model.PsbGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.PcbTPModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.TableItemEditWizardPage;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EditTpPcbWizardPage1
extends TableItemEditWizardPage
implements SelectionListener,
ModifyListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static int margin = 5;
    private static int spacing = 10;
    private static int left2Percentage = 50;
    private static int right2Percentage = 97;
    private static int fieldLength = 100;
    private Composite parentComposite;
    private Text pcbNameField;
    private Text pcbAliasField;
    private Text ltermNameField;
    private Combo altrespCombo;
    private Combo sametrmCombo;
    private Combo modifyCombo;
    private Combo expressCombo;
    private Combo listCombo;
    private Label pcbNameStatus;
    private Label pcbAliasStatus;
    private Label ltermStatus;
    private Label listStatus;
    private Label modifyStatus;
    private Label pcbNameReq;
    private Label pcbAliasReq;
    private Label pcbLabelReq;
    private Label nameReq;
    private Button[] pcbNameOrLabel;
    private static String[] yesOrNo = new String[]{WorkbenchPlugin.labels.getString("YES"), WorkbenchPlugin.labels.getString("NO")};
    private PsbSummaryPage parentPage;
    private PcbTPModel currTpPcb;
    private boolean addingNewTableItem;
    private Label pcbNameLabelFormat;
    private Label pcbNameLabel;
    private Label pcbAliasLabel;
    private Label ltermLabel;
    private Label altrespLabel;
    private Label sametrmLabel;
    private Label modifyLabel;
    private Label expressLabel;
    private Label listLabel;
    private UIHelper uih;
    private int leftLabelSize;
    private int rightLabelSize;
    private boolean isReadOnly;

    public EditTpPcbWizardPage1(String pageName, TableItem tableItem, PsbSummaryPage parentPage, boolean addingNewTableItem, boolean isReadOnly) {
        super(pageName, tableItem);
        this.setTitle(addingNewTableItem ? WorkbenchPlugin.descriptions.getString("WB39A1") : WorkbenchPlugin.descriptions.getString("WB39A2"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB40A"));
        this.setImageDescriptor(Utility.getImageDescriptor(addingNewTableItem ? WorkbenchPlugin.icons.getString("addPcb") : WorkbenchPlugin.icons.getString("editPcb")));
        this.parentPage = parentPage;
        this.addingNewTableItem = addingNewTableItem;
        this.isReadOnly = isReadOnly;
        if (addingNewTableItem) {
            this.createNewTpPcb();
        } else {
            this.setCurrentPcb();
        }
        this.setPageComplete(false);
    }

    private void createNewTpPcb() {
        PcbTPModel tpPcb;
        this.currTpPcb = tpPcb = new PcbTPModel();
    }

    public void removeNewPCBFromModel() {
        PsbModel psb = ((PsbGEFModel)this.parentPage.getRMEParent().getDbdOrPcbList()).getPsb();
        psb.removeTPPcb(this.currTpPcb);
    }

    public void createControl(Composite composite) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite composite)", new Object[0]);
        try {
            this.parentComposite = new Composite(composite, 0);
            this.parentComposite.setLayout((Layout)new FormLayout());
            this.uih = new UIHelper();
            Display display = this.parentComposite.getDisplay();
            this.uih.setDisplay(display);
            this.createUIControl();
            this.layoutUIControls();
            if (!this.addingNewTableItem) {
                this.initWidgetValues(this.parentComposite.getChildren());
            } else {
                this.initWidgetsWithInputDefaults(this.parentComposite.getChildren());
            }
            if (this.isReadOnly) {
                this.pcbNameOrLabel[0].setEnabled(false);
                this.pcbNameOrLabel[1].setEnabled(false);
                this.pcbNameField.setEnabled(false);
                this.pcbAliasField.setEnabled(false);
                this.ltermNameField.setEnabled(false);
                this.altrespCombo.setEnabled(false);
                this.sametrmCombo.setEnabled(false);
                this.modifyCombo.setEnabled(false);
                this.expressCombo.setEnabled(false);
                this.listCombo.setEnabled(false);
            }
            this.addListeners();
            this.setControl((Control)this.parentComposite);
            Point point = this.getShell().computeSize(-1, -1, true);
            this.getShell().setMinimumSize(point.x, point.y + margin * spacing);
            this.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite composite)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite composite)", new Object[0]);
    }

    private void addListeners() {
        this.pcbNameOrLabel[0].addSelectionListener((SelectionListener)this);
        this.pcbNameOrLabel[1].addSelectionListener((SelectionListener)this);
        this.listCombo.addModifyListener((ModifyListener)this);
        this.expressCombo.addModifyListener((ModifyListener)this);
        this.modifyCombo.addModifyListener((ModifyListener)this);
        this.sametrmCombo.addModifyListener((ModifyListener)this);
        this.altrespCombo.addModifyListener((ModifyListener)this);
        this.ltermNameField.addModifyListener((ModifyListener)this);
        this.pcbNameField.addModifyListener((ModifyListener)this);
        this.pcbAliasField.addModifyListener((ModifyListener)this);
        this.ltermNameField.addVerifyListener((VerifyListener)this);
        this.pcbNameField.addVerifyListener((VerifyListener)this);
        this.pcbAliasField.addVerifyListener((VerifyListener)this);
    }

    public void updateMetadataWithWidgetValues() {
        this.setLtermName();
        this.setSameTrm();
        this.setPcbNameOrLabel();
        this.setPcbAlias();
        this.setAltresp();
        this.setExpress();
        this.setModify();
        this.setList();
    }

    public void addCurrPcbToModel() {
        PsbModel psb = ((PsbGEFModel)this.parentPage.getRMEParent().getDbdOrPcbList()).getPsb();
        psb.addTPPcb(this.currTpPcb);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        try {
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            if (e.widget == this.ltermNameField) {
                this.ltermNameFieldModifyText();
            } else if (e.widget == this.pcbNameField) {
                this.pcbNameFieldModifyText();
            } else if (e.widget == this.pcbAliasField) {
                this.pcbAliasFieldModifyText();
            } else if (e.widget == this.modifyCombo) {
                this.modifyComboModifyText();
            } else if (e.widget == this.listCombo) {
                this.listComboModifyText();
            }
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void ltermNameFieldModifyText() {
        String ltermName = this.ltermNameField.getText().trim();
        if (ltermName.length() > 0 && Utility.hasSpecialChar(ltermName)) {
            this.ltermStatus.setToolTipText(WorkbenchPlugin.errors.getString("EISRC8"));
            this.ltermStatus.setVisible(true);
        } else if (ltermName.length() == 0 && this.modifyCombo.getText().equals(yesOrNo[1])) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB414"), WorkbenchPlugin.noxlatlabels.getString("WB415")};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC12"));
            this.ltermStatus.setToolTipText(formatter.format(messageArguments));
            this.ltermStatus.setVisible(true);
        } else {
            this.modifyStatus.setToolTipText(null);
            this.modifyStatus.setVisible(false);
            this.ltermStatus.setToolTipText(null);
            this.ltermStatus.setVisible(false);
        }
    }

    private void setLtermName() {
        String value = this.ltermNameField.getText();
        this.currTpPcb.setTrancodeName(value);
    }

    private int validPcbName(String pcbName) {
        TableItem tableItem;
        int i;
        int pcbNumber = 0;
        if (this.parentPage.getTpPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getTpPcbTable().getItemCount()) {
                tableItem = this.parentPage.getTpPcbTable().getItem(i);
                ++pcbNumber;
                if (this.tableItem != tableItem && pcbName.equals(tableItem.getText(1))) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getDbPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getDbPcbTable().getItemCount()) {
                tableItem = this.parentPage.getDbPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(1).equals(pcbName)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getGsamPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getGsamPcbTable().getItemCount()) {
                tableItem = this.parentPage.getGsamPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(1).equals(pcbName)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        return -1;
    }

    private int validPcbAlias(String pcbAlias) {
        TableItem tableItem;
        int i;
        int pcbNumber = 0;
        if (this.parentPage.getTpPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getTpPcbTable().getItemCount()) {
                tableItem = this.parentPage.getTpPcbTable().getItem(i);
                ++pcbNumber;
                if (this.tableItem != tableItem && pcbAlias.equals(tableItem.getText(2))) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getDbPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getDbPcbTable().getItemCount()) {
                tableItem = this.parentPage.getDbPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(2).equals(pcbAlias)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getGsamPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getGsamPcbTable().getItemCount()) {
                tableItem = this.parentPage.getGsamPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(2).equals(pcbAlias)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        return -1;
    }

    private void pcbNameFieldModifyText() {
        String pcbName = this.pcbNameField.getText().trim();
        int pcbNumber = this.validPcbName(pcbName);
        if (pcbName.length() > 0 && Utility.hasSpecialChar(pcbName)) {
            this.pcbNameStatus.setToolTipText(WorkbenchPlugin.errors.getString("EISRC8"));
            this.pcbNameStatus.setVisible(true);
        } else if (pcbName.length() > 0 && pcbNumber > 0) {
            Object[] messageArguments = new Object[]{pcbName, this.validPcbName(pcbName), pcbName};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC13"));
            this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
            this.pcbNameStatus.setVisible(true);
        } else if (pcbName.length() == 0 && this.listCombo.getText().equals(yesOrNo[1])) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB420"), WorkbenchPlugin.labels.getString("LABEL")};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC12"));
            this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
            this.pcbNameStatus.setVisible(true);
        } else {
            this.listStatus.setToolTipText(null);
            this.listStatus.setVisible(false);
            this.pcbNameStatus.setToolTipText(null);
            this.pcbNameStatus.setVisible(false);
        }
    }

    private void pcbAliasFieldModifyText() {
        String pcbAlias = this.pcbAliasField.getText().trim();
        int aliasLen = pcbAlias.length();
        if (aliasLen > 0 && aliasLen <= 128) {
            if (Utility.hasSpecialChar(pcbAlias) || pcbAlias.indexOf(32) >= 0) {
                Object[] attrs = new String[]{pcbAlias, WorkbenchPlugin.labels.getString("WB211")};
                this.pcbAliasStatus.setToolTipText(Utility.formatMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_5", attrs)));
                this.pcbAliasStatus.setVisible(true);
            } else if (this.validPcbAlias(pcbAlias) > 0) {
                Object[] messageArguments = new Object[]{pcbAlias, this.validPcbAlias(pcbAlias), pcbAlias};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC13"));
                this.pcbAliasStatus.setToolTipText(formatter.format(messageArguments));
                this.pcbAliasStatus.setVisible(true);
            } else {
                this.pcbAliasStatus.setToolTipText(null);
                this.pcbAliasStatus.setVisible(false);
            }
        } else if (aliasLen > 128) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.labels.getString("WB211"), pcbAlias};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC11"));
            this.pcbAliasStatus.setToolTipText(formatter.format(messageArguments));
            this.pcbAliasStatus.setVisible(true);
        } else {
            this.pcbAliasStatus.setToolTipText(null);
            this.pcbAliasStatus.setVisible(false);
        }
    }

    private void setPcbNameOrLabel() {
        String value = this.pcbNameField.getText().trim();
        if (this.pcbNameOrLabel[0].getSelection()) {
            this.currTpPcb.setLabel(value);
            this.currTpPcb.setPcbName(null);
        } else {
            this.currTpPcb.setPcbName(value);
            this.currTpPcb.setLabel(null);
        }
    }

    private void setPcbAlias() {
        String value = this.pcbAliasField.getText().trim();
        String oldVal = this.currTpPcb.getExternalName();
        if (oldVal == null || !oldVal.equals(value)) {
            this.currTpPcb.setName(value);
        }
    }

    private void setAltresp() {
        String value = this.altrespCombo.getText();
        DBDConstants newValue = PsbSummaryPage.getYesNoConstant(value);
        if (!this.currTpPcb.getAltresp().equals((Object)newValue)) {
            this.currTpPcb.setAltresp(newValue);
        }
    }

    private void setExpress() {
        String value = this.expressCombo.getText();
        DBDConstants newValue = PsbSummaryPage.getYesNoConstant(value);
        if (!this.currTpPcb.getExpress().equals((Object)newValue)) {
            this.currTpPcb.setExpress(newValue);
        }
    }

    private void setSameTrm() {
        String value = this.sametrmCombo.getText();
        DBDConstants newValue = PsbSummaryPage.getYesNoConstant(value);
        if (!this.currTpPcb.getSametrm().equals((Object)newValue)) {
            this.currTpPcb.setSametrm(newValue);
        }
    }

    private void setModify() {
        String value = this.modifyCombo.getText();
        DBDConstants newValue = PsbSummaryPage.getYesNoConstant(value);
        if (!this.currTpPcb.getModify().equals((Object)newValue)) {
            this.currTpPcb.setModify(newValue);
        }
    }

    private void setList() {
        String value = this.listCombo.getText();
        DBDConstants newValue = PsbSummaryPage.getYesNoConstant(value);
        if (!this.currTpPcb.getList().equals((Object)newValue)) {
            this.currTpPcb.setList(newValue);
        }
    }

    private void modifyComboModifyText() {
        try {
            String lterm = this.ltermNameField.getText();
            String modify = this.modifyCombo.getText();
            this.nameReq.setVisible(modify.equals(yesOrNo[1]));
            this.ltermNameField.setEnabled(modify.equals(yesOrNo[1]));
            if (lterm.length() == 0 && modify.equals(yesOrNo[1])) {
                Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB414"), WorkbenchPlugin.noxlatlabels.getString("WB415")};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC12"));
                this.ltermStatus.setToolTipText(formatter.format(messageArguments));
                this.ltermStatus.setVisible(true);
            } else {
                this.modifyStatus.setToolTipText(null);
                this.modifyStatus.setVisible(false);
                this.ltermStatus.setToolTipText(null);
                this.ltermStatus.setVisible(false);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyComboModifyText()", e);
            logger.error(e);
        }
    }

    private void listComboModifyText() {
        String pcbName = this.pcbNameField.getText();
        String list = this.listCombo.getText();
        this.pcbNameReq.setVisible(list.equals(yesOrNo[1]));
        this.pcbLabelReq.setVisible(list.equals(yesOrNo[1]));
        if (pcbName.length() == 0 && list.equals(yesOrNo[1])) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB420"), WorkbenchPlugin.labels.getString("LABEL")};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC12"));
            this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
            this.pcbNameStatus.setVisible(true);
        } else {
            this.pcbNameStatus.setToolTipText(null);
            this.pcbNameStatus.setVisible(false);
            this.listStatus.setToolTipText(null);
            this.listStatus.setVisible(false);
        }
    }

    private void setCurrentPcb() {
        PsbModel psb = ((PsbGEFModel)this.parentPage.getRMEParent().getDbdOrPcbList()).getPsb();
        this.currTpPcb = psb.getTpPcbWithNum(Integer.valueOf(this.tableItem.getText(0)).intValue());
        if (this.currTpPcb == null) {
            throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
        }
    }

    private boolean validatePage() {
        boolean msgDestSpecified = this.validateMsgDestInput();
        boolean pcbNameSpecified = this.validatePcbNameInput();
        boolean pcbAliasSpecified = this.validatePcbAliasInput();
        return msgDestSpecified && pcbNameSpecified && pcbAliasSpecified;
    }

    private boolean validateMsgDestInput() {
        boolean retVal = false;
        String modifyStr = this.modifyCombo.getText().trim();
        if (modifyStr.equals(yesOrNo[1])) {
            String ltermNameStr = this.ltermNameField.getText().trim();
            if (ltermNameStr != null && ltermNameStr.length() > 0 && !Utility.hasSpecialChar(ltermNameStr)) {
                retVal = true;
            }
        } else {
            retVal = true;
        }
        return retVal;
    }

    private boolean validatePcbNameInput() {
        boolean retVal = false;
        String listStr = this.listCombo.getText().trim();
        String pcbNameStr = this.pcbNameField.getText().trim();
        if (listStr.equals(yesOrNo[1])) {
            if (pcbNameStr != null && pcbNameStr.length() > 0 && !Utility.hasSpecialChar(pcbNameStr)) {
                retVal = true;
            }
        } else if (pcbNameStr != null && pcbNameStr.length() > 0) {
            if (!Utility.hasSpecialChar(pcbNameStr)) {
                retVal = true;
            }
        } else {
            retVal = true;
        }
        if (pcbNameStr != null && pcbNameStr.length() > 0 && this.validPcbName(pcbNameStr) > 0) {
            retVal = false;
        }
        return retVal;
    }

    private boolean validatePcbAliasInput() {
        this.pcbAliasFieldModifyText();
        return !this.pcbAliasStatus.isVisible();
    }

    @Override
    public void initWidgetValues(Control[] children) {
        super.initWidgetValues(children);
        try {
            this.modifyComboModifyText();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "initWidgetValues(Control[] children)", e);
            logger.error(e);
        }
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    private void createUIControl() {
        this.pcbNameReq = this.uih.genRequiredSymbol(this.parentComposite, 0, null, this.parentComposite.getDisplay().getSystemColor(3));
        this.pcbNameReq.setVisible(false);
        this.pcbNameLabelFormat = new Label(this.parentComposite, 0);
        this.pcbNameLabelFormat.setText(WorkbenchPlugin.labels.getString("WB420") + WorkbenchPlugin.colon.getString("COLON"));
        this.pcbNameLabelFormat.setToolTipText(WorkbenchPlugin.descriptions.getString("WB441"));
        this.pcbNameOrLabel = new Button[2];
        this.pcbNameOrLabel[0] = new Button(this.parentComposite, 16);
        this.pcbNameOrLabel[0].setText(WorkbenchPlugin.labels.getString("LABEL"));
        this.pcbNameOrLabel[0].setToolTipText(WorkbenchPlugin.descriptions.getString("WB442"));
        this.pcbNameOrLabel[0].setData("ID", (Object)DBDConstants.PCB_NAME_LABEL_GROUP.toString());
        this.pcbNameOrLabel[0].setData("DEFAULT", (Object)"true");
        this.pcbNameOrLabel[1] = new Button(this.parentComposite, 16);
        this.pcbNameOrLabel[1].setText(WorkbenchPlugin.noxlatlabels.getString("WB420"));
        this.pcbNameOrLabel[1].setToolTipText(WorkbenchPlugin.descriptions.getString("WB443"));
        this.pcbNameOrLabel[1].setData("ID", (Object)DBDConstants.PCB_NAME_LABEL_GROUP.toString());
        this.pcbLabelReq = this.uih.genRequiredSymbol(this.parentComposite, 0, null, this.parentComposite.getDisplay().getSystemColor(3));
        this.pcbLabelReq.setVisible(false);
        this.pcbNameLabel = new Label(this.parentComposite, 0);
        this.pcbNameLabel.setText(WorkbenchPlugin.labels.getString("WB430") + WorkbenchPlugin.colon.getString("COLON"));
        this.pcbNameField = new Text(this.parentComposite, 2048);
        this.pcbNameField.setText("");
        this.pcbNameField.setTextLimit(8);
        this.pcbNameField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB403"));
        this.setInputDefault((Control)this.pcbNameField, WorkbenchPlugin.labels.getString("PSP_PCB_NAME"), "");
        this.pcbNameStatus = new Label(this.parentComposite, 0);
        this.pcbNameStatus.setImage(FigureConstants.ERROR);
        this.pcbNameStatus.setVisible(false);
        this.pcbAliasReq = this.uih.genRequiredSymbol(this.parentComposite, 0, null, this.parentComposite.getDisplay().getSystemColor(3));
        this.pcbAliasReq.setVisible(false);
        this.pcbAliasLabel = new Label(this.parentComposite, 0);
        this.pcbAliasLabel.setText(WorkbenchPlugin.labels.getString("WB211") + " " + WorkbenchPlugin.noxlatlabels.getString("WB091") + WorkbenchPlugin.colon.getString("COLON"));
        this.pcbAliasField = new Text(this.parentComposite, 2048);
        this.pcbAliasField.setText("");
        this.pcbAliasField.setTextLimit(128);
        this.pcbAliasField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB449"));
        this.setInputDefault((Control)this.pcbAliasField, WorkbenchPlugin.labels.getString("WB211"), "");
        this.pcbAliasStatus = new Label(this.parentComposite, 0);
        this.pcbAliasStatus.setImage(FigureConstants.ERROR);
        this.pcbAliasStatus.setVisible(false);
        this.nameReq = this.uih.genRequiredSymbol(this.parentComposite, 0, null, this.parentComposite.getDisplay().getSystemColor(3));
        this.ltermLabel = new Label(this.parentComposite, 0);
        this.ltermLabel.setText(WorkbenchPlugin.labels.getString("WB415") + WorkbenchPlugin.colon.getString("COLON"));
        this.ltermNameField = new Text(this.parentComposite, 2048);
        this.ltermNameField.setText("");
        this.ltermNameField.setTextLimit(8);
        this.ltermNameField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB404"));
        this.setInputDefault((Control)this.ltermNameField, WorkbenchPlugin.noxlatlabels.getString("LTERM_OR_NAME"), "");
        this.ltermStatus = new Label(this.parentComposite, 0);
        this.ltermStatus.setImage(FigureConstants.ERROR);
        this.ltermStatus.setVisible(false);
        this.altrespLabel = new Label(this.parentComposite, 0);
        this.altrespLabel.setText(WorkbenchPlugin.labels.getString("WB416") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB416") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        this.altrespLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB405"));
        this.altrespCombo = new Combo(this.parentComposite, 8);
        this.altrespCombo.setItems(yesOrNo);
        this.setInputDefault((Control)this.altrespCombo, WorkbenchPlugin.noxlatlabels.getString("WB416"), yesOrNo[1]);
        this.sametrmLabel = new Label(this.parentComposite, 0);
        this.sametrmLabel.setText(WorkbenchPlugin.labels.getString("WB417") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB417") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        this.sametrmLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB406"));
        this.sametrmCombo = new Combo(this.parentComposite, 8);
        this.sametrmCombo.setItems(yesOrNo);
        this.setInputDefault((Control)this.sametrmCombo, WorkbenchPlugin.noxlatlabels.getString("WB417"), yesOrNo[1]);
        this.modifyLabel = new Label(this.parentComposite, 0);
        this.modifyLabel.setText(WorkbenchPlugin.labels.getString("WB418") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB418") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        this.modifyLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB407"));
        this.modifyCombo = new Combo(this.parentComposite, 8);
        this.modifyCombo.setItems(yesOrNo);
        this.setInputDefault((Control)this.modifyCombo, WorkbenchPlugin.noxlatlabels.getString("WB418"), yesOrNo[1]);
        this.modifyStatus = new Label(this.parentComposite, 0);
        this.modifyStatus.setImage(FigureConstants.ERROR);
        this.modifyStatus.setVisible(false);
        this.expressLabel = new Label(this.parentComposite, 0);
        this.expressLabel.setText(WorkbenchPlugin.labels.getString("WB419") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB419") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        this.expressLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB408"));
        this.expressCombo = new Combo(this.parentComposite, 8);
        this.expressCombo.setItems(yesOrNo);
        this.setInputDefault((Control)this.expressCombo, WorkbenchPlugin.noxlatlabels.getString("WB419"), yesOrNo[1]);
        this.listLabel = new Label(this.parentComposite, 0);
        this.listLabel.setText(WorkbenchPlugin.labels.getString("WB421") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB421") + ")" + WorkbenchPlugin.colon.getString("COLON"));
        this.listLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB409"));
        this.listCombo = new Combo(this.parentComposite, 8);
        this.listCombo.setItems(yesOrNo);
        this.setInputDefault((Control)this.listCombo, WorkbenchPlugin.noxlatlabels.getString("WB421"), yesOrNo[0]);
        this.listStatus = new Label(this.parentComposite, 0);
        this.listStatus.setImage(FigureConstants.ERROR);
        this.listStatus.setVisible(false);
    }

    private void layoutUIControls() {
        int requiredLabelWidth = this.uih.getAverageLabelWidth(new Label[]{this.pcbNameReq});
        this.leftLabelSize = this.uih.getAverageLabelWidth(new Label[]{this.pcbNameLabelFormat, this.pcbNameLabel, this.pcbAliasLabel, this.ltermLabel}) + margin + requiredLabelWidth;
        this.rightLabelSize = this.uih.getAverageLabelWidth(new Label[]{this.altrespLabel, this.sametrmLabel, this.modifyLabel, this.expressLabel, this.listLabel}) + margin;
        FormLayout layout = new FormLayout();
        layout.marginHeight = margin;
        layout.marginWidth = margin;
        FormData fd = this.uih.genFormData(new FormAttachment(0, margin + 2), null, new FormAttachment(0, 0), null);
        this.pcbNameReq.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.pcbNameReq, margin), null);
        this.pcbNameLabelFormat.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(0, this.leftLabelSize), null);
        this.pcbNameOrLabel[0].setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.pcbNameOrLabel[0], margin + 10), null);
        this.pcbNameOrLabel[1].setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2 + 2), null, new FormAttachment(0, 0), null);
        this.pcbLabelReq.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2), null, new FormAttachment((Control)this.pcbLabelReq, margin), null);
        this.pcbNameLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2 - 2), null, new FormAttachment(0, this.leftLabelSize), null);
        fd.width = fieldLength;
        this.pcbNameField.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2 - 2), null, new FormAttachment((Control)this.pcbNameField, 0), null);
        this.pcbNameStatus.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameField, spacing * 2 + 2), null, new FormAttachment(0, 0), null);
        this.pcbAliasReq.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameField, spacing * 2), null, new FormAttachment((Control)this.pcbLabelReq, margin), null);
        this.pcbAliasLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameField, spacing * 2 - 2), null, new FormAttachment(0, this.leftLabelSize), null);
        fd.width = fieldLength;
        this.pcbAliasField.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameField, spacing * 2 - 2), null, new FormAttachment((Control)this.pcbNameField, 0), null);
        this.pcbAliasStatus.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasField, spacing * 2 + 2), null, new FormAttachment(0, 0), null);
        this.nameReq.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasField, spacing * 2), null, new FormAttachment((Control)this.nameReq, margin), null);
        this.ltermLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasField, spacing * 2), null, new FormAttachment(0, this.leftLabelSize), null);
        fd.width = fieldLength;
        this.ltermNameField.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasField, spacing * 2), null, new FormAttachment((Control)this.ltermNameField, 0), null);
        this.ltermStatus.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(left2Percentage), null);
        this.altrespLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, margin - 2), null, new FormAttachment(left2Percentage, this.rightLabelSize), new FormAttachment(right2Percentage, margin));
        this.altrespCombo.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.altrespCombo, spacing * 2), null, new FormAttachment(left2Percentage), null);
        this.sametrmLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.altrespCombo, spacing * 2 - 2), null, new FormAttachment(left2Percentage, this.rightLabelSize), new FormAttachment(right2Percentage, margin));
        this.sametrmCombo.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.sametrmCombo, spacing * 2), null, new FormAttachment(left2Percentage), null);
        this.modifyLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.sametrmCombo, spacing * 2 - 2), null, new FormAttachment(left2Percentage, this.rightLabelSize), new FormAttachment(right2Percentage, margin));
        this.modifyCombo.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.sametrmLabel, spacing * 2 - 2), null, new FormAttachment((Control)this.modifyCombo, 0), null);
        this.modifyStatus.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.modifyCombo, spacing * 2), null, new FormAttachment(left2Percentage), null);
        this.expressLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.modifyCombo, spacing * 2 - 2), null, new FormAttachment(left2Percentage, this.rightLabelSize), new FormAttachment(right2Percentage, margin));
        this.expressCombo.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.expressCombo, spacing * 2), null, new FormAttachment(left2Percentage), null);
        this.listLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.expressCombo, spacing * 2 - 2), null, new FormAttachment(left2Percentage, this.rightLabelSize), new FormAttachment(right2Percentage, margin));
        this.listCombo.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)this.expressLabel, spacing * 2 - 3), null, new FormAttachment((Control)this.listCombo, 0), null);
        this.listStatus.setLayoutData((Object)fd);
    }
}

