/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.wizard.editpcb;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.ResourceMultiPageEditor;
import com.ibm.im.ims.workbench.editors.figures.FigureConstants;
import com.ibm.im.ims.workbench.editors.form.PsbSummaryPage;
import com.ibm.im.ims.workbench.editors.model.PsbGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.InvalidInputException;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.TableItemEditWizardPage;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.FileEditorInput;

public class EditGsamPcbWizardPage1
extends TableItemEditWizardPage
implements SelectionListener,
ModifyListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private PsbSummaryPage parentPage;
    private boolean addingNewTableItem;
    private PcbGsamModel currGsamPcb;
    private static int margin = 3;
    private static int spacing = 10;
    private Text pcbNameField;
    private Text pcbAliasField;
    private Combo procoptCombo;
    private Combo listCombo;
    private Combo dbdNameCombo;
    private Label pcbNameStatus;
    private Label pcbAliasStatus;
    private Label dbdNameStatus;
    private Label listStatus;
    private Label procoptStatus;
    private Label pcbNameReq;
    private Label pcbAliasReq;
    private Label pcbLabelReq;
    private Button[] pcbNameOrLabel;
    private static final String[] yesOrNo = new String[]{WorkbenchPlugin.labels.getString("YES"), WorkbenchPlugin.labels.getString("NO")};
    private static final String get = "G (Get)";
    private static final String getSequential = "GS (Get sequential)";
    private static final String load = "L (Load)";
    private static final String loadSequential = "LS (Load sequential)";
    private static final String[] gsamProcopts = new String[]{"", "G (Get)", "GS (Get sequential)", "L (Load)", "LS (Load sequential)"};
    private String[] dbdNames;
    private Composite parent;
    private UIHelper uih;
    private FormData fd;
    private Label requiredLabel1;
    private Label dbNameLabel;
    private Label pcbNameLabel;
    private Label requiredLabel2;
    private Label pcbNameLabelFormat;
    private Label procoptLabel;
    private Label listLabel;
    private Label pcbAliasLabel;
    private int leftLabelSize;
    private static final String DB_NAME_LABEL = WorkbenchPlugin.labels.getString("WB422") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB422") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String PCB_NAME_LABEL = WorkbenchPlugin.labels.getString("WB430") + WorkbenchPlugin.colon.getString("COLON");
    private static final String PCB_ALIAS_LABEL = WorkbenchPlugin.labels.getString("WB211") + " " + WorkbenchPlugin.noxlatlabels.getString("WB091") + WorkbenchPlugin.colon.getString("COLON");
    private static final String PROCOPT_LABEL = WorkbenchPlugin.labels.getString("WB423") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB423") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String LIST_LABEL = WorkbenchPlugin.labels.getString("WB421") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB421") + ")" + WorkbenchPlugin.colon.getString("COLON");
    private static final String PCBNAME_FORMAT_LABEL = WorkbenchPlugin.labels.getString("WB420") + WorkbenchPlugin.colon.getString("COLON");
    private static final int comboWidth = 200;
    private boolean isReadOnly;

    public EditGsamPcbWizardPage1(String pageName, TableItem tableItem, PsbSummaryPage parentPage, boolean addingNewTableItem, boolean isReadOnly) {
        super(pageName, tableItem);
        this.setTitle(addingNewTableItem ? WorkbenchPlugin.descriptions.getString("WB503A") : WorkbenchPlugin.descriptions.getString("WB503B"));
        this.setDescription(WorkbenchPlugin.descriptions.getString("WB504"));
        this.setImageDescriptor(Utility.getImageDescriptor(addingNewTableItem ? WorkbenchPlugin.icons.getString("addPcb") : WorkbenchPlugin.icons.getString("editPcb")));
        this.parentPage = parentPage;
        this.addingNewTableItem = addingNewTableItem;
        this.isReadOnly = isReadOnly;
        if (addingNewTableItem) {
            this.createNewGsamPcb();
        } else {
            this.setCurrentPcb();
        }
        this.setPageComplete(false);
    }

    private void setCurrentPcb() {
        PsbModel psb = ((PsbGEFModel)this.parentPage.getRMEParent().getDbdOrPcbList()).getPsb();
        this.currGsamPcb = psb.getGsamPcbWithNum(Integer.valueOf(this.tableItem.getText(0)).intValue());
        if (this.currGsamPcb == null) {
            throw new RuntimeException("IMS Explorer Error: selected pcb does not exist in the model");
        }
    }

    private void createNewGsamPcb() {
        PcbGsamModel gsamPcb;
        this.currGsamPcb = gsamPcb = new PcbGsamModel();
    }

    public void removeNewPCBFromModel() {
        PsbModel psb = ((PsbGEFModel)this.parentPage.getRMEParent().getDbdOrPcbList()).getPsb();
        psb.removeGsamPcb(this.currGsamPcb);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        super.widgetDefaultSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        try {
            this.validatePage();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
    }

    public void modifyText(ModifyEvent e) {
        try {
            if (e.widget == this.dbdNameCombo) {
                this.dbdNameComboModifyText();
            } else if (e.widget == this.pcbNameField) {
                this.pcbNameFieldModifyText();
            } else if (e.widget == this.pcbAliasField) {
                this.pcbAliasFieldModifyText();
            } else if (e.widget == this.procoptCombo) {
                this.procoptComboModifyText();
            } else if (e.widget == this.listCombo) {
                this.listComboModifyText();
            }
            this.validatePage();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", err);
            logger.error(err);
        }
    }

    private void validatePage() throws CoreException {
        try {
            this.setErrorMessage(null);
            boolean dbdNameSpecified = this.validateDbdNameInput();
            boolean procoptSpecified = this.validateProcoptInput();
            boolean pcbNameSpecified = this.validatePcbNameInput();
            boolean pcbAliasSpecified = this.validatePcbAliasInput();
            this.setPageComplete(dbdNameSpecified && procoptSpecified && pcbNameSpecified && pcbAliasSpecified);
        }
        catch (InvalidInputException iie) {
            String message = iie.getMessage();
            this.setErrorMessage(message);
            Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB422")};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(message);
            this.dbdNameStatus.setToolTipText(formatter.format(messageArguments));
            this.dbdNameStatus.setImage(FigureConstants.ERROR);
            this.dbdNameStatus.setVisible(true);
            this.setPageComplete(false);
        }
    }

    private boolean isPcbNameRequired() {
        if (this.listCombo != null) {
            String listStr = this.listCombo.getText().trim();
            if (listStr != null && listStr.equals(yesOrNo[1])) {
                return true;
            }
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            if (store != null && store.getBoolean("explorer_enable_ims_jdbc")) {
                return true;
            }
        }
        return false;
    }

    private boolean validatePcbAliasInput() {
        this.pcbAliasFieldModifyText();
        return !this.pcbAliasStatus.isVisible();
    }

    private boolean validatePcbNameInput() {
        block5: {
            String pcbNameStr = this.pcbNameField.getText().trim();
            if (pcbNameStr == null || pcbNameStr.length() <= 0) break block5;
            if (this.validPcbName(pcbNameStr) > 0) {
                Object[] messageArguments = new Object[]{pcbNameStr, this.validPcbName(pcbNameStr)};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC13"));
                this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
                this.pcbNameStatus.setVisible(true);
                return false;
            }
        }
        try {
            if (this.isPcbNameRequired()) {
                Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB420"), WorkbenchPlugin.labels.getString("LABEL")};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC12"));
                this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
                this.pcbNameStatus.setVisible(true);
                return false;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "validatePcbNameInput()", e);
            logger.error(e);
        }
        this.pcbNameStatus.setToolTipText(null);
        this.pcbNameStatus.setVisible(false);
        return true;
    }

    private boolean validateDbdNameInput() throws CoreException, InvalidInputException {
        boolean retVal = false;
        if (this.addingNewTableItem) {
            ResourceMultiPageEditor editor;
            FileEditorInput fileInput;
            IFile file;
            IPath path;
            String projectName;
            String dbdNameStr = this.dbdNameCombo.getText().trim();
            if (dbdNameStr != null && dbdNameStr.length() > 0 && ProjectTreeFileHelper.isDbdMetadataFileExists((String)(projectName = (path = (file = (fileInput = (FileEditorInput)(editor = this.parentPage.getRMEParent()).getEditorInput()).getFile()).getFullPath()).segments()[0]), (String)dbdNameStr)) {
                DbdModel dbdModel = this.parentPage.getDbdModel(dbdNameStr);
                DBDConstants DBType = dbdModel.getAccessType();
                if (dbdModel != null && DBType != null) {
                    if (!DBType.equals((Object)DBDConstants.GSAM)) {
                        Object[] inserts = new Object[]{dbdNameStr, DBType.toString(), WorkbenchModelBundle.getError().getString("GSAM_DB")};
                        throw new InvalidInputException(WorkbenchModelBundle.getError().getString("EISRC60", inserts));
                    }
                    retVal = true;
                }
            }
        } else {
            retVal = true;
        }
        return retVal;
    }

    private boolean validateProcoptInput() {
        boolean retVal = false;
        try {
            String procoptStr = this.procoptCombo.getText().trim();
            if (procoptStr != null && procoptStr.length() > 0) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "validateProcoptInput()", e);
            logger.error(e);
        }
        return retVal;
    }

    private void dbdNameComboModifyText() {
        String dbdName = this.dbdNameCombo.getText();
        if (dbdName.length() == 0) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB422")};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC15"));
            this.dbdNameStatus.setToolTipText(formatter.format(messageArguments));
            this.dbdNameStatus.setImage(FigureConstants.ERROR);
            this.dbdNameStatus.setVisible(true);
        } else if (!this.dbdExists(this.dbdNameCombo.getText())) {
            Object[] messageArguments = new Object[]{this.dbdNameCombo.getText()};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC20"));
            this.dbdNameStatus.setToolTipText(formatter.format(messageArguments));
            this.dbdNameStatus.setImage(FigureConstants.WARNING);
            this.dbdNameStatus.setVisible(true);
        } else {
            this.dbdNameStatus.setToolTipText(null);
            this.dbdNameStatus.setVisible(false);
        }
    }

    private void setDbdName() {
        String dbdName = this.dbdNameCombo.getText();
        if (!dbdName.equals(this.currGsamPcb.getDbdName())) {
            this.currGsamPcb.setDbdName(dbdName);
        }
    }

    private int validPcbName(String pcbName) {
        TableItem tableItem;
        int i;
        int pcbNumber = 0;
        if (this.parentPage.getTpPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getTpPcbTable().getItemCount()) {
                tableItem = this.parentPage.getTpPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(1).equals(pcbName)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getDbPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getDbPcbTable().getItemCount()) {
                tableItem = this.parentPage.getDbPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(1).equals(pcbName)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getGsamPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getGsamPcbTable().getItemCount()) {
                tableItem = this.parentPage.getGsamPcbTable().getItem(i);
                ++pcbNumber;
                if (this.tableItem != tableItem && pcbName.equals(tableItem.getText(1))) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        return -1;
    }

    private int validPcbAlias(String pcbAlias) {
        TableItem tableItem;
        int i;
        int pcbNumber = 0;
        if (this.parentPage.getTpPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getTpPcbTable().getItemCount()) {
                tableItem = this.parentPage.getTpPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(2).equals(pcbAlias)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getDbPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getDbPcbTable().getItemCount()) {
                tableItem = this.parentPage.getDbPcbTable().getItem(i);
                ++pcbNumber;
                if (tableItem.getText(2).equals(pcbAlias)) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        if (this.parentPage.getGsamPcbTable() != null) {
            i = 0;
            while (i < this.parentPage.getGsamPcbTable().getItemCount()) {
                tableItem = this.parentPage.getGsamPcbTable().getItem(i);
                ++pcbNumber;
                if (this.tableItem != tableItem && pcbAlias.equals(tableItem.getText(2))) {
                    return pcbNumber;
                }
                ++i;
            }
        }
        return -1;
    }

    private void pcbNameFieldModifyText() {
        String pcbName = this.pcbNameField.getText();
        int pcbNumber = this.validPcbName(pcbName);
        if (pcbName.length() > 0 && Utility.hasSpecialChar(pcbName)) {
            this.pcbNameStatus.setToolTipText(WorkbenchPlugin.errors.getString("EISRC8"));
            this.pcbNameStatus.setVisible(true);
        } else if (pcbName.length() > 0 && pcbNumber > 0) {
            Object[] messageArguments = new Object[]{pcbName, this.validPcbName(pcbName), pcbName};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC13"));
            this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
            this.pcbNameStatus.setVisible(true);
        } else if (pcbName.length() == 0 && this.listCombo.getText().equals(yesOrNo[1])) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB420"), WorkbenchPlugin.labels.getString("LABEL")};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC12"));
            this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
            this.pcbNameStatus.setVisible(true);
        } else {
            this.listStatus.setToolTipText(null);
            this.listStatus.setVisible(false);
            this.pcbNameStatus.setToolTipText(null);
            this.pcbNameStatus.setVisible(false);
        }
    }

    private void pcbAliasFieldModifyText() {
        String pcbAlias = this.pcbAliasField.getText().trim();
        int aliasLen = pcbAlias.length();
        if (aliasLen > 0 && aliasLen <= 128) {
            if (Utility.hasSpecialChar(pcbAlias) || pcbAlias.indexOf(32) >= 0) {
                Object[] attrs = new String[]{pcbAlias, WorkbenchPlugin.labels.getString("WB211")};
                this.pcbAliasStatus.setToolTipText(Utility.formatMessage(WorkbenchPlugin.errors.getString("EDIT_TEMPLATE_WIZ_5", attrs)));
                this.pcbAliasStatus.setVisible(true);
            } else if (this.validPcbAlias(pcbAlias) > 0) {
                Object[] messageArguments = new Object[]{pcbAlias, this.validPcbAlias(pcbAlias), pcbAlias};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC13"));
                this.pcbAliasStatus.setToolTipText(formatter.format(messageArguments));
                this.pcbAliasStatus.setVisible(true);
            } else {
                this.pcbAliasStatus.setToolTipText(null);
                this.pcbAliasStatus.setVisible(false);
            }
        } else if (aliasLen > 128) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.labels.getString("WB211"), pcbAlias};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC11"));
            this.pcbAliasStatus.setToolTipText(formatter.format(messageArguments));
            this.pcbAliasStatus.setVisible(true);
        } else {
            this.pcbAliasStatus.setToolTipText(null);
            this.pcbAliasStatus.setVisible(false);
        }
    }

    private void setPcbName() {
        String value = this.pcbNameField.getText();
        if (this.pcbNameOrLabel[0].getSelection()) {
            this.currGsamPcb.setLabel(value);
            this.currGsamPcb.setPcbName(null);
        } else {
            this.currGsamPcb.setPcbName(value);
            this.currGsamPcb.setLabel(null);
        }
    }

    private void setPcbAlias() {
        String value = this.pcbAliasField.getText().trim();
        String oldVal = this.currGsamPcb.getExternalName();
        if (oldVal == null || !oldVal.equals(value)) {
            this.currGsamPcb.setName(value);
        }
    }

    private void setProcopt() {
        DBDConstants procopt = DBDConstants.valueOf((String)this.getProcopt());
        if (!procopt.equals((Object)this.currGsamPcb.getProcopt())) {
            this.currGsamPcb.setProcopt(procopt);
        }
    }

    private void procoptComboModifyText() {
        String procopt = this.getProcopt();
        if (procopt.length() == 0) {
            Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB423")};
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(Locale.getDefault());
            formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC15"));
            this.procoptStatus.setToolTipText(formatter.format(messageArguments));
            this.procoptStatus.setVisible(true);
        } else {
            this.procoptStatus.setToolTipText(null);
            this.procoptStatus.setVisible(false);
        }
    }

    private String getProcopt() {
        return !this.procoptCombo.getText().isEmpty() ? this.procoptCombo.getText().substring(0, 2).trim() : "";
    }

    protected String getProcopt(String procopt) {
        if (procopt.equals("G")) {
            return get;
        }
        if (procopt.equals("GS")) {
            return getSequential;
        }
        if (procopt.equals("L")) {
            return load;
        }
        if (procopt.equals("LS")) {
            return loadSequential;
        }
        return procopt;
    }

    private void listComboModifyText() {
        String pcbName = this.pcbNameField.getText();
        String list = this.listCombo.getText();
        boolean isRequired = this.isPcbNameRequired();
        this.pcbNameReq.setVisible(isRequired);
        this.pcbLabelReq.setVisible(isRequired);
        if (isRequired) {
            if (list.equals(yesOrNo[1]) && pcbName.length() == 0) {
                Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB421"), yesOrNo[1], WorkbenchPlugin.noxlatlabels.getString("WB420"), WorkbenchPlugin.labels.getString("LABEL")};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC14"));
                this.listStatus.setToolTipText(formatter.format(messageArguments));
                this.listStatus.setVisible(true);
            } else if (pcbName.length() == 0) {
                Object[] messageArguments = new Object[]{WorkbenchPlugin.noxlatlabels.getString("WB420"), WorkbenchPlugin.labels.getString("LABEL")};
                MessageFormat formatter = new MessageFormat("");
                formatter.setLocale(Locale.getDefault());
                formatter.applyPattern(WorkbenchPlugin.errors.getString("EISRC12"));
                this.pcbNameStatus.setToolTipText(formatter.format(messageArguments));
                this.pcbNameStatus.setVisible(true);
                if (list.equals(yesOrNo[0])) {
                    this.listStatus.setToolTipText(null);
                    this.listStatus.setVisible(false);
                }
            } else {
                this.pcbNameStatus.setToolTipText(null);
                this.pcbNameStatus.setVisible(false);
                this.listStatus.setToolTipText(null);
                this.listStatus.setVisible(false);
            }
        } else {
            this.pcbNameStatus.setToolTipText(null);
            this.pcbNameStatus.setVisible(false);
            this.listStatus.setToolTipText(null);
            this.listStatus.setVisible(false);
        }
    }

    private void setList() {
        String value = this.listCombo.getText();
        DBDConstants newValue = PsbSummaryPage.getYesNoConstant(value);
        if (!this.currGsamPcb.getList().equals((Object)newValue)) {
            this.currGsamPcb.setList(newValue);
        }
    }

    private boolean dbdExists(String dbdName) {
        int i = 0;
        while (this.dbdNames != null && i < this.dbdNames.length) {
            if (dbdName.equals(this.dbdNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
    }

    public void createControl(Composite composite) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite composite)", new Object[0]);
        try {
            this.parent = new Composite(composite, 0);
            this.parent.setLayout((Layout)new FormLayout());
            this.uih = new UIHelper();
            Display display = this.parent.getDisplay();
            this.uih.setDisplay(display);
            this.createUIControl();
            this.layoutUIControls();
            if (!this.addingNewTableItem) {
                this.initWidgetValues(this.parent.getChildren());
            } else {
                this.initWidgetsWithInputDefaults(this.parent.getChildren());
                this.initDbdNames();
            }
            this.addListeners();
            boolean isRequired = this.isPcbNameRequired();
            this.pcbNameReq.setVisible(isRequired);
            this.pcbLabelReq.setVisible(isRequired);
            if (this.isReadOnly) {
                this.pcbNameOrLabel[0].setEnabled(false);
                this.pcbNameOrLabel[1].setEnabled(false);
                this.pcbNameField.setEnabled(false);
                this.pcbAliasField.setEnabled(false);
                this.procoptCombo.setEnabled(false);
                this.listCombo.setEnabled(false);
                this.dbdNameCombo.setEnabled(false);
            }
            this.setPageComplete(false);
            this.setControl((Control)this.parent);
            Point point = this.getShell().computeSize(-1, -1, true);
            this.getShell().setMinimumSize(point.x, point.y + margin * spacing);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite composite)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite composite)", new Object[0]);
    }

    @Override
    public void initWidgetValues(Control[] children) {
        super.initWidgetValues(children);
        try {
            if (this.addingNewTableItem && this.dbdNames == null) {
                this.dbdNames = this.parentPage.getGsamDbNames();
                if (this.dbdNames != null) {
                    this.dbdNameCombo.setItems(this.dbdNames);
                } else {
                    this.dbdNameCombo.setItems(new String[]{""});
                }
            }
            TableColumn[] columns = this.tableItem.getParent().getColumns();
            int i = 0;
            while (i < columns.length) {
                String text = this.tableItem.getText(i);
                if (columns[i].getText().equals(WorkbenchPlugin.noxlatlabels.getString("WB421"))) {
                    this.listCombo.setText(text);
                    this.listComboModifyText();
                } else if (columns[i].getText().equals(WorkbenchPlugin.noxlatlabels.getString("WB422"))) {
                    if (this.addingNewTableItem) {
                        this.dbdNameCombo.setText(text);
                        this.dbdNameComboModifyText();
                    }
                } else if (columns[i].getText().equals(WorkbenchPlugin.noxlatlabels.getString("WB423"))) {
                    this.procoptCombo.setText(this.getProcopt(text));
                    this.procoptComboModifyText();
                }
                ++i;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
    }

    private void initDbdNames() {
        if (this.dbdNames == null) {
            this.dbdNames = this.parentPage.getGsamDbNames();
            if (this.dbdNames != null) {
                this.dbdNameCombo.setItems(this.dbdNames);
            } else {
                this.dbdNameCombo.setItems(new String[]{""});
            }
        }
    }

    public void addCurrPcbToModel() {
        PsbModel psb = ((PsbGEFModel)this.parentPage.getRMEParent().getDbdOrPcbList()).getPsb();
        psb.addGSAMPcb(this.currGsamPcb);
    }

    public void updateMetadataWithWidgetValues() {
        this.setDbdName();
        this.setPcbName();
        this.setPcbAlias();
        this.setProcopt();
        this.setList();
    }

    private void addListeners() {
        this.pcbNameField.addModifyListener((ModifyListener)this);
        this.pcbAliasField.addModifyListener((ModifyListener)this);
        if (this.addingNewTableItem) {
            this.dbdNameCombo.addModifyListener((ModifyListener)this);
        }
        this.listCombo.addModifyListener((ModifyListener)this);
        this.procoptCombo.addModifyListener((ModifyListener)this);
        this.pcbNameOrLabel[0].addSelectionListener((SelectionListener)this);
        this.pcbNameOrLabel[1].addSelectionListener((SelectionListener)this);
        this.pcbNameField.addVerifyListener((VerifyListener)this);
        this.pcbAliasField.addVerifyListener((VerifyListener)this);
        if (this.addingNewTableItem) {
            this.dbdNameCombo.addVerifyListener((VerifyListener)this);
        }
    }

    private void createUIControl() {
        this.pcbNameReq = this.uih.genRequiredSymbol(this.parent, 0, this.fd, this.parent.getDisplay().getSystemColor(3));
        this.pcbNameLabelFormat = new Label(this.parent, 0);
        this.pcbNameLabelFormat.setText(PCBNAME_FORMAT_LABEL);
        this.pcbNameLabelFormat.setToolTipText(WorkbenchPlugin.descriptions.getString("WB441"));
        this.pcbNameOrLabel = new Button[2];
        this.pcbNameOrLabel[0] = new Button(this.parent, 16);
        this.pcbNameOrLabel[0].setText(WorkbenchPlugin.labels.getString("LABEL"));
        this.pcbNameOrLabel[0].setToolTipText(WorkbenchPlugin.descriptions.getString("WB442"));
        this.pcbNameOrLabel[0].setData("ID", (Object)DBDConstants.PCB_NAME_LABEL_GROUP.toString());
        this.pcbNameOrLabel[0].setData("DEFAULT", (Object)"true");
        this.pcbNameOrLabel[1] = new Button(this.parent, 16);
        this.pcbNameOrLabel[1].setText(WorkbenchPlugin.noxlatlabels.getString("WB420"));
        this.pcbNameOrLabel[1].setToolTipText(WorkbenchPlugin.descriptions.getString("WB443"));
        this.pcbNameOrLabel[1].setData("ID", (Object)DBDConstants.PCB_NAME_LABEL_GROUP.toString());
        this.pcbLabelReq = this.uih.genRequiredSymbol(this.parent, 0, null, this.parent.getDisplay().getSystemColor(3));
        this.pcbLabelReq.setVisible(false);
        this.pcbNameLabel = new Label(this.parent, 0);
        this.pcbNameLabel.setText(PCB_NAME_LABEL);
        this.pcbNameField = new Text(this.parent, 2048);
        this.pcbNameField.setText("");
        this.pcbNameField.setTextLimit(8);
        this.pcbNameField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB403"));
        this.setInputDefault((Control)this.pcbNameField, WorkbenchPlugin.labels.getString("PSP_PCB_NAME"), "");
        this.pcbNameStatus = new Label(this.parent, 0);
        this.pcbNameStatus.setImage(FigureConstants.ERROR);
        this.pcbNameStatus.setVisible(false);
        this.pcbAliasReq = this.uih.genRequiredSymbol(this.parent, 0, null, this.parent.getDisplay().getSystemColor(3));
        this.pcbAliasReq.setVisible(false);
        this.pcbAliasLabel = new Label(this.parent, 0);
        this.pcbAliasLabel.setText(PCB_ALIAS_LABEL);
        this.pcbAliasField = new Text(this.parent, 2048);
        this.pcbAliasField.setText("");
        this.pcbAliasField.setTextLimit(128);
        this.pcbAliasField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB449"));
        this.setInputDefault((Control)this.pcbAliasField, WorkbenchPlugin.labels.getString("WB211"), "");
        this.pcbAliasStatus = new Label(this.parent, 0);
        this.pcbAliasStatus.setImage(FigureConstants.ERROR);
        this.pcbAliasStatus.setVisible(false);
        this.requiredLabel1 = this.uih.genRequiredSymbol(this.parent, 0, null, this.parent.getDisplay().getSystemColor(3));
        this.dbNameLabel = new Label(this.parent, 0);
        this.dbNameLabel.setText(DB_NAME_LABEL);
        this.dbNameLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB410"));
        this.dbdNameCombo = new Combo(this.parent, 0);
        this.dbdNameCombo.setTextLimit(8);
        this.dbdNameCombo.setToolTipText(WorkbenchPlugin.descriptions.getString("WB410"));
        this.dbdNameCombo.setEnabled(this.addingNewTableItem);
        this.dbdNameStatus = new Label(this.parent, 0);
        this.dbdNameStatus.setImage(FigureConstants.ERROR);
        this.dbdNameStatus.setVisible(false);
        this.setInputDefault((Control)this.dbdNameCombo, WorkbenchPlugin.noxlatlabels.getString("WB422"), "");
        this.requiredLabel2 = this.uih.genRequiredSymbol(this.parent, 0, null, this.parent.getDisplay().getSystemColor(3));
        this.procoptLabel = new Label(this.parent, 0);
        this.procoptLabel.setText(PROCOPT_LABEL);
        this.procoptLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB411"));
        this.procoptCombo = new Combo(this.parent, 8);
        this.procoptCombo.setItems(gsamProcopts);
        this.setInputDefault((Control)this.procoptCombo, WorkbenchPlugin.noxlatlabels.getString("WB423"), "");
        this.procoptStatus = new Label(this.parent, 0);
        this.procoptStatus.setImage(FigureConstants.ERROR);
        this.procoptStatus.setVisible(false);
        this.listLabel = new Label(this.parent, 0);
        this.listLabel.setText(LIST_LABEL);
        this.listLabel.setToolTipText(WorkbenchPlugin.descriptions.getString("WB409"));
        this.listCombo = new Combo(this.parent, 8);
        this.listCombo.setItems(yesOrNo);
        this.listCombo.setText(yesOrNo[0]);
        this.listCombo.setToolTipText(WorkbenchPlugin.descriptions.getString("WB409"));
        this.setInputDefault((Control)this.listCombo, WorkbenchPlugin.noxlatlabels.getString("WB421"), yesOrNo[0]);
        this.listStatus = new Label(this.parent, 0);
        this.listStatus.setImage(FigureConstants.ERROR);
        this.listStatus.setVisible(false);
    }

    private void layoutUIControls() {
        int requiredLabelWidth = this.uih.getAverageLabelWidth(new Label[]{this.pcbNameReq});
        this.leftLabelSize = this.uih.getAverageLabelWidth(new Label[]{this.pcbNameLabelFormat, this.pcbNameLabel, this.dbNameLabel, this.procoptLabel, this.listLabel}) + requiredLabelWidth + margin;
        this.fd = this.uih.genFormData(new FormAttachment(0, margin + 2), null, new FormAttachment(0, 0), null);
        this.pcbNameReq.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.pcbNameReq, margin), null);
        this.pcbNameLabelFormat.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(0, this.leftLabelSize), null);
        this.pcbNameOrLabel[0].setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.pcbNameOrLabel[0], margin + 10), null);
        this.pcbNameOrLabel[1].setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2 + 2), null, new FormAttachment(0, 0), null);
        this.pcbLabelReq.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2), null, new FormAttachment((Control)this.pcbLabelReq, margin), null);
        this.pcbNameLabel.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(0, this.leftLabelSize + 200));
        this.pcbNameField.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabelFormat, spacing * 2), null, new FormAttachment((Control)this.pcbNameField, 0), null);
        this.pcbNameStatus.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabel, spacing * 2 + 2), null, new FormAttachment(0, 0), null);
        this.pcbAliasReq.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabel, spacing * 2), null, new FormAttachment((Control)this.requiredLabel1, margin), null);
        this.pcbAliasLabel.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabel, spacing * 2), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(0, this.leftLabelSize + 200));
        this.pcbAliasField.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbNameLabel, spacing * 2), null, new FormAttachment((Control)this.pcbAliasField, 0), null);
        this.pcbAliasStatus.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasLabel, spacing * 2 + 2), null, new FormAttachment(0, 0), null);
        this.requiredLabel1.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasLabel, spacing * 2), null, new FormAttachment((Control)this.requiredLabel1, margin), null);
        this.dbNameLabel.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasLabel, spacing * 2), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(0, this.leftLabelSize + 200));
        this.dbdNameCombo.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.pcbAliasLabel, spacing * 2), null, new FormAttachment((Control)this.dbdNameCombo, 0), null);
        this.dbdNameStatus.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.dbNameLabel, spacing * 2 + 2), null, new FormAttachment(0, 0), null);
        this.requiredLabel2.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.dbNameLabel, spacing * 2), null, new FormAttachment((Control)this.requiredLabel2, margin), null);
        this.procoptLabel.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.dbNameLabel, spacing * 2), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(0, this.leftLabelSize + 200));
        this.procoptCombo.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.dbNameLabel, spacing * 2), null, new FormAttachment((Control)this.procoptCombo, 0), null);
        this.procoptStatus.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.procoptLabel, spacing * 2), null, new FormAttachment((Control)this.requiredLabel2, margin), null);
        this.listLabel.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.procoptLabel, spacing * 2 - 2), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(0, this.leftLabelSize + 200));
        this.listCombo.setLayoutData((Object)this.fd);
        this.fd = this.uih.genFormData(new FormAttachment((Control)this.procoptLabel, spacing * 2), null, new FormAttachment((Control)this.listCombo, 0), null);
        this.listStatus.setLayoutData((Object)this.fd);
    }
}

