/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.utilities.Utility;
import java.io.UnsupportedEncodingException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Warnings
extends MessageDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text text;
    private String warnings;
    private String fontName = null;
    private SegmentGEFModel segmentGEFModel;
    private Label encodingStatus;
    private Label remarksStatus;
    private Text encodingText;
    private boolean isDbd = false;
    private boolean isReadOnly;

    public Warnings(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public Warnings(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, SegmentGEFModel segmentGEFModel, boolean isReadOnly) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.segmentGEFModel = segmentGEFModel;
        this.isDbd = dialogTitle.equals(WorkbenchPlugin.labels.getString("WB498R"));
        this.isReadOnly = isReadOnly;
    }

    public Control createCustomArea(Composite parent) {
        if (this.segmentGEFModel == null) {
            GridData gData = new GridData(1808);
            gData.widthHint = 400;
            gData.heightHint = 200;
            this.text = new Text(parent, 2890);
            this.text.setLayoutData((Object)gData);
            this.text.setText(this.warnings);
            this.setFont();
        } else {
            ((GridLayout)parent.getLayout()).numColumns = 3;
            GridData gData = new GridData(1808);
            gData.heightHint = 25;
            gData.verticalIndent = 4;
            Label label1 = new Label(parent, 0);
            label1.setText(WorkbenchPlugin.labels.getString("WB027A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB477") + ")" + WorkbenchPlugin.colon.getString("COLON"));
            if (this.isDbd) {
                label1.setToolTipText(WorkbenchPlugin.descriptions.getString("WB22A2"));
            } else {
                label1.setToolTipText(WorkbenchPlugin.descriptions.getString("WB22A1"));
            }
            label1.setLayoutData((Object)gData);
            gData = new GridData(1808);
            gData.widthHint = 250;
            gData.heightHint = 23;
            this.encodingText = new Text(parent, 2048);
            this.encodingText.setTextLimit(25);
            this.encodingText.setLayoutData((Object)gData);
            String encoding = WorkbenchPlugin.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
            if (encoding == null || encoding.isEmpty()) {
                encoding = "Cp1047";
            }
            String dbdEncoding = this.segmentGEFModel.getDbGEFModel().getDbdModel().getEncoding();
            if (this.isDbd) {
                if (dbdEncoding != null && !dbdEncoding.isEmpty()) {
                    encoding = dbdEncoding;
                }
            } else {
                String segmentEncoding = this.segmentGEFModel.getSegmentModel().getEncoding();
                if (segmentEncoding != null && !segmentEncoding.isEmpty()) {
                    encoding = segmentEncoding;
                } else if (dbdEncoding != null && !dbdEncoding.isEmpty()) {
                    encoding = dbdEncoding;
                }
            }
            this.encodingText.setText(encoding);
            Object[] args = new Object[]{new String(Character.toChars(8482)), WorkbenchPlugin.colon.getString("COLON")};
            this.encodingText.setToolTipText(WorkbenchPlugin.descriptions.getString("WB23A", args));
            this.encodingText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (Warnings.this.encodingStatus != null && Warnings.this.remarksStatus != null) {
                        Warnings.this.encodingStatus.setToolTipText(null);
                        Warnings.this.encodingStatus.setVisible(false);
                        try {
                            Warnings.this.encodingText.getText().getBytes(Warnings.this.encodingText.getText());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Warnings.this.encodingStatus.setToolTipText(WorkbenchPlugin.errors.getString("EISRC21"));
                            Warnings.this.encodingStatus.setVisible(true);
                        }
                        Warnings.this.getButton(0).setEnabled(!Warnings.this.encodingStatus.isVisible() && !Warnings.this.remarksStatus.isVisible());
                    }
                }
            });
            gData = new GridData(1808);
            gData.heightHint = 25;
            gData.widthHint = 25;
            this.encodingStatus = new Label(parent, 0);
            this.encodingStatus.setImage(IconAndMessageDialog.getImage((String)"dialog_message_error_image"));
            this.encodingStatus.setVisible(false);
            this.encodingStatus.setLayoutData((Object)gData);
            gData = new GridData(1808);
            gData.heightHint = 25;
            gData.verticalIndent = 4;
            Label label2 = new Label(parent, 0);
            label2.setToolTipText(WorkbenchPlugin.descriptions.getString("WB099"));
            label2.setText(WorkbenchPlugin.labels.getString("WB019A") + " (" + WorkbenchPlugin.noxlatlabels.getString("WB478") + ")" + WorkbenchPlugin.colon.getString("COLON"));
            label2.setLayoutData((Object)gData);
            gData = new GridData(1808);
            gData.widthHint = 250;
            gData.heightHint = 100;
            this.text = new Text(parent, 2882);
            this.text.setToolTipText(WorkbenchPlugin.descriptions.getString("WB100"));
            this.text.setLayoutData((Object)gData);
            this.text.setText(this.warnings == null ? "" : this.warnings);
            this.text.setTextLimit(255);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (Warnings.this.encodingStatus != null && Warnings.this.remarksStatus != null) {
                        Warnings.this.remarksStatus.setToolTipText(null);
                        Warnings.this.remarksStatus.setVisible(false);
                        String invalidCharacter = com.ibm.im.ims.workbench.model.utilities.Utility.getInvalidRemarksCharacter((String)Warnings.this.text.getText());
                        if (invalidCharacter != null) {
                            Object[] inserts = new String[]{WorkbenchModelBundle.getLabel().getString("WB019A"), invalidCharacter};
                            Object errorMessage = WorkbenchModelBundle.getError().getString("EISRC11", inserts);
                            if (invalidCharacter.equals("'")) {
                                errorMessage = (String)errorMessage + " " + WorkbenchModelBundle.getError().getString("EISRC11A");
                            }
                            Warnings.this.remarksStatus.setVisible(true);
                            Warnings.this.remarksStatus.setToolTipText(Utility.formatMessage((String)errorMessage));
                        }
                        Warnings.this.getButton(0).setEnabled(!Warnings.this.encodingStatus.isVisible() && !Warnings.this.remarksStatus.isVisible());
                    }
                }
            });
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.character == '\t') {
                        e.text = null;
                        Warnings.this.text.traverse(16);
                    } else if (e.character == '\r') {
                        e.text = null;
                        Warnings.this.text.traverse(4, (KeyEvent)e);
                    }
                }
            });
            gData = new GridData(1808);
            gData.heightHint = 25;
            gData.widthHint = 25;
            this.remarksStatus = new Label(parent, 0);
            this.remarksStatus.setImage(IconAndMessageDialog.getImage((String)"dialog_message_error_image"));
            this.remarksStatus.setVisible(false);
            this.remarksStatus.setLayoutData((Object)gData);
        }
        parent.setSize(parent.computeSize(-1, -1));
        if (this.isReadOnly) {
            this.text.setEditable(false);
            this.encodingText.setEditable(false);
        }
        return parent;
    }

    private void setFont() {
        if (this.text != null && this.fontName != null) {
            Display display = this.text.getDisplay();
            int h = display.getSystemFont().getFontData()[0].getHeight();
            this.text.setFont(new Font((Device)display, this.fontName, h, 0));
        }
    }

    public boolean close() {
        if (this.getReturnCode() == 0 && this.segmentGEFModel != null) {
            String encoding = this.encodingText.getText().trim();
            String remarks = this.text.getText();
            if (this.isDbd) {
                DbdModel dbdModel = this.segmentGEFModel.getDbGEFModel().getDbdModel();
                dbdModel.setEncoding(encoding);
                dbdModel.setRemarks(remarks);
            } else {
                String dbdEncoding = this.segmentGEFModel.getDbGEFModel().getDbdModel().getEncoding();
                SegmentModel segmentModel = this.segmentGEFModel.getSegmentModel();
                if (dbdEncoding == null || !dbdEncoding.equalsIgnoreCase(encoding)) {
                    segmentModel.setEncoding(encoding);
                }
                segmentModel.setRemarks(remarks);
            }
            this.segmentGEFModel.getDbGEFModel().getEditorPage().getPsbMultiPageEditor().setDirty(true);
        }
        return super.close();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (this.segmentGEFModel != null && button.getText().equals(IDialogConstants.OK_LABEL)) {
            button.setEnabled(false);
        }
        return button;
    }

    public void setWarnings(String warnings) {
        this.warnings = warnings;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }
}

