/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.catalog.ui.workflow.FieldImportWorkflowXViewer;
import com.ibm.im.ims.catalog.ui.workflow.MultiPageEditor;
import com.ibm.im.ims.catalog.ui.workflow.WorkflowManager;
import com.ibm.im.ims.catalog.ui.workflow.actions.AddOrEditFieldAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.EditSEGMAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.FieldImportWorkflowImportDSAction;
import com.ibm.im.ims.catalog.ui.workflow.actions.ManageMapCaseAction;
import com.ibm.im.ims.metadata.workflow.field.WorkflowDBD;
import com.ibm.im.ims.metadata.workflow.field.WorkflowMapCaseType;
import com.ibm.im.ims.metadata.workflow.field.WorkflowSegmentType;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowController;
import com.ibm.im.ims.workbench.controller.workflow.field.FieldImportWorkflowModelUtil;
import com.ibm.im.ims.workbench.editors.model.DbGEFModel;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.model.DBDConstants;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.FieldModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import com.ibm.im.ims.workbench.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.model.utilities.WorkbenchModelBundle;
import com.ibm.im.ims.workbench.utilities.InfoDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class Utility {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static Map imageCache;
    private static final String ICON_PATH = "icons/";
    private static final int COMBO_HISTORY_LENGTH = 8;
    public static char[] specialChar;
    private static final String[] reservedNames;
    private static final String[] reservedIMSRoutines;

    static {
        specialChar = new char[]{'<', '>', '&', '\\', '!', '%', '(', ')', '*', '|', '+', '-', ',', '.', ':', ';', '=', '?', '[', ']', '{', '}', '^', '`', '~', ' ', '\"', '\''};
        reservedNames = new String[]{"BASICEDT", "DBCDM", "DBRC", "ISCEDT", "MSDB", "SDB", "WTOR"};
        reservedIMSRoutines = new String[]{"DFS", "DBF", "DSP", "DXR", "BPE", " CQS", "CSL"};
    }

    public static String preparePSBds(String file) {
        int index = file.lastIndexOf(File.separator);
        return file.substring(index + 1);
    }

    public static String removeFileExt(String name) {
        int marker = name.indexOf(".");
        if (marker > -1) {
            return name.substring(0, marker);
        }
        return name;
    }

    public static boolean allAttrsOnPage(String[] errorAttrs, String[] pageAttrs) {
        boolean retVal = true;
        int i = 0;
        while (i < errorAttrs.length) {
            String currErrorAttr = errorAttrs[i];
            boolean currErrorAttrExistsOnPage = false;
            int j = 0;
            while (j < pageAttrs.length) {
                String currPageAttr = pageAttrs[j];
                if (currErrorAttr.equals(currPageAttr)) {
                    currErrorAttrExistsOnPage = true;
                    break;
                }
                ++j;
            }
            if (!currErrorAttrExistsOnPage) {
                retVal = false;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public static String getInvalidRemarksCharacter(String remarks) {
        String retVal = null;
        if (remarks.indexOf("<") >= 0) {
            retVal = "<";
        } else if (remarks.indexOf(">") >= 0) {
            retVal = ">";
        } else if (remarks.indexOf("&") >= 0) {
            retVal = "&";
        } else if (remarks.indexOf(34) >= 0) {
            retVal = "\"";
        } else if (remarks.indexOf("'") >= 0) {
            retVal = "'";
        }
        return retVal;
    }

    public static boolean hasReservedName(String text) {
        int i = 0;
        while (i < reservedNames.length) {
            if (text.toUpperCase().equals(reservedNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasReservedName(String datasetName, VerifyEvent event) {
        if (event.character == '\b') {
            datasetName = ((String)datasetName).substring(0, event.start) + ((String)datasetName).substring(event.end);
        } else if (event.character == '\u007f') {
            datasetName = (event.start > 0 ? ((String)datasetName).substring(0, event.start) : "") + (event.end < ((String)datasetName).length() ? ((String)datasetName).substring(event.end) : "");
        }
        return Utility.hasReservedName((String)datasetName + event.text);
    }

    public static boolean hasReservedIMSRoutines(String text) {
        int i = 0;
        while (i < reservedIMSRoutines.length) {
            if (text.toUpperCase().equals(reservedIMSRoutines[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasReservedIMSRoutines(String datasetName, VerifyEvent event) {
        if (event.character == '\b') {
            datasetName = ((String)datasetName).substring(0, event.start) + ((String)datasetName).substring(event.end);
        } else if (event.character == '\u007f') {
            datasetName = (event.start > 0 ? ((String)datasetName).substring(0, event.start) : "") + (event.end < ((String)datasetName).length() ? ((String)datasetName).substring(event.end) : "");
        }
        return Utility.hasReservedIMSRoutines((String)datasetName + event.text);
    }

    public static boolean isStringNumeric(String text) {
        try {
            if (text.length() > 0) {
                Integer.parseInt(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isStringNumeric(String text, VerifyEvent event) {
        return Utility.isStringNumeric(Utility.getCurrentString(text, event) + event.text);
    }

    public static String getCurrentString(String string, VerifyEvent event) {
        if (event.character == '\b') {
            return string.substring(0, event.start) + string.substring(event.end) + event.text;
        }
        if (event.character == '\u007f' || String.valueOf(event.character).trim().length() > 0) {
            return (event.start > 0 ? string.substring(0, event.start) : "") + (event.end < string.length() ? string.substring(event.end) : "") + event.text;
        }
        return string;
    }

    public static boolean hasSpecialChar(String text) {
        int i = 0;
        while (i < specialChar.length) {
            if (text.length() <= 8 && text.indexOf(specialChar[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasSpecialChar(String datasetName, VerifyEvent event) {
        if (event.character == '\b') {
            datasetName = ((String)datasetName).substring(0, event.start) + ((String)datasetName).substring(event.end);
        } else if (event.character == '\u007f') {
            datasetName = (event.start > 0 ? ((String)datasetName).substring(0, event.start) : "") + (event.end < ((String)datasetName).length() ? ((String)datasetName).substring(event.end) : "");
        }
        return Utility.hasSpecialChar((String)datasetName + event.text);
    }

    public static URL getURL(String path) {
        try {
            WorkbenchPlugin plugin = WorkbenchPlugin.getDefault();
            URL installURL = plugin.getBundle().getEntry(File.separator);
            URL url = FileLocator.resolve((URL)installURL);
            return new URL(url, path);
        }
        catch (Exception e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.Utility", "getURL(String path)", (Throwable)e);
            logger.error((Throwable)e);
            return null;
        }
    }

    public static boolean foundFile(String relativePath) {
        try {
            URL url = Utility.getURL(relativePath);
            File file = new File(url.getFile());
            return file.exists();
        }
        catch (Exception e) {
            logger.throwing("com.ibm.im.ims.workbench.utilities.Utility", "foundFile(String relativePath)", (Throwable)e);
            logger.error((Throwable)e);
            return false;
        }
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        ImageDescriptor img;
        if (imageCache == null) {
            imageCache = new HashMap();
        }
        if ((img = (ImageDescriptor)imageCache.get(fileName)) == null) {
            URL url = Utility.getURL(ICON_PATH + fileName);
            img = ImageDescriptor.createFromURL((URL)url);
            imageCache.put(fileName, img);
        }
        return img;
    }

    public static String doReplace(String strIn) {
        StringBuffer finalStr = new StringBuffer();
        String digit = "0123456789";
        int i = 0;
        while (i < strIn.length()) {
            char ch = strIn.charAt(i);
            if (digit.indexOf(ch) != -1) {
                ch = '%';
            }
            finalStr.append(ch);
            ++i;
        }
        return finalStr.toString();
    }

    public static boolean isDuplicateSegmentAlias(SegmentGEFModel segment, String newAlias) {
        if (!segment.getSegmentAlias().equals(newAlias)) {
            Vector segmentList = segment.getDbGEFModel().getNonSelectedSegments(segment.getSegmentAlias());
            int i = 0;
            while (i < segmentList.size()) {
                SegmentGEFModel dliSegmentModel = (SegmentGEFModel)segmentList.get(i);
                if (dliSegmentModel.getSegmentAlias().equals(newAlias)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isDuplicateFieldAlias(FieldGEFModel field, String newAlias) {
        if (!field.getAlias().equals(newAlias)) {
            Vector<FieldGEFModel> fieldList = field.getSegmentGEFModel().getNonSelectedFields(field.getAlias());
            int i = 0;
            while (i < fieldList.size()) {
                FieldGEFModel dliFieldModel = fieldList.get(i);
                if (dliFieldModel.getAlias().equals(newAlias) || dliFieldModel.getIMSName().equals(newAlias)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isDuplicateFieldAlias(SegmentGEFModel dliSegmentModel, String newAlias) {
        Vector<FieldGEFModel> fieldList = dliSegmentModel.getFieldsList();
        int i = 0;
        while (i < fieldList.size()) {
            FieldGEFModel dliFieldModel = fieldList.get(i);
            if (dliFieldModel.getAlias().equals(newAlias) || dliFieldModel.getIMSName().equals(newAlias)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDuplicatePcbAlias(DbGEFModel pcb, String newAlias) {
        if (!pcb.getPcbAlias().equals(newAlias)) {
            return pcb.isDuplicateAlias(newAlias);
        }
        return false;
    }

    public static int fieldFitsInSegment(String startInput, String lengthInput, SegmentGEFModel segment) {
        int start = 0;
        int length = 0;
        if (startInput.length() > 0) {
            start = Integer.parseInt(startInput);
        }
        if (lengthInput.length() > 0) {
            length = Integer.parseInt(lengthInput);
        }
        int segLen = segment.getSegLen();
        if (start > 0 && length > 0 && segLen < start + length - 1 || (start == 0 || length == 0) && segLen < start + length) {
            return segLen;
        }
        return 0;
    }

    public static String getTimeStamp() {
        Date date = new Date();
        String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss z";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(date);
    }

    public static void displayMessageforProject(String projectName, String message, int severity) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IMarker marker = project.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("severity", severity);
        marker.setAttribute("message", (Object)("[" + Utility.getTimeStamp() + "] " + message));
        marker.setAttribute("location", (Object)ProjectTreeFileHelper.getProjectPathStr((String)projectName));
    }

    public static boolean isFieldFit(SegmentModel segmentModel, FieldModel fieldModel) {
        return fieldModel.getStartPos() <= segmentModel.getMaxBytes() && fieldModel.getBytes() <= segmentModel.getMaxBytes() && fieldModel.getStartPos() + fieldModel.getBytes() - 1 <= segmentModel.getMaxBytes();
    }

    public static int getTextWidth(Composite composite, int style, String label) {
        Text text = new Text(composite, style);
        text.setText(label);
        text.setFont(composite.getFont());
        int retVal = text.computeSize((int)-1, (int)-1).x;
        text.dispose();
        return retVal;
    }

    public static int getTextHeight(Composite composite, int style, int margin) {
        Text text = new Text(composite, style);
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int charHeight = fm.getHeight();
        int charWidth = fm.getAverageCharWidth();
        gc.dispose();
        int retVal = text.computeSize((int)charWidth, (int)charHeight).y;
        text.dispose();
        return retVal + margin * 2;
    }

    public static int getMaxSize(int[] labelSize) {
        Arrays.sort(labelSize);
        return labelSize[labelSize.length - 1];
    }

    public static String formatMessage(String inputMessage) {
        Object retVal = "";
        int maxLength = 37;
        if (inputMessage != null) {
            while (inputMessage.length() > 0) {
                int index = inputMessage.indexOf(" ");
                if (index >= 0) {
                    int currentLineLength = ((String)retVal).length() % maxLength;
                    String tempString = inputMessage.substring(0, index + 1);
                    retVal = (String)retVal + tempString;
                    if (tempString.indexOf("\n") < 0) {
                        if (tempString.length() >= maxLength) {
                            retVal = (String)retVal + "\n";
                        } else if (((String)retVal).length() % maxLength < currentLineLength) {
                            retVal = (String)retVal + "\n";
                        }
                    }
                    inputMessage = inputMessage.substring(index + 1);
                    continue;
                }
                retVal = (String)retVal + inputMessage;
                break;
            }
        }
        return retVal;
    }

    public static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        Utility.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private static void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        if (!newEntry.isEmpty()) {
            history.add(0, newEntry);
            if (history.size() > 8) {
                history.remove(8);
            }
        }
    }

    public static IDialogSettings getDialogSettings(String sectionID) {
        IDialogSettings settings = WorkbenchPlugin.getDefault().getDialogSettings();
        if (settings == null) {
            settings = WorkbenchPlugin.getDefault().getDialogSettings().addNewSection(sectionID);
        } else {
            settings = WorkbenchPlugin.getDefault().getDialogSettings().getSection(sectionID);
            if (settings == null) {
                settings = WorkbenchPlugin.getDefault().getDialogSettings().addNewSection(sectionID);
            }
        }
        return settings;
    }

    /*
     * Unable to fully structure code
     */
    public static void deleteTempFile(IFile tempFile) {
        block3: {
            try {
                if (tempFile == null || !tempFile.exists()) break block3;
                tempFile.refreshLocal(1, null);
                tempFile.delete(true, null);
                break block3;
            }
            catch (CoreException v0) {
                System.gc();
                file = new File(tempFile.getLocation().toOSString());
                ** while (file.exists())
            }
lbl-1000:
            // 1 sources

            {
                file.delete();
                continue;
            }
        }
    }

    public static boolean isJDBCEnable() {
        boolean retVal = false;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store != null && store.getBoolean("explorer_enable_ims_jdbc")) {
            retVal = true;
        }
        return retVal;
    }

    public static void openMessageDialog(final int kind, final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.open((int)kind, (Shell)activeShell, (String)title, (String)message, (int)0);
            }
        });
    }

    public static MultiPageEditor launchWfmEditor(String projectName, String dbdName, String segmentName) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IViewPart view = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        IFile wfFile = FieldImportWorkflowModelUtil.getFieldImportWorkflowFile((String)projectName);
        MultiPageEditor editor = (MultiPageEditor)page.openEditor((IEditorInput)new FileEditorInput(wfFile), "com.ibm.im.ims.catalog.ui.workflow.WorkflowManager");
        ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)wfFile));
        return editor;
    }

    public static void selectSegmentInWfmEditor(MultiPageEditor editor, String dbdName, String segmentName, String actionId) {
        WorkflowManager wfm = editor.getWorkflowManager();
        FieldImportWorkflowXViewer workflowXViewer = wfm.getXviewer();
        workflowXViewer.getWorkflowController();
        Tree workflowTree = workflowXViewer.getTree();
        TreeItem[] treeItems = workflowTree.getItems();
        int i = 0;
        while (i < treeItems.length) {
            Object workflowObject;
            TreeItem currentDbd = treeItems[i];
            if (currentDbd.getText().equals(dbdName) && (workflowObject = currentDbd.getData()) instanceof WorkflowDBD) {
                WorkflowDBD workflowDbd = (WorkflowDBD)workflowObject;
                workflowXViewer.dbdChanged(workflowDbd);
                currentDbd.setExpanded(true);
                workflowXViewer.refresh(workflowDbd, true);
                TreeItem[] segmItems = currentDbd.getItems();
                int j = 0;
                while (j < segmItems.length) {
                    TreeItem currentSegm = segmItems[j];
                    if (currentSegm.getText().equals(segmentName) && (workflowObject = currentSegm.getData()) instanceof WorkflowSegmentType) {
                        workflowTree.setSelection(currentSegm);
                        if (actionId.equals("com.ibm.im.ims.workbench.popup.actions.ImportCobolAction")) {
                            FieldImportWorkflowImportDSAction action = new FieldImportWorkflowImportDSAction(workflowXViewer, currentSegm);
                            action.run();
                        } else if (actionId.equals("com.ibm.im.ims.workbench.popup.actions.ManageMappingAction")) {
                            ManageMapCaseAction action = new ManageMapCaseAction(workflowXViewer, currentSegm);
                            action.run();
                        } else if (actionId.equals("com.ibm.im.ims.workbench.popup.actions.ManageSegmentAction")) {
                            AddOrEditFieldAction action = new AddOrEditFieldAction(workflowXViewer, currentSegm);
                            action.run();
                        } else if (actionId.equals("com.ibm.im.ims.workbench.editEncoding")) {
                            EditSEGMAction action = new EditSEGMAction(workflowXViewer, currentSegm);
                            action.run();
                        }
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static boolean isNotGSAM(WorkflowDBD workflowDbd, FieldImportWorkflowController WorkflowController) {
        boolean retVal = true;
        String dbdName = workflowDbd.getName();
        String projectName = WorkflowController.getProjectName();
        try {
            IFile dbdFile = ProjectTreeFileHelper.getDbdMetadataFile((String)projectName, (String)dbdName);
            DbdModel dbd = new DbdModel(dbdFile.getContents());
            if (dbd.getAccessType() == DBDConstants.GSAM) {
                retVal = false;
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return retVal;
    }

    public WorkflowDBD getWorkflowDBD(TreeItem item) {
        WorkflowDBD retVal = null;
        if (item.getData() instanceof WorkflowDBD) {
            retVal = (WorkflowDBD)item.getData();
        } else if (item.getData() instanceof WorkflowSegmentType) {
            retVal = ((WorkflowSegmentType)item.getData()).getParent();
        } else if (item.getData() instanceof WorkflowMapCaseType) {
            retVal = ((WorkflowMapCaseType)item.getData()).getParent().getParent();
        }
        return retVal;
    }

    public static void openInformationDialog(String msg, Object[] inserts) {
        InfoDialog dialog = new InfoDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchPlugin.labels.getString("WDT_DIALOG_TITLE"), null, WorkbenchModelBundle.getNoXlatLabel().getString("EAWC_WFM_DS_IMPORT_WARNING") + " - " + msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.setWarningType("WFM_DS_IMPORT_WARNING");
        dialog.open();
    }
}

