/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class TableItemEditWizardPage
extends WizardPage
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TableItem tableItem;
    public static final String ID = "ID";
    public static final String DEFAULT = "DEFAULT";

    protected TableItemEditWizardPage(String pageName, TableItem tableItem) {
        super(pageName);
        this.tableItem = tableItem;
    }

    public void recursiveInitWidgetValues(Control[] children, ArrayList<String> tableColumnNames) {
        if (children.length > 0) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Text) {
                    Text text = (Text)children[i];
                    controlId = (String)text.getData(ID);
                    if (controlId != null) {
                        if (tableColumnNames.contains(controlId)) {
                            text.setText(this.tableItem.getText(tableColumnNames.indexOf(controlId)));
                        } else {
                            dataStr = (String)this.tableItem.getData(controlId);
                            if (dataStr != null) {
                                text.setText(dataStr);
                            } else {
                                text.setText("");
                            }
                        }
                    }
                } else if (children[i] instanceof Combo) {
                    Combo combo = (Combo)children[i];
                    controlId = (String)combo.getData(ID);
                    if (controlId != null && (dataStr = tableColumnNames.contains(controlId) ? this.tableItem.getText(tableColumnNames.indexOf(controlId)) : (String)this.tableItem.getData(controlId)) != null) {
                        combo.setText(dataStr);
                    }
                } else if (children[i] instanceof Button) {
                    Button button = (Button)children[i];
                    controlId = (String)button.getData(ID);
                    if (controlId != null) {
                        String buttonLabelStr = null;
                        if (tableColumnNames.contains(controlId)) {
                            int colIndex = tableColumnNames.indexOf(controlId);
                            buttonLabelStr = this.tableItem.getText(colIndex);
                        } else {
                            buttonLabelStr = (String)this.tableItem.getData(controlId);
                        }
                        if (button.getText().equals(buttonLabelStr)) {
                            button.setSelection(true);
                        } else {
                            button.setSelection(false);
                        }
                    }
                } else if (children[i] instanceof Composite) {
                    this.recursiveInitWidgetValues(((Composite)children[i]).getChildren(), tableColumnNames);
                }
                ++i;
            }
        }
    }

    protected void initWidgetValues(Control[] children) {
        ArrayList<String> tableColumnNames = this.getTableColumnNames();
        this.recursiveInitWidgetValues(children, tableColumnNames);
    }

    private ArrayList<String> getTableColumnNames() {
        TableColumn[] tableColumns = this.tableItem.getParent().getColumns();
        ArrayList<String> tableColumnNames = new ArrayList<String>(tableColumns.length);
        int i = 0;
        while (i < tableColumns.length) {
            tableColumnNames.add(i, tableColumns[i].getText());
            ++i;
        }
        return tableColumnNames;
    }

    protected void updateTableItemDataFromWidgets(Control[] children) {
        ArrayList<String> tableColumnNames = this.getTableColumnNames();
        this.recursiveUpdateTableItemDataFromWidgets(children, tableColumnNames);
    }

    private void recursiveUpdateTableItemDataFromWidgets(Control[] children, ArrayList<String> tableColumnNames) {
        if (children.length > 0) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Text) {
                    Text text = (Text)children[i];
                    widgetId = text.getData(ID);
                    if (tableColumnNames.contains(widgetId)) {
                        String widgetValueStr = text.getText();
                        int widgetIndex = tableColumnNames.indexOf(widgetId);
                        this.tableItem.setText(widgetIndex, widgetValueStr);
                    } else {
                        String string = text.getText();
                        if (string != null) {
                            this.tableItem.setData((String)widgetId, (Object)string);
                        }
                    }
                } else if (children[i] instanceof Combo) {
                    Combo combo = (Combo)children[i];
                    widgetId = combo.getData(ID);
                    if (tableColumnNames.contains(widgetId)) {
                        int widgetIndex = tableColumnNames.indexOf(widgetId);
                        String widgetValueStr = combo.getText();
                        this.tableItem.setText(widgetIndex, widgetValueStr);
                    } else if (widgetId != null) {
                        String widgetValueStr = combo.getText();
                        this.tableItem.setData((String)widgetId, (Object)widgetValueStr);
                    }
                } else if (children[i] instanceof Button) {
                    boolean selected;
                    Button button = (Button)children[i];
                    widgetId = (String)button.getData(ID);
                    if (widgetId != null && (selected = button.getSelection())) {
                        String buttonLabelStr = button.getText();
                        if (tableColumnNames.contains(widgetId)) {
                            int widgetIndex = tableColumnNames.indexOf(widgetId);
                            this.tableItem.setText(widgetIndex, buttonLabelStr);
                        } else {
                            this.tableItem.setData((String)widgetId, (Object)buttonLabelStr);
                        }
                    }
                } else if (children[i] instanceof Composite) {
                    Composite composite = (Composite)children[i];
                    this.recursiveUpdateTableItemDataFromWidgets(composite.getChildren(), tableColumnNames);
                }
                ++i;
            }
        }
    }

    public void initWidgetsWithInputDefaults(Control[] arrayMainCompInputs) {
        int i = 0;
        while (i < arrayMainCompInputs.length) {
            if (arrayMainCompInputs[i] instanceof Text) {
                Text text = (Text)arrayMainCompInputs[i];
                defaultInputStr = this.getInputDefault((Control)text);
                if (defaultInputStr != null) {
                    text.setText(defaultInputStr);
                }
            } else if (arrayMainCompInputs[i] instanceof Combo) {
                Combo combo = (Combo)arrayMainCompInputs[i];
                defaultInputStr = this.getInputDefault((Control)combo);
                if (defaultInputStr != null) {
                    combo.setText(defaultInputStr);
                }
            } else if (arrayMainCompInputs[i] instanceof Button) {
                Button button = (Button)arrayMainCompInputs[i];
                String defaultBoolean = this.getInputDefault((Control)button);
                if (defaultBoolean != null && defaultBoolean.equals("true")) {
                    button.setSelection(true);
                } else {
                    button.setSelection(false);
                }
            } else if (arrayMainCompInputs[i] instanceof Composite) {
                this.initWidgetsWithInputDefaults(((Composite)arrayMainCompInputs[i]).getChildren());
            }
            ++i;
        }
    }

    public String getInputDefault(Control control) {
        if (control != null) {
            return (String)control.getData(DEFAULT);
        }
        return null;
    }

    protected void setInputDefault(Control control, String controlId, Object defaultString) {
        if (control != null) {
            if (control instanceof Text) {
                Text text = (Text)control;
                text.setData(ID, (Object)controlId);
                text.setData(DEFAULT, defaultString);
            } else if (control instanceof Combo) {
                Combo combo = (Combo)control;
                combo.setData(ID, (Object)controlId);
                combo.setData(DEFAULT, defaultString);
            } else if (control instanceof Button) {
                Button button = (Button)control;
                button.setData(ID, (Object)controlId);
                button.setData(DEFAULT, defaultString);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

