/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.editors.ResourceEditorPage;
import com.ibm.im.ims.workbench.editors.model.FieldGEFModel;
import com.ibm.im.ims.workbench.editors.model.SegmentGEFModel;
import com.ibm.im.ims.workbench.editors.parts.DbEditPart;
import com.ibm.im.ims.workbench.editors.parts.FieldEditPart;
import com.ibm.im.ims.workbench.editors.parts.SegmentEditPart;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SearchDialog
extends Dialog
implements ModifyListener,
KeyListener,
VerifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Image FIND_IMAGE = Utility.getImageDescriptor("view_simple_16.gif").createImage();
    private static final String STORE_SEARCH_SEGMENT_DIALOG_ID = "STORE_SEARCH_SEGMENT_DIALOG_ID";
    private static final String STORE_LAST_SEARCH_STRING_ID = "STORE_LAST_SEARCH_STRING_ID";
    private static final int MARGIN = 5;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ResourceEditorPage editorPage;
    private Combo segmentCombo;
    private Button forwardSearch;
    private Button backwardSearch;
    private Label errorMessage;

    public SearchDialog(Shell parentShell, ResourceEditorPage editorPage) {
        super(parentShell);
        this.editorPage = editorPage;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    protected Control createDialogArea(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createDialogArea(Composite parent)", new Object[]{this.editorPage.getPageName()});
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)area.getLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        try {
            Composite container = new Composite(area, 0);
            FormLayout formLayout = new FormLayout();
            formLayout.marginTop = -5;
            formLayout.marginBottom = -5;
            formLayout.marginLeft = -5;
            formLayout.marginRight = -5;
            container.setLayout((Layout)formLayout);
            container.setLayoutData((Object)new GridData(1808));
            Composite composite = new Composite(container, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            FormData fd_composite = new FormData();
            fd_composite.top = new FormAttachment(0);
            fd_composite.left = new FormAttachment(0);
            fd_composite.right = new FormAttachment(100);
            composite.setLayoutData((Object)fd_composite);
            Composite findGroup = new Composite(composite, 0);
            GridLayout gl_findGroup = new GridLayout(2, false);
            gl_findGroup.marginWidth = 0;
            findGroup.setLayout((Layout)gl_findGroup);
            findGroup.setLayoutData((Object)new GridData(1808));
            new Label(findGroup, 0).setText(WorkbenchPlugin.labels.getString("fdSeg") + WorkbenchPlugin.colon.getString("COLON"));
            this.segmentCombo = new Combo(findGroup, 4);
            this.segmentCombo.setLayoutData((Object)new GridData(768));
            this.segmentCombo.setTextLimit(255);
            this.segmentCombo.setText(this.restoreWidgetValues());
            Group directionGroup = new Group(composite, 0);
            directionGroup.setLayout((Layout)new GridLayout(1, false));
            directionGroup.setText(WorkbenchPlugin.labels.getString("fdOpts"));
            directionGroup.setLayoutData((Object)new GridData(1808));
            this.forwardSearch = new Button((Composite)directionGroup, 16);
            this.forwardSearch.setText(WorkbenchPlugin.labels.getString("fdDirF"));
            this.forwardSearch.setLayoutData((Object)new GridData(1));
            this.forwardSearch.setSelection(true);
            this.backwardSearch = new Button((Composite)directionGroup, 16);
            this.backwardSearch.setText(WorkbenchPlugin.labels.getString("fdDirB"));
            this.backwardSearch.setLayoutData((Object)new GridData(1));
            this.backwardSearch.setSelection(false);
            this.errorMessage = new Label(composite, 0);
            this.errorMessage.setLayoutData((Object)new GridData(1808));
            this.errorMessage.setForeground(parent.getDisplay().getSystemColor(3));
            this.addListeners();
        }
        catch (Throwable t) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createDialogArea(Composite parent)", t);
            logger.error(t);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createDialogArea(Composite parent)", new Object[]{this.editorPage.getPageName()});
        return area;
    }

    private void addListeners() {
        this.segmentCombo.addModifyListener((ModifyListener)this);
        this.segmentCombo.addKeyListener((KeyListener)this);
        this.segmentCombo.addVerifyListener((VerifyListener)this);
        this.forwardSearch.addSelectionListener((SelectionListener)this);
        this.backwardSearch.addSelectionListener((SelectionListener)this);
    }

    protected Point getInitialSize() {
        return new Point(400, 275);
    }

    public void modifyText(ModifyEvent arg0) {
        logger.entering(((Object)((Object)this)).getClass().getName(), " modifyText(ModifyEvent arg0)", new Object[]{arg0.widget});
        this.setErrorMessage(null);
        this.validate();
        logger.exiting(((Object)((Object)this)).getClass().getName(), " modifyText(ModifyEvent arg0)", new Object[]{arg0.widget});
    }

    private boolean validate() {
        boolean valid;
        this.setErrorMessage(null);
        String segName = this.segmentCombo.getText().trim();
        boolean bl = valid = segName != null && !segName.isEmpty();
        if (valid) {
            boolean bl2 = valid = segName.indexOf(" ") < 0;
            if (!valid) {
                this.setErrorMessage(WorkbenchPlugin.errors.getString("SEARCH_SEGM_DIALOG_1"));
            }
        }
        this.getButton(0).setEnabled(valid);
        return valid;
    }

    protected void okPressed() {
        this.performSearch();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if ((e.keyCode == 13 || e.keyCode == 102 && e.stateMask == 65536) && this.validate()) {
            this.performSearch();
        }
    }

    private void performSearch() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "performSearch()", new Object[]{this.segmentCombo.getText()});
        try {
            SegmentEditPart segEditPart = null;
            int startIndex = this.getSegmentIndex();
            segEditPart = this.forwardSearch.getSelection() || startIndex == 0 ? this.forwardSearch(startIndex + 1) : this.backwardSearch(startIndex - 1);
            if (segEditPart != null) {
                this.revealEditPart((GraphicalEditPart)segEditPart);
                this.editorPage.setSelectedPart((EditPart)segEditPart);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(WorkbenchPlugin.errors.getString("SEARCH_SEGM_DIALOG_2"));
            }
            this.segmentCombo.forceFocus();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performSearch()", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "performSearch()", new Object[]{this.segmentCombo.getText()});
    }

    private void setErrorMessage(String errorMessage) {
        if (errorMessage != null && !errorMessage.isEmpty()) {
            this.errorMessage.setText(errorMessage);
        } else {
            this.errorMessage.setText("");
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchPlugin.labels.getString("fdFind"));
        shell.setImage(FIND_IMAGE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, WorkbenchPlugin.labels.getString("fdFind1"), true);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        this.getButton(0).setEnabled(this.validate());
    }

    public void verifyText(VerifyEvent arg0) {
        try {
            if (arg0.character >= 'a' && arg0.character <= 'z') {
                arg0.text = arg0.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public boolean close() {
        this.saveWidgetValues();
        this.segmentCombo.removeModifyListener((ModifyListener)this);
        this.segmentCombo.removeKeyListener((KeyListener)this);
        this.segmentCombo.removeVerifyListener((VerifyListener)this);
        this.forwardSearch.removeSelectionListener((SelectionListener)this);
        this.backwardSearch.removeSelectionListener((SelectionListener)this);
        this.segmentCombo.dispose();
        this.errorMessage.dispose();
        this.forwardSearch.dispose();
        this.backwardSearch.dispose();
        return super.close();
    }

    private SegmentEditPart forwardSearch(int startIndex) {
        SegmentEditPart retVal = null;
        DbEditPart dbEditPart = (DbEditPart)this.editorPage.getEditPart();
        String segmentName = this.segmentCombo.getText().trim();
        List children = dbEditPart.getChildren();
        int i = startIndex;
        while (i < children.size()) {
            SegmentEditPart segEditPart;
            SegmentGEFModel segmentGEFModel;
            if (children.get(i) instanceof SegmentEditPart && ((segmentGEFModel = (SegmentGEFModel)(segEditPart = (SegmentEditPart)children.get(i)).getModel()).getSegmentName().contains(segmentName) || segmentGEFModel.getSegmentAlias().contains(segmentName))) {
                retVal = segEditPart;
                this.addSearchHistory();
                break;
            }
            ++i;
        }
        return retVal;
    }

    private SegmentEditPart backwardSearch(int startIndex) {
        SegmentEditPart retVal = null;
        DbEditPart dbEditPart = (DbEditPart)this.editorPage.getEditPart();
        String segmentName = this.segmentCombo.getText().trim();
        List children = dbEditPart.getChildren();
        int i = startIndex;
        while (i >= 0) {
            SegmentEditPart segEditPart;
            SegmentGEFModel segmentGEFModel;
            if (children.get(i) instanceof SegmentEditPart && ((segmentGEFModel = (SegmentGEFModel)(segEditPart = (SegmentEditPart)children.get(i)).getModel()).getSegmentName().contains(segmentName) || segmentGEFModel.getSegmentAlias().contains(segmentName))) {
                retVal = segEditPart;
                this.addSearchHistory();
                break;
            }
            --i;
        }
        return retVal;
    }

    private String getSelectedSegmentName() {
        String retVal = null;
        List selectedParts = this.editorPage.getViewer().getSelectedEditParts();
        int i = 0;
        while (i < selectedParts.size()) {
            Object currentPart = selectedParts.get(i);
            if (currentPart instanceof SegmentEditPart || currentPart instanceof FieldEditPart) {
                SegmentGEFModel segmentGEFModel;
                if (currentPart instanceof SegmentEditPart) {
                    SegmentEditPart segEditPart = (SegmentEditPart)currentPart;
                    segmentGEFModel = (SegmentGEFModel)segEditPart.getModel();
                } else {
                    FieldEditPart fieldEditPart = (FieldEditPart)currentPart;
                    FieldGEFModel fieldGEFModel = (FieldGEFModel)fieldEditPart.getModel();
                    segmentGEFModel = fieldGEFModel.getSegmentGEFModel();
                }
                retVal = segmentGEFModel.getSegmentAlias();
                break;
            }
            ++i;
        }
        return retVal;
    }

    private int getSegmentIndex() {
        int retVal = 0;
        String segmentName = this.getSelectedSegmentName();
        if (segmentName != null) {
            DbEditPart dbEditPart = (DbEditPart)this.editorPage.getEditPart();
            List children = dbEditPart.getChildren();
            int i = 0;
            while (i < children.size()) {
                Object child = children.get(i);
                if (child instanceof SegmentEditPart || child instanceof FieldEditPart) {
                    SegmentGEFModel segmentGEFModel;
                    if (child instanceof SegmentEditPart) {
                        SegmentEditPart segEditPart = (SegmentEditPart)child;
                        segmentGEFModel = (SegmentGEFModel)segEditPart.getModel();
                    } else {
                        FieldEditPart fieldEditPart = (FieldEditPart)child;
                        FieldGEFModel fieldGEFModel = (FieldGEFModel)fieldEditPart.getModel();
                        segmentGEFModel = fieldGEFModel.getSegmentGEFModel();
                    }
                    if (segmentGEFModel.getSegmentName().equalsIgnoreCase(segmentName) || segmentGEFModel.getSegmentAlias().equalsIgnoreCase(segmentName)) {
                        retVal = i;
                        break;
                    }
                }
                ++i;
            }
        }
        return retVal;
    }

    private void revealEditPart(GraphicalEditPart editPart) {
        IFigure target = editPart.getFigure();
        FigureCanvas figureCanvas = (FigureCanvas)this.editorPage.getViewer().getControl();
        figureCanvas.scrollTo(target.getBounds().x - 100, target.getBounds().y - 100);
    }

    private void addSearchHistory() {
        boolean found = false;
        String segmentName = this.segmentCombo.getText().trim();
        int i = 0;
        while (i < this.segmentCombo.getItems().length) {
            if (this.segmentCombo.getItem(i).equalsIgnoreCase(segmentName)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.segmentCombo.add(segmentName);
        }
    }

    private String restoreWidgetValues() {
        String retVal = null;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            retVal = settings.get(STORE_LAST_SEARCH_STRING_ID);
        }
        if (retVal == null) {
            retVal = "";
        }
        return retVal;
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_LAST_SEARCH_STRING_ID, this.segmentCombo.getText());
        }
    }

    public IDialogSettings getDialogSettings() {
        return Utility.getDialogSettings(STORE_SEARCH_SEGMENT_DIALOG_ID);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.validate();
    }
}

