/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.utilities;

import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.SegmentModel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHandler
extends DefaultHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String currSegmentImsName;
    private DbdModel dbdModel;

    public SaxHandler(DbdModel dbdModel) {
        this.dbdModel = dbdModel;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if ("segment".equals(eName)) {
            this.currSegmentImsName = this.getValueForAttr(attrs, "imsName");
        } else if ("field".equals(eName)) {
            String remarksValue = this.getValueForAttr(attrs, "remarks");
            String currFieldName = this.getValueForAttr(attrs, "name");
            if (remarksValue != null && currFieldName != null) {
                SegmentModel rootSegment = this.dbdModel.getRootSegment();
                this.dbdModel.setFieldRemarks(remarksValue, this.currSegmentImsName, currFieldName, rootSegment);
            }
        }
    }

    private String getValueForAttr(Attributes attrs, String attrName) {
        String retVal = null;
        int i = 0;
        while (i < attrs.getLength()) {
            String aName = attrs.getLocalName(i);
            if ("".equals(aName)) {
                aName = attrs.getQName(i);
            }
            if (attrName.equals(aName)) {
                retVal = attrs.getValue(i);
                break;
            }
            ++i;
        }
        return retVal;
    }
}

